/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import mx.viewer.manager.IconManager;

public class IconInfoPanel
extends JPanel {
    private static final long serialVersionUID = -4616279839826283363L;
    private IconManager icon = null;
    private static final int LARGHEZZA = 85;
    private static final int HEIGHTGAP = 5;
    private static final int WIDTHGAP = 5;
    private static final int ROWHEIGHT = 20;

    public IconInfoPanel(IconManager icon) {
        this.setIcon(icon);
        this.initialize();
    }

    public void initialize() {
        int row = 0;
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        JLabel fileNameTitle = new JLabel("Nome del file:");
        fileNameTitle.setHorizontalAlignment(4);
        this.setPreferredWidth(fileNameTitle, 85);
        JLabel fileName = new JLabel(this.getIcon().getFileName());
        fileName.setHorizontalAlignment(2);
        JLabel widthTitle = new JLabel("Larghezza:");
        widthTitle.setHorizontalAlignment(4);
        this.setPreferredWidth(widthTitle, 85);
        JLabel width = new JLabel(new Integer(this.getIcon().getWidth()).toString());
        width.setHorizontalAlignment(2);
        JLabel heightTitle = new JLabel("Altezza:");
        heightTitle.setHorizontalAlignment(4);
        this.setPreferredWidth(heightTitle, 85);
        JLabel height = new JLabel(new Integer(this.getIcon().getHeight()).toString());
        height.setHorizontalAlignment(2);
        JLabel colorTitle = new JLabel("Colori:");
        colorTitle.setHorizontalAlignment(4);
        this.setPreferredWidth(colorTitle, 85);
        JLabel color = new JLabel(this.getIcon().getColorType());
        color.setHorizontalAlignment(2);
        this.add(fileNameTitle);
        layout.putConstraint("North", (Component)fileNameTitle, row * 20 + 5, "North", (Component)this);
        layout.putConstraint("West", (Component)fileNameTitle, 5, "West", (Component)this);
        this.add(fileName);
        layout.putConstraint("North", (Component)fileName, 0, "North", (Component)fileNameTitle);
        layout.putConstraint("West", (Component)fileName, 5, "East", (Component)fileNameTitle);
        this.add(widthTitle);
        layout.putConstraint("North", (Component)widthTitle, ++row * 20 + 5, "North", (Component)this);
        layout.putConstraint("West", (Component)widthTitle, 5, "West", (Component)this);
        this.add(width);
        layout.putConstraint("North", (Component)width, 0, "North", (Component)widthTitle);
        layout.putConstraint("West", (Component)width, 5, "East", (Component)widthTitle);
        this.add(heightTitle);
        layout.putConstraint("North", (Component)heightTitle, ++row * 20 + 5, "North", (Component)this);
        layout.putConstraint("West", (Component)heightTitle, 5, "West", (Component)this);
        this.add(height);
        layout.putConstraint("North", (Component)height, 0, "North", (Component)heightTitle);
        layout.putConstraint("West", (Component)height, 5, "East", (Component)heightTitle);
        this.add(colorTitle);
        layout.putConstraint("North", (Component)colorTitle, ++row * 20 + 5, "North", (Component)this);
        layout.putConstraint("West", (Component)colorTitle, 5, "West", (Component)this);
        this.add(color);
        layout.putConstraint("North", (Component)color, 0, "North", (Component)colorTitle);
        layout.putConstraint("West", (Component)color, 5, "East", (Component)colorTitle);
        this.setPreferredSize(this.computeMaxSize());
    }

    public IconManager getIcon() {
        return this.icon;
    }

    public void setIcon(IconManager icon) {
        this.icon = icon;
    }

    private void setPreferredWidth(JComponent component, int preferredWidth) {
        Dimension d = null;
        d = component.getPreferredSize();
        d.width = preferredWidth;
        component.setPreferredSize(d);
    }

    private Dimension computeMaxSize() {
        Spring spring = null;
        Dimension d = new Dimension(0, 0);
        SpringLayout layout = (SpringLayout)this.getLayout();
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            spring = layout.getConstraint("East", c);
            d.width = Math.max(d.width, spring.getValue());
            spring = layout.getConstraint("South", c);
            d.height = Math.max(d.height, spring.getValue());
            ++i;
        }
        d.width += 10;
        d.height += 10;
        return d;
    }
}

