/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import mx.viewer.gui.IconScrollPanel;
import mx.viewer.gui.IconScrollPanelContainer;
import mx.viewer.gui.MainContainer;
import mx.viewer.gui.MessagePanel;
import mx.viewer.gui.toolBar.StatusToolBar;
import mx.viewer.manager.CursorManager;
import mx.viewer.manager.ImageManager;
import mx.viewer.util.SwingWorker;

public class IconPanelContainer
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = -7559710579512974374L;
    public static final int IL_HORIZONTAL_TILED = 0;
    public static final int IL_VERTICAL_TILED = 1;
    private MainContainer mainContainer;
    private Vector panelList = null;
    private int imageLayout = 0;
    private ImageManager image = null;
    private int displayMode = 1;
    private MessagePanel messagePanel = null;
    private int zoom;
    private boolean modZoom = false;
    private StatusToolBar statusToolBar;

    public IconPanelContainer(MainContainer mainContainer) {
        this.mainContainer = mainContainer;
        this.mainContainer.add((Component)this, "Center");
        this.initialize();
    }

    private void initialize() {
        this.panelList = new Vector();
        this.messagePanel = new MessagePanel("Caricamento in corso...");
        this.add(this.messagePanel);
        this.refreshImageLayout();
        this.addComponentListener(this);
    }

    public int getImageLayout() {
        return this.imageLayout;
    }

    public void refreshImageLayout() {
        this.setLayout(null);
    }

    public int addPanel(IconScrollPanel panel) {
        panel.setStatusToolBar(this.statusToolBar);
        IconScrollPanelContainer viewPanel = new IconScrollPanelContainer(panel);
        viewPanel.setLayout(new BorderLayout());
        viewPanel.setBorder(BorderFactory.createEmptyBorder());
        viewPanel.add((Component)panel, "Center");
        this.panelList.add(viewPanel);
        this.add((Component)viewPanel, "Center");
        return this.panelList.size();
    }

    public IconScrollPanel getPanel(int n) {
        return ((IconScrollPanelContainer)this.panelList.get(n)).getIconScrollPanel();
    }

    public IconScrollPanelContainer getScrollPanelContainer(int n) {
        return (IconScrollPanelContainer)this.panelList.get(n);
    }

    public int panelCount() {
        return this.panelList.size();
    }

    public ImageManager getImage() {
        return this.image;
    }

    public void setImage(ImageManager image) {
        this.image = image;
        this.zoom = this.statusToolBar.getZoom();
        this.beginRefresh();
        SwingWorker myWorker = new SwingWorker(){

            public Object construct() {
                IconPanelContainer.this.doRefresh();
                return null;
            }

            public void finished() {
                IconPanelContainer.this.endRefresh();
            }
        };
        myWorker.start();
    }

    private void beginRefresh() {
        int left = 0;
        int top = 0;
        int width = 0;
        int height = 0;
        int conta = 0;
        this.setCursor(CursorManager.defaultMouseCursor(3));
        width = this.getWidth();
        height = this.getHeight();
        this.messagePanel.setPosition((width - 200) / 2, (height - 50) / 2, 200, 50);
        this.messagePanel.setVisible(true);
        int i = 0;
        while (i < this.panelCount()) {
            this.getPanel(i).setIcon(null);
            this.getScrollPanelContainer(i).setVisible(false);
            if (i < this.image.iconCount()) {
                ++conta;
            }
            ++i;
        }
        if (this.getImageLayout() == 0) {
            height = (height - conta) / conta;
        }
        if (this.getImageLayout() == 1) {
            width = (width - conta) / conta;
        }
        i = 0;
        while (i < this.panelCount()) {
            if (i < this.image.iconCount()) {
                this.getScrollPanelContainer(i).setBounds(left, top, width, height);
                this.getScrollPanelContainer(i).getIconScrollPanel().setBounds(left, top, width, height);
                if (this.getImageLayout() == 0) {
                    top = top + height + 1;
                }
                if (this.getImageLayout() == 1) {
                    left = left + width + 1;
                }
            }
            ++i;
        }
    }

    private void doRefresh() {
        int i = 0;
        while (i < this.panelCount()) {
            if (i < this.image.iconCount() && !this.image.getIcon(i).getName().equals("")) {
                if (this.image.getIcon(i).getBitmap() == null) {
                    this.image.setLoad(true);
                    this.image.getIcon(i).loadBitmap();
                }
                this.getPanel(i).setIcon(this.image.getIcon(i));
                this.getPanel(i).setDisplayMode(this.displayMode);
                if (this.zoom > 0 && this.modZoom) {
                    this.getPanel(i).setZoom(this.zoom);
                }
            }
            ++i;
        }
    }

    private void endRefresh() {
        this.messagePanel.setVisible(false);
        int i = 0;
        while (i < this.panelCount()) {
            if (i < this.image.iconCount()) {
                if (this.image.getIcon(i).getBitmap() != null) {
                    this.getPanel(i).setIcon(this.image.getIcon(i));
                    this.getScrollPanelContainer(i).setVisible(true);
                }
            } else {
                this.getPanel(i).setIcon(null);
                this.getScrollPanelContainer(i).setVisible(false);
            }
            ++i;
        }
        this.setCursor(CursorManager.defaultMouseCursor(0));
    }

    public void refresh() {
        try {
            this.beginRefresh();
        }
        finally {
            this.endRefresh();
        }
    }

    public void setImageLayout(int imageLayout) {
        this.imageLayout = imageLayout;
        this.refreshImageLayout();
    }

    public void setMouseMode(int mouseMode) {
        int i = 0;
        while (i < this.panelCount()) {
            this.getPanel(i).setMouseMode(mouseMode);
            ++i;
        }
    }

    public void printFull(Book bk, PageFormat userPageFormat) {
        int i = 0;
        while (i < this.panelCount()) {
            this.getPanel(i).printPage(bk, userPageFormat);
            ++i;
        }
    }

    public void save() {
        int i = 0;
        while (i < this.panelCount()) {
            this.getPanel(i).save();
            ++i;
        }
    }

    public void setDisplayMode(int displayMode) {
        this.modZoom = false;
        this.displayMode = displayMode;
        int i = 0;
        while (i < this.panelCount()) {
            this.getPanel(i).setDisplayMode(displayMode);
            ++i;
        }
    }

    public int getZoom() {
        int zoom = 0;
        int i = 0;
        while (i < this.panelCount()) {
            zoom = this.getPanel(i).getZoom();
            ++i;
        }
        return zoom;
    }

    public void setZoomIncrement(int zoomIncrement) {
        int i = 0;
        while (i < this.panelCount()) {
            this.getPanel(i).setZoomIncrement(zoomIncrement);
            ++i;
        }
    }

    public void zoomUp() {
        this.modZoom = true;
        int i = 0;
        while (i < this.panelCount()) {
            this.getPanel(i).zoomUp();
            ++i;
        }
    }

    public void zoomDown() {
        this.modZoom = true;
        int i = 0;
        while (i < this.panelCount()) {
            this.getPanel(i).zoomDown();
            ++i;
        }
    }

    public void rotateBitmap(int direction) {
        int i = 0;
        while (i < this.panelCount()) {
            if (i < this.image.iconCount()) {
                this.getPanel(i).rotateBitmap(direction);
            }
            ++i;
        }
    }

    public void invertBitmap() {
        int i = 0;
        while (i < this.panelCount()) {
            if (i < this.image.iconCount()) {
                this.getPanel(i).invertBitmap();
            }
            ++i;
        }
    }

    public void setMouseMode() {
    }

    public void setPrintVisible(boolean visible) {
        int i = 0;
        while (i < this.panelCount()) {
            this.getPanel(i).setPrintVisible(visible);
            ++i;
        }
    }

    public void setSaveVisible(boolean visible) {
        int i = 0;
        while (i < this.panelCount()) {
            this.getPanel(i).setSaveVisible(visible);
            ++i;
        }
    }

    public void setToolPopupMenuEnable(boolean enable) {
        int i = 0;
        while (i < this.panelCount()) {
            this.getPanel(i).setToolPopupMenuEnable(enable);
            ++i;
        }
    }

    public void componentResized(ComponentEvent e) {
        if (this.getImage() != null) {
            this.refresh();
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void setStatusToolBar(StatusToolBar statusToolBar) {
        this.statusToolBar = statusToolBar;
    }

    public void setModZoom(boolean modZoom) {
        this.modZoom = modZoom;
    }
}

