/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.renderable.ParameterBlock;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.JScrollPane;
import mx.viewer.gui.IconInfoPanel;
import mx.viewer.gui.IconLabel;
import mx.viewer.gui.IconPanelContainer;
import mx.viewer.gui.MessageDialog;
import mx.viewer.gui.toolBar.StatusToolBar;
import mx.viewer.manager.CursorManager;
import mx.viewer.manager.DisplayIconManager;
import mx.viewer.manager.IconManager;
import mx.viewer.util.FileSaveAs;
import mx.viewer.util.SwingWorkerNotifier;

public class IconScrollPanel
extends JScrollPane
implements ComponentListener {
    private static final long serialVersionUID = 2827071530664708792L;
    private IconLabel iconLabel = new IconLabel(this);
    private IconManager icon = null;
    private int displayMode = 1;
    private IconPanelContainer iconPanelContainer = null;
    private int zoom = 0;
    private int zoomIncrement = 5;
    private Dimension dimScrollBars = null;
    private boolean repaintable = false;
    private boolean isPrintSelection = false;
    private Rectangle printSel = null;
    private StatusToolBar statusToolBar;

    public IconScrollPanel(IconPanelContainer iconPanelContainer) {
        this.iconPanelContainer = iconPanelContainer;
        this.initialize();
    }

    public void initialize() {
        Dimension dHorizontal = this.getHorizontalScrollBar().getUI().getPreferredSize(this.getHorizontalScrollBar());
        Dimension dVertical = this.getVerticalScrollBar().getUI().getPreferredSize(this.getVerticalScrollBar());
        this.dimScrollBars = new Dimension(dVertical.width, dHorizontal.height);
        this.repaintable = true;
        this.getViewport().add(this.iconLabel);
    }

    public float getClientWidth() {
        Insets insets = this.getInsets();
        return this.getWidth() - (insets.left + insets.right);
    }

    public float getClientHeight() {
        Insets insets = this.getInsets();
        return this.getHeight() - (insets.top + insets.bottom);
    }

    public IconManager getIcon() {
        return this.icon;
    }

    public void setIcon(IconManager icon) {
        this.icon = icon;
        this.scrollPanelTo(0, 0);
        this.refreshDisplayIcon();
    }

    public int getMouseMode() {
        return this.iconLabel.getMouseMode();
    }

    public void setMouseMode(int mouseMode) {
        this.iconLabel.setMouseMode(mouseMode);
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int displayMode) {
        this.displayMode = displayMode;
        this.refreshDisplayIcon();
    }

    public void printPage() {
        this.isPrintSelection = false;
        this.printAuto();
    }

    public void printPage(Book bk, PageFormat userPageFormat) {
        this.isPrintSelection = false;
        this.printIcon(bk, userPageFormat);
    }

    public void printSelection(Rectangle paintRect) {
        this.isPrintSelection = true;
        this.printSel = paintRect;
        this.printAuto();
        this.isPrintSelection = false;
    }

    private void printAuto() {
        PageFormat userPageFormat;
        PageFormat defaultPageFormat;
        PrinterJob job = PrinterJob.getPrinterJob();
        Book bk = new Book();
        if (job.printDialog() && (defaultPageFormat = job.defaultPage()) != (userPageFormat = job.pageDialog(defaultPageFormat))) {
            this.printIcon(bk, userPageFormat);
            job.setPageable(bk);
            try {
                job.print();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void save() {
        FileSaveAs fileSave;
        if (this.getIcon() != null && (fileSave = new FileSaveAs(this, this.getIcon().getBitmap(), this.getIcon().getFileName())).saveAs()) {
            final Cursor oldCursor = this.iconLabel.getCursor();
            this.iconLabel.setCursor(CursorManager.defaultMouseCursor(3));
            this.getIcon().saveBitmap(fileSave.getFileName(), new SwingWorkerNotifier(){

                public void swingWorkerFinished(Object obj) {
                    IconScrollPanel.this.iconLabel.setCursor(oldCursor);
                }
            });
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
        this.iconPanelContainer.setModZoom(true);
        this.displayMode = 4;
        this.refreshDisplayIcon();
    }

    public void setZoomIncrement(int zoomIncrement) {
        this.zoomIncrement = zoomIncrement;
    }

    public int getZoomIncrement() {
        return this.zoomIncrement;
    }

    public void zoomUp() {
        int newZoom = this.getZoom() + this.zoomIncrement;
        if (newZoom <= 5000) {
            this.setZoom(newZoom);
        }
    }

    public void zoomDown() {
        int newZoom = this.getZoom() - this.zoomIncrement;
        if (newZoom >= 5) {
            this.setZoom(newZoom);
        }
    }

    public void rotateBitmap(int direction) {
        if (this.getIcon() != null) {
            this.getIcon().rotateBitmap(direction);
            this.setIcon(this.getIcon());
        }
    }

    public void invertBitmap() {
        if (this.getIcon() != null) {
            this.getIcon().invertBitmap();
            this.setIcon(this.getIcon());
        }
    }

    public void showInfo() {
        MessageDialog cd = null;
        IconInfoPanel messagePanel = new IconInfoPanel(this.getIcon());
        cd = new MessageDialog(null, "Info sull'immagine", "Chiudi", messagePanel);
        cd.pack();
        cd.setLocationRelativeTo(this);
        cd.setVisible(true);
    }

    public void setToolPopupMenuEnable(boolean enable) {
        this.iconLabel.setToolPopupMenuEnable(enable);
    }

    public void setPrintVisible(boolean visible) {
        this.iconLabel.setPrintVisible(visible);
    }

    public void setSaveVisible(boolean visible) {
        this.iconLabel.setSaveVisible(visible);
    }

    private void refreshDisplayIcon() {
        if (this.getIcon() != null) {
            ParameterBlock pbInput = new ParameterBlock();
            pbInput.add(this.getDisplayMode());
            pbInput.add(this.getClientWidth());
            pbInput.add(this.getClientHeight());
            pbInput.add(this.dimScrollBars);
            pbInput.add(this.getZoom());
            pbInput.add(-1.0f);
            pbInput.add(-1.0f);
            DisplayIconManager labelIcon = this.getIcon().createDisplayIcon(pbInput);
            this.zoom = labelIcon.getZoom();
            this.statusToolBar.setZoom(this.getZoom());
            this.iconLabel.setIcon(labelIcon);
        }
    }

    private Printable getPrintableIcon() {
        Printable printableIcon = null;
        printableIcon = this.isPrintSelection ? this.getIcon().cropImage(this.printSel) : this.getIcon();
        return printableIcon;
    }

    private void printIcon(Book bk, PageFormat userPageFormat) {
        Printable printableIcon = this.getPrintableIcon();
        if (printableIcon != null) {
            bk.append(printableIcon, userPageFormat);
        }
    }

    public void disableRepaint() {
        this.repaintable = false;
    }

    public void enableRepaint() {
        this.repaintable = true;
    }

    public void componentResized(ComponentEvent e) {
        this.refreshDisplayIcon();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void scrollPanel(int x, int y) {
        this.scrollPanelTo(this.getHorizontalScrollBar().getValue() + x, this.getVerticalScrollBar().getValue() + y);
    }

    public void scrollPanelTo(int x, int y) {
        this.getHorizontalScrollBar().setValue(x);
        this.getVerticalScrollBar().setValue(y);
    }

    public void setStatusToolBar(StatusToolBar statusToolBar) {
        this.statusToolBar = statusToolBar;
    }
}

