/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.gui;

import java.awt.BorderLayout;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import javax.swing.JPanel;
import mx.viewer.gui.IconPanelContainer;
import mx.viewer.gui.IconScrollPanel;
import mx.viewer.gui.NavigationToolBar;
import mx.viewer.gui.ToolToolBar;
import mx.viewer.gui.toolBar.StatusToolBar;
import mx.viewer.manager.ImageManager;
import mx.viewer.manager.ViewerManager;

public class MainContainer
extends JPanel {
    private static final long serialVersionUID = -4556146446303201556L;
    private ViewerManager viewerManager;
    private ToolToolBar toolToolBar = null;
    private NavigationToolBar navigationToolBar = null;
    private IconPanelContainer imageContainer = null;
    private StatusToolBar statusToolBar = null;

    public MainContainer(ViewerManager viewerManager) {
        this.viewerManager = viewerManager;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.imageContainer = new IconPanelContainer(this);
        this.toolToolBar = new ToolToolBar(this, this.viewerManager, "West", 1);
        this.navigationToolBar = new NavigationToolBar(this, this.viewerManager, "North", 0);
        this.statusToolBar = new StatusToolBar(this, this.viewerManager, "South", 0);
        this.imageContainer.setStatusToolBar(this.statusToolBar);
    }

    public void addPanel() {
        this.imageContainer.addPanel(new IconScrollPanel(this.imageContainer));
    }

    public void addImage(String caption) {
        this.navigationToolBar.addImage(caption);
    }

    public void setImageLayout(int imageLayout) {
        this.imageContainer.setImageLayout(imageLayout);
    }

    public void setImage(ImageManager image) {
        this.imageContainer.setImage(image);
    }

    public void setCurrent(int current) {
        this.navigationToolBar.setCurrentImage(current);
    }

    public void save() {
        this.imageContainer.save();
    }

    public void printFull(Book bk, PageFormat userPageFormat) {
        this.imageContainer.printFull(bk, userPageFormat);
    }

    public void setMouseMode(int mouseMode) {
        this.imageContainer.setMouseMode(mouseMode);
    }

    public void setDisplayMode(int displayMode) {
        this.imageContainer.setDisplayMode(displayMode);
    }

    public void setZoomIncrement(int zoomIncrement) {
        this.imageContainer.setZoomIncrement(zoomIncrement);
        this.statusToolBar.setZoom(this.imageContainer.getZoom());
    }

    public void zoomUp() {
        this.imageContainer.zoomUp();
        this.statusToolBar.setZoom(this.imageContainer.getZoom());
    }

    public void zoomDown() {
        this.imageContainer.zoomDown();
        this.statusToolBar.setZoom(this.imageContainer.getZoom());
    }

    public void rotateBitmap(int direction) {
        this.imageContainer.rotateBitmap(direction);
    }

    public void invertBitmap() {
        this.imageContainer.invertBitmap();
    }

    public void setNavigationToolBarVisible(boolean visible) {
        this.navigationToolBar.setVisible(visible);
    }

    public void setNavigationToolBarAutoVisible(boolean visible) {
        this.navigationToolBar.setVisibleAuto(visible);
    }

    public void setToolToolBarVisible(boolean visible) {
        this.toolToolBar.setVisible(visible);
    }

    public void setToolPopupMenuEnable(boolean enable) {
        this.imageContainer.setToolPopupMenuEnable(enable);
    }

    public void setPrintVisible(boolean visible) {
        this.toolToolBar.setPrintVisible(visible);
        this.imageContainer.setPrintVisible(visible);
    }

    public void setSaveVisible(boolean visible) {
        this.toolToolBar.setSaveVisible(visible);
        this.imageContainer.setSaveVisible(visible);
    }

    public void setFullScreen(boolean fullScren) {
        if (this.navigationToolBar.isVisibleAuto()) {
            this.navigationToolBar.setVisible(fullScren);
        }
    }

    public void setFullScreenVisible(boolean visible) {
        this.toolToolBar.setFullScreenVisible(visible);
    }

    public void clearImgAll() {
        this.navigationToolBar.clearImgAll();
    }
}

