/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.manager;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import mx.viewer.manager.DisplayIconManager;
import mx.viewer.manager.PrintIconManager;
import mx.viewer.util.BitmapLoader;
import mx.viewer.util.BitmapSaver;
import mx.viewer.util.SwingWorkerNotifier;

public class IconManager
implements Printable {
    public static final int BR_CLOCKWISE = 1;
    public static final int BR_UNCLOCKWISE = -1;
    private String fileName = "";
    private PlanarImage bitmap = null;
    private String password = "";
    private Component component = null;

    public void initialize() {
    }

    public IconManager(String fileName, String password, Component component) {
        this.initialize();
        this.component = component;
        this.setPassword(password);
        this.setFileName(fileName);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        String ris = "";
        int pos = 0;
        pos = this.fileName.lastIndexOf("/");
        ris = pos == -1 ? this.fileName : this.fileName.substring(pos + 1);
        pos = ris.lastIndexOf("=");
        if (pos > -1) {
            ris = ris.substring(pos + 1);
        }
        return ris;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getColorType() {
        String ret = "";
        if (this.bitmap != null) {
            int colorType = this.bitmap.getColorModel().getColorSpace().getType();
            switch (colorType) {
                case 0: {
                    ret = "Any of the family of XYZ color spaces.";
                    break;
                }
                case 1: {
                    ret = "Any of the family of Lab color spaces.";
                    break;
                }
                case 2: {
                    ret = "Any of the family of Luv color spaces.";
                    break;
                }
                case 3: {
                    ret = "Any of the family of YCbCr color spaces.";
                    break;
                }
                case 4: {
                    ret = "Any of the family of Yxy color spaces.";
                    break;
                }
                case 5: {
                    ret = "Any of the family of RGB color spaces.";
                    break;
                }
                case 6: {
                    ret = "Any of the family of GRAY color spaces.";
                    break;
                }
                case 7: {
                    ret = "Any of the family of HSV color spaces.";
                    break;
                }
                case 8: {
                    ret = "Any of the family of HLS color spaces.";
                    break;
                }
                case 9: {
                    ret = "Any of the family of CMYK color spaces.";
                    break;
                }
                case 11: {
                    ret = "Any of the family of CMY color spaces.";
                    break;
                }
                case 12: {
                    ret = "Generic 2 component color spaces.";
                    break;
                }
                case 13: {
                    ret = "Generic 3 component color spaces.";
                    break;
                }
                case 14: {
                    ret = "Generic 4 component color spaces.";
                    break;
                }
                case 15: {
                    ret = "Generic 5 component color spaces.";
                    break;
                }
                case 16: {
                    ret = "Generic 6 component color spaces.";
                    break;
                }
                case 17: {
                    ret = "Generic 7 component color spaces.";
                    break;
                }
                case 18: {
                    ret = "Generic 8 component color spaces.";
                    break;
                }
                case 19: {
                    ret = "Generic 9 component color spaces.";
                    break;
                }
                case 20: {
                    ret = "Generic 10 component color spaces.";
                    break;
                }
                case 21: {
                    ret = "Generic 11 component color spaces.";
                    break;
                }
                case 22: {
                    ret = "Generic 12 component color spaces.";
                    break;
                }
                case 23: {
                    ret = "Generic 13 component color spaces.";
                    break;
                }
                case 24: {
                    ret = "Generic 14 component color spaces.";
                    break;
                }
                case 25: {
                    ret = "Generic 15 component color spaces.";
                    break;
                }
                case 1000: {
                    ret = "The sRGB color space defined at http://www.w3.org/pub/WWW/Graphics/Color/sRGB.html.";
                    break;
                }
                case 1004: {
                    ret = "A built-in linear RGB color space.";
                    break;
                }
                case 1001: {
                    ret = "The CIEXYZ conversion color space.";
                    break;
                }
                case 1002: {
                    ret = "The Photo YCC conversion color space.";
                    break;
                }
                case 1003: {
                    ret = "The built-in linear gray scale color space.";
                    break;
                }
                default: {
                    ret = "Unknown.";
                    break;
                }
            }
        } else {
            ret = "Unknown.";
        }
        return ret;
    }

    public int getWidth() {
        int width = this.bitmap == null ? 0 : this.bitmap.getWidth();
        return width;
    }

    public int getHeight() {
        int height = this.bitmap == null ? 0 : this.bitmap.getHeight();
        return height;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void loadBitmap() {
        this.setBitmap(BitmapLoader.loadBitmap(this.getFileName(), this.getPassword()));
    }

    public void saveBitmap(String fileName, SwingWorkerNotifier objToNotify) {
        BitmapSaver.threadSaveBitmap(fileName, this.getBitmap(), objToNotify, this.component);
        System.gc();
    }

    public PlanarImage getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(PlanarImage bitmap) {
        this.bitmap = bitmap;
        System.gc();
    }

    public void rotateBitmap(int direction) {
        if (this.bitmap != null) {
            Interpolation interp = null;
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.bitmap);
            pb.add(0.0f);
            pb.add(0.0f);
            if (direction == 1) {
                pb.add(1.5707964f);
            } else {
                pb.add(-1.5707964f);
            }
            if (interp == null) {
                interp = Interpolation.getInstance((int)0);
            }
            pb.add(interp);
            RenderedOp tempImage = JAI.create((String)"rotate", (ParameterBlock)pb);
            float x = 0.0f - (float)tempImage.getMinX();
            float y = 0.0f - (float)tempImage.getMinY();
            pb = new ParameterBlock();
            pb.addSource(tempImage);
            pb.add(x);
            pb.add(y);
            this.setBitmap((PlanarImage)JAI.create((String)"translate", (ParameterBlock)pb));
        }
    }

    public void invertBitmap() {
        if (this.bitmap != null) {
            this.setBitmap((PlanarImage)JAI.create((String)"invert", (RenderedImage)this.bitmap));
        }
    }

    public PrintIconManager cropImage(Rectangle cropRect) {
        ParameterBlock pbInput = new ParameterBlock();
        pbInput.addSource(this.getBitmap());
        pbInput.add(new Float(cropRect.x));
        pbInput.add(new Float(cropRect.y));
        pbInput.add(new Float(cropRect.width));
        pbInput.add(new Float(cropRect.height));
        RenderedOp tempImage = JAI.create((String)"crop", (ParameterBlock)pbInput);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(tempImage);
        pb.add(new Float(-cropRect.x));
        pb.add(new Float(-cropRect.y));
        return new PrintIconManager((PlanarImage)JAI.create((String)"translate", (ParameterBlock)pb));
    }

    public DisplayIconManager createDisplayIcon(ParameterBlock pbInput) {
        return new DisplayIconManager((RenderedImage)this.bitmap, pbInput);
    }

    public int print(Graphics graphics, PageFormat pf, int pageIndex) throws PrinterException {
        int ret = 1;
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)graphics;
            g2.translate(pf.getImageableX(), pf.getImageableY());
            int imgWidth = this.getWidth();
            int imgHeight = this.getHeight();
            double xRatio = pf.getImageableWidth() / (double)imgWidth;
            double yRatio = pf.getImageableHeight() / (double)imgHeight;
            double aspectRatio = Math.min(xRatio, yRatio);
            AffineTransform at = new AffineTransform();
            if (aspectRatio > 1.0) {
                aspectRatio = 1.0;
            }
            at.scale(aspectRatio, aspectRatio);
            g2.drawRenderedImage((RenderedImage)this.bitmap, at);
            ret = 0;
        }
        return ret;
    }
}

