/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.manager;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;

public class PrintIconManager
implements Printable {
    private PlanarImage cropImage = null;
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int height = 0;

    public PrintIconManager(ParameterBlock pbInput) {
        this.setX(new Float(pbInput.getFloatParameter(0)).intValue());
        this.setY(new Float(pbInput.getFloatParameter(1)).intValue());
        this.setWidth(new Float(pbInput.getFloatParameter(2)).intValue());
        this.setHeight(new Float(pbInput.getFloatParameter(3)).intValue());
        this.cropImage = JAI.create((String)"crop", (ParameterBlock)pbInput);
    }

    public PrintIconManager(PlanarImage anImage) {
        this.cropImage = anImage;
        this.setX(0);
        this.setY(0);
        this.setWidth(new Float(anImage.getWidth()).intValue());
        this.setHeight(new Float(anImage.getHeight()).intValue());
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int print(Graphics graphics, PageFormat pf, int pageIndex) throws PrinterException {
        int ret = 1;
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)graphics;
            g2.translate(pf.getImageableX(), pf.getImageableY());
            int imgWidth = this.getWidth();
            int imgHeight = this.getHeight();
            double xRatio = pf.getImageableWidth() / (double)imgWidth;
            double yRatio = pf.getImageableHeight() / (double)imgHeight;
            double aspectRatio = Math.min(xRatio, yRatio);
            AffineTransform at = new AffineTransform();
            if (aspectRatio > 1.0) {
                aspectRatio = 1.0;
            }
            at.scale(aspectRatio, aspectRatio);
            g2.drawRenderedImage((RenderedImage)this.cropImage, at);
            ret = 0;
        }
        return ret;
    }
}

