/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.manager;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import mx.viewer.manager.CursorManager;
import mx.viewer.manager.Selectable;

public class SelectionManager
implements MouseListener,
MouseMotionListener {
    private Selectable panel = null;
    private Point selectionStart = null;
    private Point selectionEnd = null;
    private Rectangle paintRect = null;
    private boolean isSelecting = false;
    private Cursor crossCursor = null;
    private Cursor oldPanelCursor = null;
    private boolean activated = false;
    private Dimension minSize = null;

    public SelectionManager(Selectable panel) {
        this.panel = panel;
        this.initialize();
    }

    private void initialize() {
        this.selectionStart = new Point(0, 0);
        this.selectionEnd = new Point(0, 0);
        this.crossCursor = CursorManager.defaultMouseCursor(1);
        this.panel.addMouseListener(this);
        this.panel.addMouseMotionListener(this);
    }

    public void activate() {
        this.oldPanelCursor = this.panel.getCursor();
        this.activated = true;
    }

    public void deActivate() {
        this.activated = false;
    }

    public Dimension getMinSize() {
        return this.minSize;
    }

    public void setMinSize(Dimension minSize) {
        this.minSize = minSize;
    }

    private void setSelectionStart(MouseEvent e) {
        this.selectionStart = this.getMousePosition(e);
    }

    private void setSelectionEnd(MouseEvent e) {
        this.selectionEnd = this.getMousePosition(e);
    }

    private Point getMousePosition(MouseEvent e) {
        return new Point(e.getX(), e.getY());
    }

    private void createPaintRectangle() {
        this.paintRect = new Rectangle();
        if (this.selectionStart.x > this.selectionEnd.x) {
            this.paintRect.x = this.selectionEnd.x;
            this.paintRect.width = this.selectionStart.x - this.selectionEnd.x;
        } else {
            this.paintRect.x = this.selectionStart.x;
            this.paintRect.width = this.selectionEnd.x - this.selectionStart.x;
        }
        if (this.selectionStart.y > this.selectionEnd.y) {
            this.paintRect.y = this.selectionEnd.y;
            this.paintRect.height = this.selectionStart.y - this.selectionEnd.y;
        } else {
            this.paintRect.y = this.selectionStart.y;
            this.paintRect.height = this.selectionEnd.y - this.selectionStart.y;
        }
    }

    private boolean checkSize() {
        boolean ret = true;
        if (this.getMinSize() != null) {
            ret = this.paintRect.width < this.minSize.width || this.paintRect.height < this.minSize.height;
        }
        return ret;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Point mousePosition;
        if (this.activated && e.getButton() == 1 && this.panel.isInImageRect(mousePosition = this.getMousePosition(e))) {
            this.setSelectionStart(e);
            this.setSelectionEnd(e);
            this.createPaintRectangle();
            this.panel.beginSelection(this.paintRect);
            this.isSelecting = true;
        }
    }

    public void mouseReleased(MouseEvent e) {
        Point mousePosition;
        if (this.activated && e.getButton() == 1 && this.panel.isInImageRect(mousePosition = this.getMousePosition(e))) {
            this.isSelecting = false;
            this.setSelectionEnd(e);
            this.createPaintRectangle();
            if (this.checkSize()) {
                this.panel.endSelection(this.paintRect);
                this.panel.repaint();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.activated) {
            Point mousePosition = this.getMousePosition(e);
            if (this.isSelecting && this.panel.isInImageRect(mousePosition)) {
                this.setSelectionEnd(e);
                this.createPaintRectangle();
                this.panel.setSelectionRect(this.paintRect);
                this.panel.repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.activated) {
            Point mousePosition = this.getMousePosition(e);
            if (this.panel.isInImageRect(mousePosition)) {
                this.panel.setCursor(this.crossCursor);
            } else {
                this.panel.setCursor(this.oldPanelCursor);
            }
        }
    }
}

