/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.manager;

import java.awt.Component;
import java.awt.Container;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import mx.viewer.applet.ViewerRelease;
import mx.viewer.gui.FrameContainer;
import mx.viewer.gui.MainContainer;
import mx.viewer.interf.IToolBarNavigazione;
import mx.viewer.manager.ImageManager;
import mx.viewer.toolBar.ToolBarNavigazioneMultiImage;

public class ViewerManager {
    protected Container container = null;
    protected String constraint = null;
    protected MainContainer mainContainer = null;
    private FrameContainer externalFrame = null;
    private IToolBarNavigazione toolBarNavigazione = null;

    public ViewerManager() {
        this.initialize();
    }

    private void initialize() {
        this.mainContainer = new MainContainer(this);
        this.toolBarNavigazione = new ToolBarNavigazioneMultiImage(this.mainContainer);
    }

    public void setContainer(Container container, String constraint) {
        this.container = container;
        this.constraint = constraint;
        container.add((Component)this.mainContainer, constraint);
    }

    public void addPanel() {
        this.mainContainer.addPanel();
    }

    public void viewImage(String basePath, String fileNames, String password, boolean otp) {
        this.mainContainer.setImage(new ImageManager(basePath, "", fileNames, password, otp, this.container));
    }

    public void setImageLayout(int imageLayout) {
        this.mainContainer.setImageLayout(imageLayout);
    }

    public void setDisplayMode(int displayMode) {
        this.mainContainer.setDisplayMode(displayMode);
    }

    public void save() {
        this.mainContainer.save();
    }

    public void printFull() {
        PageFormat userPageFormat;
        PageFormat defaultPageFormat;
        PrinterJob job = PrinterJob.getPrinterJob();
        Book bk = new Book();
        if (job.printDialog() && (defaultPageFormat = job.defaultPage()) != (userPageFormat = job.pageDialog(defaultPageFormat))) {
            this.mainContainer.printFull(bk, userPageFormat);
            job.setPageable(bk);
            try {
                job.print();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setMouseMode(int mouseMode) {
        this.mainContainer.setMouseMode(mouseMode);
    }

    public void setZoomIncrement(int zoomIncrement) {
        this.mainContainer.setZoomIncrement(zoomIncrement);
    }

    public void zoomUp() {
        this.mainContainer.zoomUp();
    }

    public void zoomDown() {
        this.mainContainer.zoomDown();
    }

    public void rotateBitmap(int direction) {
        this.mainContainer.rotateBitmap(direction);
    }

    public void invertBitmap() {
        this.mainContainer.invertBitmap();
    }

    public void toggleFrame() {
        if (this.externalFrame == null) {
            this.mainContainer.setFullScreen(true);
            this.externalFrame = new FrameContainer(String.valueOf(ViewerRelease.title) + " " + ViewerRelease.version, this.mainContainer, this);
            this.externalFrame.showMe();
            this.container.setVisible(false);
        } else {
            this.mainContainer.setFullScreen(false);
            this.container.add((Component)this.mainContainer, this.constraint);
            this.container.setVisible(true);
            this.externalFrame.dispose();
            this.externalFrame = null;
        }
    }

    public void closeMe() {
        if (this.externalFrame != null) {
            this.container.add((Component)this.mainContainer, this.constraint);
            this.container.setVisible(true);
            this.externalFrame.dispose();
            this.externalFrame = null;
        }
    }

    public void setNavigationToolBarVisible(boolean visible) {
        this.mainContainer.setNavigationToolBarVisible(visible);
    }

    public void setNavigationToolBarAutomatic(boolean toolBarAuto, IToolBarNavigazione toolBarNavigazione) {
        this.mainContainer.setNavigationToolBarAutoVisible(toolBarAuto);
        this.toolBarNavigazione = toolBarNavigazione;
    }

    public void setToolToolBarVisible(boolean visible) {
        this.mainContainer.setToolToolBarVisible(visible);
    }

    public void setToolPopupMenuEnable(boolean enable) {
        this.mainContainer.setToolPopupMenuEnable(enable);
    }

    public void setPrintVisible(boolean visible) {
        this.mainContainer.setPrintVisible(visible);
    }

    public void setSaveVisible(boolean visible) {
        this.mainContainer.setSaveVisible(visible);
    }

    public void setFullScreenVisible(boolean visible) {
        this.mainContainer.setFullScreenVisible(visible);
    }

    public void setTitle(String title) {
        if (!title.trim().equals("")) {
            ViewerRelease.title = title;
        }
    }

    public IToolBarNavigazione getToolBarNavigazione() {
        return this.toolBarNavigazione;
    }

    public MainContainer getMainContainer() {
        return this.mainContainer;
    }
}

