/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.toolBar;

import java.util.Vector;
import mx.viewer.gui.MainContainer;
import mx.viewer.interf.IToolBarNavigazione;
import mx.viewer.manager.ImageManager;

public class ToolBarNavigazioneMultiImage
implements IToolBarNavigazione {
    private int current = -1;
    private MainContainer mainContainer = null;
    protected Vector imageList = null;

    public ToolBarNavigazioneMultiImage(MainContainer mainContainer) {
        this.mainContainer = mainContainer;
        this.imageList = new Vector();
    }

    private ImageManager getImage(int n) {
        return (ImageManager)this.imageList.get(n);
    }

    private int getCurrent() {
        return this.current;
    }

    public void setCurrent(int current) {
        if (current >= 0 && current < this.imageCount()) {
            if (this.getCurrent() >= 0 && this.getCurrent() < this.imageCount()) {
                this.getImage(this.getCurrent()).setLoad(false);
            }
            this.current = current;
            this.mainContainer.setImage(this.getImage(current));
            this.mainContainer.setCurrent(current);
        }
    }

    public int addImage(ImageManager image) {
        this.imageList.add(image);
        this.mainContainer.addImage(image.getCaption());
        return this.imageList.size();
    }

    public int imageCount() {
        return this.imageList.size();
    }

    public void moveFirst() {
        this.setCurrent(0);
    }

    public void moveLast() {
        this.setCurrent(this.imageCount() - 1);
    }

    public void moveNext() {
        this.setCurrent(this.getCurrent() + 1);
    }

    public void movePrevious() {
        this.setCurrent(this.getCurrent() - 1);
    }
}

