/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import javax.media.jai.PlanarImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import mx.viewer.manager.DisplayIconManager;

public class FileSaveAs {
    public static final String jpeg = "jpeg";
    public static final String jpg = "jpg";
    public static final String gif = "gif";
    public static final String tiff = "tiff";
    public static final String tif = "tif";
    public static final String png = "png";
    private JFileChooser fc;
    private String fileName = "";
    private Component parent = null;

    public FileSaveAs(Component parent, PlanarImage image, String defaultFileName) {
        this.parent = parent;
        this.fc = new JFileChooser();
        this.fc.setSelectedFile(new File(new File(defaultFileName).getName()));
        this.fc.setAccessory(new ImagePreview(this.fc, image));
        ImageFilter png = new ImageFilter(png);
        this.fc.addChoosableFileFilter(png);
        ImageFilter jpg = new ImageFilter(jpg);
        this.fc.addChoosableFileFilter(jpg);
        ImageFilter tif = new ImageFilter(tif);
        this.fc.addChoosableFileFilter(tif);
        if (defaultFileName.toLowerCase().endsWith(jpg) || defaultFileName.toLowerCase().endsWith(jpeg)) {
            this.fc.setFileFilter(jpg);
        } else if (defaultFileName.toLowerCase().endsWith(tif) || defaultFileName.toLowerCase().endsWith(tiff)) {
            this.fc.setFileFilter(tif);
        } else {
            this.fc.setFileFilter(png);
        }
        this.fc.setAcceptAllFileFilterUsed(false);
    }

    public static final String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean saveAs() {
        boolean returnVal = false;
        String fileName = "";
        String ext = "";
        boolean bl = returnVal = this.fc.showSaveDialog(this.parent) == 0;
        if (returnVal) {
            fileName = this.fc.getSelectedFile().getAbsolutePath();
            if (!fileName.endsWith("." + (ext = this.fc.getFileFilter().toString()))) {
                fileName = String.valueOf(fileName) + "." + ext;
            }
            this.setFileName(fileName);
        } else {
            this.setFileName("");
        }
        return returnVal;
    }

    public class ImageFilter
    extends FileFilter {
        String estensione = "png";

        public ImageFilter(String estensione) {
            this.estensione = estensione;
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = FileSaveAs.getExtension(f);
            if (extension != null) {
                return extension.equals(this.estensione);
            }
            return false;
        }

        public String getDescription() {
            return "Immagini " + this.estensione + " (*." + this.estensione + ")";
        }

        public String toString() {
            return this.estensione;
        }
    }

    public class ImagePreview
    extends JComponent {
        private static final long serialVersionUID = 7263353677432901635L;
        Icon thumbnail = null;
        PlanarImage image = null;

        public ImagePreview(JFileChooser fc, PlanarImage image) {
            this.setPreferredSize(new Dimension(100, 142));
            this.image = image;
            this.loadImage();
        }

        public void loadImage() {
            if (this.image == null) {
                this.thumbnail = null;
                return;
            }
            ParameterBlock pbInput = null;
            Dimension d = null;
            d = this.getPreferredSize();
            pbInput = new ParameterBlock();
            pbInput.add(1);
            pbInput.add((float)d.getWidth());
            pbInput.add((float)d.getHeight());
            pbInput.add(new Dimension(0, 0));
            pbInput.add(0);
            pbInput.add(-1.0f);
            pbInput.add(-1.0f);
            this.thumbnail = new DisplayIconManager((RenderedImage)this.image, pbInput);
        }

        protected void paintComponent(Graphics g) {
            if (this.thumbnail == null) {
                this.loadImage();
            }
            if (this.thumbnail != null) {
                int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
                int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
                if (y < 0) {
                    y = 0;
                }
                if (x < 5) {
                    x = 5;
                }
                this.thumbnail.paintIcon(this, g, x, y);
            }
        }
    }
}

