/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DeferredAttrImpl;
import org.apache.xerces.dom.DeferredAttrNSImpl;
import org.apache.xerces.dom.DeferredCDATASectionImpl;
import org.apache.xerces.dom.DeferredCommentImpl;
import org.apache.xerces.dom.DeferredDocumentTypeImpl;
import org.apache.xerces.dom.DeferredElementDefinitionImpl;
import org.apache.xerces.dom.DeferredElementImpl;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.apache.xerces.dom.DeferredEntityImpl;
import org.apache.xerces.dom.DeferredEntityReferenceImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.DeferredNotationImpl;
import org.apache.xerces.dom.DeferredProcessingInstructionImpl;
import org.apache.xerces.dom.DeferredTextImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.utils.StringPool;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeferredDocumentImpl
extends DocumentImpl
implements DeferredNode {
    static final long serialVersionUID = 5186323580749626857L;
    private static final boolean DEBUG_PRINT_REF_COUNTS = false;
    private static final boolean DEBUG_PRINT_TABLES = false;
    private static final boolean DEBUG_IDS = false;
    protected static final int CHUNK_SHIFT = 11;
    protected static final int CHUNK_SIZE = 2048;
    protected static final int CHUNK_MASK = 2047;
    protected static final int INITIAL_CHUNK_COUNT = 32;
    protected transient int fNodeCount = 0;
    protected transient int[][] fNodeType;
    protected transient int[][] fNodeName;
    protected transient int[][] fNodeValue;
    protected transient int[][] fNodeParent;
    protected transient int[][] fNodeLastChild;
    protected transient int[][] fNodePrevSib;
    protected transient int[][] fNodeURI;
    protected transient int fIdCount;
    protected transient int[] fIdName;
    protected transient int[] fIdElement;
    protected transient StringPool fStringPool;
    protected boolean fNamespacesEnabled = false;
    private final StringBuffer fBufferStr = new StringBuffer();
    private final Vector fStrChunks = new Vector();

    public DeferredDocumentImpl(StringPool stringPool) {
        this(stringPool, false);
    }

    public DeferredDocumentImpl(StringPool stringPool, boolean namespacesEnabled) {
        this(stringPool, namespacesEnabled, false);
    }

    public DeferredDocumentImpl(StringPool stringPool, boolean namespaces, boolean grammarAccess) {
        super(grammarAccess);
        this.fStringPool = stringPool;
        this.needsSyncData(true);
        this.needsSyncChildren(true);
        this.fNamespacesEnabled = namespaces;
    }

    boolean getNamespacesEnabled() {
        return this.fNamespacesEnabled;
    }

    public int createDocument() {
        int nodeIndex = this.createNode((short)9);
        return nodeIndex;
    }

    public int createDocumentType(int rootElementNameIndex, int publicId, int systemId) {
        int nodeIndex = this.createNode((short)10);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int extraDataIndex = this.createNode((short)0);
        int echunk = extraDataIndex >> 11;
        int eindex = extraDataIndex & 0x7FF;
        this.setChunkIndex(this.fNodeName, rootElementNameIndex, chunk, index);
        this.setChunkIndex(this.fNodeValue, extraDataIndex, chunk, index);
        this.setChunkIndex(this.fNodeName, publicId, echunk, eindex);
        this.setChunkIndex(this.fNodeValue, systemId, echunk, eindex);
        return nodeIndex;
    }

    public void setInternalSubset(int doctypeIndex, int subsetIndex) {
        int chunk = doctypeIndex >> 11;
        int index = doctypeIndex & 0x7FF;
        int extraDataIndex = this.fNodeValue[chunk][index];
        int echunk = extraDataIndex >> 11;
        int eindex = extraDataIndex & 0x7FF;
        this.setChunkIndex(this.fNodeLastChild, subsetIndex, echunk, eindex);
    }

    public int createNotation(int notationName, int publicId, int systemId) throws Exception {
        int nodeIndex = this.createNode((short)12);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int extraDataIndex = this.createNode((short)0);
        int echunk = extraDataIndex >> 11;
        int eindex = extraDataIndex & 0x7FF;
        this.setChunkIndex(this.fNodeName, notationName, chunk, index);
        this.setChunkIndex(this.fNodeValue, extraDataIndex, chunk, index);
        this.setChunkIndex(this.fNodeName, publicId, echunk, eindex);
        this.setChunkIndex(this.fNodeValue, systemId, echunk, eindex);
        return nodeIndex;
    }

    public int createEntity(int entityName, int publicId, int systemId, int notationName) throws Exception {
        int nodeIndex = this.createNode((short)6);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int extraDataIndex = this.createNode((short)0);
        int echunk = extraDataIndex >> 11;
        int eindex = extraDataIndex & 0x7FF;
        int extraDataIndex2 = this.createNode((short)0);
        int echunk2 = extraDataIndex2 >> 11;
        int eindex2 = extraDataIndex2 & 0x7FF;
        this.setChunkIndex(this.fNodeName, entityName, chunk, index);
        this.setChunkIndex(this.fNodeValue, extraDataIndex, chunk, index);
        this.setChunkIndex(this.fNodeLastChild, notationName, echunk, eindex);
        this.setChunkIndex(this.fNodeName, publicId, echunk, eindex);
        this.setChunkIndex(this.fNodeValue, extraDataIndex2, echunk, eindex);
        this.setChunkIndex(this.fNodeName, systemId, echunk2, eindex2);
        this.setChunkIndex(this.fNodeValue, -1, echunk2, eindex2);
        this.setChunkIndex(this.fNodeLastChild, -1, echunk2, eindex2);
        return nodeIndex;
    }

    public void setEntityInfo(int currentEntityDecl, int versionIndex, int encodingIndex) {
        int eNodeIndex = this.getNodeValue(this.getNodeValue(currentEntityDecl, false), false);
        if (eNodeIndex != -1) {
            int echunk = eNodeIndex >> 11;
            int eindex = eNodeIndex & 0x7FF;
            this.setChunkIndex(this.fNodeValue, versionIndex, echunk, eindex);
            this.setChunkIndex(this.fNodeLastChild, encodingIndex, echunk, eindex);
        }
    }

    public int createEntityReference(int nameIndex) throws Exception {
        int nodeIndex = this.createNode((short)5);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.setChunkIndex(this.fNodeName, nameIndex, chunk, index);
        return nodeIndex;
    }

    public int createElement(int elementNameIndex, XMLAttrList attrList, int attrListIndex) {
        return this.createElement(elementNameIndex, -1, attrList, attrListIndex);
    }

    public int createElement(int elementNameIndex, int elementURIIndex, XMLAttrList attrList, int attrListIndex) {
        int elementNodeIndex = this.createNode((short)1);
        int elementChunk = elementNodeIndex >> 11;
        int elementIndex = elementNodeIndex & 0x7FF;
        this.setChunkIndex(this.fNodeName, elementNameIndex, elementChunk, elementIndex);
        this.setChunkIndex(this.fNodeURI, elementURIIndex, elementChunk, elementIndex);
        if (attrListIndex != -1) {
            int first = attrList.getFirstAttr(attrListIndex);
            int lastAttrNodeIndex = -1;
            int lastAttrChunk = -1;
            int lastAttrIndex = -1;
            int index = first;
            while (index != -1) {
                int attrNodeIndex = this.createAttribute(attrList.getAttrName(index), attrList.getAttrURI(index), attrList.getAttValue(index), attrList.isSpecified(index));
                int attrChunk = attrNodeIndex >> 11;
                int attrIndex = attrNodeIndex & 0x7FF;
                this.setChunkIndex(this.fNodeParent, elementNodeIndex, attrChunk, attrIndex);
                if (index == first) {
                    this.setChunkIndex(this.fNodeValue, attrNodeIndex, elementChunk, elementIndex);
                } else {
                    this.setChunkIndex(this.fNodePrevSib, attrNodeIndex, lastAttrChunk, lastAttrIndex);
                }
                lastAttrNodeIndex = attrNodeIndex;
                lastAttrChunk = attrChunk;
                lastAttrIndex = attrIndex;
                index = attrList.getNextAttr(index);
            }
        }
        return elementNodeIndex;
    }

    public int createAttribute(int attrNameIndex, int attrValueIndex, boolean specified) {
        return this.createAttribute(attrNameIndex, -1, attrValueIndex, specified);
    }

    public int createAttribute(int attrNameIndex, int attrURIIndex, int attrValueIndex, boolean specified) {
        int nodeIndex = this.createNode((short)2);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.setChunkIndex(this.fNodeName, attrNameIndex, chunk, index);
        this.setChunkIndex(this.fNodeURI, attrURIIndex, chunk, index);
        this.setChunkIndex(this.fNodeValue, specified ? 1 : 0, chunk, index);
        int textNodeIndex = this.createTextNode(attrValueIndex, false);
        this.appendChild(nodeIndex, textNodeIndex);
        return nodeIndex;
    }

    public int createElementDefinition(int elementNameIndex) {
        int nodeIndex = this.createNode((short)-1);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.setChunkIndex(this.fNodeName, elementNameIndex, chunk, index);
        return nodeIndex;
    }

    public int createTextNode(int dataIndex, boolean ignorableWhitespace) {
        int nodeIndex = this.createNode((short)3);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.setChunkIndex(this.fNodeValue, dataIndex, chunk, index);
        this.setChunkIndex(this.fNodeLastChild, ignorableWhitespace ? 1 : 0, chunk, index);
        return nodeIndex;
    }

    public int createCDATASection(int dataIndex, boolean ignorableWhitespace) {
        int nodeIndex = this.createNode((short)4);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.setChunkIndex(this.fNodeValue, dataIndex, chunk, index);
        this.setChunkIndex(this.fNodeLastChild, ignorableWhitespace ? 1 : 0, chunk, index);
        return nodeIndex;
    }

    public int createProcessingInstruction(int targetIndex, int dataIndex) {
        int nodeIndex = this.createNode((short)7);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.setChunkIndex(this.fNodeName, targetIndex, chunk, index);
        this.setChunkIndex(this.fNodeValue, dataIndex, chunk, index);
        return nodeIndex;
    }

    public int createComment(int dataIndex) {
        int nodeIndex = this.createNode((short)8);
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        this.setChunkIndex(this.fNodeValue, dataIndex, chunk, index);
        return nodeIndex;
    }

    public void appendChild(int parentIndex, int childIndex) {
        int pchunk = parentIndex >> 11;
        int pindex = parentIndex & 0x7FF;
        int cchunk = childIndex >> 11;
        int cindex = childIndex & 0x7FF;
        this.setChunkIndex(this.fNodeParent, parentIndex, cchunk, cindex);
        int olast = this.getChunkIndex(this.fNodeLastChild, pchunk, pindex);
        this.setChunkIndex(this.fNodePrevSib, olast, cchunk, cindex);
        this.setChunkIndex(this.fNodeLastChild, childIndex, pchunk, pindex);
    }

    public int setAttributeNode(int elemIndex, int attrIndex) {
        int echunk = elemIndex >> 11;
        int eindex = elemIndex & 0x7FF;
        int achunk = attrIndex >> 11;
        int aindex = attrIndex & 0x7FF;
        String attrName = this.fStringPool.toString(this.getChunkIndex(this.fNodeName, achunk, aindex));
        int oldAttrIndex = this.getChunkIndex(this.fNodeValue, echunk, eindex);
        int nextIndex = -1;
        int oachunk = -1;
        int oaindex = -1;
        while (oldAttrIndex != -1) {
            oachunk = oldAttrIndex >> 11;
            oaindex = oldAttrIndex & 0x7FF;
            String oldAttrName = this.fStringPool.toString(this.getChunkIndex(this.fNodeName, oachunk, oaindex));
            if (oldAttrName.equals(attrName)) break;
            nextIndex = oldAttrIndex;
            oldAttrIndex = this.getChunkIndex(this.fNodePrevSib, oachunk, oaindex);
        }
        if (oldAttrIndex != -1) {
            int prevIndex = this.getChunkIndex(this.fNodePrevSib, oachunk, oaindex);
            if (nextIndex == -1) {
                this.setChunkIndex(this.fNodeValue, prevIndex, echunk, eindex);
            } else {
                int pchunk = nextIndex >> 11;
                int pindex = nextIndex & 0x7FF;
                this.setChunkIndex(this.fNodePrevSib, prevIndex, pchunk, pindex);
            }
            this.clearChunkIndex(this.fNodeType, oachunk, oaindex);
            this.clearChunkIndex(this.fNodeName, oachunk, oaindex);
            this.clearChunkIndex(this.fNodeValue, oachunk, oaindex);
            this.clearChunkIndex(this.fNodeParent, oachunk, oaindex);
            this.clearChunkIndex(this.fNodePrevSib, oachunk, oaindex);
            int attrTextIndex = this.clearChunkIndex(this.fNodeLastChild, oachunk, oaindex);
            int atchunk = attrTextIndex >> 11;
            int atindex = attrTextIndex & 0x7FF;
            this.clearChunkIndex(this.fNodeType, atchunk, atindex);
            this.clearChunkIndex(this.fNodeValue, atchunk, atindex);
            this.clearChunkIndex(this.fNodeParent, atchunk, atindex);
            this.clearChunkIndex(this.fNodeLastChild, atchunk, atindex);
        }
        int prevIndex = this.getChunkIndex(this.fNodeValue, echunk, eindex);
        this.setChunkIndex(this.fNodeValue, attrIndex, echunk, eindex);
        this.setChunkIndex(this.fNodePrevSib, prevIndex, achunk, aindex);
        return oldAttrIndex;
    }

    public int insertBefore(int parentIndex, int newChildIndex, int refChildIndex) {
        if (refChildIndex == -1) {
            this.appendChild(parentIndex, newChildIndex);
            return newChildIndex;
        }
        int nchunk = newChildIndex >> 11;
        int nindex = newChildIndex & 0x7FF;
        int rchunk = refChildIndex >> 11;
        int rindex = refChildIndex & 0x7FF;
        int previousIndex = this.getChunkIndex(this.fNodePrevSib, rchunk, rindex);
        this.setChunkIndex(this.fNodePrevSib, newChildIndex, rchunk, rindex);
        this.setChunkIndex(this.fNodePrevSib, previousIndex, nchunk, nindex);
        return newChildIndex;
    }

    public void setAsLastChild(int parentIndex, int childIndex) {
        int pchunk = parentIndex >> 11;
        int pindex = parentIndex & 0x7FF;
        int chunk = childIndex >> 11;
        int index = childIndex & 0x7FF;
        this.setChunkIndex(this.fNodeLastChild, childIndex, pchunk, pindex);
    }

    public int getParentNode(int nodeIndex) {
        return this.getParentNode(nodeIndex, false);
    }

    public int getParentNode(int nodeIndex, boolean free) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        return free ? this.clearChunkIndex(this.fNodeParent, chunk, index) : this.getChunkIndex(this.fNodeParent, chunk, index);
    }

    public int getLastChild(int nodeIndex) {
        return this.getLastChild(nodeIndex, true);
    }

    public int getLastChild(int nodeIndex, boolean free) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        return free ? this.clearChunkIndex(this.fNodeLastChild, chunk, index) : this.getChunkIndex(this.fNodeLastChild, chunk, index);
    }

    public int getPrevSibling(int nodeIndex) {
        return this.getPrevSibling(nodeIndex, true);
    }

    public int getPrevSibling(int nodeIndex, boolean free) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int type = this.getChunkIndex(this.fNodeType, chunk, index);
        if (type == 3) {
            while ((nodeIndex = this.getChunkIndex(this.fNodePrevSib, chunk, index)) != -1 && (type = this.getChunkIndex(this.fNodeType, chunk = nodeIndex >> 11, index = nodeIndex & 0x7FF)) == 3) {
            }
        } else {
            nodeIndex = this.getChunkIndex(this.fNodePrevSib, chunk, index);
        }
        return nodeIndex;
    }

    public int getRealPrevSibling(int nodeIndex) {
        return this.getRealPrevSibling(nodeIndex, true);
    }

    public int getRealPrevSibling(int nodeIndex, boolean free) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        return free ? this.clearChunkIndex(this.fNodePrevSib, chunk, index) : this.getChunkIndex(this.fNodePrevSib, chunk, index);
    }

    public int lookupElementDefinition(int elementNameIndex) {
        if (this.fNodeCount > 1) {
            int docTypeIndex = -1;
            int nchunk = 0;
            int nindex = 0;
            int index = this.getChunkIndex(this.fNodeLastChild, nchunk, nindex);
            while (index != -1) {
                nchunk = index >> 11;
                nindex = index & 0x7FF;
                if (this.getChunkIndex(this.fNodeType, nchunk, nindex) == 10) {
                    docTypeIndex = index;
                    break;
                }
                index = this.getChunkIndex(this.fNodePrevSib, nchunk, nindex);
            }
            if (docTypeIndex == -1) {
                return -1;
            }
            nchunk = docTypeIndex >> 11;
            nindex = docTypeIndex & 0x7FF;
            index = this.getChunkIndex(this.fNodeLastChild, nchunk, nindex);
            while (index != -1) {
                nchunk = index >> 11;
                nindex = index & 0x7FF;
                if (this.getChunkIndex(this.fNodeName, nchunk, nindex) == elementNameIndex) {
                    return index;
                }
                index = this.getChunkIndex(this.fNodePrevSib, nchunk, nindex);
            }
        }
        return -1;
    }

    public DeferredNode getNodeObject(int nodeIndex) {
        if (nodeIndex == -1) {
            return null;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int type = this.getChunkIndex(this.fNodeType, chunk, index);
        if (type != 3) {
            this.clearChunkIndex(this.fNodeType, chunk, index);
        }
        NodeImpl node = null;
        switch (type) {
            case 2: {
                if (this.fNamespacesEnabled) {
                    node = new DeferredAttrNSImpl(this, nodeIndex);
                    break;
                }
                node = new DeferredAttrImpl(this, nodeIndex);
                break;
            }
            case 4: {
                node = new DeferredCDATASectionImpl(this, nodeIndex);
                break;
            }
            case 8: {
                node = new DeferredCommentImpl(this, nodeIndex);
                break;
            }
            case 9: {
                node = this;
                break;
            }
            case 10: {
                node = new DeferredDocumentTypeImpl(this, nodeIndex);
                this.docType = (DocumentTypeImpl)node;
                break;
            }
            case 1: {
                node = this.fNamespacesEnabled ? new DeferredElementNSImpl(this, nodeIndex) : new DeferredElementImpl(this, nodeIndex);
                if (this.docElement == null) {
                    this.docElement = (ElementImpl)node;
                }
                if (this.fIdElement == null) break;
                int idIndex = DeferredDocumentImpl.binarySearch(this.fIdElement, 0, this.fIdCount - 1, nodeIndex);
                while (idIndex != -1) {
                    int nameIndex = this.fIdName[idIndex];
                    if (nameIndex != -1) {
                        String name = this.fStringPool.toString(nameIndex);
                        this.putIdentifier0(name, (Element)((Object)node));
                        this.fIdName[idIndex] = -1;
                    }
                    if (idIndex + 1 < this.fIdCount && this.fIdElement[idIndex + 1] == nodeIndex) {
                        ++idIndex;
                        continue;
                    }
                    idIndex = -1;
                }
                break;
            }
            case 6: {
                node = new DeferredEntityImpl(this, nodeIndex);
                break;
            }
            case 5: {
                node = new DeferredEntityReferenceImpl(this, nodeIndex);
                break;
            }
            case 12: {
                node = new DeferredNotationImpl(this, nodeIndex);
                break;
            }
            case 7: {
                node = new DeferredProcessingInstructionImpl(this, nodeIndex);
                break;
            }
            case 3: {
                node = new DeferredTextImpl(this, nodeIndex);
                break;
            }
            case -1: {
                node = new DeferredElementDefinitionImpl(this, nodeIndex);
                break;
            }
            default: {
                throw new IllegalArgumentException("type: " + type);
            }
        }
        if (node != null) {
            return node;
        }
        throw new IllegalArgumentException();
    }

    public String getNodeNameString(int nodeIndex) {
        return this.getNodeNameString(nodeIndex, true);
    }

    public String getNodeNameString(int nodeIndex, boolean free) {
        int nameIndex;
        if (nodeIndex == -1) {
            return null;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int n = nameIndex = free ? this.clearChunkIndex(this.fNodeName, chunk, index) : this.getChunkIndex(this.fNodeName, chunk, index);
        if (nameIndex == -1) {
            return null;
        }
        return this.fStringPool.toString(nameIndex);
    }

    public String getNodeValueString(int nodeIndex) {
        return this.getNodeValueString(nodeIndex, true);
    }

    public String getNodeValueString(int nodeIndex, boolean free) {
        int prevSib;
        int valueIndex;
        if (nodeIndex == -1) {
            return null;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        int n = valueIndex = free ? this.clearChunkIndex(this.fNodeValue, chunk, index) : this.getChunkIndex(this.fNodeValue, chunk, index);
        if (valueIndex == -1) {
            return null;
        }
        int type = this.getChunkIndex(this.fNodeType, chunk, index);
        if (type == 3 && (prevSib = this.getRealPrevSibling(nodeIndex)) != -1 && this.getNodeType(prevSib, false) == 3) {
            this.fStrChunks.addElement(this.fStringPool.toString(valueIndex));
            do {
                chunk = prevSib >> 11;
                index = prevSib & 0x7FF;
                valueIndex = this.getChunkIndex(this.fNodeValue, chunk, index);
                this.fStrChunks.addElement(this.fStringPool.toString(valueIndex));
            } while ((prevSib = this.getChunkIndex(this.fNodePrevSib, chunk, index)) != -1 && this.getNodeType(prevSib, false) == 3);
            int i = this.fStrChunks.size() - 1;
            while (i >= 0) {
                this.fBufferStr.append((String)this.fStrChunks.elementAt(i));
                --i;
            }
            String value = this.fBufferStr.toString();
            this.fStrChunks.setSize(0);
            this.fBufferStr.setLength(0);
            return value;
        }
        return this.fStringPool.toString(valueIndex);
    }

    public int getNodeName(int nodeIndex) {
        return this.getNodeName(nodeIndex, true);
    }

    public int getNodeName(int nodeIndex, boolean free) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        return free ? this.clearChunkIndex(this.fNodeName, chunk, index) : this.getChunkIndex(this.fNodeName, chunk, index);
    }

    public int getNodeValue(int nodeIndex) {
        return this.getNodeValue(nodeIndex, true);
    }

    public int getNodeValue(int nodeIndex, boolean free) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        return free ? this.clearChunkIndex(this.fNodeValue, chunk, index) : this.getChunkIndex(this.fNodeValue, chunk, index);
    }

    public short getNodeType(int nodeIndex) {
        return this.getNodeType(nodeIndex, true);
    }

    public short getNodeType(int nodeIndex, boolean free) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        if (free) {
            return (short)this.clearChunkIndex(this.fNodeType, chunk, index);
        }
        return (short)this.getChunkIndex(this.fNodeType, chunk, index);
    }

    public int getAttribute(int elemIndex, int nameIndex) {
        if (elemIndex == -1 || nameIndex == -1) {
            return -1;
        }
        int echunk = elemIndex >> 11;
        int eindex = elemIndex & 0x7FF;
        int attrIndex = this.getChunkIndex(this.fNodeValue, echunk, eindex);
        while (attrIndex != -1) {
            int achunk = attrIndex >> 11;
            int aindex = attrIndex & 0x7FF;
            if (this.getChunkIndex(this.fNodeName, achunk, aindex) == nameIndex) {
                return this.getChunkIndex(this.fNodeValue, achunk, aindex);
            }
            attrIndex = this.getChunkIndex(this.fNodePrevSib, achunk, aindex);
        }
        return -1;
    }

    public short getNodeURI(int nodeIndex) {
        return this.getNodeURI(nodeIndex, true);
    }

    public short getNodeURI(int nodeIndex, boolean free) {
        if (nodeIndex == -1) {
            return -1;
        }
        int chunk = nodeIndex >> 11;
        int index = nodeIndex & 0x7FF;
        if (free) {
            return (short)this.clearChunkIndex(this.fNodeURI, chunk, index);
        }
        return (short)this.getChunkIndex(this.fNodeURI, chunk, index);
    }

    public void putIdentifier(int nameIndex, int elementNodeIndex) {
        if (this.fIdName == null) {
            this.fIdName = new int[64];
            this.fIdElement = new int[64];
        }
        if (this.fIdCount == this.fIdName.length) {
            int[] idName = new int[this.fIdCount * 2];
            System.arraycopy(this.fIdName, 0, idName, 0, this.fIdCount);
            this.fIdName = idName;
            int[] idElement = new int[idName.length];
            System.arraycopy(this.fIdElement, 0, idElement, 0, this.fIdCount);
            this.fIdElement = idElement;
        }
        this.fIdName[this.fIdCount] = nameIndex;
        this.fIdElement[this.fIdCount] = elementNodeIndex;
        ++this.fIdCount;
    }

    public void print() {
    }

    public int getNodeIndex() {
        return 0;
    }

    protected StringPool getStringPool() {
        return this.fStringPool;
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
        if (this.fIdElement != null) {
            IntVector path = new IntVector();
            int i = 0;
            while (i < this.fIdCount) {
                int elementNodeIndex = this.fIdElement[i];
                int idNameIndex = this.fIdName[i];
                if (idNameIndex != -1) {
                    int pindex;
                    int pchunk;
                    path.removeAllElements();
                    int index = elementNodeIndex;
                    do {
                        path.addElement(index);
                    } while ((index = this.getChunkIndex(this.fNodeParent, pchunk = index >> 11, pindex = index & 0x7FF)) != -1);
                    Node place = this;
                    int j = path.size() - 2;
                    while (j >= 0) {
                        index = path.elementAt(j);
                        Node child = place.getLastChild();
                        while (child != null) {
                            int nodeIndex;
                            if (child instanceof DeferredNode && (nodeIndex = ((DeferredNode)child).getNodeIndex()) == index) {
                                place = child;
                                break;
                            }
                            child = child.getPreviousSibling();
                        }
                        --j;
                    }
                    Element element = (Element)place;
                    String name = this.fStringPool.toString(idNameIndex);
                    this.putIdentifier0(name, element);
                    this.fIdName[i] = -1;
                    while (i + 1 < this.fIdCount && this.fIdElement[i + 1] == elementNodeIndex) {
                        if ((idNameIndex = this.fIdName[++i]) == -1) continue;
                        name = this.fStringPool.toString(idNameIndex);
                        this.putIdentifier0(name, element);
                    }
                }
                ++i;
            }
        }
    }

    protected void synchronizeChildren() {
        if (this.needsSyncData()) {
            this.synchronizeData();
            if (!this.needsSyncChildren()) {
                return;
            }
        }
        boolean orig = this.mutationEvents;
        this.mutationEvents = false;
        this.needsSyncChildren(false);
        this.getNodeType(0);
        NodeImpl first = null;
        ChildNode last = null;
        int index = this.getLastChild(0);
        while (index != -1) {
            ChildNode node = (ChildNode)((Object)this.getNodeObject(index));
            if (last == null) {
                last = node;
            } else {
                ((ChildNode)first).previousSibling = node;
            }
            node.ownerNode = this;
            node.isOwned(true);
            node.nextSibling = first;
            first = node;
            short type = node.getNodeType();
            if (type == 1) {
                this.docElement = (ElementImpl)node;
            } else if (type == 10) {
                this.docType = (DocumentTypeImpl)node;
            }
            index = this.getPrevSibling(index);
        }
        if (first != null) {
            this.firstChild = first;
            first.isFirstChild(true);
            this.lastChild(last);
        }
        this.mutationEvents = orig;
    }

    protected final void synchronizeChildren(AttrImpl a, int nodeIndex) {
        boolean orig = this.getMutationEvents();
        this.setMutationEvents(false);
        a.needsSyncChildren(false);
        int last = this.getLastChild(nodeIndex);
        int prev = this.getPrevSibling(last);
        if (prev == -1) {
            a.value = this.getNodeValueString(last);
            a.hasStringValue(true);
        } else {
            NodeImpl firstNode = null;
            ChildNode lastNode = null;
            int index = last;
            while (index != -1) {
                ChildNode node = (ChildNode)((Object)this.getNodeObject(index));
                if (lastNode == null) {
                    lastNode = node;
                } else {
                    ((ChildNode)firstNode).previousSibling = node;
                }
                node.ownerNode = a;
                node.isOwned(true);
                node.nextSibling = firstNode;
                firstNode = node;
                index = this.getPrevSibling(index);
            }
            if (lastNode != null) {
                a.value = firstNode;
                firstNode.isFirstChild(true);
                a.lastChild(lastNode);
            }
            a.hasStringValue(false);
        }
        this.setMutationEvents(orig);
    }

    protected final void synchronizeChildren(ParentNode p, int nodeIndex) {
        boolean orig = this.getMutationEvents();
        this.setMutationEvents(false);
        p.needsSyncChildren(false);
        NodeImpl firstNode = null;
        ChildNode lastNode = null;
        int index = this.getLastChild(nodeIndex);
        while (index != -1) {
            ChildNode node = (ChildNode)((Object)this.getNodeObject(index));
            if (lastNode == null) {
                lastNode = node;
            } else {
                ((ChildNode)firstNode).previousSibling = node;
            }
            node.ownerNode = p;
            node.isOwned(true);
            node.nextSibling = firstNode;
            firstNode = node;
            index = this.getPrevSibling(index);
        }
        if (lastNode != null) {
            p.firstChild = firstNode;
            firstNode.isFirstChild(true);
            p.lastChild(lastNode);
        }
        this.setMutationEvents(orig);
    }

    protected boolean ensureCapacity(int chunk, int index) {
        if (this.fNodeType == null) {
            this.fNodeType = new int[32][];
            this.fNodeName = new int[32][];
            this.fNodeValue = new int[32][];
            this.fNodeParent = new int[32][];
            this.fNodeLastChild = new int[32][];
            this.fNodePrevSib = new int[32][];
            this.fNodeURI = new int[32][];
        }
        try {
            return this.fNodeType[chunk][index] != 0;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            int newsize = chunk * 2;
            int[][] newArray = new int[newsize][];
            System.arraycopy(this.fNodeType, 0, newArray, 0, chunk);
            this.fNodeType = newArray;
            newArray = new int[newsize][];
            System.arraycopy(this.fNodeName, 0, newArray, 0, chunk);
            this.fNodeName = newArray;
            newArray = new int[newsize][];
            System.arraycopy(this.fNodeValue, 0, newArray, 0, chunk);
            this.fNodeValue = newArray;
            newArray = new int[newsize][];
            System.arraycopy(this.fNodeParent, 0, newArray, 0, chunk);
            this.fNodeParent = newArray;
            newArray = new int[newsize][];
            System.arraycopy(this.fNodeLastChild, 0, newArray, 0, chunk);
            this.fNodeLastChild = newArray;
            newArray = new int[newsize][];
            System.arraycopy(this.fNodePrevSib, 0, newArray, 0, chunk);
            this.fNodePrevSib = newArray;
            newArray = new int[newsize][];
            System.arraycopy(this.fNodeURI, 0, newArray, 0, chunk);
            this.fNodeURI = newArray;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.createChunk(this.fNodeType, chunk);
        this.createChunk(this.fNodeName, chunk);
        this.createChunk(this.fNodeValue, chunk);
        this.createChunk(this.fNodeParent, chunk);
        this.createChunk(this.fNodeLastChild, chunk);
        this.createChunk(this.fNodePrevSib, chunk);
        this.createChunk(this.fNodeURI, chunk);
        return true;
    }

    protected int createNode(short nodeType) {
        int chunk = this.fNodeCount >> 11;
        int index = this.fNodeCount & 0x7FF;
        this.ensureCapacity(chunk, index);
        this.setChunkIndex(this.fNodeType, nodeType, chunk, index);
        return this.fNodeCount++;
    }

    protected static int binarySearch(int[] values, int start, int end, int target) {
        while (start <= end) {
            int middle = (start + end) / 2;
            int value = values[middle];
            if (value == target) {
                while (middle > 0 && values[middle - 1] == target) {
                    --middle;
                }
                return middle;
            }
            if (value > target) {
                end = middle - 1;
                continue;
            }
            start = middle + 1;
        }
        return -1;
    }

    private final void createChunk(int[][] data, int chunk) {
        data[chunk] = new int[2050];
        int i = 0;
        while (i < 2048) {
            data[chunk][i] = -1;
            ++i;
        }
    }

    private final int setChunkIndex(int[][] data, int value, int chunk, int index) {
        if (value == -1) {
            return this.clearChunkIndex(data, chunk, index);
        }
        int ovalue = data[chunk][index];
        if (ovalue == -1) {
            int[] nArray = data[chunk];
            nArray[2048] = nArray[2048] + 1;
        }
        data[chunk][index] = value;
        return ovalue;
    }

    private final int getChunkIndex(int[][] data, int chunk, int index) {
        return data[chunk] != null ? data[chunk][index] : -1;
    }

    private final int clearChunkIndex(int[][] data, int chunk, int index) {
        int value;
        int n = value = data[chunk] != null ? data[chunk][index] : -1;
        if (value != -1) {
            int[] nArray = data[chunk];
            nArray[2049] = nArray[2049] + 1;
            data[chunk][index] = -1;
            if (data[chunk][2048] == data[chunk][2049]) {
                data[chunk] = null;
            }
        }
        return value;
    }

    private final void putIdentifier0(String idName, Element element) {
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(idName, element);
    }

    private static void print(int[] values, int start, int end, int middle, int target) {
    }

    static class IntVector {
        private int[] data;
        private int size;

        IntVector() {
        }

        public int size() {
            return this.size;
        }

        public int elementAt(int index) {
            return this.data[index];
        }

        public void addElement(int element) {
            this.ensureCapacity(this.size + 1);
            this.data[this.size++] = element;
        }

        public void removeAllElements() {
            this.size = 0;
        }

        private void ensureCapacity(int newsize) {
            if (this.data == null) {
                this.data = new int[newsize + 15];
            } else if (newsize > this.data.length) {
                int[] newdata = new int[newsize + 15];
                System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                this.data = newdata;
            }
        }
    }
}

