/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.utils.StringPool;

public class DeferredDocumentTypeImpl
extends DocumentTypeImpl
implements DeferredNode {
    static final long serialVersionUID = -2172579663227313509L;
    protected transient int fNodeIndex;

    DeferredDocumentTypeImpl(DeferredDocumentImpl ownerDocument, int nodeIndex) {
        super(ownerDocument, null);
        this.fNodeIndex = nodeIndex;
        this.needsSyncData(true);
        this.needsSyncChildren(true);
    }

    public int getNodeIndex() {
        return this.fNodeIndex;
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument;
        this.name = ownerDocument.getNodeNameString(this.fNodeIndex);
        StringPool pool = ownerDocument.getStringPool();
        int extraDataIndex = ownerDocument.getNodeValue(this.fNodeIndex);
        this.publicID = pool.toString(ownerDocument.getNodeName(extraDataIndex));
        this.systemID = pool.toString(ownerDocument.getNodeValue(extraDataIndex));
        this.internalSubset = pool.toString(ownerDocument.getLastChild(extraDataIndex));
    }

    protected void synchronizeChildren() {
        boolean orig = this.ownerDocument().getMutationEvents();
        this.ownerDocument().setMutationEvents(false);
        this.needsSyncChildren(false);
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument;
        this.entities = new NamedNodeMapImpl(this);
        this.notations = new NamedNodeMapImpl(this);
        this.elements = new NamedNodeMapImpl(this);
        DeferredNode last = null;
        int index = ownerDocument.getLastChild(this.fNodeIndex);
        while (index != -1) {
            DeferredNode node = ownerDocument.getNodeObject(index);
            short type = node.getNodeType();
            switch (type) {
                case 6: {
                    this.entities.setNamedItem(node);
                    break;
                }
                case 12: {
                    this.notations.setNamedItem(node);
                    break;
                }
                case -1: {
                    this.elements.setNamedItem(node);
                    break;
                }
                case 1: {
                    if (((DocumentImpl)this.getOwnerDocument()).allowGrammarAccess) {
                        this.insertBefore(node, last);
                        last = node;
                        break;
                    }
                }
                default: {
                    System.out.println("DeferredDocumentTypeImpl#synchronizeInfo: node.getNodeType() = " + node.getNodeType() + ", class = " + node.getClass().getName());
                }
            }
            index = ownerDocument.getPrevSibling(index);
        }
        this.ownerDocument().setMutationEvents(orig);
        this.setReadOnly(true, false);
    }
}

