/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.utils.StringPool;
import org.w3c.dom.NamedNodeMap;

public class DeferredElementNSImpl
extends ElementNSImpl
implements DeferredNode {
    static final long serialVersionUID = -5001885145370927385L;
    protected transient int fNodeIndex;

    DeferredElementNSImpl(DeferredDocumentImpl ownerDoc, int nodeIndex) {
        super(ownerDoc, null);
        this.fNodeIndex = nodeIndex;
        this.needsSyncChildren(true);
    }

    public final int getNodeIndex() {
        return this.fNodeIndex;
    }

    protected final void synchronizeData() {
        this.needsSyncData(false);
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument;
        boolean orig = ownerDocument.mutationEvents;
        ownerDocument.mutationEvents = false;
        int elementQName = ownerDocument.getNodeName(this.fNodeIndex);
        StringPool pool = ownerDocument.getStringPool();
        this.name = pool.toString(elementQName);
        int index = this.name.indexOf(58);
        this.localName = index < 0 ? this.name : this.name.substring(index + 1);
        this.namespaceURI = pool.toString(ownerDocument.getNodeURI(this.fNodeIndex));
        if (this.namespaceURI.length() == 0) {
            this.namespaceURI = null;
        }
        this.setupDefaultAttributes();
        int attrIndex = ownerDocument.getNodeValue(this.fNodeIndex);
        if (attrIndex != -1) {
            NamedNodeMap attrs = this.getAttributes();
            do {
                NodeImpl attr = (NodeImpl)((Object)ownerDocument.getNodeObject(attrIndex));
                attrs.setNamedItem(attr);
            } while ((attrIndex = ownerDocument.getPrevSibling(attrIndex)) != -1);
        }
        ownerDocument.mutationEvents = orig;
    }

    protected final void synchronizeChildren() {
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument();
        ownerDocument.synchronizeChildren(this, this.fNodeIndex);
    }
}

