/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.utils.StringPool;

public class DeferredEntityImpl
extends EntityImpl
implements DeferredNode {
    static final long serialVersionUID = 4760180431078941638L;
    protected transient int fNodeIndex;

    DeferredEntityImpl(DeferredDocumentImpl ownerDocument, int nodeIndex) {
        super(ownerDocument, null);
        this.fNodeIndex = nodeIndex;
        this.needsSyncData(true);
        this.needsSyncChildren(true);
    }

    public int getNodeIndex() {
        return this.fNodeIndex;
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument;
        this.name = ownerDocument.getNodeNameString(this.fNodeIndex);
        StringPool pool = ownerDocument.getStringPool();
        int extraDataIndex = ownerDocument.getNodeValue(this.fNodeIndex);
        ownerDocument.getNodeType(extraDataIndex);
        this.publicId = pool.toString(ownerDocument.getNodeName(extraDataIndex));
        this.notationName = pool.toString(ownerDocument.getLastChild(extraDataIndex));
        extraDataIndex = ownerDocument.getNodeValue(extraDataIndex);
        this.systemId = pool.toString(ownerDocument.getNodeName(extraDataIndex));
        this.version = pool.toString(ownerDocument.getNodeValue(extraDataIndex));
        this.encoding = pool.toString(ownerDocument.getLastChild(extraDataIndex));
    }

    protected void synchronizeChildren() {
        this.needsSyncChildren(false);
        this.isReadOnly(false);
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument();
        ownerDocument.synchronizeChildren(this, this.fNodeIndex);
        this.setReadOnly(true, true);
    }
}

