/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DeferredEntityReferenceImpl
extends EntityReferenceImpl
implements DeferredNode {
    static final long serialVersionUID = 390319091370032223L;
    protected transient int fNodeIndex;

    DeferredEntityReferenceImpl(DeferredDocumentImpl ownerDocument, int nodeIndex) {
        super(ownerDocument, null);
        this.fNodeIndex = nodeIndex;
        this.needsSyncData(true);
        this.needsSyncChildren(true);
    }

    public int getNodeIndex() {
        return this.fNodeIndex;
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument;
        this.name = ownerDocument.getNodeNameString(this.fNodeIndex);
    }

    protected void synchronizeChildren() {
        this.needsSyncChildren(false);
        DocumentType doctype = this.ownerDocument.getDoctype();
        boolean found = false;
        if (doctype != null) {
            Entity entity;
            boolean orig = this.ownerDocument.getMutationEvents();
            this.ownerDocument.setMutationEvents(false);
            NamedNodeMap entities = doctype.getEntities();
            if (entities != null && (entity = (Entity)entities.getNamedItem(this.getNodeName())) != null) {
                found = true;
                boolean ro = this.isReadOnly();
                this.isReadOnly(false);
                Node child = entity.getFirstChild();
                while (child != null) {
                    this.appendChild(child.cloneNode(true));
                    child = child.getNextSibling();
                }
                if (ro) {
                    this.setReadOnly(true, true);
                }
            }
            this.ownerDocument.setMutationEvents(orig);
        }
        if (!found) {
            this.isReadOnly(false);
            DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument();
            ownerDocument.synchronizeChildren(this, this.fNodeIndex);
            this.setReadOnly(true, true);
        }
    }

    protected void synchronize() {
    }
}

