/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap,
Serializable {
    static final long serialVersionUID = -7039242451046758020L;
    protected short flags;
    protected static final short READONLY = 1;
    protected static final short CHANGED = 2;
    protected static final short HASDEFAULTS = 4;
    protected Vector nodes;
    protected NodeImpl ownerNode;

    protected NamedNodeMapImpl(NodeImpl ownerNode) {
        this.ownerNode = ownerNode;
    }

    public int getLength() {
        return this.nodes != null ? this.nodes.size() : 0;
    }

    public Node item(int index) {
        return this.nodes != null && index < this.nodes.size() ? (Node)this.nodes.elementAt(index) : null;
    }

    public Node getNamedItem(String name) {
        int i = this.findNamePoint(name, 0);
        return i < 0 ? null : (Node)this.nodes.elementAt(i);
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        int i = this.findNamePoint(namespaceURI, localName);
        return i < 0 ? null : (Node)this.nodes.elementAt(i);
    }

    public Node setNamedItem(Node arg) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (arg.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        int i = this.findNamePoint(arg.getNodeName(), 0);
        NodeImpl previous = null;
        if (i >= 0) {
            previous = (NodeImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(arg, i);
        } else {
            i = -1 - i;
            if (this.nodes == null) {
                this.nodes = new Vector(5, 10);
            }
            this.nodes.insertElementAt(arg, i);
        }
        return previous;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (arg.getOwnerDocument() != this.ownerNode.ownerDocument()) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        int i = this.findNamePoint(arg.getNamespaceURI(), arg.getLocalName());
        NodeImpl previous = null;
        if (i >= 0) {
            previous = (NodeImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(arg, i);
        } else {
            i = this.findNamePoint(arg.getNodeName(), 0);
            if (i >= 0) {
                previous = (NodeImpl)this.nodes.elementAt(i);
                this.nodes.insertElementAt(arg, i);
            } else {
                i = -1 - i;
                if (this.nodes == null) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(arg, i);
            }
        }
        return previous;
    }

    public Node removeNamedItem(String name) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        int i = this.findNamePoint(name, 0);
        if (i < 0) {
            throw new DOMException(8, "DOM008 Not found");
        }
        NodeImpl n = (NodeImpl)this.nodes.elementAt(i);
        this.nodes.removeElementAt(i);
        return n;
    }

    public Node removeNamedItemNS(String namespaceURI, String name) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        int i = this.findNamePoint(namespaceURI, name);
        if (i < 0) {
            throw new DOMException(8, "DOM008 Not found");
        }
        NodeImpl n = (NodeImpl)this.nodes.elementAt(i);
        this.nodes.removeElementAt(i);
        return n;
    }

    public NamedNodeMapImpl cloneMap(NodeImpl ownerNode) {
        NamedNodeMapImpl newmap = new NamedNodeMapImpl(ownerNode);
        newmap.cloneContent(this);
        return newmap;
    }

    protected void cloneContent(NamedNodeMapImpl srcmap) {
        if (srcmap.nodes != null) {
            this.nodes = new Vector(srcmap.nodes.size());
            int i = 0;
            while (i < srcmap.nodes.size()) {
                NodeImpl n = (NodeImpl)srcmap.nodes.elementAt(i);
                NodeImpl clone = (NodeImpl)n.cloneNode(true);
                clone.isSpecified(n.isSpecified());
                this.nodes.insertElementAt(clone, i);
                ++i;
            }
        }
    }

    void setReadOnly(boolean readOnly, boolean deep) {
        this.isReadOnly(readOnly);
        if (deep && this.nodes != null) {
            Enumeration e = this.nodes.elements();
            while (e.hasMoreElements()) {
                ((NodeImpl)e.nextElement()).setReadOnly(readOnly, deep);
            }
        }
    }

    boolean getReadOnly() {
        return this.isReadOnly();
    }

    void setOwnerDocument(CoreDocumentImpl doc) {
        if (this.nodes != null) {
            int i = 0;
            while (i < this.nodes.size()) {
                ((NodeImpl)this.item(i)).setOwnerDocument(doc);
                ++i;
            }
        }
    }

    final boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    final void isReadOnly(boolean value) {
        this.flags = (short)(value ? this.flags | 1 : this.flags & 0xFFFFFFFE);
    }

    final boolean changed() {
        return (this.flags & 2) != 0;
    }

    final void changed(boolean value) {
        this.flags = (short)(value ? this.flags | 2 : this.flags & 0xFFFFFFFD);
    }

    final boolean hasDefaults() {
        return (this.flags & 4) != 0;
    }

    final void hasDefaults(boolean value) {
        this.flags = (short)(value ? this.flags | 4 : this.flags & 0xFFFFFFFB);
    }

    protected int findNamePoint(String name, int start) {
        int i = 0;
        if (this.nodes != null) {
            int first = start;
            int last = this.nodes.size() - 1;
            while (first <= last) {
                i = (first + last) / 2;
                int test = name.compareTo(((Node)this.nodes.elementAt(i)).getNodeName());
                if (test == 0) {
                    return i;
                }
                if (test < 0) {
                    last = i - 1;
                    continue;
                }
                first = i + 1;
            }
            if (first > i) {
                i = first;
            }
        }
        return -1 - i;
    }

    protected int findNamePoint(String namespaceURI, String name) {
        if (this.nodes == null) {
            return -1;
        }
        if (name == null) {
            return -1;
        }
        int i = 0;
        while (i < this.nodes.size()) {
            NodeImpl a = (NodeImpl)this.nodes.elementAt(i);
            String aNamespaceURI = a.getNamespaceURI();
            String aLocalName = a.getLocalName();
            if (namespaceURI == null ? aNamespaceURI == null && (name.equals(aLocalName) || aLocalName == null && name.equals(a.getNodeName())) : namespaceURI.equals(aNamespaceURI) && name.equals(aLocalName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

