/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ParentNode
extends ChildNode {
    static final long serialVersionUID = 2815829867152120872L;
    protected CoreDocumentImpl ownerDocument;
    protected ChildNode firstChild = null;
    protected transient int fCachedLength = -1;
    protected transient ChildNode fCachedChild;
    protected transient int fCachedChildIndex = -1;

    protected ParentNode(CoreDocumentImpl ownerDocument) {
        super(ownerDocument);
        this.ownerDocument = ownerDocument;
    }

    public ParentNode() {
    }

    public Node cloneNode(boolean deep) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ParentNode newnode = (ParentNode)super.cloneNode(deep);
        newnode.ownerDocument = this.ownerDocument;
        newnode.firstChild = null;
        newnode.fCachedChildIndex = -1;
        newnode.fCachedLength = -1;
        if (deep) {
            ChildNode child = this.firstChild;
            while (child != null) {
                newnode.appendChild(child.cloneNode(true));
                child = child.nextSibling;
            }
        }
        return newnode;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    CoreDocumentImpl ownerDocument() {
        return this.ownerDocument;
    }

    void setOwnerDocument(CoreDocumentImpl doc) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        super.setOwnerDocument(doc);
        this.ownerDocument = doc;
        ChildNode child = this.firstChild;
        while (child != null) {
            child.setOwnerDocument(doc);
            child = child.nextSibling;
        }
    }

    public boolean hasChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.firstChild != null;
    }

    public NodeList getChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this;
    }

    public Node getFirstChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.firstChild;
    }

    public Node getLastChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.lastChild();
    }

    final ChildNode lastChild() {
        return this.firstChild != null ? this.firstChild.previousSibling : null;
    }

    final void lastChild(ChildNode node) {
        if (this.firstChild != null) {
            this.firstChild.previousSibling = node;
        }
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.internalInsertBefore(newChild, refChild, false);
    }

    Node internalInsertBefore(Node newChild, Node refChild, boolean replace) throws DOMException {
        boolean errorChecking = this.ownerDocument.errorChecking;
        if (newChild.getNodeType() == 11) {
            if (errorChecking) {
                Node kid = newChild.getFirstChild();
                while (kid != null) {
                    if (!this.ownerDocument.isKidOK(this, kid)) {
                        throw new DOMException(3, "DOM006 Hierarchy request error");
                    }
                    kid = kid.getNextSibling();
                }
            }
            while (newChild.hasChildNodes()) {
                this.insertBefore(newChild.getFirstChild(), refChild);
            }
            return newChild;
        }
        if (newChild == refChild) {
            refChild = refChild.getNextSibling();
            this.removeChild(newChild);
            this.insertBefore(newChild, refChild);
            return newChild;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (errorChecking) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (newChild.getOwnerDocument() != this.ownerDocument) {
                throw new DOMException(4, "DOM005 Wrong document");
            }
            if (!this.ownerDocument.isKidOK(this, newChild)) {
                throw new DOMException(3, "DOM006 Hierarchy request error");
            }
            if (refChild != null && refChild.getParentNode() != this) {
                throw new DOMException(8, "DOM008 Not found");
            }
            boolean treeSafe = true;
            NodeImpl a = this;
            while (treeSafe && a != null) {
                treeSafe = newChild != a;
                a = ((NodeImpl)a).parentNode();
            }
            if (!treeSafe) {
                throw new DOMException(3, "DOM006 Hierarchy request error");
            }
        }
        this.ownerDocument.insertingNode(this, replace);
        ChildNode newInternal = (ChildNode)newChild;
        NodeImpl oldparent = newInternal.parentNode();
        if (oldparent != null) {
            oldparent.removeChild(newInternal);
        }
        ChildNode refInternal = (ChildNode)refChild;
        newInternal.ownerNode = this;
        newInternal.isOwned(true);
        if (this.firstChild == null) {
            this.firstChild = newInternal;
            newInternal.isFirstChild(true);
            newInternal.previousSibling = newInternal;
        } else if (refInternal == null) {
            ChildNode lastChild = this.firstChild.previousSibling;
            lastChild.nextSibling = newInternal;
            newInternal.previousSibling = lastChild;
            this.firstChild.previousSibling = newInternal;
        } else if (refChild == this.firstChild) {
            this.firstChild.isFirstChild(false);
            newInternal.nextSibling = this.firstChild;
            newInternal.previousSibling = this.firstChild.previousSibling;
            this.firstChild.previousSibling = newInternal;
            this.firstChild = newInternal;
            newInternal.isFirstChild(true);
        } else {
            ChildNode prev = refInternal.previousSibling;
            newInternal.nextSibling = refInternal;
            prev.nextSibling = newInternal;
            refInternal.previousSibling = newInternal;
            newInternal.previousSibling = prev;
        }
        this.changed();
        if (this.fCachedLength != -1) {
            ++this.fCachedLength;
        }
        if (this.fCachedChildIndex != -1) {
            if (this.fCachedChild == refInternal) {
                this.fCachedChild = newInternal;
            } else {
                this.fCachedChildIndex = -1;
            }
        }
        this.ownerDocument.insertedNode(this, newInternal, replace);
        this.checkNormalizationAfterInsert(newInternal);
        return newChild;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.internalRemoveChild(oldChild, false);
    }

    Node internalRemoveChild(Node oldChild, boolean replace) throws DOMException {
        CoreDocumentImpl ownerDocument = this.ownerDocument();
        if (ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (oldChild != null && oldChild.getParentNode() != this) {
                throw new DOMException(8, "DOM008 Not found");
            }
        }
        ChildNode oldInternal = (ChildNode)oldChild;
        ownerDocument.removingNode(this, oldInternal, replace);
        if (this.fCachedLength != -1) {
            --this.fCachedLength;
        }
        if (this.fCachedChildIndex != -1) {
            if (this.fCachedChild == oldInternal) {
                --this.fCachedChildIndex;
                this.fCachedChild = oldInternal.previousSibling();
            } else {
                this.fCachedChildIndex = -1;
            }
        }
        if (oldInternal == this.firstChild) {
            oldInternal.isFirstChild(false);
            this.firstChild = oldInternal.nextSibling;
            if (this.firstChild != null) {
                this.firstChild.isFirstChild(true);
                this.firstChild.previousSibling = oldInternal.previousSibling;
            }
        } else {
            ChildNode next;
            ChildNode prev = oldInternal.previousSibling;
            prev.nextSibling = next = oldInternal.nextSibling;
            if (next == null) {
                this.firstChild.previousSibling = prev;
            } else {
                next.previousSibling = prev;
            }
        }
        ChildNode oldPreviousSibling = oldInternal.previousSibling();
        oldInternal.ownerNode = ownerDocument;
        oldInternal.isOwned(false);
        oldInternal.nextSibling = null;
        oldInternal.previousSibling = null;
        this.changed();
        ownerDocument.removedNode(this, replace);
        this.checkNormalizationAfterRemove(oldPreviousSibling);
        return oldInternal;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.ownerDocument.replacingNode(this);
        this.internalInsertBefore(newChild, oldChild, true);
        if (newChild != oldChild) {
            this.internalRemoveChild(oldChild, true);
        }
        this.ownerDocument.replacedNode(this);
        return oldChild;
    }

    private int nodeListGetLength() {
        if (this.fCachedLength == -1) {
            ChildNode node;
            if (this.fCachedChildIndex != -1 && this.fCachedChild != null) {
                this.fCachedLength = this.fCachedChildIndex;
                node = this.fCachedChild;
            } else {
                node = this.firstChild;
                this.fCachedLength = 0;
            }
            while (node != null) {
                ++this.fCachedLength;
                node = node.nextSibling;
            }
        }
        return this.fCachedLength;
    }

    public int getLength() {
        return this.nodeListGetLength();
    }

    private Node nodeListItem(int index) {
        if (this.fCachedChildIndex != -1 && this.fCachedChild != null) {
            if (this.fCachedChildIndex < index) {
                while (this.fCachedChildIndex < index && this.fCachedChild != null) {
                    ++this.fCachedChildIndex;
                    this.fCachedChild = this.fCachedChild.nextSibling;
                }
            } else if (this.fCachedChildIndex > index) {
                while (this.fCachedChildIndex > index && this.fCachedChild != null) {
                    --this.fCachedChildIndex;
                    this.fCachedChild = this.fCachedChild.previousSibling();
                }
            }
            return this.fCachedChild;
        }
        this.fCachedChild = this.firstChild;
        this.fCachedChildIndex = 0;
        while (this.fCachedChildIndex < index && this.fCachedChild != null) {
            this.fCachedChild = this.fCachedChild.nextSibling;
            ++this.fCachedChildIndex;
        }
        return this.fCachedChild;
    }

    public Node item(int index) {
        return this.nodeListItem(index);
    }

    protected final NodeList getChildNodesUnoptimized() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return new NodeList(){

            public int getLength() {
                return ParentNode.this.nodeListGetLength();
            }

            public Node item(int index) {
                return ParentNode.this.nodeListItem(index);
            }
        };
    }

    public void normalize() {
        if (this.isNormalized()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ChildNode kid = this.firstChild;
        while (kid != null) {
            kid.normalize();
            kid = kid.nextSibling;
        }
        this.isNormalized(true);
    }

    public void setReadOnly(boolean readOnly, boolean deep) {
        super.setReadOnly(readOnly, deep);
        if (deep) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            ChildNode mykid = this.firstChild;
            while (mykid != null) {
                if (mykid.getNodeType() != 5) {
                    mykid.setReadOnly(readOnly, true);
                }
                mykid = mykid.nextSibling;
            }
        }
    }

    protected void synchronizeChildren() {
        this.needsSyncChildren(false);
    }

    void checkNormalizationAfterInsert(ChildNode insertedChild) {
        if (insertedChild.getNodeType() == 3) {
            ChildNode prev = insertedChild.previousSibling();
            ChildNode next = insertedChild.nextSibling;
            if (prev != null && prev.getNodeType() == 3 || next != null && next.getNodeType() == 3) {
                this.isNormalized(false);
            }
        } else if (!insertedChild.isNormalized()) {
            this.isNormalized(false);
        }
    }

    void checkNormalizationAfterRemove(ChildNode previousSibling) {
        ChildNode next;
        if (previousSibling != null && previousSibling.getNodeType() == 3 && (next = previousSibling.nextSibling) != null && next.getNodeType() == 3) {
            this.isNormalized(false);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.needsSyncChildren(false);
        this.fCachedLength = -1;
        this.fCachedChildIndex = -1;
    }
}

