/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.framework;

import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.xml.sax.AttributeList;

public final class XMLAttrList
implements AttributeList {
    private static final int CHUNK_SHIFT = 5;
    private static final int CHUNK_SIZE = 32;
    private static final int CHUNK_MASK = 31;
    private static final int INITIAL_CHUNK_COUNT = 32;
    private static final int ATTFLAG_SPECIFIED = 1;
    private static final int ATTFLAG_LASTATTR = 2;
    private static final int ATTFLAG_NEEDSEARCH = 4;
    private StringPool fStringPool = null;
    private int fCurrentHandle = -1;
    private int fAttributeListHandle = -1;
    private int fAttributeListLength = 0;
    private int fAttrCount = 0;
    private int[][] fAttPrefix = new int[32][];
    private int[][] fAttLocalpart = new int[32][];
    private int[][] fAttName = new int[32][];
    private int[][] fAttURI = new int[32][];
    private int[][] fAttValue = new int[32][];
    private int[][] fAttType = new int[32][];
    private byte[][] fAttFlags = new byte[32][];
    private QName fAttributeQName = new QName();

    public XMLAttrList(StringPool stringPool) {
        this.fStringPool = stringPool;
    }

    public void reset(StringPool stringPool) {
        this.fStringPool = stringPool;
        this.fCurrentHandle = -1;
        this.fAttributeListHandle = -1;
        this.fAttributeListLength = 0;
        this.fAttrCount = 0;
    }

    public int addAttr(int attrName, int attValue, int attType, boolean specified, boolean search) throws Exception {
        this.fAttributeQName.setValues(-1, attrName, attrName);
        return this.addAttr(this.fAttributeQName, attValue, attType, specified, search);
    }

    public int addAttr(QName attribute, int attValue, int attType, boolean specified, boolean search) throws Exception {
        int index;
        int chunk;
        if (search) {
            chunk = this.fCurrentHandle >> 5;
            index = this.fCurrentHandle & 0x1F;
            int attrIndex = this.fCurrentHandle;
            while (attrIndex < this.fAttrCount) {
                if (this.fStringPool.equalNames(this.fAttName[chunk][index], attribute.rawname)) {
                    return -1;
                }
                if (++index == 32) {
                    ++chunk;
                    index = 0;
                }
                ++attrIndex;
            }
        } else {
            chunk = this.fAttrCount >> 5;
            index = this.fAttrCount & 0x1F;
        }
        this.ensureCapacity(chunk, index);
        this.fAttPrefix[chunk][index] = attribute.prefix;
        this.fAttLocalpart[chunk][index] = attribute.localpart;
        this.fAttName[chunk][index] = attribute.rawname;
        this.fAttURI[chunk][index] = attribute.uri;
        this.fAttValue[chunk][index] = attValue;
        this.fAttType[chunk][index] = attType;
        this.fAttFlags[chunk][index] = (byte)((specified ? 1 : 0) | (search ? 4 : 0));
        return this.fAttrCount++;
    }

    public int startAttrList() {
        this.fCurrentHandle = this.fAttrCount;
        return this.fCurrentHandle;
    }

    public int[] endAttrList() {
        if (this.fCurrentHandle == -1) {
            return null;
        }
        int oldHandle = this.fCurrentHandle;
        int attrIndex = this.fAttrCount - 1;
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        byte[] byArray = this.fAttFlags[chunk];
        int n = index;
        byArray[n] = (byte)(byArray[n] | 2);
        this.fCurrentHandle = -1;
        int dupCount = 0;
        int[] dupNames = null;
        int attrIndex1 = oldHandle + 1;
        int chunk1 = attrIndex1 >> 5;
        int index1 = attrIndex1 & 0x1F;
        while (attrIndex1 < this.fAttrCount) {
            if ((this.fAttFlags[chunk1][index1] & 4) != 0) {
                int chunk2 = chunk1;
                int index2 = index1;
                int attrIndex2 = oldHandle;
                while (attrIndex2 < attrIndex1) {
                    if (--index2 == -1) {
                        --chunk2;
                        index2 = 31;
                    }
                    if (this.fStringPool.equalNames(this.fAttURI[chunk1][index1], this.fAttURI[chunk2][index2]) && this.fStringPool.equalNames(this.fAttLocalpart[chunk1][index1], this.fAttLocalpart[chunk2][index2])) {
                        if (dupCount == 0) {
                            dupNames = new int[this.fAttrCount - oldHandle];
                        }
                        dupNames[dupCount++] = this.fAttName[chunk1][index1];
                    }
                    ++attrIndex2;
                }
                if (++index1 == 32) {
                    ++chunk1;
                    index1 = 0;
                }
            }
            ++attrIndex1;
        }
        if (dupCount > 0) {
            int[] names = new int[dupCount];
            System.arraycopy(dupNames, 0, names, 0, dupCount);
            dupNames = names;
        }
        return dupNames;
    }

    public int getAttrPrefix(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return -1;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        return this.fAttPrefix[chunk][index];
    }

    public int getAttrLocalpart(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return -1;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        return this.fAttLocalpart[chunk][index];
    }

    public int getAttrName(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return -1;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        return this.fAttName[chunk][index];
    }

    public void setAttrURI(int attrIndex, int uri) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        this.fAttURI[chunk][index] = uri;
    }

    public int getAttrURI(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return -1;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        return this.fAttURI[chunk][index];
    }

    public int getAttValue(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return -1;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        return this.fAttValue[chunk][index];
    }

    public void setAttValue(int attrIndex, int attrValue) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        this.fAttValue[chunk][index] = attrValue;
    }

    public void setAttType(int attrIndex, int attTypeIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        this.fAttType[chunk][index] = attTypeIndex;
    }

    public int getAttType(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return -1;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        return this.fAttType[chunk][index];
    }

    public boolean isSpecified(int attrIndex) {
        if (attrIndex < 0 || attrIndex >= this.fAttrCount) {
            return true;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        return (this.fAttFlags[chunk][index] & 1) != 0;
    }

    public void releaseAttrList(int attrListHandle) {
        boolean last;
        if (attrListHandle == -1) {
            return;
        }
        int chunk = attrListHandle >> 5;
        int index = attrListHandle & 0x1F;
        do {
            last = (this.fAttFlags[chunk][index] & 2) != 0;
            this.fAttPrefix[chunk][index] = -1;
            this.fAttLocalpart[chunk][index] = -1;
            this.fAttName[chunk][index] = -1;
            this.fAttURI[chunk][index] = 0;
            if ((this.fAttFlags[chunk][index] & 1) != 0) {
                this.fStringPool.releaseString(this.fAttValue[chunk][index]);
            }
            this.fAttValue[chunk][index] = -1;
            if (++index != 32) continue;
            ++chunk;
            index = 0;
        } while (!last);
        int lastIndex = (chunk << 5) + index;
        if (this.fAttrCount == lastIndex) {
            this.fAttrCount = attrListHandle;
        }
    }

    public int getFirstAttr(int attrListHandle) {
        if (attrListHandle < 0 || attrListHandle >= this.fAttrCount) {
            return -1;
        }
        return attrListHandle;
    }

    public int getNextAttr(int attrIndex) {
        if (attrIndex < 0 || attrIndex + 1 >= this.fAttrCount) {
            return -1;
        }
        int chunk = attrIndex >> 5;
        int index = attrIndex & 0x1F;
        if ((this.fAttFlags[chunk][index] & 2) != 0) {
            return -1;
        }
        return attrIndex + 1;
    }

    public AttributeList getAttributeList(int attrListHandle) {
        this.fAttributeListHandle = attrListHandle;
        if (this.fAttributeListHandle == -1) {
            this.fAttributeListLength = 0;
        } else {
            int chunk = this.fAttributeListHandle >> 5;
            int index = this.fAttributeListHandle & 0x1F;
            this.fAttributeListLength = 1;
            while ((this.fAttFlags[chunk][index] & 2) == 0) {
                if (++index == 32) {
                    ++chunk;
                    index = 0;
                }
                ++this.fAttributeListLength;
            }
        }
        return this;
    }

    public int getLength() {
        return this.fAttributeListLength;
    }

    public String getPrefix(int i) {
        if (i < 0 || i >= this.fAttributeListLength) {
            return null;
        }
        int chunk = this.fAttributeListHandle + i >> 5;
        int index = this.fAttributeListHandle + i & 0x1F;
        return this.fStringPool.toString(this.fAttPrefix[chunk][index]);
    }

    public String getLocalpart(int i) {
        if (i < 0 || i >= this.fAttributeListLength) {
            return null;
        }
        int chunk = this.fAttributeListHandle + i >> 5;
        int index = this.fAttributeListHandle + i & 0x1F;
        return this.fStringPool.toString(this.fAttLocalpart[chunk][index]);
    }

    public String getName(int i) {
        if (i < 0 || i >= this.fAttributeListLength) {
            return null;
        }
        int chunk = this.fAttributeListHandle + i >> 5;
        int index = this.fAttributeListHandle + i & 0x1F;
        return this.fStringPool.toString(this.fAttName[chunk][index]);
    }

    public String getURI(int i) {
        if (i < 0 || i >= this.fAttributeListLength) {
            return null;
        }
        int chunk = this.fAttributeListHandle + i >> 5;
        int index = this.fAttributeListHandle + i & 0x1F;
        return this.fStringPool.toString(this.fAttURI[chunk][index]);
    }

    public String getType(int i) {
        if (i < 0 || i >= this.fAttributeListLength) {
            return null;
        }
        int chunk = this.fAttributeListHandle + i >> 5;
        int index = this.fAttributeListHandle + i & 0x1F;
        int attType = this.fAttType[chunk][index];
        if (attType == this.fStringPool.addSymbol("ENUMERATION")) {
            attType = this.fStringPool.addSymbol("NMTOKEN");
        }
        return this.fStringPool.toString(attType);
    }

    public String getValue(int i) {
        if (i < 0 || i >= this.fAttributeListLength) {
            return null;
        }
        int chunk = this.fAttributeListHandle + i >> 5;
        int index = this.fAttributeListHandle + i & 0x1F;
        return this.fStringPool.toString(this.fAttValue[chunk][index]);
    }

    public String getType(String name) {
        int nameIndex = this.fStringPool.addSymbol(name);
        if (nameIndex == -1) {
            return null;
        }
        int chunk = this.fAttributeListHandle >> 5;
        int index = this.fAttributeListHandle & 0x1F;
        int i = 0;
        while (i < this.fAttributeListLength) {
            if (this.fStringPool.equalNames(this.fAttName[chunk][index], nameIndex)) {
                int attType = this.fAttType[chunk][index];
                if (attType == this.fStringPool.addSymbol("ENUMERATION")) {
                    attType = this.fStringPool.addSymbol("NMTOKEN");
                }
                return this.fStringPool.toString(attType);
            }
            if (++index == 32) {
                ++chunk;
                index = 0;
            }
            ++i;
        }
        return null;
    }

    public String getValue(String name) {
        int nameIndex = this.fStringPool.addSymbol(name);
        if (nameIndex == -1) {
            return null;
        }
        int chunk = this.fAttributeListHandle >> 5;
        int index = this.fAttributeListHandle & 0x1F;
        int i = 0;
        while (i < this.fAttributeListLength) {
            if (this.fStringPool.equalNames(this.fAttName[chunk][index], nameIndex)) {
                return this.fStringPool.toString(this.fAttValue[chunk][index]);
            }
            if (++index == 32) {
                ++chunk;
                index = 0;
            }
            ++i;
        }
        return null;
    }

    private void ensureCapacity(int chunk, int index) {
        if (chunk >= this.fAttPrefix.length) {
            int[][] newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fAttPrefix, 0, newIntArray, 0, chunk);
            this.fAttPrefix = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fAttLocalpart, 0, newIntArray, 0, chunk);
            this.fAttLocalpart = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fAttName, 0, newIntArray, 0, chunk);
            this.fAttName = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fAttURI, 0, newIntArray, 0, chunk);
            this.fAttURI = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fAttValue, 0, newIntArray, 0, chunk);
            this.fAttValue = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fAttType, 0, newIntArray, 0, chunk);
            this.fAttType = newIntArray;
            byte[][] newByteArray = new byte[chunk * 2][];
            System.arraycopy(this.fAttFlags, 0, newByteArray, 0, chunk);
            this.fAttFlags = newByteArray;
        } else if (this.fAttPrefix[chunk] != null) {
            return;
        }
        this.fAttPrefix[chunk] = new int[32];
        this.fAttLocalpart[chunk] = new int[32];
        this.fAttName[chunk] = new int[32];
        this.fAttURI[chunk] = new int[32];
        this.fAttValue[chunk] = new int[32];
        this.fAttType[chunk] = new int[32];
        this.fAttFlags[chunk] = new byte[32];
    }
}

