/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.framework;

import org.apache.xerces.utils.StringPool;

public class XMLContentSpec {
    public static final int CONTENTSPECNODE_LEAF = 0;
    public static final int CONTENTSPECNODE_ZERO_OR_ONE = 1;
    public static final int CONTENTSPECNODE_ZERO_OR_MORE = 2;
    public static final int CONTENTSPECNODE_ONE_OR_MORE = 3;
    public static final int CONTENTSPECNODE_CHOICE = 4;
    public static final int CONTENTSPECNODE_SEQ = 5;
    public static final int CONTENTSPECNODE_ANY = 6;
    public static final int CONTENTSPECNODE_ANY_OTHER = 7;
    public static final int CONTENTSPECNODE_ANY_NS = 8;
    public static final int CONTENTSPECNODE_ALL = 9;
    public static final int CONTENTSPECNODE_ANY_LAX = 22;
    public static final int CONTENTSPECNODE_ANY_OTHER_LAX = 23;
    public static final int CONTENTSPECNODE_ANY_NS_LAX = 24;
    public static final int CONTENTSPECNODE_ANY_SKIP = 38;
    public static final int CONTENTSPECNODE_ANY_OTHER_SKIP = 39;
    public static final int CONTENTSPECNODE_ANY_NS_SKIP = 40;
    public int type;
    public int value;
    public int otherValue;

    public XMLContentSpec() {
        this.clear();
    }

    public XMLContentSpec(int type, int value, int otherValue) {
        this.setValues(type, value, otherValue);
    }

    public XMLContentSpec(XMLContentSpec contentSpec) {
        this.setValues(contentSpec);
    }

    public XMLContentSpec(Provider provider, int contentSpecIndex) {
        this.setValues(provider, contentSpecIndex);
    }

    public void clear() {
        this.type = -1;
        this.value = -1;
        this.otherValue = -1;
    }

    public void setValues(int type, int value, int otherValue) {
        this.type = type;
        this.value = value;
        this.otherValue = otherValue;
    }

    public void setValues(XMLContentSpec contentSpec) {
        this.type = contentSpec.type;
        this.value = contentSpec.value;
        this.otherValue = contentSpec.otherValue;
    }

    public void setValues(Provider provider, int contentSpecIndex) {
        if (!provider.getContentSpec(contentSpecIndex, this)) {
            this.clear();
        }
    }

    public static String toString(Provider provider, StringPool stringPool, int contentSpecIndex) {
        XMLContentSpec contentSpec = new XMLContentSpec();
        if (provider.getContentSpec(contentSpecIndex, contentSpec)) {
            StringBuffer str = new StringBuffer();
            int parentContentSpecType = contentSpec.type & 0xF;
            switch (parentContentSpecType) {
                case 0: {
                    str.append('(');
                    if (contentSpec.value == -1 && contentSpec.otherValue == -1) {
                        str.append("#PCDATA");
                    } else {
                        str.append(stringPool.toString(contentSpec.value));
                    }
                    str.append(')');
                    break;
                }
                case 1: {
                    provider.getContentSpec(contentSpec.value, contentSpec);
                    int nextContentSpec = contentSpec.type;
                    if (nextContentSpec == 0) {
                        str.append('(');
                        str.append(stringPool.toString(contentSpec.value));
                        str.append(')');
                    } else if (nextContentSpec == 3 || nextContentSpec == 2 || nextContentSpec == 1) {
                        str.append('(');
                        XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, parentContentSpecType);
                        str.append(')');
                    } else {
                        XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, parentContentSpecType);
                    }
                    str.append('?');
                    break;
                }
                case 2: {
                    provider.getContentSpec(contentSpec.value, contentSpec);
                    int nextContentSpec = contentSpec.type;
                    if (nextContentSpec == 0) {
                        str.append('(');
                        if (contentSpec.value == -1 && contentSpec.otherValue == -1) {
                            str.append("#PCDATA");
                        } else if (contentSpec.otherValue != -1) {
                            str.append("##any:uri=" + stringPool.toString(contentSpec.otherValue));
                        } else if (contentSpec.value == -1) {
                            str.append("##any");
                        } else {
                            XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, parentContentSpecType);
                        }
                        str.append(')');
                    } else if (nextContentSpec == 3 || nextContentSpec == 2 || nextContentSpec == 1) {
                        str.append('(');
                        XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, parentContentSpecType);
                        str.append(')');
                    } else {
                        XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, parentContentSpecType);
                    }
                    str.append('*');
                    break;
                }
                case 3: {
                    provider.getContentSpec(contentSpec.value, contentSpec);
                    int nextContentSpec = contentSpec.type;
                    if (nextContentSpec == 0) {
                        str.append('(');
                        if (contentSpec.value == -1 && contentSpec.otherValue == -1) {
                            str.append("#PCDATA");
                        } else if (contentSpec.otherValue != -1) {
                            str.append("##any:uri=" + stringPool.toString(contentSpec.otherValue));
                        } else if (contentSpec.value == -1) {
                            str.append("##any");
                        } else {
                            str.append(stringPool.toString(contentSpec.value));
                        }
                        str.append(')');
                    } else if (nextContentSpec == 3 || nextContentSpec == 2 || nextContentSpec == 1) {
                        str.append('(');
                        XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, parentContentSpecType);
                        str.append(')');
                    } else {
                        XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, parentContentSpecType);
                    }
                    str.append('+');
                    break;
                }
                case 4: 
                case 5: 
                case 9: {
                    XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, parentContentSpecType);
                    break;
                }
                case 6: {
                    str.append("##any");
                    break;
                }
                case 7: {
                    str.append("##other:uri=");
                    str.append(stringPool.toString(contentSpec.otherValue));
                    break;
                }
                case 8: {
                    str.append("namespace:uri=");
                    str.append(stringPool.toString(contentSpec.otherValue));
                    break;
                }
                default: {
                    str.append("???");
                }
            }
            return str.toString();
        }
        return null;
    }

    public int hashCode() {
        return this.type << 16 | this.value << 8 | this.otherValue;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof XMLContentSpec) {
            XMLContentSpec contentSpec = (XMLContentSpec)object;
            return this.type == contentSpec.type && this.value == contentSpec.value && this.otherValue == contentSpec.otherValue;
        }
        return false;
    }

    private static void appendContentSpec(Provider provider, StringPool stringPool, XMLContentSpec contentSpec, StringBuffer str, boolean parens, int parentContentSpecType) {
        int thisContentSpec = contentSpec.type & 0xF;
        switch (thisContentSpec) {
            case 0: {
                if (contentSpec.value == -1 && contentSpec.otherValue == -1) {
                    str.append("#PCDATA");
                    break;
                }
                if (contentSpec.value == -1 && contentSpec.otherValue != -1) {
                    str.append("##any:uri=" + stringPool.toString(contentSpec.otherValue));
                    break;
                }
                if (contentSpec.value == -1) {
                    str.append("##any");
                    break;
                }
                str.append(stringPool.toString(contentSpec.value));
                break;
            }
            case 1: {
                if (parentContentSpecType == 3 || parentContentSpecType == 2 || parentContentSpecType == 1) {
                    provider.getContentSpec(contentSpec.value, contentSpec);
                    str.append('(');
                    XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, thisContentSpec);
                    str.append(')');
                } else {
                    provider.getContentSpec(contentSpec.value, contentSpec);
                    XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, thisContentSpec);
                }
                str.append('?');
                break;
            }
            case 2: {
                if (parentContentSpecType == 3 || parentContentSpecType == 2 || parentContentSpecType == 1) {
                    provider.getContentSpec(contentSpec.value, contentSpec);
                    str.append('(');
                    XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, thisContentSpec);
                    str.append(')');
                } else {
                    provider.getContentSpec(contentSpec.value, contentSpec);
                    XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, thisContentSpec);
                }
                str.append('*');
                break;
            }
            case 3: {
                if (parentContentSpecType == 3 || parentContentSpecType == 2 || parentContentSpecType == 1) {
                    str.append('(');
                    provider.getContentSpec(contentSpec.value, contentSpec);
                    XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, thisContentSpec);
                    str.append(')');
                } else {
                    provider.getContentSpec(contentSpec.value, contentSpec);
                    XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, thisContentSpec);
                }
                str.append('+');
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                int type = contentSpec.type;
                if (parens) {
                    if (type == 9) {
                        str.append("all(");
                    } else {
                        str.append('(');
                    }
                }
                int otherValue = contentSpec.otherValue;
                provider.getContentSpec(contentSpec.value, contentSpec);
                XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, contentSpec.type != type, thisContentSpec);
                if (otherValue != -2) {
                    if (type == 4) {
                        str.append('|');
                    } else {
                        str.append(',');
                    }
                    provider.getContentSpec(otherValue, contentSpec);
                    XMLContentSpec.appendContentSpec(provider, stringPool, contentSpec, str, true, thisContentSpec);
                }
                if (!parens) break;
                str.append(')');
                break;
            }
            case 6: {
                str.append("##any");
                break;
            }
            case 7: {
                str.append("##other:uri=");
                str.append(stringPool.toString(contentSpec.otherValue));
                break;
            }
            case 8: {
                str.append("namespace:uri=");
                str.append(stringPool.toString(contentSpec.otherValue));
                break;
            }
            default: {
                str.append("???");
            }
        }
    }

    public static interface Provider {
        public boolean getContentSpec(int var1, XMLContentSpec var2);
    }
}

