/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.framework;

import java.util.StringTokenizer;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.dtd.DTDGrammar;

public final class XMLDTDScanner {
    private static final char[] version_string = new char[]{'v', 'e', 'r', 's', 'i', 'o', 'n'};
    private static final char[] element_string = new char[]{'E', 'L', 'E', 'M', 'E', 'N', 'T'};
    private static final char[] empty_string = new char[]{'E', 'M', 'P', 'T', 'Y'};
    private static final char[] any_string = new char[]{'A', 'N', 'Y'};
    private static final char[] pcdata_string = new char[]{'#', 'P', 'C', 'D', 'A', 'T', 'A'};
    private static final char[] attlist_string = new char[]{'A', 'T', 'T', 'L', 'I', 'S', 'T'};
    private static final char[] cdata_string = new char[]{'C', 'D', 'A', 'T', 'A'};
    private static final char[] id_string = new char[]{'I', 'D'};
    private static final char[] ref_string = new char[]{'R', 'E', 'F'};
    private static final char[] entit_string = new char[]{'E', 'N', 'T', 'I', 'T'};
    private static final char[] ies_string = new char[]{'I', 'E', 'S'};
    private static final char[] nmtoken_string = new char[]{'N', 'M', 'T', 'O', 'K', 'E', 'N'};
    private static final char[] notation_string = new char[]{'N', 'O', 'T', 'A', 'T', 'I', 'O', 'N'};
    private static final char[] required_string = new char[]{'#', 'R', 'E', 'Q', 'U', 'I', 'R', 'E', 'D'};
    private static final char[] implied_string = new char[]{'#', 'I', 'M', 'P', 'L', 'I', 'E', 'D'};
    private static final char[] fixed_string = new char[]{'#', 'F', 'I', 'X', 'E', 'D'};
    private static final char[] include_string = new char[]{'I', 'N', 'C', 'L', 'U', 'D', 'E'};
    private static final char[] ignore_string = new char[]{'I', 'G', 'N', 'O', 'R', 'E'};
    private static final char[] entity_string = new char[]{'E', 'N', 'T', 'I', 'T', 'Y'};
    private static final char[] system_string = new char[]{'S', 'Y', 'S', 'T', 'E', 'M'};
    private static final char[] public_string = new char[]{'P', 'U', 'B', 'L', 'I', 'C'};
    private static final char[] ndata_string = new char[]{'N', 'D', 'A', 'T', 'A'};
    private static final char[] encoding_string = new char[]{'e', 'n', 'c', 'o', 'd', 'i', 'n', 'g'};
    private DTDGrammar fDTDGrammar = null;
    private GrammarResolver fGrammarResolver = null;
    private boolean fNamespacesEnabled = false;
    private boolean fValidationEnabled = false;
    private boolean fLoadExternalDTD = true;
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    private QName fElementQName = new QName();
    private QName fAttributeQName = new QName();
    private QName fElementRefQName = new QName();
    private EventHandler fEventHandler = null;
    private XMLDocumentHandler.DTDHandler fDTDHandler = null;
    private StringPool fStringPool = null;
    private XMLErrorReporter fErrorReporter = null;
    private XMLEntityHandler fEntityHandler = null;
    private XMLEntityHandler.EntityReader fEntityReader = null;
    private XMLEntityHandler.CharBuffer fLiteralData = null;
    private int fReaderId = -1;
    private int fSystemLiteral = -1;
    private int fPubidLiteral = -1;
    private int[] fOpStack = null;
    private int[] fNodeIndexStack = null;
    private int[] fPrevNodeIndexStack = null;
    private int fScannerState = -1;
    private int fIncludeSectDepth = 0;
    private int fDoctypeReader = -1;
    private int fExternalSubsetReader = -1;
    private int fDefaultAttValueReader = -1;
    private int fDefaultAttValueElementType = -1;
    private int fDefaultAttValueAttrName = -1;
    private int fDefaultAttValueOffset = -1;
    private int fDefaultAttValueMark = -1;
    private int fEntityValueReader = -1;
    private int fEntityValueMark = -1;
    private int fXMLSymbol = -1;
    private int fXMLNamespace = -1;
    private int fXMLSpace = -1;
    private int fDefault = -1;
    private int fPreserve = -1;
    private int fScannerMarkupDepth = 0;
    private int fScannerParenDepth = 0;
    private static final int SCANNER_STATE_INVALID = -1;
    private static final int SCANNER_STATE_END_OF_INPUT = 0;
    private static final int SCANNER_STATE_DOCTYPEDECL = 50;
    private static final int SCANNER_STATE_MARKUP_DECL = 51;
    private static final int SCANNER_STATE_TEXTDECL = 53;
    private static final int SCANNER_STATE_COMMENT = 54;
    private static final int SCANNER_STATE_PI = 55;
    private static final int SCANNER_STATE_DEFAULT_ATTRIBUTE_VALUE = 56;
    private static final int SCANNER_STATE_CONTENTSPEC = 57;
    private static final int SCANNER_STATE_ENTITY_VALUE = 58;
    private static final int SCANNER_STATE_SYSTEMLITERAL = 59;
    private static final int SCANNER_STATE_PUBIDLITERAL = 60;
    private QName fElementDeclQName = new QName();

    public XMLDTDScanner(StringPool stringPool, XMLErrorReporter errorReporter, XMLEntityHandler entityHandler, XMLEntityHandler.CharBuffer literalData) {
        this.fStringPool = stringPool;
        this.fErrorReporter = errorReporter;
        this.fEntityHandler = entityHandler;
        this.fLiteralData = literalData;
        this.init();
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    public void setDTDHandler(XMLDocumentHandler.DTDHandler dtdHandler) {
        this.fDTDHandler = dtdHandler;
    }

    public void setGrammarResolver(GrammarResolver resolver) {
        this.fGrammarResolver = resolver;
    }

    public void setNamespacesEnabled(boolean enabled) {
        this.fNamespacesEnabled = enabled;
    }

    public void setValidationEnabled(boolean enabled) {
        this.fValidationEnabled = enabled;
    }

    public void setLoadExternalDTD(boolean enabled) {
        this.fLoadExternalDTD = enabled;
    }

    public boolean getReadingExternalEntity() {
        return this.fReaderId != this.fDoctypeReader;
    }

    public boolean getReadingContentSpec() {
        return this.getScannerState() == 57;
    }

    public int markupDepth() {
        return this.fScannerMarkupDepth;
    }

    private int increaseMarkupDepth() {
        return this.fScannerMarkupDepth++;
    }

    private int decreaseMarkupDepth() {
        return this.fScannerMarkupDepth--;
    }

    public int parenDepth() {
        return this.fScannerParenDepth;
    }

    private void setParenDepth(int parenDepth) {
        this.fScannerParenDepth = parenDepth;
    }

    private void increaseParenDepth() {
        ++this.fScannerParenDepth;
    }

    private void decreaseParenDepth() {
        --this.fScannerParenDepth;
    }

    public void reset(StringPool stringPool, XMLEntityHandler.CharBuffer literalData) throws Exception {
        this.fStringPool = stringPool;
        this.fLiteralData = literalData;
        this.fEntityReader = null;
        this.fReaderId = -1;
        this.fSystemLiteral = -1;
        this.fPubidLiteral = -1;
        this.fOpStack = null;
        this.fNodeIndexStack = null;
        this.fPrevNodeIndexStack = null;
        this.fScannerState = -1;
        this.fIncludeSectDepth = 0;
        this.fDoctypeReader = -1;
        this.fExternalSubsetReader = -1;
        this.fDefaultAttValueReader = -1;
        this.fDefaultAttValueElementType = -1;
        this.fDefaultAttValueAttrName = -1;
        this.fDefaultAttValueOffset = -1;
        this.fDefaultAttValueMark = -1;
        this.fEntityValueReader = -1;
        this.fEntityValueMark = -1;
        this.fScannerMarkupDepth = 0;
        this.fScannerParenDepth = 0;
        this.init();
    }

    private void init() {
        this.fXMLSymbol = this.fStringPool.addSymbol("xml");
        this.fXMLNamespace = this.fStringPool.addSymbol("http://www.w3.org/XML/1998/namespace");
        this.fXMLSpace = this.fStringPool.addSymbol("xml:space");
        this.fDefault = this.fStringPool.addSymbol("default");
        this.fPreserve = this.fStringPool.addSymbol("preserve");
    }

    protected void reportRecoverableXMLError(int majorCode, int minorCode, int stringIndex1) throws Exception {
        Object[] args = new Object[]{this.fStringPool.toString(stringIndex1)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 1);
    }

    protected void reportRecoverableXMLError(int majorCode, int minorCode, String string1) throws Exception {
        Object[] args = new Object[]{string1};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 1);
    }

    protected void reportRecoverableXMLError(int majorCode, int minorCode, String string1, String string2) throws Exception {
        Object[] args = new Object[]{string1, string2};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 1);
    }

    private void reportFatalXMLError(int majorCode, int minorCode) throws Exception {
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, null, 2);
    }

    private void reportFatalXMLError(int majorCode, int minorCode, int stringIndex1) throws Exception {
        Object[] args = new Object[]{this.fStringPool.toString(stringIndex1)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 2);
    }

    private void reportFatalXMLError(int majorCode, int minorCode, String string1) throws Exception {
        Object[] args = new Object[]{string1};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 2);
    }

    private void reportFatalXMLError(int majorCode, int minorCode, int stringIndex1, int stringIndex2) throws Exception {
        Object[] args = new Object[]{this.fStringPool.toString(stringIndex1), this.fStringPool.toString(stringIndex2)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 2);
    }

    private void reportFatalXMLError(int majorCode, int minorCode, String string1, String string2) throws Exception {
        Object[] args = new Object[]{string1, string2};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 2);
    }

    private void reportFatalXMLError(int majorCode, int minorCode, String string1, String string2, String string3) throws Exception {
        Object[] args = new Object[]{string1, string2, string3};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 2);
    }

    private void abortMarkup(int majorCode, int minorCode) throws Exception {
        this.reportFatalXMLError(majorCode, minorCode);
        this.skipPastEndOfCurrentMarkup();
    }

    private void abortMarkup(int majorCode, int minorCode, int stringIndex1) throws Exception {
        this.reportFatalXMLError(majorCode, minorCode, stringIndex1);
        this.skipPastEndOfCurrentMarkup();
    }

    private void abortMarkup(int majorCode, int minorCode, String string1) throws Exception {
        this.reportFatalXMLError(majorCode, minorCode, string1);
        this.skipPastEndOfCurrentMarkup();
    }

    private void abortMarkup(int majorCode, int minorCode, int stringIndex1, int stringIndex2) throws Exception {
        this.reportFatalXMLError(majorCode, minorCode, stringIndex1, stringIndex2);
        this.skipPastEndOfCurrentMarkup();
    }

    private void skipPastEndOfCurrentMarkup() throws Exception {
        this.fEntityReader.skipToChar('>');
        if (this.fEntityReader.lookingAtChar('>', true)) {
            this.decreaseMarkupDepth();
        }
    }

    private int setScannerState(int scannerState) {
        int prevState = this.fScannerState;
        this.fScannerState = scannerState;
        return prevState;
    }

    private int getScannerState() {
        return this.fScannerState;
    }

    private void restoreScannerState(int scannerState) {
        if (this.fScannerState != 0) {
            this.fScannerState = scannerState;
        }
    }

    public void readerChange(XMLEntityHandler.EntityReader nextReader, int nextReaderId) throws Exception {
        this.fEntityReader = nextReader;
        this.fReaderId = nextReaderId;
        if (this.fScannerState == 56) {
            this.fDefaultAttValueMark = this.fDefaultAttValueOffset = this.fEntityReader.currentOffset();
        } else if (this.fScannerState == 58) {
            this.fEntityValueMark = this.fEntityReader.currentOffset();
        }
    }

    public void endOfInput(int entityNameIndex, boolean moreToFollow) throws Exception {
        if (this.fValidationEnabled) {
            int readerDepth = this.fEntityHandler.getReaderDepth();
            if (this.getReadingContentSpec()) {
                int parenDepth = this.parenDepth();
                if (readerDepth != parenDepth) {
                    this.reportRecoverableXMLError(74, 75, entityNameIndex);
                }
            } else {
                int markupDepth = this.markupDepth();
                if (readerDepth != markupDepth) {
                    this.reportRecoverableXMLError(73, 74, entityNameIndex);
                }
            }
        }
        moreToFollow = this.fReaderId != this.fExternalSubsetReader;
        switch (this.fScannerState) {
            case -1: {
                throw new RuntimeException("FWK004 XMLDTDScanner.endOfInput: cannot happen: 2\n2");
            }
            case 0: {
                break;
            }
            case 51: {
                if (moreToFollow || this.fIncludeSectDepth <= 0) break;
                this.reportFatalXMLError(23, 22);
                break;
            }
            case 50: {
                throw new RuntimeException("FWK004 XMLDTDScanner.endOfInput: cannot happen: 2.5\n2.5");
            }
            case 53: {
                break;
            }
            case 59: {
                if (moreToFollow) break;
                this.reportFatalXMLError(100, 140);
                break;
            }
            case 60: {
                if (moreToFollow) break;
                this.reportFatalXMLError(101, 141);
                break;
            }
            case 54: {
                if (moreToFollow || this.getReadingExternalEntity()) break;
                this.reportFatalXMLError(163, 133);
                break;
            }
            case 55: {
                if (!moreToFollow) {
                    this.reportFatalXMLError(164, 134);
                    break;
                }
                this.reportFatalXMLError(165, 68);
                break;
            }
            case 56: {
                if (!moreToFollow) {
                    this.reportFatalXMLError(151, 136, this.fDefaultAttValueElementType, this.fDefaultAttValueAttrName);
                    break;
                }
                if (this.fReaderId == this.fDefaultAttValueReader) break;
                this.fEntityReader.append(this.fLiteralData, this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
                break;
            }
            case 57: {
                break;
            }
            case 58: {
                if (this.fReaderId == this.fEntityValueReader) break;
                this.fEntityReader.append(this.fLiteralData, this.fEntityValueMark, this.fEntityReader.currentOffset() - this.fEntityValueMark);
                break;
            }
            default: {
                throw new RuntimeException("FWK004 XMLDTDScanner.endOfInput: cannot happen: 3\n3");
            }
        }
        if (!moreToFollow) {
            this.setScannerState(0);
        }
    }

    private int scanCharRef() throws Exception {
        int valueOffset = this.fEntityReader.currentOffset();
        boolean hex = this.fEntityReader.lookingAtChar('x', true);
        int num = this.fEntityReader.scanCharRef(hex);
        if (num < 0) {
            switch (num) {
                case -1: {
                    this.reportFatalXMLError(18, 17);
                    return -1;
                }
                case -2: {
                    int majorCode = hex ? 17 : 16;
                    int minorCode = hex ? 16 : 15;
                    this.reportFatalXMLError(majorCode, minorCode);
                    return -1;
                }
                case -3: {
                    num = 0x110000;
                }
            }
        }
        if (num < 32 ? num == 9 || num == 10 || num == 13 : num <= 55295 || num >= 57344 && (num <= 65533 || num >= 65536 && num <= 0x10FFFF)) {
            return num;
        }
        int valueLength = this.fEntityReader.currentOffset() - valueOffset;
        this.reportFatalXMLError(11, 9, this.fEntityReader.addString(valueOffset, valueLength));
        return -1;
    }

    private void scanComment() throws Exception {
        int commentOffset = this.fEntityReader.currentOffset();
        boolean sawDashDash = false;
        int previousState = this.setScannerState(54);
        while (this.fScannerState == 54) {
            if (this.fEntityReader.lookingAtChar('-', false)) {
                int nextEndOffset = this.fEntityReader.currentOffset();
                int endOffset = 0;
                this.fEntityReader.lookingAtChar('-', true);
                int offset = this.fEntityReader.currentOffset();
                int count = 1;
                while (this.fEntityReader.lookingAtChar('-', true)) {
                    ++count;
                    endOffset = nextEndOffset;
                    nextEndOffset = offset;
                    offset = this.fEntityReader.currentOffset();
                }
                if (count <= 1) continue;
                if (this.fEntityReader.lookingAtChar('>', true)) {
                    if (!sawDashDash && count > 2) {
                        this.reportFatalXMLError(9, 7);
                        sawDashDash = true;
                    }
                    this.decreaseMarkupDepth();
                    int comment = this.fEntityReader.addString(commentOffset, endOffset - commentOffset);
                    this.fDTDGrammar.callComment(comment);
                    if (this.fDTDHandler != null) {
                        this.fDTDHandler.comment(comment);
                    }
                    this.restoreScannerState(previousState);
                    return;
                }
                if (sawDashDash) continue;
                this.reportFatalXMLError(9, 7);
                sawDashDash = true;
                continue;
            }
            if (this.fEntityReader.lookingAtValidChar(true)) continue;
            int invChar = this.fEntityReader.scanInvalidChar();
            if (this.fScannerState == 0 || invChar < 0) continue;
            this.reportFatalXMLError(10, 8, Integer.toHexString(invChar));
        }
        this.restoreScannerState(previousState);
    }

    /*
     * Unable to fully structure code
     */
    private void scanPI(int piTarget) throws Exception {
        block9: {
            block8: {
                piTargetString = this.fStringPool.toString(piTarget);
                if (!(piTargetString.length() != 3 || piTargetString.charAt(0) != 'X' && piTargetString.charAt(0) != 'x' || piTargetString.charAt(1) != 'M' && piTargetString.charAt(1) != 'm' || piTargetString.charAt(2) != 'L' && piTargetString.charAt(2) != 'l')) {
                    this.abortMarkup(6, 4);
                    return;
                }
                prevState = this.setScannerState(55);
                piDataOffset = -1;
                piDataLength = 0;
                if (this.fEntityReader.lookingAtSpace(true)) break block8;
                if (!this.fEntityReader.lookingAtChar('?', true) || !this.fEntityReader.lookingAtChar('>', true)) {
                    if (this.fScannerState != 0) {
                        this.abortMarkup(7, 5);
                        this.restoreScannerState(prevState);
                    }
                    return;
                }
                this.decreaseMarkupDepth();
                this.restoreScannerState(prevState);
                break block9;
            }
            this.fEntityReader.skipPastSpaces();
            piDataOffset = this.fEntityReader.currentOffset();
            ** GOTO lbl43
            {
                block10: {
                    offset = this.fEntityReader.currentOffset();
                    this.fEntityReader.lookingAtChar('?', true);
                    if (!this.fEntityReader.lookingAtChar('>', true)) break block10;
                    piDataLength = offset - piDataOffset;
                    this.decreaseMarkupDepth();
                    this.restoreScannerState(prevState);
                    ** GOTO lbl34
                }
                do {
                    if (this.fEntityReader.lookingAtChar('?', false)) continue block0;
lbl34:
                    // 2 sources

                    if (this.fScannerState != 55) break block0;
                    if (this.fEntityReader.lookingAtValidChar(true)) continue;
                    invChar = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState != 0) {
                        if (invChar >= 0) {
                            this.reportFatalXMLError(8, 6, Integer.toHexString(invChar));
                        }
                        this.skipPastEndOfCurrentMarkup();
                        this.restoreScannerState(prevState);
                    }
                    return;
lbl43:
                    // 2 sources

                } while (this.fScannerState == 55);
            }
        }
        piData = piDataLength == 0 ? 0 : this.fEntityReader.addString(piDataOffset, piDataLength);
        this.fDTDGrammar.callProcessingInstruction(piTarget, piData);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.processingInstruction(piTarget, piData);
        }
    }

    public boolean scanDoctypeDecl() throws Exception {
        boolean lbrkt;
        this.fDTDGrammar = new DTDGrammar(this.fStringPool);
        this.fDTDGrammar.callStartDTD();
        this.increaseMarkupDepth();
        this.fEntityReader = this.fEntityHandler.getEntityReader();
        this.fDoctypeReader = this.fReaderId = this.fEntityHandler.getReaderId();
        this.setScannerState(50);
        if (!this.fEntityReader.lookingAtSpace(true)) {
            this.abortMarkup(159, 120);
            return false;
        }
        this.fEntityReader.skipPastSpaces();
        this.scanElementType(this.fEntityReader, ' ', this.fElementQName);
        if (this.fElementQName.rawname == -1) {
            this.abortMarkup(153, 119);
            return false;
        }
        boolean scanExternalSubset = false;
        int publicId = -1;
        int systemId = -1;
        if (this.fEntityReader.lookingAtSpace(true)) {
            this.fEntityReader.skipPastSpaces();
            lbrkt = this.fEntityReader.lookingAtChar('[', true);
            if (!lbrkt && !this.fEntityReader.lookingAtChar('>', false)) {
                if (!this.scanExternalID(false)) {
                    this.skipPastEndOfCurrentMarkup();
                    return false;
                }
                if (this.fValidationEnabled || this.fLoadExternalDTD) {
                    scanExternalSubset = true;
                }
                publicId = this.fPubidLiteral;
                systemId = this.fSystemLiteral;
                this.fEntityReader.skipPastSpaces();
                lbrkt = this.fEntityReader.lookingAtChar('[', true);
            }
        } else {
            lbrkt = this.fEntityReader.lookingAtChar('[', true);
        }
        this.fDTDGrammar.doctypeDecl(this.fElementQName, publicId, systemId);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startDTD(this.fElementQName, publicId, systemId);
        }
        if (lbrkt) {
            this.scanDecls(false);
            this.fEntityReader.skipPastSpaces();
        }
        if (!this.fEntityReader.lookingAtChar('>', true)) {
            if (this.fScannerState != 0) {
                this.abortMarkup(147, 121, this.fElementQName.rawname);
            }
            return false;
        }
        this.decreaseMarkupDepth();
        if (scanExternalSubset) {
            ((DefaultEntityHandler)this.fEntityHandler).startReadingFromExternalSubset(this.fStringPool.toString(publicId), this.fStringPool.toString(systemId), this.markupDepth());
            this.fDTDGrammar.startReadingFromExternalSubset(publicId, systemId);
        } else {
            this.fDTDGrammar.callEndDTD();
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endDTD();
            }
        }
        this.fGrammarResolver.putGrammar("", this.fDTDGrammar);
        return true;
    }

    private boolean scanExternalID(boolean scanPublicID) throws Exception {
        this.fSystemLiteral = -1;
        this.fPubidLiteral = -1;
        int offset = this.fEntityReader.currentOffset();
        if (this.fEntityReader.skippedString(system_string)) {
            if (!this.fEntityReader.lookingAtSpace(true)) {
                this.reportFatalXMLError(160, 131);
                return false;
            }
            this.fEntityReader.skipPastSpaces();
            if (this.getReadingExternalEntity()) {
                this.checkForPEReference(false);
            }
            return this.scanSystemLiteral();
        }
        if (this.fEntityReader.skippedString(public_string)) {
            if (!this.fEntityReader.lookingAtSpace(true)) {
                this.reportFatalXMLError(158, 131);
                return false;
            }
            this.fEntityReader.skipPastSpaces();
            if (!this.scanPubidLiteral()) {
                return false;
            }
            if (scanPublicID) {
                if (!this.fEntityReader.lookingAtSpace(true)) {
                    return true;
                }
                this.fEntityReader.skipPastSpaces();
                if (this.fEntityReader.lookingAtChar('>', false)) {
                    return true;
                }
            } else {
                if (!this.fEntityReader.lookingAtSpace(true)) {
                    this.reportFatalXMLError(154, 131);
                    return false;
                }
                this.fEntityReader.skipPastSpaces();
            }
            return this.scanSystemLiteral();
        }
        this.reportFatalXMLError(50, 52);
        return false;
    }

    private boolean scanSystemLiteral() throws Exception {
        boolean single = this.fEntityReader.lookingAtChar('\'', true);
        if (!single && !this.fEntityReader.lookingAtChar('\"', true)) {
            this.reportFatalXMLError(19, 18);
            return false;
        }
        int prevState = this.setScannerState(59);
        int offset = this.fEntityReader.currentOffset();
        char qchar = single ? (char)'\'' : '\"';
        boolean dataok = true;
        boolean fragment = false;
        while (!this.fEntityReader.lookingAtChar(qchar, false)) {
            if (this.fEntityReader.lookingAtChar('#', true)) {
                fragment = true;
                continue;
            }
            if (this.fEntityReader.lookingAtValidChar(true)) continue;
            dataok = false;
            int invChar = this.fEntityReader.scanInvalidChar();
            if (this.fScannerState == 0) {
                return false;
            }
            if (invChar < 0) continue;
            this.reportFatalXMLError(20, 19, Integer.toHexString(invChar));
        }
        if (dataok) {
            this.fSystemLiteral = this.fEntityReader.addString(offset, this.fEntityReader.currentOffset() - offset);
            if (fragment) {
                Object[] args = new Object[]{this.fStringPool.toString(this.fSystemLiteral)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 133, 142, args, 1);
            }
        }
        this.fEntityReader.lookingAtChar(qchar, true);
        this.restoreScannerState(prevState);
        return dataok;
    }

    private boolean scanPubidLiteral() throws Exception {
        boolean single = this.fEntityReader.lookingAtChar('\'', true);
        if (!single && !this.fEntityReader.lookingAtChar('\"', true)) {
            this.reportFatalXMLError(21, 20);
            return false;
        }
        char qchar = single ? (char)'\'' : '\"';
        int prevState = this.setScannerState(60);
        boolean dataok = true;
        do {
            if (!this.fEntityReader.lookingAtChar('\t', true)) continue;
            dataok = false;
            this.reportFatalXMLError(60, 21, "9");
        } while (this.fEntityReader.lookingAtSpace(true));
        int offset = this.fEntityReader.currentOffset();
        int dataOffset = this.fLiteralData.length();
        int toCopy = offset;
        while (true) {
            if (this.fEntityReader.lookingAtChar(qchar, true)) {
                if (!dataok || offset - toCopy <= 0) break;
                this.fEntityReader.append(this.fLiteralData, toCopy, offset - toCopy);
                break;
            }
            if (this.fEntityReader.lookingAtChar('\t', true)) {
                dataok = false;
                this.reportFatalXMLError(60, 21, "9");
                continue;
            }
            if (this.fEntityReader.lookingAtSpace(true)) {
                if (dataok && offset - toCopy > 0) {
                    this.fEntityReader.append(this.fLiteralData, toCopy, offset - toCopy);
                }
                do {
                    if (!this.fEntityReader.lookingAtChar('\t', true)) continue;
                    dataok = false;
                    this.reportFatalXMLError(60, 21, "9");
                    break;
                } while (this.fEntityReader.lookingAtSpace(true));
                if (this.fEntityReader.lookingAtChar(qchar, true)) break;
                if (!dataok) continue;
                this.fLiteralData.append(' ');
                toCopy = offset = this.fEntityReader.currentOffset();
                continue;
            }
            if (!this.fEntityReader.lookingAtValidChar(true)) {
                int invChar = this.fEntityReader.scanInvalidChar();
                if (this.fScannerState == 0) {
                    return false;
                }
                dataok = false;
                if (invChar >= 0) {
                    this.reportFatalXMLError(22, 21, Integer.toHexString(invChar));
                }
            }
            if (!dataok) continue;
            offset = this.fEntityReader.currentOffset();
        }
        if (dataok) {
            int dataLength = this.fLiteralData.length() - dataOffset;
            this.fPubidLiteral = this.fLiteralData.addString(dataOffset, dataLength);
            String publicId = this.fStringPool.toString(this.fPubidLiteral);
            int invCharIndex = this.validPublicId(publicId);
            if (invCharIndex >= 0) {
                this.reportFatalXMLError(60, 21, Integer.toHexString(publicId.charAt(invCharIndex)));
                return false;
            }
        }
        this.restoreScannerState(prevState);
        return dataok;
    }

    public void scanDecls(boolean extSubset) throws Exception {
        int subsetOffset = this.fEntityReader.currentOffset();
        if (extSubset) {
            this.fExternalSubsetReader = this.fReaderId;
        }
        this.fIncludeSectDepth = 0;
        boolean parseTextDecl = extSubset;
        int prevState = this.setScannerState(51);
        while (this.fScannerState == 51) {
            boolean newParseTextDecl = false;
            if (this.fEntityReader.lookingAtChar(']', false) && !this.getReadingExternalEntity()) {
                int subsetLength = this.fEntityReader.currentOffset() - subsetOffset;
                int internalSubset = this.fEntityReader.addString(subsetOffset, subsetLength);
                this.fDTDGrammar.internalSubset(internalSubset);
                if (this.fDTDHandler != null) {
                    this.fDTDHandler.internalSubset(internalSubset);
                }
                this.fEntityReader.lookingAtChar(']', true);
                this.restoreScannerState(prevState);
                return;
            }
            if (this.fEntityReader.lookingAtChar('<', true)) {
                int olddepth = this.markupDepth();
                this.increaseMarkupDepth();
                if (this.fEntityReader.lookingAtChar('!', true)) {
                    if (this.fEntityReader.lookingAtChar('-', true)) {
                        if (this.fEntityReader.lookingAtChar('-', true)) {
                            this.scanComment();
                        } else {
                            this.abortMarkup(150, 122);
                        }
                    } else if (this.fEntityReader.lookingAtChar('[', true) && this.getReadingExternalEntity()) {
                        this.checkForPEReference(false);
                        if (this.fEntityReader.skippedString(include_string)) {
                            this.checkForPEReference(false);
                            if (!this.fEntityReader.lookingAtChar('[', true)) {
                                this.abortMarkup(150, 122);
                            } else {
                                ++this.fIncludeSectDepth;
                            }
                        } else if (this.fEntityReader.skippedString(ignore_string)) {
                            this.checkForPEReference(false);
                            if (!this.fEntityReader.lookingAtChar('[', true)) {
                                this.abortMarkup(150, 122);
                            } else {
                                this.scanIgnoreSectContents();
                            }
                        } else {
                            this.abortMarkup(150, 122);
                        }
                    } else if (this.fEntityReader.skippedString(element_string)) {
                        this.scanElementDecl();
                    } else if (this.fEntityReader.skippedString(attlist_string)) {
                        this.scanAttlistDecl();
                    } else if (this.fEntityReader.skippedString(entity_string)) {
                        this.scanEntityDecl();
                    } else if (this.fEntityReader.skippedString(notation_string)) {
                        this.scanNotationDecl();
                    } else {
                        this.abortMarkup(150, 122);
                    }
                } else if (this.fEntityReader.lookingAtChar('?', true)) {
                    int piTarget = this.fEntityReader.scanName(' ');
                    if (piTarget == -1) {
                        this.abortMarkup(131, 106);
                    } else if ("xml".equals(this.fStringPool.toString(piTarget))) {
                        if (this.fEntityReader.lookingAtSpace(true)) {
                            if (parseTextDecl) {
                                this.scanTextDecl();
                            } else {
                                this.abortMarkup(105, 138);
                            }
                        } else {
                            this.abortMarkup(6, 4);
                        }
                    } else {
                        this.scanPI(piTarget);
                    }
                } else {
                    this.abortMarkup(150, 122);
                }
            } else if (this.fEntityReader.lookingAtSpace(true)) {
                this.fEntityReader.skipPastSpaces();
            } else if (this.fEntityReader.lookingAtChar('%', true)) {
                int nameOffset = this.fEntityReader.currentOffset();
                this.fEntityReader.skipPastName(';');
                int nameLength = this.fEntityReader.currentOffset() - nameOffset;
                if (nameLength == 0) {
                    this.reportFatalXMLError(48, 50);
                } else if (!this.fEntityReader.lookingAtChar(';', true)) {
                    this.reportFatalXMLError(49, 51, this.fEntityReader.addString(nameOffset, nameLength));
                } else {
                    int peNameIndex = this.fEntityReader.addSymbol(nameOffset, nameLength);
                    newParseTextDecl = this.fEntityHandler.startReadingFromEntity(peNameIndex, this.markupDepth(), 3);
                }
            } else if (this.fIncludeSectDepth > 0 && this.fEntityReader.lookingAtChar(']', true)) {
                if (!this.fEntityReader.lookingAtChar(']', true) || !this.fEntityReader.lookingAtChar('>', true)) {
                    this.abortMarkup(23, 22);
                } else {
                    this.decreaseMarkupDepth();
                }
                --this.fIncludeSectDepth;
            } else if (!this.fEntityReader.lookingAtValidChar(false)) {
                int invChar = this.fEntityReader.scanInvalidChar();
                if (this.fScannerState == 0) break;
                if (invChar >= 0) {
                    if (!extSubset) {
                        this.reportFatalXMLError(44, 46, Integer.toHexString(invChar));
                    } else {
                        this.reportFatalXMLError(45, 47, Integer.toHexString(invChar));
                    }
                }
            } else {
                this.reportFatalXMLError(150, 122);
                this.fEntityReader.lookingAtValidChar(true);
            }
            parseTextDecl = newParseTextDecl;
        }
        if (extSubset) {
            ((DefaultEntityHandler)this.fEntityHandler).stopReadingFromExternalSubset();
            this.fDTDGrammar.stopReadingFromExternalSubset();
            this.fDTDGrammar.callEndDTD();
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endDTD();
            }
            this.fGrammarResolver.putGrammar("", this.fDTDGrammar);
        }
    }

    private void scanIgnoreSectContents() throws Exception {
        int initialDepth = ++this.fIncludeSectDepth;
        while (true) {
            if (this.fEntityReader.lookingAtChar('<', true)) {
                if (!this.fEntityReader.lookingAtChar('!', true) || !this.fEntityReader.lookingAtChar('[', true)) continue;
                ++this.fIncludeSectDepth;
                continue;
            }
            if (this.fEntityReader.lookingAtChar(']', true)) {
                if (!this.fEntityReader.lookingAtChar(']', true)) continue;
                while (this.fEntityReader.lookingAtChar(']', true)) {
                }
                if (!this.fEntityReader.lookingAtChar('>', true) || this.fIncludeSectDepth-- != initialDepth) continue;
                this.decreaseMarkupDepth();
                return;
            }
            if (this.fEntityReader.lookingAtValidChar(true)) continue;
            int invChar = this.fEntityReader.scanInvalidChar();
            if (this.fScannerState == 0) {
                return;
            }
            if (invChar < 0) continue;
            this.reportFatalXMLError(25, 24, Integer.toHexString(invChar));
        }
    }

    private void scanTextDecl() throws Exception {
        int version = -1;
        int encoding = -1;
        boolean TEXTDECL_START = false;
        boolean TEXTDECL_VERSION = true;
        int TEXTDECL_ENCODING = 2;
        int TEXTDECL_FINISHED = 3;
        int prevState = this.setScannerState(53);
        int state = 0;
        do {
            this.fEntityReader.skipPastSpaces();
            int offset = this.fEntityReader.currentOffset();
            if (state == 0 && this.fEntityReader.skippedString(version_string)) {
                state = 1;
            } else if (this.fEntityReader.skippedString(encoding_string)) {
                state = 2;
            } else {
                this.abortMarkup(29, 28);
                this.restoreScannerState(prevState);
                return;
            }
            int length = this.fEntityReader.currentOffset() - offset;
            this.fEntityReader.skipPastSpaces();
            if (!this.fEntityReader.lookingAtChar('=', true)) {
                int minorCode = state == 1 ? 30 : 32;
                this.abortMarkup(32, minorCode, this.fEntityReader.addString(offset, length));
                this.restoreScannerState(prevState);
                return;
            }
            this.fEntityReader.skipPastSpaces();
            int result = this.fEntityReader.scanStringLiteral();
            switch (result) {
                case -1: {
                    int minorCode = state == 1 ? 33 : 35;
                    this.abortMarkup(34, minorCode, this.fEntityReader.addString(offset, length));
                    this.restoreScannerState(prevState);
                    return;
                }
                case -2: {
                    int invChar = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState != 0) {
                        if (invChar >= 0) {
                            int minorCode = state == 1 ? 36 : 38;
                            this.reportFatalXMLError(36, minorCode, Integer.toHexString(invChar));
                        }
                        this.skipPastEndOfCurrentMarkup();
                        this.restoreScannerState(prevState);
                    }
                    return;
                }
            }
            switch (state) {
                case 1: {
                    version = result;
                    String versionString = this.fStringPool.toString(version);
                    if (!"1.0".equals(versionString)) {
                        if (!this.validVersionNum(versionString)) {
                            this.abortMarkup(37, 39, versionString);
                            this.restoreScannerState(prevState);
                            return;
                        }
                        Object[] args = new Object[]{versionString};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 38, 40, args, 1);
                    }
                    if (this.fEntityReader.lookingAtSpace(true)) break;
                    this.abortMarkup(39, 41);
                    this.restoreScannerState(prevState);
                    return;
                }
                case 2: {
                    encoding = result;
                    String encodingString = this.fStringPool.toString(encoding);
                    if (!this.validEncName(encodingString)) {
                        this.abortMarkup(40, 42, encodingString);
                        this.restoreScannerState(prevState);
                        return;
                    }
                    this.fEntityReader.skipPastSpaces();
                    state = 3;
                }
            }
        } while (state != 3);
        if (!this.fEntityReader.lookingAtChar('?', true) || !this.fEntityReader.lookingAtChar('>', true)) {
            this.abortMarkup(43, 45);
            this.restoreScannerState(prevState);
            return;
        }
        this.decreaseMarkupDepth();
        this.fDTDGrammar.callTextDecl(version, encoding);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.textDecl(version, encoding);
        }
        this.restoreScannerState(prevState);
    }

    private void scanElementDecl() throws Exception {
        if (!this.checkForPEReference(true)) {
            this.abortMarkup(156, 125);
            return;
        }
        this.checkForElementTypeWithPEReference(this.fEntityReader, ' ', this.fElementQName);
        if (this.fElementQName.rawname == -1) {
            this.abortMarkup(148, 124);
            return;
        }
        if (this.fDTDHandler != null) {
            this.fElementDeclQName.setValues(this.fElementQName);
        }
        if (!this.checkForPEReference(true)) {
            this.abortMarkup(155, 125, this.fElementQName.rawname);
            return;
        }
        int contentSpecType = -1;
        int contentSpec = -1;
        if (this.fEntityReader.skippedString(empty_string)) {
            contentSpecType = 0;
        } else if (this.fEntityReader.skippedString(any_string)) {
            contentSpecType = 1;
        } else {
            if (!this.fEntityReader.lookingAtChar('(', true)) {
                this.abortMarkup(146, 123, this.fElementQName.rawname);
                return;
            }
            int contentSpecReader = this.fReaderId;
            int contentSpecReaderDepth = this.fEntityHandler.getReaderDepth();
            int prevState = this.setScannerState(57);
            int oldDepth = this.parenDepth();
            this.fEntityHandler.setReaderDepth(oldDepth);
            this.increaseParenDepth();
            this.checkForPEReference(false);
            boolean skippedPCDATA = this.fEntityReader.skippedString(pcdata_string);
            if (skippedPCDATA) {
                contentSpecType = 2;
                contentSpec = this.scanMixed(this.fElementQName);
            } else {
                contentSpecType = 4;
                contentSpec = this.scanChildren(this.fElementQName);
            }
            boolean success = contentSpec != -1;
            this.restoreScannerState(prevState);
            this.fEntityHandler.setReaderDepth(contentSpecReaderDepth);
            if (!success) {
                this.setParenDepth(oldDepth);
                this.skipPastEndOfCurrentMarkup();
                return;
            }
            if (this.parenDepth() != oldDepth) {
                // empty if block
            }
        }
        this.checkForPEReference(false);
        if (!this.fEntityReader.lookingAtChar('>', true)) {
            this.abortMarkup(106, 126, this.fElementQName.rawname);
            return;
        }
        this.decreaseMarkupDepth();
        int elementIndex = this.fDTDGrammar.getElementDeclIndex(this.fElementQName, -1);
        boolean elementDeclIsExternal = this.getReadingExternalEntity();
        if (elementIndex == -1) {
            elementIndex = this.fDTDGrammar.addElementDecl(this.fElementQName, contentSpecType, contentSpec, elementDeclIsExternal);
        } else {
            this.fDTDGrammar.getElementDecl(elementIndex, this.fTempElementDecl);
            if (this.fTempElementDecl.type == -1) {
                this.fTempElementDecl.type = contentSpecType;
                this.fTempElementDecl.contentSpecIndex = contentSpec;
                this.fDTDGrammar.setElementDeclDTD(elementIndex, this.fTempElementDecl);
                this.fDTDGrammar.setElementDeclIsExternal(elementIndex, elementDeclIsExternal);
            } else if (this.fValidationEnabled) {
                this.reportRecoverableXMLError(89, 82, this.fStringPool.toString(this.fElementQName.rawname));
            }
        }
        if (this.fDTDHandler != null) {
            this.fDTDGrammar.getElementDecl(elementIndex, this.fTempElementDecl);
            this.fDTDHandler.elementDecl(this.fElementDeclQName, contentSpecType, contentSpec, this.fDTDGrammar);
        }
    }

    private int scanMixed(QName element) throws Exception {
        int valueIndex = -1;
        int prevNodeIndex = -1;
        boolean starRequired = false;
        int[] valueSeen = new int[32];
        int valueCount = 0;
        boolean dupAttrType = false;
        int nodeIndex = -1;
        do {
            if (this.fValidationEnabled) {
                int i = 0;
                while (i < valueCount) {
                    if (valueSeen[i] == valueIndex) {
                        dupAttrType = true;
                        break;
                    }
                    ++i;
                }
            }
            if (dupAttrType && this.fValidationEnabled) {
                this.reportRecoverableXMLError(67, 67, valueIndex);
                dupAttrType = false;
            } else {
                try {
                    valueSeen[valueCount] = valueIndex;
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                    int[] newArray = new int[valueSeen.length * 2];
                    System.arraycopy(valueSeen, 0, newArray, 0, valueSeen.length);
                    valueSeen = newArray;
                    valueSeen[valueCount] = valueIndex;
                }
                ++valueCount;
                nodeIndex = this.fDTDGrammar.addUniqueLeafNode(valueIndex);
            }
            this.checkForPEReference(false);
            if (!this.fEntityReader.lookingAtChar('|', true)) {
                if (!this.fEntityReader.lookingAtChar(')', true)) {
                    this.reportFatalXMLError(145, 129, element.rawname);
                    return -1;
                }
                this.decreaseParenDepth();
                if (nodeIndex == -1) {
                    nodeIndex = prevNodeIndex;
                } else if (prevNodeIndex != -1) {
                    nodeIndex = this.fDTDGrammar.addContentSpecNode(4, prevNodeIndex, nodeIndex);
                }
                if (this.fEntityReader.lookingAtChar('*', true)) {
                    nodeIndex = this.fDTDGrammar.addContentSpecNode(2, nodeIndex);
                } else if (starRequired) {
                    this.reportFatalXMLError(47, 49, this.fStringPool.toString(element.rawname), this.fDTDGrammar.getContentSpecNodeAsString(nodeIndex));
                    return -1;
                }
                return nodeIndex;
            }
            if (nodeIndex != -1) {
                if (prevNodeIndex != -1) {
                    nodeIndex = this.fDTDGrammar.addContentSpecNode(4, prevNodeIndex, nodeIndex);
                }
                prevNodeIndex = nodeIndex;
            }
            starRequired = true;
            this.checkForPEReference(false);
            this.checkForElementTypeWithPEReference(this.fEntityReader, ')', this.fElementRefQName);
        } while ((valueIndex = this.fElementRefQName.rawname) != -1);
        this.reportFatalXMLError(149, 130, element.rawname);
        return -1;
    }

    private int scanChildren(QName element) throws Exception {
        int depth = 1;
        this.initializeContentModelStack(depth);
        while (true) {
            block17: {
                if (this.fEntityReader.lookingAtChar('(', true)) {
                    this.increaseParenDepth();
                    this.checkForPEReference(false);
                    this.initializeContentModelStack(++depth);
                    continue;
                }
                this.checkForElementTypeWithPEReference(this.fEntityReader, ')', this.fElementRefQName);
                int valueIndex = this.fElementRefQName.rawname;
                if (valueIndex == -1) {
                    this.reportFatalXMLError(152, 128, element.rawname);
                    return -1;
                }
                this.fNodeIndexStack[depth] = this.fDTDGrammar.addContentSpecNode(0, valueIndex);
                if (this.fEntityReader.lookingAtChar('?', true)) {
                    this.fNodeIndexStack[depth] = this.fDTDGrammar.addContentSpecNode(1, this.fNodeIndexStack[depth]);
                } else if (this.fEntityReader.lookingAtChar('*', true)) {
                    this.fNodeIndexStack[depth] = this.fDTDGrammar.addContentSpecNode(2, this.fNodeIndexStack[depth]);
                } else if (this.fEntityReader.lookingAtChar('+', true)) {
                    this.fNodeIndexStack[depth] = this.fDTDGrammar.addContentSpecNode(3, this.fNodeIndexStack[depth]);
                }
                do {
                    int nodeIndex;
                    this.checkForPEReference(false);
                    if (this.fOpStack[depth] != 5 && this.fEntityReader.lookingAtChar('|', true)) {
                        if (this.fPrevNodeIndexStack[depth] != -1) {
                            this.fNodeIndexStack[depth] = this.fDTDGrammar.addContentSpecNode(this.fOpStack[depth], this.fPrevNodeIndexStack[depth], this.fNodeIndexStack[depth]);
                        }
                        this.fPrevNodeIndexStack[depth] = this.fNodeIndexStack[depth];
                        this.fOpStack[depth] = 4;
                        break block17;
                    }
                    if (this.fOpStack[depth] != 4 && this.fEntityReader.lookingAtChar(',', true)) {
                        if (this.fPrevNodeIndexStack[depth] != -1) {
                            this.fNodeIndexStack[depth] = this.fDTDGrammar.addContentSpecNode(this.fOpStack[depth], this.fPrevNodeIndexStack[depth], this.fNodeIndexStack[depth]);
                        }
                        this.fPrevNodeIndexStack[depth] = this.fNodeIndexStack[depth];
                        this.fOpStack[depth] = 5;
                        break block17;
                    }
                    if (!this.fEntityReader.lookingAtChar(')', true)) {
                        this.reportFatalXMLError(98, 127, element.rawname);
                    }
                    this.decreaseParenDepth();
                    if (this.fPrevNodeIndexStack[depth] != -1) {
                        this.fNodeIndexStack[depth] = this.fDTDGrammar.addContentSpecNode(this.fOpStack[depth], this.fPrevNodeIndexStack[depth], this.fNodeIndexStack[depth]);
                    }
                    int n = depth--;
                    this.fNodeIndexStack[depth] = nodeIndex = this.fNodeIndexStack[n];
                    if (this.fEntityReader.lookingAtChar('?', true)) {
                        this.fNodeIndexStack[depth] = this.fDTDGrammar.addContentSpecNode(1, this.fNodeIndexStack[depth]);
                        continue;
                    }
                    if (this.fEntityReader.lookingAtChar('*', true)) {
                        this.fNodeIndexStack[depth] = this.fDTDGrammar.addContentSpecNode(2, this.fNodeIndexStack[depth]);
                        continue;
                    }
                    if (!this.fEntityReader.lookingAtChar('+', true)) continue;
                    this.fNodeIndexStack[depth] = this.fDTDGrammar.addContentSpecNode(3, this.fNodeIndexStack[depth]);
                } while (depth != 0);
                return this.fNodeIndexStack[0];
            }
            this.checkForPEReference(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scanAttlistDecl() throws Exception {
        if (!this.checkForPEReference(true)) {
            this.abortMarkup(141, 112);
            return;
        }
        this.checkForElementTypeWithPEReference(this.fEntityReader, ' ', this.fElementQName);
        int elementTypeIndex = this.fElementQName.rawname;
        if (elementTypeIndex == -1) {
            this.abortMarkup(125, 111);
            return;
        }
        int elementIndex = this.fDTDGrammar.getElementDeclIndex(this.fElementQName, -1);
        if (elementIndex == -1) {
            elementIndex = this.fDTDGrammar.addElementDecl(this.fElementQName);
        }
        boolean sawSpace = this.checkForPEReference(true);
        if (this.fEntityReader.lookingAtChar('>', true)) {
            this.decreaseMarkupDepth();
            return;
        }
        if (!sawSpace) {
            if (this.fEntityReader.lookingAtSpace(true)) {
                this.fEntityReader.skipPastSpaces();
            } else {
                this.reportFatalXMLError(138, 113);
            }
        } else if (this.fEntityReader.lookingAtSpace(true)) {
            this.fEntityReader.skipPastSpaces();
        }
        if (this.fEntityReader.lookingAtChar('>', true)) {
            this.decreaseMarkupDepth();
            return;
        }
        while (true) {
            int attDefIndex;
            int attDefEnumeration;
            boolean attDefList;
            int attDefType;
            int attDefName;
            block55: {
                block58: {
                    block57: {
                        this.checkForAttributeNameWithPEReference(this.fEntityReader, ' ', this.fAttributeQName);
                        attDefName = this.fAttributeQName.rawname;
                        if (attDefName == -1) {
                            this.abortMarkup(58, 70, this.fElementQName.rawname);
                            return;
                        }
                        if (!this.checkForPEReference(true)) {
                            this.abortMarkup(139, 113);
                            return;
                        }
                        attDefType = -1;
                        attDefList = false;
                        attDefEnumeration = -1;
                        if (!this.fEntityReader.skippedString(cdata_string)) break block57;
                        attDefType = 0;
                        break block55;
                    }
                    if (!this.fEntityReader.skippedString(id_string)) break block58;
                    if (!this.fEntityReader.skippedString(ref_string)) {
                        attDefType = 3;
                        break block55;
                    } else if (!this.fEntityReader.lookingAtChar('S', true)) {
                        attDefType = 4;
                        break block55;
                    } else {
                        attDefType = 4;
                        attDefList = true;
                    }
                    break block55;
                }
                if (this.fEntityReader.skippedString(entit_string)) {
                    if (this.fEntityReader.lookingAtChar('Y', true)) {
                        attDefType = 1;
                    } else {
                        if (!this.fEntityReader.skippedString(ies_string)) {
                            this.abortMarkup(59, 71, elementTypeIndex, attDefName);
                            return;
                        }
                        attDefType = 1;
                        attDefList = true;
                    }
                } else if (this.fEntityReader.skippedString(nmtoken_string)) {
                    if (this.fEntityReader.lookingAtChar('S', true)) {
                        attDefType = 5;
                        attDefList = true;
                    } else {
                        attDefType = 5;
                    }
                } else if (this.fEntityReader.skippedString(notation_string)) {
                    if (!this.checkForPEReference(true)) {
                        this.abortMarkup(136, 115, elementTypeIndex, attDefName);
                        return;
                    }
                    if (!this.fEntityReader.lookingAtChar('(', true)) {
                        this.abortMarkup(130, 114, elementTypeIndex, attDefName);
                        return;
                    }
                    this.increaseParenDepth();
                    attDefType = 6;
                    attDefEnumeration = this.scanEnumeration(elementTypeIndex, attDefName, true);
                    if (attDefEnumeration == -1) {
                        this.skipPastEndOfCurrentMarkup();
                        return;
                    }
                } else {
                    if (!this.fEntityReader.lookingAtChar('(', true)) {
                        this.abortMarkup(59, 71, elementTypeIndex, attDefName);
                        return;
                    }
                    this.increaseParenDepth();
                    attDefType = 2;
                    attDefEnumeration = this.scanEnumeration(elementTypeIndex, attDefName, false);
                    if (attDefEnumeration == -1) {
                        this.skipPastEndOfCurrentMarkup();
                        return;
                    }
                }
            }
            if (!this.checkForPEReference(true)) {
                this.abortMarkup(140, 113, elementTypeIndex, attDefName);
                return;
            }
            int attDefDefaultType = -1;
            int attDefDefaultValue = -1;
            if (this.fEntityReader.skippedString(required_string)) {
                attDefDefaultType = 2;
            } else if (this.fEntityReader.skippedString(implied_string)) {
                attDefDefaultType = 1;
            } else {
                if (this.fEntityReader.skippedString(fixed_string)) {
                    if (!this.checkForPEReference(true)) {
                        this.abortMarkup(135, 116, elementTypeIndex, attDefName);
                        return;
                    }
                    attDefDefaultType = 16;
                } else {
                    attDefDefaultType = 8;
                }
                attDefDefaultValue = this.scanDefaultAttValue(this.fElementQName, this.fAttributeQName, attDefType, attDefEnumeration);
                if (attDefDefaultValue != -1 && attDefType != 0) {
                    attDefDefaultValue = this.normalizeDefaultAttValue(this.fAttributeQName, attDefDefaultValue, attDefType, attDefEnumeration, attDefList);
                }
                if (attDefDefaultValue == -1) {
                    this.skipPastEndOfCurrentMarkup();
                    return;
                }
            }
            if (attDefName == this.fXMLSpace) {
                int index;
                boolean ok = false;
                if (attDefType == 2 && (index = attDefEnumeration) != -1) {
                    boolean bl = ok = this.fStringPool.stringListLength(index) == 1 && (this.fStringPool.stringInList(index, this.fDefault) || this.fStringPool.stringInList(index, this.fPreserve)) || this.fStringPool.stringListLength(index) == 2 && this.fStringPool.stringInList(index, this.fDefault) && this.fStringPool.stringInList(index, this.fPreserve);
                }
                if (!ok) {
                    this.reportFatalXMLError(144, 117, elementTypeIndex);
                }
            }
            sawSpace = this.checkForPEReference(true);
            if (this.fAttributeQName.prefix == this.fXMLSymbol) {
                this.fAttributeQName.uri = this.fXMLNamespace;
            }
            if (this.fEntityReader.lookingAtChar('>', true)) {
                attDefIndex = this.addAttDef(this.fElementQName, this.fAttributeQName, attDefType, attDefList, attDefEnumeration, attDefDefaultType, attDefDefaultValue, this.getReadingExternalEntity());
                this.decreaseMarkupDepth();
                return;
            }
            if (!sawSpace) {
                if (this.fEntityReader.lookingAtSpace(true)) {
                    this.fEntityReader.skipPastSpaces();
                } else {
                    this.reportFatalXMLError(138, 113);
                }
            } else if (this.fEntityReader.lookingAtSpace(true)) {
                this.fEntityReader.skipPastSpaces();
            }
            if (this.fEntityReader.lookingAtChar('>', true)) {
                attDefIndex = this.addAttDef(this.fElementQName, this.fAttributeQName, attDefType, attDefList, attDefEnumeration, attDefDefaultType, attDefDefaultValue, this.getReadingExternalEntity());
                this.decreaseMarkupDepth();
                return;
            }
            int n = this.addAttDef(this.fElementQName, this.fAttributeQName, attDefType, attDefList, attDefEnumeration, attDefDefaultType, attDefDefaultValue, this.getReadingExternalEntity());
        }
    }

    private int addAttDef(QName element, QName attribute, int attDefType, boolean attDefList, int attDefEnumeration, int attDefDefaultType, int attDefDefaultValue, boolean isExternal) throws Exception {
        int elementIndex;
        if (this.fDTDHandler != null) {
            String enumString = attDefEnumeration != -1 ? this.fStringPool.stringListAsString(attDefEnumeration) : null;
            this.fDTDHandler.attlistDecl(element, attribute, attDefType, attDefList, enumString, attDefDefaultType, attDefDefaultValue);
        }
        if ((elementIndex = this.fDTDGrammar.getElementDeclIndex(element, -1)) != -1) {
            int attlistIndex = this.fDTDGrammar.getFirstAttributeDeclIndex(elementIndex);
            int dupID = -1;
            int dupNotation = -1;
            while (attlistIndex != -1) {
                this.fDTDGrammar.getAttributeDecl(attlistIndex, this.fTempAttributeDecl);
                if (this.fStringPool.equalNames(this.fTempAttributeDecl.name.rawname, attribute.rawname)) {
                    return -1;
                }
                if (this.fValidationEnabled) {
                    if (attDefType == 3 && this.fTempAttributeDecl.type == 3) {
                        dupID = this.fTempAttributeDecl.name.rawname;
                    }
                    if (attDefType == 6 && this.fTempAttributeDecl.type == 6) {
                        dupNotation = this.fTempAttributeDecl.name.rawname;
                    }
                }
                attlistIndex = this.fDTDGrammar.getNextAttributeDeclIndex(attlistIndex);
            }
            if (this.fValidationEnabled) {
                if (dupID != -1) {
                    Object[] args = new Object[]{this.fStringPool.toString(element.rawname), this.fStringPool.toString(dupID), this.fStringPool.toString(attribute.rawname)};
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 86, 81, args, 1);
                    return -1;
                }
                if (dupNotation != -1) {
                    Object[] args = new Object[]{this.fStringPool.toString(element.rawname), this.fStringPool.toString(dupNotation), this.fStringPool.toString(attribute.rawname)};
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 121, 143, args, 1);
                    return -1;
                }
            }
        }
        return this.fDTDGrammar.addAttDef(element, attribute, attDefType, attDefList, attDefEnumeration, attDefDefaultType, attDefDefaultValue, isExternal);
    }

    private int scanEnumeration(int elementType, int attrName, boolean isNotationType) throws Exception {
        int enumIndex = this.fDTDGrammar.startEnumeration();
        do {
            int nameIndex;
            this.checkForPEReference(false);
            int n = nameIndex = isNotationType ? this.checkForNameWithPEReference(this.fEntityReader, ')') : this.checkForNmtokenWithPEReference(this.fEntityReader, ')');
            if (nameIndex == -1) {
                if (isNotationType) {
                    this.reportFatalXMLError(115, 90, elementType, attrName);
                } else {
                    this.reportFatalXMLError(116, 92, elementType, attrName);
                }
                this.fDTDGrammar.endEnumeration(enumIndex);
                return -1;
            }
            this.fDTDGrammar.addNameToEnumeration(enumIndex, elementType, attrName, nameIndex, isNotationType);
            if (isNotationType && !((DefaultEntityHandler)this.fEntityHandler).isNotationDeclared(nameIndex)) {
                Object[] args = new Object[]{this.fStringPool.toString(elementType), this.fStringPool.toString(attrName), this.fStringPool.toString(nameIndex)};
                ((DefaultEntityHandler)this.fEntityHandler).addRequiredNotation(nameIndex, this.fErrorReporter.getLocator(), 117, 89, args);
            }
            this.checkForPEReference(false);
        } while (this.fEntityReader.lookingAtChar('|', true));
        this.fDTDGrammar.endEnumeration(enumIndex);
        if (!this.fEntityReader.lookingAtChar(')', true)) {
            if (isNotationType) {
                this.reportFatalXMLError(118, 91, elementType, attrName);
            } else {
                this.reportFatalXMLError(119, 93, elementType, attrName);
            }
            return -1;
        }
        this.decreaseParenDepth();
        return enumIndex;
    }

    public int scanDefaultAttValue(QName element, QName attribute) throws Exception {
        boolean single = this.fEntityReader.lookingAtChar('\'', true);
        if (!single && !this.fEntityReader.lookingAtChar('\"', true)) {
            this.reportFatalXMLError(13, 12, element.rawname, attribute.rawname);
            return -1;
        }
        int previousState = this.setScannerState(56);
        char qchar = single ? (char)'\'' : '\"';
        this.fDefaultAttValueReader = this.fReaderId;
        this.fDefaultAttValueElementType = element.rawname;
        this.fDefaultAttValueAttrName = attribute.rawname;
        boolean setMark = true;
        int dataOffset = this.fLiteralData.length();
        while (true) {
            this.fDefaultAttValueOffset = this.fEntityReader.currentOffset();
            if (setMark) {
                this.fDefaultAttValueMark = this.fDefaultAttValueOffset;
                setMark = false;
            }
            if (this.fEntityReader.lookingAtChar(qchar, true)) {
                if (this.fReaderId != this.fDefaultAttValueReader) continue;
                break;
            }
            if (this.fEntityReader.lookingAtChar(' ', true)) continue;
            boolean skippedCR = this.fEntityReader.lookingAtChar('\r', true);
            if (skippedCR || this.fEntityReader.lookingAtSpace(true)) {
                if (this.fDefaultAttValueOffset - this.fDefaultAttValueMark > 0) {
                    this.fEntityReader.append(this.fLiteralData, this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
                }
                setMark = true;
                this.fLiteralData.append(' ');
                if (!skippedCR) continue;
                this.fEntityReader.lookingAtChar('\n', true);
                continue;
            }
            if (this.fEntityReader.lookingAtChar('&', true)) {
                if (this.fDefaultAttValueOffset - this.fDefaultAttValueMark > 0) {
                    this.fEntityReader.append(this.fLiteralData, this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
                }
                setMark = true;
                if (this.fEntityReader.lookingAtChar('#', true)) {
                    int ch = this.scanCharRef();
                    if (ch == -1) continue;
                    if (ch < 65536) {
                        this.fLiteralData.append((char)ch);
                        continue;
                    }
                    this.fLiteralData.append((char)((ch - 65536 >> 10) + 55296));
                    this.fLiteralData.append((char)((ch - 65536 & 0x3FF) + 56320));
                    continue;
                }
                int nameOffset = this.fEntityReader.currentOffset();
                this.fEntityReader.skipPastName(';');
                int nameLength = this.fEntityReader.currentOffset() - nameOffset;
                if (nameLength == 0) {
                    this.reportFatalXMLError(14, 13);
                    continue;
                }
                if (!this.fEntityReader.lookingAtChar(';', true)) {
                    this.reportFatalXMLError(15, 14, this.fEntityReader.addString(nameOffset, nameLength));
                    continue;
                }
                int entityNameIndex = this.fEntityReader.addSymbol(nameOffset, nameLength);
                this.fEntityHandler.startReadingFromEntity(entityNameIndex, this.markupDepth(), 1);
                continue;
            }
            if (this.fEntityReader.lookingAtChar('<', true)) {
                if (this.fDefaultAttValueOffset - this.fDefaultAttValueMark > 0) {
                    this.fEntityReader.append(this.fLiteralData, this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
                }
                setMark = true;
                this.reportFatalXMLError(2, 11, element.rawname, attribute.rawname);
                continue;
            }
            if (this.fEntityReader.lookingAtValidChar(true)) continue;
            if (this.fDefaultAttValueOffset - this.fDefaultAttValueMark > 0) {
                this.fEntityReader.append(this.fLiteralData, this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
            }
            setMark = true;
            int invChar = this.fEntityReader.scanInvalidChar();
            if (this.fScannerState == 0) {
                return -1;
            }
            if (invChar < 0) continue;
            this.reportFatalXMLError(12, 10, this.fStringPool.toString(element.rawname), this.fStringPool.toString(attribute.rawname), Integer.toHexString(invChar));
        }
        this.restoreScannerState(previousState);
        int dataLength = this.fLiteralData.length() - dataOffset;
        if (dataLength == 0) {
            return this.fEntityReader.addString(this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
        }
        if (this.fDefaultAttValueOffset - this.fDefaultAttValueMark > 0) {
            this.fEntityReader.append(this.fLiteralData, this.fDefaultAttValueMark, this.fDefaultAttValueOffset - this.fDefaultAttValueMark);
            dataLength = this.fLiteralData.length() - dataOffset;
        }
        return this.fLiteralData.addString(dataOffset, dataLength);
    }

    private void scanNotationDecl() throws Exception {
        if (!this.checkForPEReference(true)) {
            this.abortMarkup(142, 102);
            return;
        }
        int notationName = this.checkForNameWithPEReference(this.fEntityReader, ' ');
        if (notationName == -1) {
            this.abortMarkup(120, 101);
            return;
        }
        if (!this.checkForPEReference(true)) {
            this.abortMarkup(137, 102, notationName);
            return;
        }
        if (!this.scanExternalID(true)) {
            this.skipPastEndOfCurrentMarkup();
            return;
        }
        this.checkForPEReference(false);
        if (!this.fEntityReader.lookingAtChar('>', true)) {
            this.abortMarkup(122, 103, notationName);
            return;
        }
        this.decreaseMarkupDepth();
        int notationIndex = ((DefaultEntityHandler)this.fEntityHandler).addNotationDecl(notationName, this.fPubidLiteral, this.fSystemLiteral, this.getReadingExternalEntity());
        this.fDTDGrammar.addNotationDecl(notationName, this.fPubidLiteral, this.fSystemLiteral);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.notationDecl(notationName, this.fPubidLiteral, this.fSystemLiteral);
        }
    }

    private void scanEntityDecl() throws Exception {
        int entityIndex;
        int value;
        boolean single;
        int entityName;
        boolean isPEDecl = false;
        boolean sawPERef = false;
        if (this.fEntityReader.lookingAtSpace(true)) {
            this.fEntityReader.skipPastSpaces();
            if (!this.fEntityReader.lookingAtChar('%', true)) {
                isPEDecl = false;
            } else if (this.fEntityReader.lookingAtSpace(true)) {
                this.checkForPEReference(false);
                isPEDecl = true;
            } else if (!this.getReadingExternalEntity()) {
                this.reportFatalXMLError(107, 98);
                isPEDecl = true;
            } else if (this.fEntityReader.lookingAtChar('%', false)) {
                this.checkForPEReference(false);
                isPEDecl = true;
            } else {
                sawPERef = true;
            }
        } else if (!this.getReadingExternalEntity() || !this.fEntityReader.lookingAtChar('%', true)) {
            this.reportFatalXMLError(108, 94);
            isPEDecl = false;
        } else if (this.fEntityReader.lookingAtSpace(false)) {
            this.reportFatalXMLError(109, 98);
            isPEDecl = false;
        } else {
            sawPERef = true;
        }
        if (sawPERef) {
            while (true) {
                int nameOffset = this.fEntityReader.currentOffset();
                this.fEntityReader.skipPastName(';');
                int nameLength = this.fEntityReader.currentOffset() - nameOffset;
                if (nameLength == 0) {
                    this.reportFatalXMLError(48, 50);
                } else if (!this.fEntityReader.lookingAtChar(';', true)) {
                    this.reportFatalXMLError(49, 51, this.fEntityReader.addString(nameOffset, nameLength));
                } else {
                    int peNameIndex = this.fEntityReader.addSymbol(nameOffset, nameLength);
                    int readerDepth = this.fScannerState == 57 ? this.parenDepth() : this.markupDepth();
                    this.fEntityHandler.startReadingFromEntity(peNameIndex, readerDepth, 5);
                }
                this.fEntityReader.skipPastSpaces();
                if (!this.fEntityReader.lookingAtChar('%', true)) break;
                if (isPEDecl) continue;
                if (this.fEntityReader.lookingAtSpace(true)) {
                    this.checkForPEReference(false);
                    isPEDecl = true;
                    break;
                }
                isPEDecl = this.fEntityReader.lookingAtChar('%', true);
            }
        }
        if ((entityName = this.checkForNameWithPEReference(this.fEntityReader, ' ')) == -1) {
            this.abortMarkup(110, 95);
            return;
        }
        if (!this.fDTDGrammar.startEntityDecl(isPEDecl, entityName)) {
            this.skipPastEndOfCurrentMarkup();
            return;
        }
        if (!this.checkForPEReference(true)) {
            this.abortMarkup(111, 96, entityName);
            this.fDTDGrammar.endEntityDecl();
            return;
        }
        if (isPEDecl) {
            single = this.fEntityReader.lookingAtChar('\'', true);
            if (single || this.fEntityReader.lookingAtChar('\"', true)) {
                value = this.scanEntityValue(single);
                if (value == -1) {
                    this.skipPastEndOfCurrentMarkup();
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                this.checkForPEReference(false);
                if (!this.fEntityReader.lookingAtChar('>', true)) {
                    this.abortMarkup(112, 99, entityName);
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                this.decreaseMarkupDepth();
                this.fDTDGrammar.endEntityDecl();
                this.fDTDGrammar.addInternalPEDecl(entityName, value);
                if (this.fDTDHandler != null) {
                    this.fDTDHandler.internalPEDecl(entityName, value);
                }
                entityIndex = ((DefaultEntityHandler)this.fEntityHandler).addInternalPEDecl(entityName, value, this.getReadingExternalEntity());
            } else {
                if (!this.scanExternalID(false)) {
                    this.skipPastEndOfCurrentMarkup();
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                this.checkForPEReference(false);
                if (!this.fEntityReader.lookingAtChar('>', true)) {
                    this.abortMarkup(112, 99, entityName);
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                this.decreaseMarkupDepth();
                this.fDTDGrammar.endEntityDecl();
                this.fDTDGrammar.addExternalPEDecl(entityName, this.fPubidLiteral, this.fSystemLiteral);
                if (this.fDTDHandler != null) {
                    this.fDTDHandler.externalPEDecl(entityName, this.fPubidLiteral, this.fSystemLiteral);
                }
                value = ((DefaultEntityHandler)this.fEntityHandler).addExternalPEDecl(entityName, this.fPubidLiteral, this.fSystemLiteral, this.getReadingExternalEntity());
            }
        } else {
            single = this.fEntityReader.lookingAtChar('\'', true);
            if (single || this.fEntityReader.lookingAtChar('\"', true)) {
                value = this.scanEntityValue(single);
                if (value == -1) {
                    this.skipPastEndOfCurrentMarkup();
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                this.checkForPEReference(false);
                if (!this.fEntityReader.lookingAtChar('>', true)) {
                    this.abortMarkup(112, 97, entityName);
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                this.decreaseMarkupDepth();
                this.fDTDGrammar.endEntityDecl();
                this.fDTDGrammar.addInternalEntityDecl(entityName, value);
                if (this.fDTDHandler != null) {
                    this.fDTDHandler.internalEntityDecl(entityName, value);
                }
                entityIndex = ((DefaultEntityHandler)this.fEntityHandler).addInternalEntityDecl(entityName, value, this.getReadingExternalEntity());
            } else {
                if (!this.scanExternalID(false)) {
                    this.skipPastEndOfCurrentMarkup();
                    this.fDTDGrammar.endEntityDecl();
                    return;
                }
                boolean unparsed = false;
                if (this.fEntityReader.lookingAtSpace(true)) {
                    this.fEntityReader.skipPastSpaces();
                    unparsed = this.fEntityReader.skippedString(ndata_string);
                }
                if (!unparsed) {
                    this.checkForPEReference(false);
                    if (!this.fEntityReader.lookingAtChar('>', true)) {
                        this.abortMarkup(112, 99, entityName);
                        this.fDTDGrammar.endEntityDecl();
                        return;
                    }
                    this.decreaseMarkupDepth();
                    this.fDTDGrammar.endEntityDecl();
                    this.fDTDGrammar.addExternalEntityDecl(entityName, this.fPubidLiteral, this.fSystemLiteral);
                    if (this.fDTDHandler != null) {
                        this.fDTDHandler.externalEntityDecl(entityName, this.fPubidLiteral, this.fSystemLiteral);
                    }
                    entityIndex = ((DefaultEntityHandler)this.fEntityHandler).addExternalEntityDecl(entityName, this.fPubidLiteral, this.fSystemLiteral, this.getReadingExternalEntity());
                } else {
                    if (!this.fEntityReader.lookingAtSpace(true)) {
                        this.abortMarkup(157, 132, entityName);
                        this.fDTDGrammar.endEntityDecl();
                        return;
                    }
                    this.fEntityReader.skipPastSpaces();
                    int ndataOffset = this.fEntityReader.currentOffset();
                    this.fEntityReader.skipPastName('>');
                    int ndataLength = this.fEntityReader.currentOffset() - ndataOffset;
                    if (ndataLength == 0) {
                        this.abortMarkup(113, 100, entityName);
                        this.fDTDGrammar.endEntityDecl();
                        return;
                    }
                    int notationName = this.fEntityReader.addSymbol(ndataOffset, ndataLength);
                    this.checkForPEReference(false);
                    if (!this.fEntityReader.lookingAtChar('>', true)) {
                        this.abortMarkup(112, 99, entityName);
                        this.fDTDGrammar.endEntityDecl();
                        return;
                    }
                    this.decreaseMarkupDepth();
                    this.fDTDGrammar.endEntityDecl();
                    this.fDTDGrammar.addUnparsedEntityDecl(entityName, this.fPubidLiteral, this.fSystemLiteral, notationName);
                    if (this.fDTDHandler != null) {
                        this.fDTDHandler.unparsedEntityDecl(entityName, this.fPubidLiteral, this.fSystemLiteral, notationName);
                    }
                    int n = ((DefaultEntityHandler)this.fEntityHandler).addUnparsedEntityDecl(entityName, this.fPubidLiteral, this.fSystemLiteral, notationName, this.getReadingExternalEntity());
                }
            }
        }
    }

    private int scanEntityValue(boolean single) throws Exception {
        char qchar = single ? (char)'\'' : '\"';
        this.fEntityValueMark = this.fEntityReader.currentOffset();
        int entityValue = this.fEntityReader.scanEntityValue(qchar, true);
        if (entityValue < 0) {
            entityValue = this.scanComplexEntityValue(qchar, entityValue);
        }
        return entityValue;
    }

    private int scanComplexEntityValue(char qchar, int result) throws Exception {
        int previousState = this.setScannerState(58);
        this.fEntityValueReader = this.fReaderId;
        int dataOffset = this.fLiteralData.length();
        while (true) {
            switch (result) {
                case -1: {
                    int offset = this.fEntityReader.currentOffset();
                    this.fEntityReader.lookingAtChar((char)qchar, true);
                    this.restoreScannerState(previousState);
                    int dataLength = this.fLiteralData.length() - dataOffset;
                    if (dataLength == 0) {
                        return this.fEntityReader.addString(this.fEntityValueMark, offset - this.fEntityValueMark);
                    }
                    if (offset - this.fEntityValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fEntityValueMark, offset - this.fEntityValueMark);
                        dataLength = this.fLiteralData.length() - dataOffset;
                    }
                    return this.fLiteralData.addString(dataOffset, dataLength);
                }
                case -2: {
                    int offset = this.fEntityReader.currentOffset();
                    if (offset - this.fEntityValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fEntityValueMark, offset - this.fEntityValueMark);
                    }
                    this.fEntityReader.lookingAtChar('&', true);
                    if (this.fEntityReader.lookingAtChar('#', true)) {
                        int ch = this.scanCharRef();
                        if (ch != -1) {
                            if (ch < 65536) {
                                this.fLiteralData.append((char)ch);
                            } else {
                                this.fLiteralData.append((char)((ch - 65536 >> 10) + 55296));
                                this.fLiteralData.append((char)((ch - 65536 & 0x3FF) + 56320));
                            }
                        }
                        this.fEntityValueMark = this.fEntityReader.currentOffset();
                        break;
                    }
                    int nameOffset = this.fEntityReader.currentOffset();
                    this.fEntityReader.skipPastName(';');
                    int nameLength = this.fEntityReader.currentOffset() - nameOffset;
                    if (nameLength == 0) {
                        this.reportFatalXMLError(14, 13);
                        this.fEntityValueMark = this.fEntityReader.currentOffset();
                        break;
                    }
                    if (!this.fEntityReader.lookingAtChar(';', true)) {
                        this.reportFatalXMLError(15, 14, this.fEntityReader.addString(nameOffset, nameLength));
                        this.fEntityValueMark = this.fEntityReader.currentOffset();
                        break;
                    }
                    this.fEntityValueMark = offset;
                    break;
                }
                case -3: {
                    int offset = this.fEntityReader.currentOffset();
                    if (offset - this.fEntityValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fEntityValueMark, offset - this.fEntityValueMark);
                    }
                    this.fEntityReader.lookingAtChar('%', true);
                    int nameOffset = this.fEntityReader.currentOffset();
                    this.fEntityReader.skipPastName(';');
                    int nameLength = this.fEntityReader.currentOffset() - nameOffset;
                    if (nameLength == 0) {
                        this.reportFatalXMLError(48, 50);
                    } else if (!this.fEntityReader.lookingAtChar(';', true)) {
                        this.reportFatalXMLError(49, 51, this.fEntityReader.addString(nameOffset, nameLength));
                    } else if (!this.getReadingExternalEntity()) {
                        this.reportFatalXMLError(51, 53, this.fEntityReader.addString(nameOffset, nameLength));
                    } else {
                        int peNameIndex = this.fEntityReader.addSymbol(nameOffset, nameLength);
                        this.fEntityHandler.startReadingFromEntity(peNameIndex, this.markupDepth(), 4);
                    }
                    this.fEntityValueMark = this.fEntityReader.currentOffset();
                    break;
                }
                case -4: {
                    int offset = this.fEntityReader.currentOffset();
                    if (offset - this.fEntityValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fEntityValueMark, offset - this.fEntityValueMark);
                    }
                    int invChar = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState == 0) {
                        return -1;
                    }
                    if (invChar >= 0) {
                        this.reportFatalXMLError(46, 48, Integer.toHexString(invChar));
                    }
                    this.fEntityValueMark = this.fEntityReader.currentOffset();
                    break;
                }
                case -5: {
                    break;
                }
            }
            result = this.fEntityReader.scanEntityValue(this.fReaderId == this.fEntityValueReader ? qchar : -1, false);
        }
    }

    private boolean checkForPEReference(boolean spaceRequired) throws Exception {
        boolean sawSpace = true;
        if (spaceRequired) {
            sawSpace = this.fEntityReader.lookingAtSpace(true);
        }
        this.fEntityReader.skipPastSpaces();
        if (!this.getReadingExternalEntity()) {
            return sawSpace;
        }
        if (!this.fEntityReader.lookingAtChar('%', true)) {
            return sawSpace;
        }
        do {
            int nameOffset = this.fEntityReader.currentOffset();
            this.fEntityReader.skipPastName(';');
            int nameLength = this.fEntityReader.currentOffset() - nameOffset;
            if (nameLength == 0) {
                this.reportFatalXMLError(48, 50);
            } else if (!this.fEntityReader.lookingAtChar(';', true)) {
                this.reportFatalXMLError(49, 51, this.fEntityReader.addString(nameOffset, nameLength));
            } else {
                int peNameIndex = this.fEntityReader.addSymbol(nameOffset, nameLength);
                int readerDepth = this.fScannerState == 57 ? this.parenDepth() : this.markupDepth();
                this.fEntityHandler.startReadingFromEntity(peNameIndex, readerDepth, 5);
            }
            this.fEntityReader.skipPastSpaces();
        } while (this.fEntityReader.lookingAtChar('%', true));
        return true;
    }

    private void initializeContentModelStack(int depth) {
        if (this.fOpStack == null) {
            this.fOpStack = new int[8];
            this.fNodeIndexStack = new int[8];
            this.fPrevNodeIndexStack = new int[8];
        } else if (depth == this.fOpStack.length) {
            int[] newStack = new int[depth * 2];
            System.arraycopy(this.fOpStack, 0, newStack, 0, depth);
            this.fOpStack = newStack;
            newStack = new int[depth * 2];
            System.arraycopy(this.fNodeIndexStack, 0, newStack, 0, depth);
            this.fNodeIndexStack = newStack;
            newStack = new int[depth * 2];
            System.arraycopy(this.fPrevNodeIndexStack, 0, newStack, 0, depth);
            this.fPrevNodeIndexStack = newStack;
        }
        this.fOpStack[depth] = -1;
        this.fNodeIndexStack[depth] = -1;
        this.fPrevNodeIndexStack[depth] = -1;
    }

    private boolean validVersionNum(String version) {
        return XMLCharacterProperties.validVersionNum(version);
    }

    private boolean validEncName(String encoding) {
        return XMLCharacterProperties.validEncName(encoding);
    }

    private int validPublicId(String publicId) {
        return XMLCharacterProperties.validPublicId(publicId);
    }

    private void scanElementType(XMLEntityHandler.EntityReader entityReader, char fastchar, QName element) throws Exception {
        if (!this.fNamespacesEnabled) {
            element.clear();
            element.rawname = element.localpart = entityReader.scanName(fastchar);
            return;
        }
        entityReader.scanQName(fastchar, element);
        if (entityReader.lookingAtChar(':', false)) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
            entityReader.skipPastNmtoken(' ');
        }
    }

    public void checkForElementTypeWithPEReference(XMLEntityHandler.EntityReader entityReader, char fastchar, QName element) throws Exception {
        if (!this.fNamespacesEnabled) {
            element.clear();
            element.rawname = element.localpart = entityReader.scanName(fastchar);
            return;
        }
        entityReader.scanQName(fastchar, element);
        if (entityReader.lookingAtChar(':', false)) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
            entityReader.skipPastNmtoken(' ');
        }
    }

    public void checkForAttributeNameWithPEReference(XMLEntityHandler.EntityReader entityReader, char fastchar, QName attribute) throws Exception {
        if (!this.fNamespacesEnabled) {
            attribute.clear();
            attribute.rawname = attribute.localpart = entityReader.scanName(fastchar);
            return;
        }
        entityReader.scanQName(fastchar, attribute);
        if (entityReader.lookingAtChar(':', false)) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
            entityReader.skipPastNmtoken(' ');
        }
    }

    public int checkForNameWithPEReference(XMLEntityHandler.EntityReader entityReader, char fastcheck) throws Exception {
        int valueIndex = entityReader.scanName(fastcheck);
        return valueIndex;
    }

    public int checkForNmtokenWithPEReference(XMLEntityHandler.EntityReader entityReader, char fastcheck) throws Exception {
        int nameOffset = entityReader.currentOffset();
        entityReader.skipPastNmtoken(fastcheck);
        int nameLength = entityReader.currentOffset() - nameOffset;
        if (nameLength == 0) {
            return -1;
        }
        int valueIndex = entityReader.addSymbol(nameOffset, nameLength);
        return valueIndex;
    }

    public int scanDefaultAttValue(QName element, QName attribute, int attType, int enumeration) throws Exception {
        int defaultAttValue;
        if (this.fValidationEnabled && attType == 3) {
            this.reportRecoverableXMLError(69, 69, this.fStringPool.toString(attribute.rawname));
        }
        if ((defaultAttValue = this.scanDefaultAttValue(element, attribute)) == -1) {
            return -1;
        }
        return defaultAttValue;
    }

    public int normalizeDefaultAttValue(QName attribute, int defaultAttValue, int attType, int enumeration, boolean list) throws Exception {
        String attValue = this.fStringPool.toString(defaultAttValue);
        if (list) {
            StringTokenizer tokenizer = new StringTokenizer(attValue);
            StringBuffer sb = new StringBuffer(attValue.length());
            boolean ok = true;
            if (tokenizer.hasMoreTokens()) {
                while (true) {
                    String nmtoken = tokenizer.nextToken();
                    if (attType == 5) {
                        if (this.fValidationEnabled && !XMLCharacterProperties.validNmtoken(nmtoken)) {
                            ok = false;
                        }
                    } else if (attType == 4 || attType == 1) {
                        if (this.fValidationEnabled && !XMLCharacterProperties.validName(nmtoken)) {
                            ok = false;
                        }
                        if (this.fValidationEnabled && attType == 1 && !((DefaultEntityHandler)this.fEntityHandler).isUnparsedEntity(defaultAttValue)) {
                            this.reportRecoverableXMLError(79, 77, this.fStringPool.toString(attribute.rawname), nmtoken);
                        }
                    }
                    sb.append(nmtoken);
                    if (!tokenizer.hasMoreTokens()) break;
                    sb.append(' ');
                }
            }
            String newAttValue = sb.toString();
            if (this.fValidationEnabled && (!ok || newAttValue.length() == 0)) {
                this.reportRecoverableXMLError(168, 145, this.fStringPool.toString(attribute.rawname), newAttValue);
            }
            if (!newAttValue.equals(attValue)) {
                defaultAttValue = this.fStringPool.addString(newAttValue);
            }
            return defaultAttValue;
        }
        String newAttValue = attValue.trim();
        if (this.fValidationEnabled) {
            defaultAttValue = newAttValue != attValue ? this.fStringPool.addSymbol(newAttValue) : this.fStringPool.addSymbol(defaultAttValue);
            if (attType == 1 || attType == 3 || attType == 4 || attType == 6) {
                if (attType == 1 && !((DefaultEntityHandler)this.fEntityHandler).isUnparsedEntity(defaultAttValue)) {
                    this.reportRecoverableXMLError(79, 77, this.fStringPool.toString(attribute.rawname), newAttValue);
                }
                if (!XMLCharacterProperties.validName(newAttValue)) {
                    this.reportRecoverableXMLError(168, 145, this.fStringPool.toString(attribute.rawname), newAttValue);
                }
            } else if (!(attType != 5 && attType != 2 || XMLCharacterProperties.validNmtoken(newAttValue))) {
                this.reportRecoverableXMLError(168, 145, this.fStringPool.toString(attribute.rawname), newAttValue);
            }
            if (!(attType != 6 && attType != 2 || this.fStringPool.stringInList(enumeration, defaultAttValue))) {
                this.reportRecoverableXMLError(168, 145, this.fStringPool.toString(attribute.rawname), newAttValue);
            }
        } else if (newAttValue != attValue) {
            defaultAttValue = this.fStringPool.addSymbol(newAttValue);
        }
        return defaultAttValue;
    }

    public static interface EventHandler {
        public void callStartDTD() throws Exception;

        public void callEndDTD() throws Exception;

        public void callTextDecl(int var1, int var2) throws Exception;

        public void doctypeDecl(QName var1, int var2, int var3) throws Exception;

        public void startReadingFromExternalSubset(int var1, int var2) throws Exception;

        public void stopReadingFromExternalSubset() throws Exception;

        public int addElementDecl(QName var1) throws Exception;

        public int addElementDecl(QName var1, int var2, int var3, boolean var4) throws Exception;

        public int addAttDef(QName var1, QName var2, int var3, boolean var4, int var5, int var6, int var7, boolean var8) throws Exception;

        public int addUniqueLeafNode(int var1) throws Exception;

        public int addContentSpecNode(int var1, int var2) throws Exception;

        public int addContentSpecNode(int var1, int var2, int var3) throws Exception;

        public String getContentSpecNodeAsString(int var1) throws Exception;

        public boolean startEntityDecl(boolean var1, int var2) throws Exception;

        public void endEntityDecl() throws Exception;

        public int addInternalPEDecl(int var1, int var2) throws Exception;

        public int addExternalPEDecl(int var1, int var2, int var3) throws Exception;

        public int addInternalEntityDecl(int var1, int var2) throws Exception;

        public int addExternalEntityDecl(int var1, int var2, int var3) throws Exception;

        public int addUnparsedEntityDecl(int var1, int var2, int var3, int var4) throws Exception;

        public int startEnumeration() throws Exception;

        public void addNameToEnumeration(int var1, int var2, int var3, int var4, boolean var5) throws Exception;

        public void endEnumeration(int var1) throws Exception;

        public int addNotationDecl(int var1, int var2, int var3) throws Exception;

        public void callComment(int var1) throws Exception;

        public void callProcessingInstruction(int var1, int var2) throws Exception;

        public void internalSubset(int var1) throws Exception;
    }
}

