/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.framework;

import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLDTDScanner;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.ChunkyCharArray;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.validators.common.GrammarResolver;

public final class XMLDocumentScanner {
    static final char[] cdata_string = new char[]{'[', 'C', 'D', 'A', 'T', 'A', '['};
    static final char[] xml_string = new char[]{'x', 'm', 'l'};
    private static final char[] version_string = new char[]{'v', 'e', 'r', 's', 'i', 'o', 'n'};
    static final char[] doctype_string = new char[]{'D', 'O', 'C', 'T', 'Y', 'P', 'E'};
    private static final char[] standalone_string = new char[]{'s', 't', 'a', 'n', 'd', 'a', 'l', 'o', 'n', 'e'};
    private static final char[] encoding_string = new char[]{'e', 'n', 'c', 'o', 'd', 'i', 'n', 'g'};
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILURE = -1;
    public static final int RESULT_DUPLICATE_ATTR = -2;
    static final int SCANNER_STATE_XML_DECL = 0;
    static final int SCANNER_STATE_START_OF_MARKUP = 1;
    static final int SCANNER_STATE_COMMENT = 2;
    static final int SCANNER_STATE_PI = 3;
    static final int SCANNER_STATE_DOCTYPE = 4;
    static final int SCANNER_STATE_PROLOG = 5;
    static final int SCANNER_STATE_ROOT_ELEMENT = 6;
    static final int SCANNER_STATE_CONTENT = 7;
    static final int SCANNER_STATE_REFERENCE = 8;
    static final int SCANNER_STATE_ATTRIBUTE_LIST = 9;
    static final int SCANNER_STATE_ATTRIBUTE_NAME = 10;
    static final int SCANNER_STATE_ATTRIBUTE_VALUE = 11;
    static final int SCANNER_STATE_TRAILING_MISC = 12;
    static final int SCANNER_STATE_END_OF_INPUT = 13;
    static final int SCANNER_STATE_TERMINATED = 14;
    private StringPool.CharArrayRange fCurrentElementCharArrayRange = null;
    int fAttrListHandle = -1;
    XMLAttrList fAttrList = null;
    GrammarResolver fGrammarResolver = null;
    XMLDTDScanner fDTDScanner = null;
    boolean fNamespacesEnabled = false;
    boolean fValidationEnabled = false;
    boolean fLoadExternalDTD = true;
    QName fElementQName = new QName();
    QName fAttributeQName = new QName();
    QName fCurrentElementQName = new QName();
    ScannerDispatcher fDispatcher = null;
    EventHandler fEventHandler = null;
    XMLDocumentHandler.DTDHandler fDTDHandler = null;
    StringPool fStringPool = null;
    XMLErrorReporter fErrorReporter = null;
    XMLEntityHandler fEntityHandler = null;
    XMLEntityHandler.EntityReader fEntityReader = null;
    XMLEntityHandler.CharBuffer fLiteralData = null;
    boolean fSeenRootElement = false;
    boolean fSeenDoctypeDecl = false;
    boolean fStandalone = false;
    boolean fParseTextDecl = false;
    boolean fScanningDTD = false;
    int fScannerState = 0;
    int fReaderId = -1;
    int fAttValueReader = -1;
    int fAttValueElementType = -1;
    int fAttValueAttrName = -1;
    int fAttValueOffset = -1;
    int fAttValueMark = -1;
    int fScannerMarkupDepth = 0;
    int fCurrentElementType = -1;

    public XMLDocumentScanner(StringPool stringPool, XMLErrorReporter errorReporter, XMLEntityHandler entityHandler, XMLEntityHandler.CharBuffer literalData) {
        this.fStringPool = stringPool;
        this.fErrorReporter = errorReporter;
        this.fEntityHandler = entityHandler;
        this.fLiteralData = literalData;
        this.fDispatcher = new XMLDeclDispatcher();
        this.fAttrList = new XMLAttrList(this.fStringPool);
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    public void setDTDHandler(XMLDocumentHandler.DTDHandler dtdHandler) {
        this.fDTDHandler = dtdHandler;
    }

    public void setGrammarResolver(GrammarResolver resolver) {
        this.fGrammarResolver = resolver;
    }

    public void reset(StringPool stringPool, XMLEntityHandler.CharBuffer literalData) {
        this.fStringPool = stringPool;
        this.fLiteralData = literalData;
        this.fParseTextDecl = false;
        this.fSeenRootElement = false;
        this.fSeenDoctypeDecl = false;
        this.fStandalone = false;
        this.fScanningDTD = false;
        this.fDispatcher = new XMLDeclDispatcher();
        this.fScannerState = 0;
        this.fScannerMarkupDepth = 0;
        this.fAttrList = new XMLAttrList(this.fStringPool);
    }

    public boolean parseSome(boolean doItAll) throws Exception {
        do {
            if (this.fDispatcher.dispatch(doItAll)) continue;
            return false;
        } while (doItAll);
        return true;
    }

    public void readerChange(XMLEntityHandler.EntityReader nextReader, int nextReaderId) throws Exception {
        this.fEntityReader = nextReader;
        this.fReaderId = nextReaderId;
        if (this.fScannerState == 11) {
            this.fAttValueMark = this.fAttValueOffset = this.fEntityReader.currentOffset();
        }
        if (this.fDTDScanner != null && this.fScanningDTD) {
            this.fDTDScanner.readerChange(nextReader, nextReaderId);
        }
    }

    public void endOfInput(int entityName, boolean moreToFollow) throws Exception {
        if (this.fDTDScanner != null && this.fScanningDTD) {
            this.fDTDScanner.endOfInput(entityName, moreToFollow);
        }
        this.fDispatcher.endOfInput(entityName, moreToFollow);
    }

    public boolean atEndOfInput() {
        return this.fScannerState == 13;
    }

    public int scanAttValue(QName element, QName attribute, boolean asSymbol) throws Exception {
        boolean single = this.fEntityReader.lookingAtChar('\'', true);
        if (!single && !this.fEntityReader.lookingAtChar('\"', true)) {
            this.reportFatalXMLError(13, 12, element.rawname, attribute.rawname);
            return -1;
        }
        char qchar = single ? (char)'\'' : '\"';
        this.fAttValueMark = this.fEntityReader.currentOffset();
        int attValue = this.fEntityReader.scanAttValue(qchar, asSymbol);
        if (attValue >= 0) {
            return attValue;
        }
        int previousState = this.setScannerState(11);
        this.fAttValueReader = this.fReaderId;
        this.fAttValueElementType = element.rawname;
        this.fAttValueAttrName = attribute.rawname;
        this.fAttValueOffset = this.fEntityReader.currentOffset();
        int dataOffset = this.fLiteralData.length();
        if (this.fAttValueOffset - this.fAttValueMark > 0) {
            this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
        }
        this.fAttValueMark = this.fAttValueOffset;
        boolean setMark = false;
        while (true) {
            if (this.fEntityReader.lookingAtChar(qchar, true)) {
                if (this.fReaderId == this.fAttValueReader) {
                    break;
                }
            } else if (!this.fEntityReader.lookingAtChar(' ', true)) {
                boolean skippedCR = this.fEntityReader.lookingAtChar('\r', true);
                if (skippedCR || this.fEntityReader.lookingAtSpace(true)) {
                    if (this.fAttValueOffset - this.fAttValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
                    }
                    setMark = true;
                    this.fLiteralData.append(' ');
                } else if (this.fEntityReader.lookingAtChar('&', true)) {
                    if (this.fAttValueOffset - this.fAttValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
                    }
                    setMark = true;
                    if (this.fEntityReader.lookingAtChar('#', true)) {
                        int ch = this.scanCharRef();
                        if (ch != -1) {
                            if (ch < 65536) {
                                this.fLiteralData.append((char)ch);
                            } else {
                                this.fLiteralData.append((char)((ch - 65536 >> 10) + 55296));
                                this.fLiteralData.append((char)((ch - 65536 & 0x3FF) + 56320));
                            }
                        }
                    } else {
                        int nameOffset = this.fEntityReader.currentOffset();
                        this.fEntityReader.skipPastName(';');
                        int nameLength = this.fEntityReader.currentOffset() - nameOffset;
                        if (nameLength == 0) {
                            this.reportFatalXMLError(14, 13);
                        } else if (!this.fEntityReader.lookingAtChar(';', true)) {
                            this.reportFatalXMLError(15, 14, this.fEntityReader.addString(nameOffset, nameLength));
                        } else {
                            int entityName = this.fEntityReader.addSymbol(nameOffset, nameLength);
                            this.fEntityHandler.startReadingFromEntity(entityName, this.fScannerMarkupDepth, 0);
                        }
                    }
                } else if (this.fEntityReader.lookingAtChar('<', true)) {
                    if (this.fAttValueOffset - this.fAttValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
                    }
                    setMark = true;
                    this.reportFatalXMLError(2, 11, element.rawname, attribute.rawname);
                } else if (!this.fEntityReader.lookingAtValidChar(true)) {
                    if (this.fAttValueOffset - this.fAttValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
                    }
                    setMark = true;
                    int invChar = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState == 13) {
                        return -1;
                    }
                    if (invChar >= 0) {
                        this.reportFatalXMLError(12, 10, this.fStringPool.toString(element.rawname), this.fStringPool.toString(attribute.rawname), Integer.toHexString(invChar));
                    }
                }
            }
            this.fAttValueOffset = this.fEntityReader.currentOffset();
            if (!setMark) continue;
            this.fAttValueMark = this.fAttValueOffset;
            setMark = false;
        }
        this.restoreScannerState(previousState);
        int dataLength = this.fLiteralData.length() - dataOffset;
        if (dataLength == 0) {
            return this.fEntityReader.addString(this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
        }
        if (this.fAttValueOffset - this.fAttValueMark > 0) {
            this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
            dataLength = this.fLiteralData.length() - dataOffset;
        }
        int value = this.fLiteralData.addString(dataOffset, dataLength);
        return value;
    }

    void reportFatalXMLError(int majorCode, int minorCode) throws Exception {
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, null, 2);
    }

    void reportFatalXMLError(int majorCode, int minorCode, int stringIndex1) throws Exception {
        Object[] args = new Object[]{this.fStringPool.toString(stringIndex1)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 2);
    }

    void reportFatalXMLError(int majorCode, int minorCode, String string1) throws Exception {
        Object[] args = new Object[]{string1};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 2);
    }

    void reportFatalXMLError(int majorCode, int minorCode, int stringIndex1, int stringIndex2) throws Exception {
        Object[] args = new Object[]{this.fStringPool.toString(stringIndex1), this.fStringPool.toString(stringIndex2)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 2);
    }

    void reportFatalXMLError(int majorCode, int minorCode, String string1, String string2) throws Exception {
        Object[] args = new Object[]{string1, string2};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 2);
    }

    void reportFatalXMLError(int majorCode, int minorCode, String string1, String string2, String string3) throws Exception {
        Object[] args = new Object[]{string1, string2, string3};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 2);
    }

    void abortMarkup(int majorCode, int minorCode) throws Exception {
        this.reportFatalXMLError(majorCode, minorCode);
        this.skipPastEndOfCurrentMarkup();
    }

    void abortMarkup(int majorCode, int minorCode, int stringIndex1) throws Exception {
        this.reportFatalXMLError(majorCode, minorCode, stringIndex1);
        this.skipPastEndOfCurrentMarkup();
    }

    void abortMarkup(int majorCode, int minorCode, String string1) throws Exception {
        this.reportFatalXMLError(majorCode, minorCode, string1);
        this.skipPastEndOfCurrentMarkup();
    }

    void abortMarkup(int majorCode, int minorCode, int stringIndex1, int stringIndex2) throws Exception {
        this.reportFatalXMLError(majorCode, minorCode, stringIndex1, stringIndex2);
        this.skipPastEndOfCurrentMarkup();
    }

    void skipPastEndOfCurrentMarkup() throws Exception {
        this.fEntityReader.skipToChar('>');
        if (this.fEntityReader.lookingAtChar('>', true)) {
            --this.fScannerMarkupDepth;
        }
    }

    int setScannerState(int state) {
        int oldState = this.fScannerState;
        this.fScannerState = state;
        return oldState;
    }

    void restoreScannerState(int state) {
        if (this.fScannerState != 13) {
            this.fScannerState = state;
        }
    }

    public int getCurrentElementType() {
        return this.fCurrentElementType;
    }

    /*
     * Enabled aggressive block sorting
     */
    void scanXMLDeclOrTextDecl(boolean scanningTextDecl) throws Exception {
        int version = -1;
        int encoding = -1;
        int standalone = -1;
        boolean XMLDECL_START = false;
        boolean XMLDECL_VERSION = true;
        int XMLDECL_ENCODING = 2;
        int XMLDECL_STANDALONE = 3;
        int XMLDECL_FINISHED = 4;
        int state = 0;
        block9: do {
            this.fEntityReader.skipPastSpaces();
            int offset = this.fEntityReader.currentOffset();
            if (scanningTextDecl) {
                if (state == 0 && this.fEntityReader.skippedString(version_string)) {
                    state = 1;
                } else {
                    if (!this.fEntityReader.skippedString(encoding_string)) {
                        this.abortMarkup(29, 28);
                        return;
                    }
                    state = 2;
                }
            } else if (state == 0) {
                if (!this.fEntityReader.skippedString(version_string)) {
                    this.abortMarkup(30, 29);
                    return;
                }
                state = 1;
            } else {
                state = state == 1 ? (this.fEntityReader.skippedString(encoding_string) ? 2 : 3) : 3;
                if (state == 3 && !this.fEntityReader.skippedString(standalone_string)) break;
            }
            int length = this.fEntityReader.currentOffset() - offset;
            this.fEntityReader.skipPastSpaces();
            if (!this.fEntityReader.lookingAtChar('=', true)) {
                int majorCode;
                int n = majorCode = scanningTextDecl ? 32 : 31;
                int minorCode = state == 1 ? 30 : (state == 2 ? 32 : 31);
                this.abortMarkup(majorCode, minorCode, this.fEntityReader.addString(offset, length));
                return;
            }
            this.fEntityReader.skipPastSpaces();
            int result = this.fEntityReader.scanStringLiteral();
            switch (result) {
                case -1: {
                    int majorCode;
                    int n = majorCode = scanningTextDecl ? 34 : 33;
                    int minorCode = state == 1 ? 33 : (state == 2 ? 35 : 34);
                    this.abortMarkup(majorCode, minorCode, this.fEntityReader.addString(offset, length));
                    return;
                }
                case -2: {
                    int invChar = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState == 13) return;
                    if (invChar >= 0) {
                        int majorCode;
                        int n = majorCode = scanningTextDecl ? 36 : 35;
                        int minorCode = state == 1 ? 36 : (state == 2 ? 38 : 37);
                        this.reportFatalXMLError(majorCode, minorCode, Integer.toHexString(invChar));
                    }
                    this.skipPastEndOfCurrentMarkup();
                    return;
                }
            }
            switch (state) {
                case 1: {
                    version = result;
                    String versionString = this.fStringPool.toString(version);
                    if (!"1.0".equals(versionString)) {
                        if (!this.validVersionNum(versionString)) {
                            this.abortMarkup(37, 39, versionString);
                            return;
                        }
                        Object[] args = new Object[]{versionString};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 38, 40, args, 1);
                    }
                    if (this.fEntityReader.lookingAtSpace(true)) continue block9;
                    if (scanningTextDecl) {
                        this.abortMarkup(39, 41);
                        return;
                    }
                    state = 4;
                    break;
                }
                case 2: {
                    encoding = result;
                    String encodingString = this.fStringPool.toString(encoding);
                    if (!this.validEncName(encodingString)) {
                        this.abortMarkup(40, 42, encodingString);
                        return;
                    }
                    if (!this.fEntityReader.lookingAtSpace(true)) {
                        state = 4;
                        break;
                    }
                    if (!scanningTextDecl) continue block9;
                    this.fEntityReader.skipPastSpaces();
                    state = 4;
                    break;
                }
                case 3: {
                    standalone = result;
                    String standaloneString = this.fStringPool.toString(standalone);
                    boolean yes = "yes".equals(standaloneString);
                    if (!yes && !"no".equals(standaloneString)) {
                        this.abortMarkup(41, 43, standaloneString);
                        return;
                    }
                    this.fStandalone = yes;
                    this.fEntityReader.skipPastSpaces();
                    state = 4;
                    break;
                }
            }
        } while (state != 4);
        if (!this.fEntityReader.lookingAtChar('?', true) || !this.fEntityReader.lookingAtChar('>', true)) {
            int minorCode;
            int majorCode;
            if (scanningTextDecl) {
                majorCode = 43;
                minorCode = 45;
            } else {
                majorCode = 42;
                minorCode = 44;
            }
            this.abortMarkup(majorCode, minorCode);
            return;
        }
        --this.fScannerMarkupDepth;
        if (scanningTextDecl) {
            this.fEventHandler.callTextDecl(version, encoding);
            return;
        }
        this.fEventHandler.callXMLDecl(version, encoding, standalone);
        if (!this.fStandalone) return;
        this.fEventHandler.callStandaloneIsYes();
    }

    boolean scanElement(QName element) throws Exception {
        boolean greater = false;
        boolean slash = false;
        greater = this.fEntityReader.lookingAtChar('>', true);
        if (!greater) {
            if (this.fEntityReader.lookingAtSpace(true)) {
                int previousState;
                block14: {
                    previousState = this.setScannerState(9);
                    do {
                        this.fEntityReader.skipPastSpaces();
                        greater = this.fEntityReader.lookingAtChar('>', true);
                        if (greater || (slash = this.fEntityReader.lookingAtChar('/', true))) break block14;
                        this.setScannerState(10);
                        this.scanAttributeName(this.fEntityReader, element, this.fAttributeQName);
                        if (this.fAttributeQName.rawname == -1) break block14;
                        this.fEntityReader.skipPastSpaces();
                        if (!this.fEntityReader.lookingAtChar('=', true)) {
                            if (this.fScannerState != 13) {
                                this.abortMarkup(27, 26, element.rawname, this.fAttributeQName.rawname);
                                this.restoreScannerState(previousState);
                            }
                            return false;
                        }
                        this.fEntityReader.skipPastSpaces();
                        int result = this.scanAttValue(element, this.fAttributeQName, false);
                        if (result == -1) {
                            if (this.fScannerState != 13) {
                                this.skipPastEndOfCurrentMarkup();
                                this.restoreScannerState(previousState);
                            }
                            return false;
                        }
                        if (result == -2) {
                            this.reportFatalXMLError(28, 27, element.rawname, this.fAttributeQName.rawname);
                        }
                        if (this.fEventHandler.attribute(element, this.fAttributeQName, result)) {
                            this.reportFatalXMLError(28, 27, element.rawname, this.fAttributeQName.rawname);
                        }
                        this.restoreScannerState(9);
                    } while (this.fEntityReader.lookingAtSpace(true));
                    greater = this.fEntityReader.lookingAtChar('>', true);
                    if (!greater) {
                        slash = this.fEntityReader.lookingAtChar('/', true);
                    }
                }
                this.restoreScannerState(previousState);
            } else {
                slash = this.fEntityReader.lookingAtChar('/', true);
            }
        }
        if (!(greater || slash && this.fEntityReader.lookingAtChar('>', true))) {
            if (this.fScannerState != 13) {
                this.abortMarkup(26, 25, element.rawname);
            }
            return false;
        }
        this.fEventHandler.callStartElement(element);
        --this.fScannerMarkupDepth;
        if (slash) {
            this.fEventHandler.callEndElement(this.fReaderId);
            return false;
        }
        return true;
    }

    int scanCharRef() throws Exception {
        int valueOffset = this.fEntityReader.currentOffset();
        boolean hex = this.fEntityReader.lookingAtChar('x', true);
        int num = this.fEntityReader.scanCharRef(hex);
        if (num < 0) {
            switch (num) {
                case -1: {
                    this.reportFatalXMLError(18, 17);
                    return -1;
                }
                case -2: {
                    int majorCode = hex ? 17 : 16;
                    int minorCode = hex ? 16 : 15;
                    this.reportFatalXMLError(majorCode, minorCode);
                    return -1;
                }
                case -3: {
                    num = 0x110000;
                }
            }
        }
        if (num < 32 ? num == 9 || num == 10 || num == 13 : num <= 55295 || num >= 57344 && (num <= 65533 || num >= 65536 && num <= 0x10FFFF)) {
            return num;
        }
        int valueLength = this.fEntityReader.currentOffset() - valueOffset;
        this.reportFatalXMLError(11, 9, this.fEntityReader.addString(valueOffset, valueLength));
        return -1;
    }

    void scanComment() throws Exception {
        int commentOffset = this.fEntityReader.currentOffset();
        boolean sawDashDash = false;
        int previousState = this.setScannerState(2);
        while (this.fScannerState == 2) {
            if (this.fEntityReader.lookingAtChar('-', false)) {
                int nextEndOffset = this.fEntityReader.currentOffset();
                int endOffset = 0;
                this.fEntityReader.lookingAtChar('-', true);
                int offset = this.fEntityReader.currentOffset();
                int count = 1;
                while (this.fEntityReader.lookingAtChar('-', true)) {
                    ++count;
                    endOffset = nextEndOffset;
                    nextEndOffset = offset;
                    offset = this.fEntityReader.currentOffset();
                }
                if (count <= 1) continue;
                if (this.fEntityReader.lookingAtChar('>', true)) {
                    if (!sawDashDash && count > 2) {
                        this.reportFatalXMLError(9, 7);
                        sawDashDash = true;
                    }
                    --this.fScannerMarkupDepth;
                    this.fEventHandler.callComment(this.fEntityReader.addString(commentOffset, endOffset - commentOffset));
                    this.restoreScannerState(previousState);
                    return;
                }
                if (sawDashDash) continue;
                this.reportFatalXMLError(9, 7);
                sawDashDash = true;
                continue;
            }
            if (this.fEntityReader.lookingAtValidChar(true)) continue;
            int invChar = this.fEntityReader.scanInvalidChar();
            if (this.fScannerState == 13 || invChar < 0) continue;
            this.reportFatalXMLError(10, 8, Integer.toHexString(invChar));
        }
        this.restoreScannerState(previousState);
    }

    /*
     * Unable to fully structure code
     */
    void scanPI(int piTarget) throws Exception {
        block8: {
            block7: {
                piTargetString = this.fStringPool.toString(piTarget);
                if (!(piTargetString.length() != 3 || piTargetString.charAt(0) != 'X' && piTargetString.charAt(0) != 'x' || piTargetString.charAt(1) != 'M' && piTargetString.charAt(1) != 'm' || piTargetString.charAt(2) != 'L' && piTargetString.charAt(2) != 'l')) {
                    this.abortMarkup(6, 4);
                    return;
                }
                prevState = this.setScannerState(3);
                piDataOffset = -1;
                piDataLength = -1;
                if (this.fEntityReader.lookingAtSpace(true)) break block7;
                if (!this.fEntityReader.lookingAtChar('?', true) || !this.fEntityReader.lookingAtChar('>', true)) {
                    if (this.fScannerState != 13) {
                        this.abortMarkup(7, 5);
                        this.restoreScannerState(prevState);
                    }
                    return;
                }
                piDataLength = 0;
                break block8;
            }
            this.fEntityReader.skipPastSpaces();
            piDataOffset = this.fEntityReader.currentOffset();
            ** GOTO lbl38
            {
                block9: {
                    offset = this.fEntityReader.currentOffset();
                    this.fEntityReader.lookingAtChar('?', true);
                    if (!this.fEntityReader.lookingAtChar('>', true)) break block9;
                    piDataLength = offset - piDataOffset;
                    ** GOTO lbl29
                }
                do {
                    if (this.fEntityReader.lookingAtChar('?', false)) continue block0;
lbl29:
                    // 2 sources

                    if (piDataLength >= 0) break block0;
                    if (this.fEntityReader.lookingAtValidChar(true)) continue;
                    invChar = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState != 13) {
                        if (invChar >= 0) {
                            this.reportFatalXMLError(8, 6, Integer.toHexString(invChar));
                        }
                        this.skipPastEndOfCurrentMarkup();
                        this.restoreScannerState(prevState);
                    }
                    return;
lbl38:
                    // 2 sources

                } while (this.fScannerState == 3);
            }
        }
        --this.fScannerMarkupDepth;
        this.restoreScannerState(prevState);
        piData = piDataLength == 0 ? 0 : this.fEntityReader.addString(piDataOffset, piDataLength);
        this.fEventHandler.callProcessingInstruction(piTarget, piData);
    }

    public void setNamespacesEnabled(boolean enabled) {
        this.fNamespacesEnabled = enabled;
    }

    public boolean getNamespacesEnabled() {
        return this.fNamespacesEnabled;
    }

    public void setValidationEnabled(boolean enabled) {
        this.fValidationEnabled = enabled;
        if (this.fDTDScanner != null) {
            this.fDTDScanner.setValidationEnabled(enabled);
        }
    }

    public boolean getValidationEnabled() {
        return this.fValidationEnabled;
    }

    public void setLoadExternalDTD(boolean enabled) {
        this.fLoadExternalDTD = enabled;
        if (this.fDTDScanner != null) {
            this.fDTDScanner.setLoadExternalDTD(enabled);
        }
    }

    public boolean getLoadExternalDTD() {
        return this.fLoadExternalDTD;
    }

    private void scanElementType(XMLEntityHandler.EntityReader entityReader, char fastchar, QName element) throws Exception {
        if (!this.fNamespacesEnabled) {
            element.clear();
            element.rawname = element.localpart = entityReader.scanName(fastchar);
        } else {
            entityReader.scanQName(fastchar, element);
            if (entityReader.lookingAtChar(':', false)) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
                entityReader.skipPastNmtoken(' ');
            }
        }
        this.fEventHandler.element(element);
    }

    private boolean scanExpectedElementType(XMLEntityHandler.EntityReader entityReader, char fastchar, int elementType) throws Exception {
        if (this.fCurrentElementCharArrayRange == null) {
            this.fCurrentElementCharArrayRange = this.fStringPool.createCharArrayRange();
        }
        this.fStringPool.getCharArrayRange(elementType, this.fCurrentElementCharArrayRange);
        return entityReader.scanExpectedName(fastchar, this.fCurrentElementCharArrayRange);
    }

    private void scanAttributeName(XMLEntityHandler.EntityReader entityReader, QName element, QName attribute) throws Exception {
        if (!this.fNamespacesEnabled) {
            attribute.clear();
            attribute.rawname = attribute.localpart = entityReader.scanName('=');
        } else {
            entityReader.scanQName('=', attribute);
            if (entityReader.lookingAtChar(':', false)) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
                entityReader.skipPastNmtoken(' ');
            }
        }
    }

    private void scanDoctypeDecl(boolean standalone) throws Exception {
        this.fScanningDTD = true;
        this.fSeenDoctypeDecl = true;
        if (this.fDTDScanner == null) {
            this.fDTDScanner = new XMLDTDScanner(this.fStringPool, this.fErrorReporter, this.fEntityHandler, new ChunkyCharArray(this.fStringPool));
            this.fDTDScanner.setValidationEnabled(this.fValidationEnabled);
            this.fDTDScanner.setNamespacesEnabled(this.fNamespacesEnabled);
            this.fDTDScanner.setLoadExternalDTD(this.fLoadExternalDTD);
        } else {
            this.fDTDScanner.reset(this.fStringPool, new ChunkyCharArray(this.fStringPool));
        }
        this.fDTDScanner.setDTDHandler(this.fDTDHandler);
        this.fDTDScanner.setGrammarResolver(this.fGrammarResolver);
        if (this.fDTDScanner.scanDoctypeDecl() && this.fDTDScanner.getReadingExternalEntity()) {
            this.fDTDScanner.scanDecls(true);
        }
        if (this.fValidationEnabled) {
            ((DefaultEntityHandler)this.fEntityHandler).checkRequiredNotations();
        }
        this.fScanningDTD = false;
    }

    private int scanAttValue(QName element, QName attribute) throws Exception {
        int attValue = this.scanAttValue(element, attribute, this.fValidationEnabled);
        if (attValue == -1) {
            return -1;
        }
        return 0;
    }

    private boolean validVersionNum(String version) {
        return XMLCharacterProperties.validVersionNum(version);
    }

    private boolean validEncName(String encoding) {
        return XMLCharacterProperties.validEncName(encoding);
    }

    final class ContentDispatcher
    implements ScannerDispatcher {
        private int fContentReader = -1;
        private int fElementDepth = 0;
        private int[] fElementTypeStack = new int[8];

        ContentDispatcher() {
        }

        void popElementType() {
            if (this.fElementDepth-- == 0) {
                throw new RuntimeException("FWK002 popElementType: fElementDepth-- == 0.");
            }
            XMLDocumentScanner.this.fCurrentElementType = this.fElementDepth == 0 ? -1 : this.fElementTypeStack[this.fElementDepth - 1];
        }

        public boolean dispatch(boolean keepgoing) throws Exception {
            block19: do {
                block0 : switch (XMLDocumentScanner.this.fScannerState) {
                    case 6: {
                        XMLDocumentScanner.this.scanElementType(XMLDocumentScanner.this.fEntityReader, '>', XMLDocumentScanner.this.fElementQName);
                        if (XMLDocumentScanner.this.fElementQName.rawname != -1) {
                            this.fContentReader = XMLDocumentScanner.this.fReaderId;
                            XMLDocumentScanner.this.fSeenRootElement = true;
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                XMLDocumentScanner.this.fEventHandler.callStartElement(XMLDocumentScanner.this.fElementQName);
                                --XMLDocumentScanner.this.fScannerMarkupDepth;
                                if (this.fElementDepth == this.fElementTypeStack.length) {
                                    int[] newStack = new int[this.fElementDepth * 2];
                                    System.arraycopy(this.fElementTypeStack, 0, newStack, 0, this.fElementDepth);
                                    this.fElementTypeStack = newStack;
                                }
                                XMLDocumentScanner.this.fCurrentElementType = XMLDocumentScanner.this.fElementQName.rawname;
                                this.fElementTypeStack[this.fElementDepth] = XMLDocumentScanner.this.fElementQName.rawname;
                                ++this.fElementDepth;
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break;
                            }
                            if (XMLDocumentScanner.this.scanElement(XMLDocumentScanner.this.fElementQName)) {
                                if (this.fElementDepth == this.fElementTypeStack.length) {
                                    int[] newStack = new int[this.fElementDepth * 2];
                                    System.arraycopy(this.fElementTypeStack, 0, newStack, 0, this.fElementDepth);
                                    this.fElementTypeStack = newStack;
                                }
                                XMLDocumentScanner.this.fCurrentElementType = XMLDocumentScanner.this.fElementQName.rawname;
                                this.fElementTypeStack[this.fElementDepth] = XMLDocumentScanner.this.fElementQName.rawname;
                                ++this.fElementDepth;
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break;
                            }
                            XMLDocumentScanner.this.fDispatcher = new TrailingMiscDispatcher();
                            XMLDocumentScanner.this.restoreScannerState(12);
                            return true;
                        }
                        XMLDocumentScanner.this.reportFatalXMLError(129, 108);
                        XMLDocumentScanner.this.fDispatcher = new PrologDispatcher();
                        XMLDocumentScanner.this.restoreScannerState(5);
                        return true;
                    }
                    case 1: {
                        if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('?', true)) {
                            int piTarget = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                            if (piTarget == -1) {
                                XMLDocumentScanner.this.abortMarkup(131, 105);
                            } else if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(piTarget))) {
                                if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                    if (XMLDocumentScanner.this.fParseTextDecl) {
                                        XMLDocumentScanner.this.scanXMLDeclOrTextDecl(true);
                                        XMLDocumentScanner.this.fParseTextDecl = false;
                                    } else {
                                        XMLDocumentScanner.this.abortMarkup(105, 138);
                                    }
                                } else {
                                    XMLDocumentScanner.this.abortMarkup(6, 4);
                                }
                            } else {
                                XMLDocumentScanner.this.scanPI(piTarget);
                            }
                            XMLDocumentScanner.this.restoreScannerState(7);
                        } else if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('!', true)) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                                if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                                    XMLDocumentScanner.this.scanComment();
                                } else {
                                    XMLDocumentScanner.this.abortMarkup(127, 110);
                                }
                            } else if (XMLDocumentScanner.this.fEntityReader.skippedString(cdata_string)) {
                                XMLDocumentScanner.this.fEntityReader.setInCDSect(true);
                                XMLDocumentScanner.this.fEventHandler.callStartCDATA();
                            } else {
                                XMLDocumentScanner.this.abortMarkup(127, 110);
                            }
                        } else if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('/', true)) {
                            if (!XMLDocumentScanner.this.scanExpectedElementType(XMLDocumentScanner.this.fEntityReader, '>', XMLDocumentScanner.this.fCurrentElementType)) {
                                XMLDocumentScanner.this.abortMarkup(56, 58, XMLDocumentScanner.this.fCurrentElementType);
                            } else {
                                if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                    XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                                    if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                        XMLDocumentScanner.this.reportFatalXMLError(57, 59, XMLDocumentScanner.this.fCurrentElementType);
                                    }
                                }
                                --XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fEventHandler.callEndElement(XMLDocumentScanner.this.fReaderId);
                                if (this.fElementDepth-- == 0) {
                                    throw new RuntimeException("FWK002 popElementType: fElementDepth-- == 0.");
                                }
                                if (this.fElementDepth == 0) {
                                    XMLDocumentScanner.this.fCurrentElementType = -1;
                                    XMLDocumentScanner.this.fDispatcher = new TrailingMiscDispatcher();
                                    XMLDocumentScanner.this.restoreScannerState(12);
                                    return true;
                                }
                                XMLDocumentScanner.this.fCurrentElementType = this.fElementTypeStack[this.fElementDepth - 1];
                            }
                        } else {
                            XMLDocumentScanner.this.scanElementType(XMLDocumentScanner.this.fEntityReader, '>', XMLDocumentScanner.this.fElementQName);
                            if (XMLDocumentScanner.this.fElementQName.rawname != -1) {
                                if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                    XMLDocumentScanner.this.fEventHandler.callStartElement(XMLDocumentScanner.this.fElementQName);
                                    --XMLDocumentScanner.this.fScannerMarkupDepth;
                                    if (this.fElementDepth == this.fElementTypeStack.length) {
                                        int[] newStack = new int[this.fElementDepth * 2];
                                        System.arraycopy(this.fElementTypeStack, 0, newStack, 0, this.fElementDepth);
                                        this.fElementTypeStack = newStack;
                                    }
                                    XMLDocumentScanner.this.fCurrentElementType = XMLDocumentScanner.this.fElementQName.rawname;
                                    this.fElementTypeStack[this.fElementDepth] = XMLDocumentScanner.this.fElementQName.rawname;
                                    ++this.fElementDepth;
                                } else if (XMLDocumentScanner.this.scanElement(XMLDocumentScanner.this.fElementQName)) {
                                    if (this.fElementDepth == this.fElementTypeStack.length) {
                                        int[] newStack = new int[this.fElementDepth * 2];
                                        System.arraycopy(this.fElementTypeStack, 0, newStack, 0, this.fElementDepth);
                                        this.fElementTypeStack = newStack;
                                    }
                                    XMLDocumentScanner.this.fCurrentElementType = XMLDocumentScanner.this.fElementQName.rawname;
                                    this.fElementTypeStack[this.fElementDepth] = XMLDocumentScanner.this.fElementQName.rawname;
                                    ++this.fElementDepth;
                                }
                            } else {
                                XMLDocumentScanner.this.abortMarkup(127, 110);
                            }
                        }
                        XMLDocumentScanner.this.restoreScannerState(7);
                        break;
                    }
                    case 7: {
                        if (XMLDocumentScanner.this.fParseTextDecl && XMLDocumentScanner.this.fEntityReader.lookingAtChar('<', true)) {
                            ++XMLDocumentScanner.this.fScannerMarkupDepth;
                            XMLDocumentScanner.this.setScannerState(1);
                            break;
                        }
                        XMLDocumentScanner.this.fCurrentElementQName.setValues(-1, -1, XMLDocumentScanner.this.fCurrentElementType);
                        switch (XMLDocumentScanner.this.fEntityReader.scanContent(XMLDocumentScanner.this.fCurrentElementQName)) {
                            case 0: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                int piTarget = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                                if (piTarget == -1) {
                                    XMLDocumentScanner.this.abortMarkup(131, 105);
                                    break block0;
                                }
                                if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(piTarget))) {
                                    if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                        if (XMLDocumentScanner.this.fReaderId == this.fContentReader) {
                                            XMLDocumentScanner.this.abortMarkup(104, 137);
                                            break block0;
                                        }
                                        XMLDocumentScanner.this.abortMarkup(105, 138);
                                        break block0;
                                    }
                                    XMLDocumentScanner.this.abortMarkup(6, 4);
                                    break block0;
                                }
                                XMLDocumentScanner.this.scanPI(piTarget);
                                break block0;
                            }
                            case 1: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.scanComment();
                                break block0;
                            }
                            case 2: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.fEntityReader.setInCDSect(true);
                                XMLDocumentScanner.this.fEventHandler.callStartCDATA();
                                break block0;
                            }
                            case 4: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                if (!XMLDocumentScanner.this.scanExpectedElementType(XMLDocumentScanner.this.fEntityReader, '>', XMLDocumentScanner.this.fCurrentElementType)) {
                                    XMLDocumentScanner.this.abortMarkup(56, 58, XMLDocumentScanner.this.fCurrentElementType);
                                } else {
                                    if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                        XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                                        if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                            XMLDocumentScanner.this.reportFatalXMLError(57, 59, XMLDocumentScanner.this.fCurrentElementType);
                                        }
                                    }
                                    --XMLDocumentScanner.this.fScannerMarkupDepth;
                                    XMLDocumentScanner.this.fEventHandler.callEndElement(XMLDocumentScanner.this.fReaderId);
                                    if (this.fElementDepth-- == 0) {
                                        throw new RuntimeException("FWK002 popElementType: fElementDepth-- == 0.");
                                    }
                                    if (this.fElementDepth == 0) {
                                        XMLDocumentScanner.this.fCurrentElementType = -1;
                                        XMLDocumentScanner.this.fDispatcher = new TrailingMiscDispatcher();
                                        XMLDocumentScanner.this.restoreScannerState(12);
                                        return true;
                                    }
                                    XMLDocumentScanner.this.fCurrentElementType = this.fElementTypeStack[this.fElementDepth - 1];
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break block0;
                            }
                            case 6: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.scanElementType(XMLDocumentScanner.this.fEntityReader, '>', XMLDocumentScanner.this.fElementQName);
                                if (XMLDocumentScanner.this.fElementQName.rawname != -1) {
                                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                        XMLDocumentScanner.this.fEventHandler.callStartElement(XMLDocumentScanner.this.fElementQName);
                                        --XMLDocumentScanner.this.fScannerMarkupDepth;
                                        if (this.fElementDepth == this.fElementTypeStack.length) {
                                            int[] newStack = new int[this.fElementDepth * 2];
                                            System.arraycopy(this.fElementTypeStack, 0, newStack, 0, this.fElementDepth);
                                            this.fElementTypeStack = newStack;
                                        }
                                        XMLDocumentScanner.this.fCurrentElementType = XMLDocumentScanner.this.fElementQName.rawname;
                                        this.fElementTypeStack[this.fElementDepth] = XMLDocumentScanner.this.fElementQName.rawname;
                                        ++this.fElementDepth;
                                    } else if (XMLDocumentScanner.this.scanElement(XMLDocumentScanner.this.fElementQName)) {
                                        if (this.fElementDepth == this.fElementTypeStack.length) {
                                            int[] newStack = new int[this.fElementDepth * 2];
                                            System.arraycopy(this.fElementTypeStack, 0, newStack, 0, this.fElementDepth);
                                            this.fElementTypeStack = newStack;
                                        }
                                        XMLDocumentScanner.this.fCurrentElementType = XMLDocumentScanner.this.fElementQName.rawname;
                                        this.fElementTypeStack[this.fElementDepth] = XMLDocumentScanner.this.fElementQName.rawname;
                                        ++this.fElementDepth;
                                    }
                                } else {
                                    XMLDocumentScanner.this.abortMarkup(127, 110);
                                }
                                if (XMLDocumentScanner.this.fScannerState == 13) continue block19;
                                XMLDocumentScanner.this.fScannerState = 7;
                                break block0;
                            }
                            case 5: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.fEventHandler.callEndElement(XMLDocumentScanner.this.fReaderId);
                                if (this.fElementDepth-- == 0) {
                                    throw new RuntimeException("FWK002 popElementType: fElementDepth-- == 0.");
                                }
                                if (this.fElementDepth == 0) {
                                    XMLDocumentScanner.this.fCurrentElementType = -1;
                                    if (XMLDocumentScanner.this.fScannerState != 13) {
                                        XMLDocumentScanner.this.fDispatcher = new TrailingMiscDispatcher();
                                        XMLDocumentScanner.this.fScannerState = 12;
                                    }
                                    return true;
                                }
                                XMLDocumentScanner.this.fCurrentElementType = this.fElementTypeStack[this.fElementDepth - 1];
                                if (XMLDocumentScanner.this.fScannerState == 13) continue block19;
                                XMLDocumentScanner.this.fScannerState = 7;
                                break block0;
                            }
                            case 7: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.setScannerState(8);
                                int num = XMLDocumentScanner.this.scanCharRef();
                                if (num != -1) {
                                    XMLDocumentScanner.this.fEventHandler.callCharacters(num);
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break block0;
                            }
                            case 8: 
                            case 12: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.setScannerState(8);
                                int nameOffset = XMLDocumentScanner.this.fEntityReader.currentOffset();
                                XMLDocumentScanner.this.fEntityReader.skipPastName(';');
                                int nameLength = XMLDocumentScanner.this.fEntityReader.currentOffset() - nameOffset;
                                if (nameLength == 0) {
                                    XMLDocumentScanner.this.reportFatalXMLError(14, 13);
                                    XMLDocumentScanner.this.restoreScannerState(7);
                                    break block0;
                                }
                                if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar(';', true)) {
                                    XMLDocumentScanner.this.reportFatalXMLError(15, 14, XMLDocumentScanner.this.fEntityReader.addString(nameOffset, nameLength));
                                    XMLDocumentScanner.this.restoreScannerState(7);
                                    break block0;
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                int entityName = XMLDocumentScanner.this.fEntityReader.addSymbol(nameOffset, nameLength);
                                XMLDocumentScanner.this.fParseTextDecl = XMLDocumentScanner.this.fEntityHandler.startReadingFromEntity(entityName, this.fElementDepth, 2);
                                break block0;
                            }
                            case 3: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                if (XMLDocumentScanner.this.fEntityReader.getInCDSect()) {
                                    XMLDocumentScanner.this.fEntityReader.setInCDSect(false);
                                    XMLDocumentScanner.this.fEventHandler.callEndCDATA();
                                    --XMLDocumentScanner.this.fScannerMarkupDepth;
                                } else {
                                    XMLDocumentScanner.this.reportFatalXMLError(124, 104);
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break block0;
                            }
                            case 9: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                if (XMLDocumentScanner.this.fScannerState == 13) continue block19;
                                if (!XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(false)) {
                                    int invChar = XMLDocumentScanner.this.fEntityReader.scanInvalidChar();
                                    if (XMLDocumentScanner.this.fScannerState != 13 && invChar >= 0) {
                                        if (XMLDocumentScanner.this.fEntityReader.getInCDSect()) {
                                            XMLDocumentScanner.this.reportFatalXMLError(54, 56, Integer.toHexString(invChar));
                                        } else {
                                            XMLDocumentScanner.this.reportFatalXMLError(55, 57, Integer.toHexString(invChar));
                                        }
                                    }
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break block0;
                            }
                            case 10: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.abortMarkup(127, 110);
                                break block0;
                            }
                            case 11: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.fScannerState = 1;
                                break block0;
                            }
                            default: {
                                throw new RuntimeException("FWK001 3] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "3\t" + XMLDocumentScanner.this.fScannerState);
                            }
                        }
                    }
                    default: {
                        throw new RuntimeException("FWK001 4] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "4\t" + XMLDocumentScanner.this.fScannerState);
                    }
                }
            } while (XMLDocumentScanner.this.fScannerState != 13 && keepgoing);
            return true;
        }

        public void endOfInput(int entityName, boolean moreToFollow) throws Exception {
            switch (XMLDocumentScanner.this.fScannerState) {
                case 1: 
                case 6: {
                    break;
                }
                case 7: {
                    if (!XMLDocumentScanner.this.fEntityReader.getInCDSect()) break;
                    XMLDocumentScanner.this.reportFatalXMLError(66, 66);
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    if (!moreToFollow) {
                        XMLDocumentScanner.this.reportFatalXMLError(151, 136, XMLDocumentScanner.this.fAttValueElementType, XMLDocumentScanner.this.fAttValueAttrName);
                        break;
                    }
                    if (XMLDocumentScanner.this.fReaderId == XMLDocumentScanner.this.fAttValueReader) break;
                    XMLDocumentScanner.this.fEntityReader.append(XMLDocumentScanner.this.fLiteralData, XMLDocumentScanner.this.fAttValueMark, XMLDocumentScanner.this.fAttValueOffset - XMLDocumentScanner.this.fAttValueMark);
                    break;
                }
                case 2: {
                    if (!moreToFollow) {
                        XMLDocumentScanner.this.reportFatalXMLError(163, 133);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(162, 68);
                    break;
                }
                case 3: {
                    if (!moreToFollow) {
                        XMLDocumentScanner.this.reportFatalXMLError(164, 134);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(165, 68);
                    break;
                }
                case 8: {
                    if (!moreToFollow) {
                        XMLDocumentScanner.this.reportFatalXMLError(166, 135);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(161, 68);
                    break;
                }
                default: {
                    throw new RuntimeException("FWK001 5] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "5\t" + XMLDocumentScanner.this.fScannerState);
                }
            }
            if (!moreToFollow) {
                if (this.fElementDepth > 0) {
                    XMLDocumentScanner.this.reportFatalXMLError(56, 58, XMLDocumentScanner.this.fCurrentElementType);
                } else {
                    XMLDocumentScanner.this.reportFatalXMLError(134, 107, null);
                }
                XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
                XMLDocumentScanner.this.setScannerState(13);
            }
        }
    }

    final class EndOfInputDispatcher
    implements ScannerDispatcher {
        EndOfInputDispatcher() {
        }

        public boolean dispatch(boolean keepgoing) throws Exception {
            if (XMLDocumentScanner.this.fScannerState != 14) {
                XMLDocumentScanner.this.fEventHandler.callEndDocument();
            }
            XMLDocumentScanner.this.setScannerState(14);
            return false;
        }

        public void endOfInput(int entityName, boolean moreToFollow) throws Exception {
            throw new RuntimeException("FWK001 7] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "7\t" + XMLDocumentScanner.this.fScannerState);
        }
    }

    public static interface EventHandler {
        public void callStandaloneIsYes() throws Exception;

        public void callStartDocument() throws Exception;

        public void callEndDocument() throws Exception;

        public void callXMLDecl(int var1, int var2, int var3) throws Exception;

        public void callTextDecl(int var1, int var2) throws Exception;

        public void callStartElement(QName var1) throws Exception;

        public void element(QName var1) throws Exception;

        public boolean attribute(QName var1, QName var2, int var3) throws Exception;

        public void callEndElement(int var1) throws Exception;

        public void callStartCDATA() throws Exception;

        public void callEndCDATA() throws Exception;

        public void callCharacters(int var1) throws Exception;

        public void callProcessingInstruction(int var1, int var2) throws Exception;

        public void callComment(int var1) throws Exception;
    }

    final class PrologDispatcher
    implements ScannerDispatcher {
        PrologDispatcher() {
        }

        public boolean dispatch(boolean keepgoing) throws Exception {
            do {
                if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('<', true)) {
                    ++XMLDocumentScanner.this.fScannerMarkupDepth;
                    XMLDocumentScanner.this.setScannerState(1);
                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('?', true)) {
                        int piTarget = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                        if (piTarget == -1) {
                            XMLDocumentScanner.this.abortMarkup(131, 105);
                        } else if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(piTarget))) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                XMLDocumentScanner.this.abortMarkup(104, 137);
                            } else {
                                XMLDocumentScanner.this.abortMarkup(6, 4);
                            }
                        } else {
                            XMLDocumentScanner.this.scanPI(piTarget);
                        }
                    } else if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('!', true)) {
                        if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                                XMLDocumentScanner.this.scanComment();
                            } else {
                                XMLDocumentScanner.this.abortMarkup(129, 108);
                            }
                        } else if (!XMLDocumentScanner.this.fSeenDoctypeDecl && XMLDocumentScanner.this.fEntityReader.skippedString(doctype_string)) {
                            XMLDocumentScanner.this.setScannerState(4);
                            XMLDocumentScanner.this.fSeenDoctypeDecl = true;
                            XMLDocumentScanner.this.scanDoctypeDecl(XMLDocumentScanner.this.fStandalone);
                            --XMLDocumentScanner.this.fScannerMarkupDepth;
                        } else {
                            XMLDocumentScanner.this.abortMarkup(129, 108);
                        }
                    } else {
                        XMLDocumentScanner.this.fDispatcher = new ContentDispatcher();
                        XMLDocumentScanner.this.restoreScannerState(6);
                        return true;
                    }
                    XMLDocumentScanner.this.restoreScannerState(5);
                    continue;
                }
                if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                    XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                    continue;
                }
                if (!XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(false)) {
                    int invChar = XMLDocumentScanner.this.fEntityReader.scanInvalidChar();
                    if (XMLDocumentScanner.this.fScannerState == 13 || invChar < 0) continue;
                    String arg = Integer.toHexString(invChar);
                    XMLDocumentScanner.this.reportFatalXMLError(52, 54, arg);
                    continue;
                }
                XMLDocumentScanner.this.reportFatalXMLError(129, 108);
                XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(true);
            } while (XMLDocumentScanner.this.fScannerState != 13 && keepgoing);
            return true;
        }

        public void endOfInput(int entityName, boolean moreToFollow) throws Exception {
            switch (XMLDocumentScanner.this.fScannerState) {
                case 1: 
                case 4: 
                case 5: {
                    break;
                }
                case 2: {
                    if (!moreToFollow) {
                        XMLDocumentScanner.this.reportFatalXMLError(163, 133);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(162, 68);
                    break;
                }
                case 3: {
                    if (!moreToFollow) {
                        XMLDocumentScanner.this.reportFatalXMLError(164, 134);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(165, 68);
                    break;
                }
                default: {
                    throw new RuntimeException("FWK001 2] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "2\t" + XMLDocumentScanner.this.fScannerState);
                }
            }
            if (!moreToFollow) {
                XMLDocumentScanner.this.reportFatalXMLError(134, 107);
                XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
                XMLDocumentScanner.this.setScannerState(13);
            }
        }
    }

    static interface ScannerDispatcher {
        public boolean dispatch(boolean var1) throws Exception;

        public void endOfInput(int var1, boolean var2) throws Exception;
    }

    final class TrailingMiscDispatcher
    implements ScannerDispatcher {
        TrailingMiscDispatcher() {
        }

        public boolean dispatch(boolean keepgoing) throws Exception {
            do {
                if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('<', true)) {
                    ++XMLDocumentScanner.this.fScannerMarkupDepth;
                    XMLDocumentScanner.this.setScannerState(1);
                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('?', true)) {
                        int piTarget = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                        if (piTarget == -1) {
                            XMLDocumentScanner.this.abortMarkup(131, 105);
                        } else if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(piTarget))) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                XMLDocumentScanner.this.abortMarkup(104, 137);
                            } else {
                                XMLDocumentScanner.this.abortMarkup(6, 4);
                            }
                        } else {
                            XMLDocumentScanner.this.scanPI(piTarget);
                        }
                    } else if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('!', true)) {
                        if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true) && XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                            XMLDocumentScanner.this.scanComment();
                        } else {
                            XMLDocumentScanner.this.abortMarkup(128, 109);
                        }
                    } else {
                        XMLDocumentScanner.this.abortMarkup(128, 109);
                    }
                    XMLDocumentScanner.this.restoreScannerState(12);
                    continue;
                }
                if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                    XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                    continue;
                }
                if (!XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(false)) {
                    int invChar = XMLDocumentScanner.this.fEntityReader.scanInvalidChar();
                    if (XMLDocumentScanner.this.fScannerState == 13 || invChar < 0) continue;
                    String arg = Integer.toHexString(invChar);
                    XMLDocumentScanner.this.reportFatalXMLError(53, 55, arg);
                    continue;
                }
                XMLDocumentScanner.this.reportFatalXMLError(128, 109);
                XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(true);
            } while (XMLDocumentScanner.this.fScannerState != 13 && keepgoing);
            return true;
        }

        public void endOfInput(int entityName, boolean moreToFollow) throws Exception {
            if (moreToFollow) {
                throw new RuntimeException("FWK003 TrailingMiscDispatcher.endOfInput moreToFollow");
            }
            switch (XMLDocumentScanner.this.fScannerState) {
                case 1: 
                case 12: {
                    break;
                }
                case 2: {
                    XMLDocumentScanner.this.reportFatalXMLError(163, 133);
                    break;
                }
                case 3: {
                    XMLDocumentScanner.this.reportFatalXMLError(164, 134);
                    break;
                }
                default: {
                    throw new RuntimeException("FWK001 6] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "6\t" + XMLDocumentScanner.this.fScannerState);
                }
            }
            XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
            XMLDocumentScanner.this.setScannerState(13);
        }
    }

    final class XMLDeclDispatcher
    implements ScannerDispatcher {
        XMLDeclDispatcher() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean dispatch(boolean keepgoing) throws Exception {
            block20: {
                block21: {
                    XMLDocumentScanner.this.fEventHandler.callStartDocument();
                    if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('<', true)) break block21;
                    ++XMLDocumentScanner.this.fScannerMarkupDepth;
                    XMLDocumentScanner.this.setScannerState(1);
                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('?', true)) {
                        int piTarget = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                        if (piTarget == -1) {
                            XMLDocumentScanner.this.abortMarkup(131, 105);
                        } else if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(piTarget))) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                XMLDocumentScanner.this.scanXMLDeclOrTextDecl(false);
                            } else {
                                XMLDocumentScanner.this.abortMarkup(6, 4);
                            }
                        } else {
                            XMLDocumentScanner.this.scanPI(piTarget);
                        }
                        XMLDocumentScanner.this.fDispatcher = new PrologDispatcher();
                        XMLDocumentScanner.this.restoreScannerState(5);
                        return true;
                    }
                    if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('!', true)) {
                        XMLDocumentScanner.this.fDispatcher = new ContentDispatcher();
                        XMLDocumentScanner.this.restoreScannerState(6);
                        return true;
                    }
                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                        if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                            XMLDocumentScanner.this.scanComment();
                            break block20;
                        } else {
                            XMLDocumentScanner.this.abortMarkup(129, 108);
                        }
                        break block20;
                    } else {
                        if (XMLDocumentScanner.this.fEntityReader.skippedString(doctype_string)) {
                            XMLDocumentScanner.this.setScannerState(4);
                            XMLDocumentScanner.this.fSeenDoctypeDecl = true;
                            XMLDocumentScanner.this.scanDoctypeDecl(XMLDocumentScanner.this.fStandalone);
                            --XMLDocumentScanner.this.fScannerMarkupDepth;
                            XMLDocumentScanner.this.fDispatcher = new PrologDispatcher();
                            XMLDocumentScanner.this.restoreScannerState(5);
                            return true;
                        }
                        XMLDocumentScanner.this.abortMarkup(129, 108);
                    }
                    break block20;
                }
                if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                    XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                } else if (!XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(false)) {
                    int invChar = XMLDocumentScanner.this.fEntityReader.scanInvalidChar();
                    if (XMLDocumentScanner.this.fScannerState == 13) {
                        XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
                        XMLDocumentScanner.this.setScannerState(13);
                        return true;
                    }
                    if (invChar >= 0) {
                        String arg = Integer.toHexString(invChar);
                        XMLDocumentScanner.this.reportFatalXMLError(52, 54, arg);
                    }
                } else {
                    XMLDocumentScanner.this.reportFatalXMLError(129, 108);
                    XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(true);
                }
            }
            XMLDocumentScanner.this.fDispatcher = new PrologDispatcher();
            XMLDocumentScanner.this.restoreScannerState(5);
            return true;
        }

        public void endOfInput(int entityName, boolean moreToFollow) throws Exception {
            switch (XMLDocumentScanner.this.fScannerState) {
                case 0: 
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    if (!moreToFollow) {
                        XMLDocumentScanner.this.reportFatalXMLError(163, 133);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(162, 68);
                    break;
                }
                case 3: {
                    if (!moreToFollow) {
                        XMLDocumentScanner.this.reportFatalXMLError(164, 134);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(165, 68);
                    break;
                }
                default: {
                    throw new RuntimeException("FWK001 1] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "1\t" + XMLDocumentScanner.this.fScannerState);
                }
            }
            if (!moreToFollow) {
                XMLDocumentScanner.this.reportFatalXMLError(134, 107);
                XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
                XMLDocumentScanner.this.setScannerState(13);
            }
        }
    }
}

