/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.framework;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLDocumentScanner;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.readers.XMLDeclRecognizer;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.ChunkyCharArray;
import org.apache.xerces.utils.ImplementationMessages;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLMessageProvider;
import org.apache.xerces.utils.XMLMessages;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.GrammarResolverImpl;
import org.apache.xerces.validators.common.XMLValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.schema.SchemaMessageProvider;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public abstract class XMLParser
implements XMLErrorReporter,
XMLDocumentHandler.DTDHandler {
    protected static final String SAX2_FEATURES_PREFIX = "http://xml.org/sax/features/";
    protected static final String SAX2_PROPERTIES_PREFIX = "http://xml.org/sax/properties/";
    protected static final String XERCES_FEATURES_PREFIX = "http://apache.org/xml/features/";
    protected static final String XERCES_PROPERTIES_PREFIX = "http://apache.org/xml/properties/";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://xml.org/sax/features/namespaces", "http://apache.org/xml/features/validation/schema", "http://apache.org/xml/features/validation/schema-full-checking", "http://apache.org/xml/features/validation/dynamic", "http://apache.org/xml/features/validation/default-attribute-values", "http://apache.org/xml/features/validation/validate-content-models", "http://apache.org/xml/features/validation/validate-datatypes", "http://apache.org/xml/features/validation/warn-on-duplicate-attdef", "http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/continue-after-fatal-error", "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", "http://apache.org/xml/features/nonvalidating/load-external-dtd"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://xml.org/sax/properties/xml-string", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation"};
    private static final boolean PRINT_EXCEPTION_STACK_TRACE = false;
    protected GrammarResolver fGrammarResolver = null;
    protected boolean fParseInProgress = false;
    private boolean fNeedReset = false;
    private boolean fContinueAfterFatalError = false;
    private ErrorHandler fErrorHandler = null;
    private Locale fLocale = null;
    private static XMLMessageProvider fgXMLMessages = new XMLMessages();
    private static XMLMessageProvider fgImplementationMessages = new ImplementationMessages();
    private static XMLMessageProvider fgSchemaMessages = new SchemaMessageProvider();
    private static XMLMessageProvider fgDatatypeMessages = new DatatypeMessageProvider();
    protected StringPool fStringPool = null;
    protected XMLErrorReporter fErrorReporter = null;
    protected DefaultEntityHandler fEntityHandler = null;
    protected XMLDocumentScanner fScanner = null;
    protected XMLValidator fValidator = null;

    protected XMLParser() {
        this(new StringPool());
    }

    protected XMLParser(StringPool stringPool) {
        this.fStringPool = stringPool;
        this.fErrorReporter = this;
        this.fEntityHandler = new DefaultEntityHandler(this.fStringPool, this.fErrorReporter);
        this.fScanner = new XMLDocumentScanner(this.fStringPool, this.fErrorReporter, this.fEntityHandler, new ChunkyCharArray(this.fStringPool));
        this.fValidator = new XMLValidator(this.fStringPool, this.fErrorReporter, this.fEntityHandler, this.fScanner);
        this.fGrammarResolver = new GrammarResolverImpl();
        this.fScanner.setGrammarResolver(this.fGrammarResolver);
        this.fValidator.setGrammarResolver(this.fGrammarResolver);
        try {
            this.setNamespaces(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initHandlers(boolean sendCharDataAsCharArray, XMLDocumentHandler docHandler, XMLDocumentHandler.DTDHandler dtdHandler) {
        this.fValidator.initHandlers(sendCharDataAsCharArray, docHandler, dtdHandler);
        this.fScanner.setDTDHandler(this);
    }

    public String[] getFeaturesRecognized() {
        return RECOGNIZED_FEATURES;
    }

    public boolean isFeatureRecognized(String featureId) {
        String[] recognizedFeatures = this.getFeaturesRecognized();
        int i = 0;
        while (i < recognizedFeatures.length) {
            if (featureId.equals(recognizedFeatures[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getPropertiesRecognized() {
        return RECOGNIZED_PROPERTIES;
    }

    public boolean isPropertyRecognized(String propertyId) {
        String[] recognizedProperties = this.getPropertiesRecognized();
        int i = 0;
        while (i < recognizedProperties.length) {
            if (propertyId.equals(recognizedProperties[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean parseSomeSetup(InputSource source) throws Exception {
        if (this.fNeedReset) {
            this.resetOrCopy();
        }
        this.fParseInProgress = true;
        this.fNeedReset = true;
        return this.fEntityHandler.startReadingFromDocument(source);
    }

    public boolean parseSome() throws Exception {
        if (!this.fScanner.parseSome(false)) {
            this.fParseInProgress = false;
            return false;
        }
        return true;
    }

    public void reset() throws Exception {
        this.fGrammarResolver.clearGrammarResolver();
        this.fStringPool.reset();
        this.fEntityHandler.reset(this.fStringPool);
        this.fScanner.reset(this.fStringPool, new ChunkyCharArray(this.fStringPool));
        this.fValidator.reset(this.fStringPool);
        this.fNeedReset = false;
    }

    public final Locator getLocator() {
        return this.fEntityHandler;
    }

    public final Locale getfLocale() {
        return this.fLocale;
    }

    public final XMLMessageProvider getfgXMLMessages() {
        return fgXMLMessages;
    }

    public final XMLMessageProvider getfgImplementationMessages() {
        return fgImplementationMessages;
    }

    public final XMLMessageProvider getfgSchemaMessages() {
        return fgSchemaMessages;
    }

    public final XMLMessageProvider getfgDatatypeMessages() {
        return fgDatatypeMessages;
    }

    public void setReaderFactory(XMLEntityReaderFactory readerFactory) {
        this.fEntityHandler.setReaderFactory(readerFactory);
    }

    public void addRecognizer(XMLDeclRecognizer recognizer) {
        this.fEntityHandler.addRecognizer(recognizer);
    }

    protected void setValidation(boolean validate) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR004 Cannot setFeature(http://xml.org/sax/features/validation): parse is in progress.\nhttp://xml.org/sax/features/validation");
        }
        try {
            this.fScanner.setValidationEnabled(validate);
            this.fValidator.setValidationEnabled(validate);
        }
        catch (Exception ex) {
            throw new SAXNotSupportedException(ex.getMessage());
        }
    }

    protected boolean getValidation() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getValidationEnabled();
    }

    protected void setExternalGeneralEntities(boolean expand) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR004 Cannot setFeature(http://xml.org/sax/features/external-general-entities): parse is in progress.\nhttp://xml.org/sax/features/external-general-entities");
        }
        if (!expand) {
            throw new SAXNotSupportedException("http://xml.org/sax/features/external-general-entities");
        }
    }

    protected boolean getExternalGeneralEntities() throws SAXNotRecognizedException, SAXNotSupportedException {
        return true;
    }

    protected void setExternalParameterEntities(boolean expand) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR004 Cannot setFeature(http://xml.org/sax/features/external-general-entities): parse is in progress.\nhttp://xml.org/sax/features/external-general-entities");
        }
        if (!expand) {
            throw new SAXNotSupportedException("http://xml.org/sax/features/external-parameter-entities");
        }
    }

    protected boolean getExternalParameterEntities() throws SAXNotRecognizedException, SAXNotSupportedException {
        return true;
    }

    protected void setNamespaces(boolean process) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR004 Cannot setFeature(http://xml.org/sax/features/namespaces): parse is in progress.\nhttp://xml.org/sax/features/namespaces");
        }
        this.fScanner.setNamespacesEnabled(process);
        this.fValidator.setNamespacesEnabled(process);
    }

    protected boolean getNamespaces() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getNamespacesEnabled();
    }

    protected void setValidationSchema(boolean schema) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/features/validation/schema: parse is in progress");
        }
        this.fValidator.setSchemaValidationEnabled(schema);
    }

    protected boolean getValidationSchema() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getSchemaValidationEnabled();
    }

    protected void setValidationSchemaFullChecking(boolean schemaFullChecking) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/features/validation/schema-full-checking:  parse is in progress");
        }
        this.fValidator.setSchemaFullCheckingEnabled(schemaFullChecking);
    }

    protected void setNormalizeContents(boolean normalize) {
        this.fValidator.setNormalizeContents(normalize);
    }

    protected boolean getNormalizeContents() {
        return this.fValidator.getNormalizeConents();
    }

    protected void setExternalSchemaLocation(Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/properties/validation/schema/external-schemaLocation:  parse is in progress");
        }
        this.fValidator.setExternalSchemas(value);
    }

    protected void setExternalNoNamespaceSchemaLocation(Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation:  parse is in progress");
        }
        this.fValidator.setExternalNoNamespaceSchema(value);
    }

    protected boolean getValidationSchemaFullChecking() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getSchemaFullCheckingEnabled();
    }

    protected void setValidationDynamic(boolean dynamic) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/features/validation/dynamic: parse is in progress");
        }
        try {
            this.fValidator.setDynamicValidationEnabled(dynamic);
        }
        catch (Exception ex) {
            throw new SAXNotSupportedException(ex.getMessage());
        }
    }

    protected boolean getValidationDynamic() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getDynamicValidationEnabled();
    }

    protected void setNormalizeAttributeValues(boolean normalize) {
        this.fValidator.setNormalizeAttributeValues(normalize);
    }

    protected void setLoadDTDGrammar(boolean loadDTDGrammar) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/features/nonvalidating/load-dtd-grammar: parse is in progress");
        }
        try {
            this.fValidator.setLoadDTDGrammar(loadDTDGrammar);
        }
        catch (Exception ex) {
            throw new SAXNotSupportedException(ex.getMessage());
        }
    }

    protected boolean getLoadDTDGrammar() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getLoadDTDGrammar();
    }

    protected void setLoadExternalDTD(boolean loadExternalDTD) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/features/nonvalidating/load-external-dtd: parse is in progress");
        }
        try {
            this.fScanner.setLoadExternalDTD(loadExternalDTD);
        }
        catch (Exception ex) {
            throw new SAXNotSupportedException(ex.getMessage());
        }
    }

    protected boolean getLoadExternalDTD() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fScanner.getLoadExternalDTD();
    }

    protected void setValidationWarnOnDuplicateAttdef(boolean warn) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fValidator.setWarningOnDuplicateAttDef(warn);
    }

    protected boolean getValidationWarnOnDuplicateAttdef() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getWarningOnDuplicateAttDef();
    }

    protected void setValidationWarnOnUndeclaredElemdef(boolean warn) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fValidator.setWarningOnUndeclaredElements(warn);
    }

    protected boolean getValidationWarnOnUndeclaredElemdef() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getWarningOnUndeclaredElements();
    }

    protected void setAllowJavaEncodings(boolean allow) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fEntityHandler.setAllowJavaEncodings(allow);
    }

    protected boolean getAllowJavaEncodings() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fEntityHandler.getAllowJavaEncodings();
    }

    protected void setContinueAfterFatalError(boolean continueAfterFatalError) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fContinueAfterFatalError = continueAfterFatalError;
    }

    protected boolean getContinueAfterFatalError() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fContinueAfterFatalError;
    }

    protected String getXMLString() throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("http://xml.org/sax/properties/xml-string");
    }

    protected void resetOrCopy() throws Exception {
        this.fStringPool = new StringPool();
        this.fEntityHandler.reset(this.fStringPool);
        this.fScanner.reset(this.fStringPool, new ChunkyCharArray(this.fStringPool));
        this.fValidator.resetOrCopy(this.fStringPool);
        this.fNeedReset = false;
        this.fGrammarResolver.clearGrammarResolver();
        this.fScanner.setGrammarResolver(this.fGrammarResolver);
        this.fValidator.setGrammarResolver(this.fGrammarResolver);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.fEntityHandler.setEntityResolver(resolver);
    }

    public EntityResolver getEntityResolver() {
        return this.fEntityHandler.getEntityResolver();
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.fErrorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void parse(InputSource source) throws SAXException, IOException {
        if (this.fParseInProgress) {
            throw new SAXException("FWK005 parse may not be called while parsing.");
        }
        try {
            try {
                if (this.parseSomeSetup(source)) {
                    this.fScanner.parseSome(true);
                }
            }
            catch (SAXException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SAXException(ex);
            }
        }
        finally {
            this.fParseInProgress = false;
        }
    }

    public void parse(String systemId) throws SAXException, IOException {
        InputSource source = new InputSource(systemId);
        try {
            this.parse(source);
        }
        finally {
            try {
                Reader reader = source.getCharacterStream();
                if (reader != null) {
                    reader.close();
                } else {
                    InputStream is = source.getByteStream();
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setLocale(Locale locale) throws SAXException {
        if (this.fParseInProgress) {
            throw new SAXException("FWK006 setLocale may not be called while parsing");
        }
        this.fLocale = locale;
        fgXMLMessages.setLocale(locale);
        fgImplementationMessages.setLocale(locale);
    }

    public void reportError(Locator locator, String errorDomain, int majorCode, int minorCode, Object[] args, int errorType) throws Exception {
        SAXParseException spe;
        if (errorDomain.equals("http://www.w3.org/TR/1998/REC-xml-19980210")) {
            spe = new SAXParseException(fgXMLMessages.createMessage(this.fLocale, majorCode, minorCode, args), locator);
        } else if (errorDomain.equals("http://www.w3.org/TR/1999/REC-xml-names-19990114")) {
            spe = new SAXParseException(fgXMLMessages.createMessage(this.fLocale, majorCode, minorCode, args), locator);
        } else if (errorDomain.equals("http://www.apache.org/xml/xerces.html")) {
            spe = new SAXParseException(fgImplementationMessages.createMessage(this.fLocale, majorCode, minorCode, args), locator);
        } else if (errorDomain.equals("http://www.w3.org/TR/xml-schema-1")) {
            spe = new SAXParseException(fgSchemaMessages.createMessage(this.fLocale, majorCode, minorCode, args), locator);
        } else if (errorDomain.equals("http://www.w3.org/TR/xml-schema-2")) {
            spe = new SAXParseException(fgDatatypeMessages.createMessage(this.fLocale, majorCode, minorCode, args), locator);
        } else {
            throw new RuntimeException("FWK007 Unknown error domain \"" + errorDomain + "\"." + "\n" + errorDomain);
        }
        if (this.fErrorHandler == null) {
            if (errorType == 2 && !this.fContinueAfterFatalError) {
                throw spe;
            }
            return;
        }
        if (errorType == 0) {
            this.fErrorHandler.warning(spe);
        } else if (errorType == 2) {
            this.fErrorHandler.fatalError(spe);
            if (!this.fContinueAfterFatalError) {
                Object[] fatalArgs = new Object[]{spe.getMessage()};
                throw new SAXException(fgImplementationMessages.createMessage(this.fLocale, 16, 0, fatalArgs));
            }
        } else {
            this.fErrorHandler.error(spe);
        }
    }

    public void setFeature(String featureId, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (featureId.startsWith(SAX2_FEATURES_PREFIX)) {
            String feature = featureId.substring(SAX2_FEATURES_PREFIX.length());
            if (feature.equals("validation")) {
                this.setValidation(state);
                return;
            }
            if (feature.equals("external-general-entities")) {
                this.setExternalGeneralEntities(state);
                return;
            }
            if (feature.equals("external-parameter-entities")) {
                this.setExternalParameterEntities(state);
                return;
            }
            if (feature.equals("namespaces")) {
                this.setNamespaces(state);
                return;
            }
        } else if (featureId.startsWith(XERCES_FEATURES_PREFIX)) {
            String feature = featureId.substring(XERCES_FEATURES_PREFIX.length());
            if (feature.equals("validation/schema")) {
                this.setValidationSchema(state);
                return;
            }
            if (feature.equals("validation/schema-full-checking")) {
                this.setValidationSchemaFullChecking(state);
                return;
            }
            if (feature.equals("validation/dynamic")) {
                this.setValidationDynamic(state);
                return;
            }
            if (feature.equals("validation/default-attribute-values")) {
                throw new SAXNotSupportedException(featureId);
            }
            if (feature.equals("schema/expose-normalized-values")) {
                this.setNormalizeContents(state);
                return;
            }
            if (feature.equals("validation/normalize-attribute-values")) {
                this.setNormalizeAttributeValues(state);
            }
            if (feature.equals("validation/validate-content-models")) {
                throw new SAXNotSupportedException(featureId);
            }
            if (feature.equals("nonvalidating/load-dtd-grammar")) {
                this.setLoadDTDGrammar(state);
                return;
            }
            if (feature.equals("nonvalidating/load-external-dtd")) {
                this.setLoadExternalDTD(state);
                return;
            }
            if (feature.equals("validation/validate-datatypes")) {
                throw new SAXNotSupportedException(featureId);
            }
            if (feature.equals("validation/warn-on-duplicate-attdef")) {
                this.setValidationWarnOnDuplicateAttdef(state);
                return;
            }
            if (feature.equals("validation/warn-on-undeclared-elemdef")) {
                this.setValidationWarnOnUndeclaredElemdef(state);
                return;
            }
            if (feature.equals("allow-java-encodings")) {
                this.setAllowJavaEncodings(state);
                return;
            }
            if (feature.equals("continue-after-fatal-error")) {
                this.setContinueAfterFatalError(state);
                return;
            }
        }
        throw new SAXNotRecognizedException(featureId);
    }

    public boolean getFeature(String featureId) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (featureId.startsWith(SAX2_FEATURES_PREFIX)) {
            String feature = featureId.substring(SAX2_FEATURES_PREFIX.length());
            if (feature.equals("validation")) {
                return this.getValidation();
            }
            if (feature.equals("external-general-entities")) {
                return this.getExternalGeneralEntities();
            }
            if (feature.equals("external-parameter-entities")) {
                return this.getExternalParameterEntities();
            }
            if (feature.equals("namespaces")) {
                return this.getNamespaces();
            }
        } else if (featureId.startsWith(XERCES_FEATURES_PREFIX)) {
            String feature = featureId.substring(XERCES_FEATURES_PREFIX.length());
            if (feature.equals("validation/schema")) {
                return this.getValidationSchema();
            }
            if (feature.equals("validation/schema-full-checking")) {
                return this.getValidationSchemaFullChecking();
            }
            if (feature.equals("validation/dynamic")) {
                return this.getValidationDynamic();
            }
            if (feature.equals("validation/default-attribute-values")) {
                throw new SAXNotRecognizedException(featureId);
            }
            if (feature.equals("validation/normalize-element-contents")) {
                return this.getNormalizeContents();
            }
            if (feature.equals("validation/validate-content-models")) {
                throw new SAXNotRecognizedException(featureId);
            }
            if (feature.equals("nonvalidating/load-dtd-grammar")) {
                return this.getLoadDTDGrammar();
            }
            if (feature.equals("nonvalidating/load-external-dtd")) {
                return this.getLoadExternalDTD();
            }
            if (feature.equals("validation/validate-datatypes")) {
                throw new SAXNotRecognizedException(featureId);
            }
            if (feature.equals("validation/warn-on-duplicate-attdef")) {
                return this.getValidationWarnOnDuplicateAttdef();
            }
            if (feature.equals("validation/warn-on-undeclared-elemdef")) {
                return this.getValidationWarnOnUndeclaredElemdef();
            }
            if (feature.equals("allow-java-encodings")) {
                return this.getAllowJavaEncodings();
            }
            if (feature.equals("continue-after-fatal-error")) {
                return this.getContinueAfterFatalError();
            }
        }
        throw new SAXNotRecognizedException(featureId);
    }

    public void setProperty(String propertyId, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        String property;
        if (propertyId.startsWith(SAX2_PROPERTIES_PREFIX) && (property = propertyId.substring(SAX2_PROPERTIES_PREFIX.length())).equals("xml-string")) {
            throw new SAXNotSupportedException(propertyId);
        }
        if (propertyId.startsWith(XERCES_PROPERTIES_PREFIX)) {
            property = propertyId.substring(XERCES_PROPERTIES_PREFIX.length());
            if (property.equals("schema/external-schemaLocation")) {
                this.setExternalSchemaLocation(value);
                return;
            }
            if (property.equals("schema/external-noNamespaceSchemaLocation")) {
                this.setExternalNoNamespaceSchemaLocation(value);
                return;
            }
        }
        throw new SAXNotRecognizedException(propertyId);
    }

    public Object getProperty(String propertyId) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (propertyId.startsWith(SAX2_PROPERTIES_PREFIX)) {
            String property = propertyId.substring(SAX2_PROPERTIES_PREFIX.length());
            if (property.equals("xml-string")) {
                return this.getXMLString();
            }
        } else if (propertyId.startsWith(XERCES_PROPERTIES_PREFIX)) {
            String property = propertyId.substring(XERCES_PROPERTIES_PREFIX.length());
            if (property.equals("schema/external-schemaLocation")) {
                return this.fValidator.getExternalSchemas();
            }
            if (property.equals("schema/external-noNamespaceSchemaLocation")) {
                return this.fValidator.getExternalNoNamespaceSchema();
            }
        }
        throw new SAXNotRecognizedException(propertyId);
    }

    public abstract void unparsedEntityDecl(int var1, int var2, int var3, int var4) throws Exception;

    public abstract void textDecl(int var1, int var2) throws Exception;

    public abstract void startDTD(QName var1, int var2, int var3) throws Exception;

    public abstract void processingInstruction(int var1, int var2) throws Exception;

    public abstract void notationDecl(int var1, int var2, int var3) throws Exception;

    public abstract void internalSubset(int var1) throws Exception;

    public abstract void internalPEDecl(int var1, int var2) throws Exception;

    public abstract void internalEntityDecl(int var1, int var2) throws Exception;

    public abstract void externalPEDecl(int var1, int var2, int var3) throws Exception;

    public abstract void externalEntityDecl(int var1, int var2, int var3) throws Exception;

    public abstract void endDTD() throws Exception;

    public abstract void elementDecl(QName var1, int var2, int var3, XMLContentSpec.Provider var4) throws Exception;

    public abstract void comment(int var1) throws Exception;

    public abstract void attlistDecl(QName var1, QName var2, int var3, boolean var4, String var5, int var6, int var7) throws Exception;
}

