/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLParser;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.schema.XUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DOMParser
extends XMLParser
implements XMLDocumentHandler {
    public static final String DEFAULT_DOCUMENT_CLASS_NAME = "org.apache.xerces.dom.DocumentImpl";
    public static final String DEFAULT_DEFERRED_DOCUMENT_CLASS_NAME = "org.apache.xerces.dom.DeferredDocumentImpl";
    private static final boolean DEBUG_ATTLIST_DECL = false;
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/dom/defer-node-expansion", "http://apache.org/xml/features/dom/create-entity-ref-nodes", "http://apache.org/xml/features/dom/include-ignorable-whitespace", "http://apache.org/xml/features/domx/grammar-access"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/dom/document-class-name", "http://apache.org/xml/properties/dom/current-element-node"};
    protected Document fDocument;
    protected DeferredDocumentImpl fDeferredDocumentImpl;
    protected int fDocumentIndex;
    protected int fDocumentTypeIndex;
    protected int fCurrentNodeIndex;
    protected int fCurrentEntityName;
    protected int fCurrentEntityNode;
    protected DocumentImpl fDocumentImpl;
    protected DocumentType fDocumentType;
    protected Node fCurrentElementNode;
    protected boolean fInDTD;
    protected boolean fWithinElement;
    protected boolean fInCDATA;
    private boolean fGrammarAccess;
    private String fDocumentClassName;
    private boolean fDeferNodeExpansion;
    private boolean fCreateEntityReferenceNodes;
    private boolean fIncludeIgnorableWhitespace;
    protected int fAmpIndex;
    protected int fLtIndex;
    protected int fGtIndex;
    protected int fAposIndex;
    protected int fQuotIndex;
    private boolean fSeenRootElement;
    private boolean fStringPoolInUse;
    private XMLAttrList fAttrList;
    static /* synthetic */ Class class$0;

    public DOMParser() {
        this.initHandlers(false, this, this);
        this.init();
        try {
            this.setDocumentClassName(DEFAULT_DOCUMENT_CLASS_NAME);
            this.setCreateEntityReferenceNodes(true);
            this.setDeferNodeExpansion(true);
            this.setIncludeIgnorableWhitespace(true);
        }
        catch (SAXException e) {
            throw new RuntimeException("PAR001 Fatal error constructing DOMParser.");
        }
    }

    public Document getDocument() {
        return this.fDocument;
    }

    public String[] getFeaturesRecognized() {
        String[] superRecognized = super.getFeaturesRecognized();
        String[] thisRecognized = RECOGNIZED_FEATURES;
        int thisLength = thisRecognized.length;
        if (thisLength == 0) {
            return superRecognized;
        }
        int superLength = superRecognized.length;
        if (superLength == 0) {
            return thisRecognized;
        }
        String[] recognized = new String[superLength + thisLength];
        System.arraycopy(superRecognized, 0, recognized, 0, superLength);
        System.arraycopy(thisRecognized, 0, recognized, superLength, thisLength);
        return recognized;
    }

    public String[] getPropertiesRecognized() {
        String[] superRecognized = super.getPropertiesRecognized();
        String[] thisRecognized = RECOGNIZED_PROPERTIES;
        int thisLength = thisRecognized.length;
        if (thisLength == 0) {
            return superRecognized;
        }
        int superLength = superRecognized.length;
        if (superLength == 0) {
            return thisRecognized;
        }
        String[] recognized = new String[superLength + thisLength];
        System.arraycopy(superRecognized, 0, recognized, 0, superLength);
        System.arraycopy(thisRecognized, 0, recognized, superLength, thisLength);
        return recognized;
    }

    public void reset() throws Exception {
        if (this.fStringPoolInUse) {
            this.fStringPool = new StringPool();
            this.fStringPoolInUse = false;
        }
        super.reset();
        this.init();
    }

    public void resetOrCopy() throws Exception {
        super.resetOrCopy();
        this.init();
    }

    protected void init() {
        this.fDocument = null;
        this.fDeferredDocumentImpl = null;
        this.fDocumentIndex = -1;
        this.fDocumentTypeIndex = -1;
        this.fCurrentNodeIndex = -1;
        this.fCurrentEntityNode = -1;
        this.fCurrentEntityName = -1;
        this.fDocumentImpl = null;
        this.fDocumentType = null;
        this.fCurrentElementNode = null;
        this.fInDTD = false;
        this.fWithinElement = false;
        this.fInCDATA = false;
        this.fAmpIndex = this.fStringPool.addSymbol("amp");
        this.fLtIndex = this.fStringPool.addSymbol("lt");
        this.fGtIndex = this.fStringPool.addSymbol("gt");
        this.fAposIndex = this.fStringPool.addSymbol("apos");
        this.fQuotIndex = this.fStringPool.addSymbol("quot");
        this.fSeenRootElement = false;
        this.fStringPoolInUse = false;
        this.fAttrList = new XMLAttrList(this.fStringPool);
    }

    protected void setDeferNodeExpansion(boolean deferNodeExpansion) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fDeferNodeExpansion = deferNodeExpansion;
    }

    protected boolean getDeferNodeExpansion() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fDeferNodeExpansion;
    }

    protected void setCreateEntityReferenceNodes(boolean create) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fCreateEntityReferenceNodes = create;
    }

    public boolean getCreateEntityReferenceNodes() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fCreateEntityReferenceNodes;
    }

    public void setIncludeIgnorableWhitespace(boolean include) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fIncludeIgnorableWhitespace = include;
    }

    public boolean getIncludeIgnorableWhitespace() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fIncludeIgnorableWhitespace;
    }

    protected void setDocumentClassName(String documentClassName) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (documentClassName == null) {
            documentClassName = DEFAULT_DOCUMENT_CLASS_NAME;
        }
        try {
            Class<?> _class = Class.forName(documentClassName);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.w3c.dom.Document");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(_class)) {
                throw new IllegalArgumentException("PAR002 Class, \"" + documentClassName + "\", is not of type org.w3c.dom.Document." + "\n" + documentClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("PAR003 Class, \"" + documentClassName + "\", not found." + "\n" + documentClassName);
        }
        this.fDocumentClassName = documentClassName;
        if (!documentClassName.equals(DEFAULT_DOCUMENT_CLASS_NAME)) {
            this.setDeferNodeExpansion(false);
        }
    }

    protected String getDocumentClassName() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fDocumentClassName;
    }

    protected Element getCurrentElementNode() throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fCurrentElementNode != null && this.fCurrentElementNode.getNodeType() == 1) {
            return (Element)this.fCurrentElementNode;
        }
        return null;
    }

    public void setFeature(String featureId, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!featureId.startsWith("http://xml.org/sax/features/") && featureId.startsWith("http://apache.org/xml/features/")) {
            String feature = featureId.substring("http://apache.org/xml/features/".length());
            if (feature.equals("dom/defer-node-expansion")) {
                if (this.fParseInProgress) {
                    throw new SAXNotSupportedException("PAR004 Cannot setFeature(" + featureId + "): parse is in progress." + "\n" + featureId);
                }
                this.setDeferNodeExpansion(state);
                return;
            }
            if (feature.equals("dom/create-entity-ref-nodes")) {
                this.setCreateEntityReferenceNodes(state);
                return;
            }
            if (feature.equals("dom/include-ignorable-whitespace")) {
                this.setIncludeIgnorableWhitespace(state);
                return;
            }
            if (feature.equals("domx/grammar-access")) {
                this.fGrammarAccess = state;
                return;
            }
        }
        super.setFeature(featureId, state);
    }

    public boolean getFeature(String featureId) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!featureId.startsWith("http://xml.org/sax/features/") && featureId.startsWith("http://apache.org/xml/features/")) {
            String feature = featureId.substring("http://apache.org/xml/features/".length());
            if (feature.equals("dom/defer-node-expansion")) {
                return this.getDeferNodeExpansion();
            }
            if (feature.equals("dom/create-entity-ref-nodes")) {
                return this.getCreateEntityReferenceNodes();
            }
            if (feature.equals("dom/include-ignorable-whitespace")) {
                return this.getIncludeIgnorableWhitespace();
            }
            if (feature.equals("domx/grammar-access")) {
                return this.fGrammarAccess;
            }
        }
        return super.getFeature(featureId);
    }

    public void setProperty(String propertyId, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            String property = propertyId.substring("http://apache.org/xml/properties/".length());
            if (property.equals("dom/current-element-node")) {
                throw new SAXNotSupportedException("PAR005 Property, \"" + propertyId + "\" is read-only.\n" + propertyId);
            }
            if (property.equals("dom/document-class-name")) {
                if (value != null && !(value instanceof String)) {
                    throw new SAXNotSupportedException("PAR006 Property value must be of type java.lang.String.");
                }
                this.setDocumentClassName((String)value);
                return;
            }
        }
        super.setProperty(propertyId, value);
    }

    public Object getProperty(String propertyId) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            String property = propertyId.substring("http://apache.org/xml/properties/".length());
            if (property.equals("dom/current-element-node")) {
                boolean throwException = false;
                try {
                    throwException = this.getFeature("http://apache.org/xml/features/dom/defer-node-expansion");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
                if (throwException) {
                    throw new SAXNotSupportedException("PAR007 Current element node cannot be queried when node expansion is deferred.");
                }
                return this.getCurrentElementNode();
            }
            if (property.equals("dom/document-class-name")) {
                return this.getDocumentClassName();
            }
        }
        return super.getProperty(propertyId);
    }

    public void startDocument() {
        block14: {
            String documentClassName = null;
            try {
                documentClassName = this.getDocumentClassName();
            }
            catch (SAXException e) {
                throw new RuntimeException("PAR008 Fatal error getting document factory.");
            }
            boolean deferNodeExpansion = true;
            try {
                deferNodeExpansion = this.getDeferNodeExpansion();
            }
            catch (SAXException e) {
                throw new RuntimeException("PAR009 Fatal error reading expansion mode.");
            }
            try {
                boolean isDocumentImpl = this.fDocumentClassName.equals(DEFAULT_DOCUMENT_CLASS_NAME);
                boolean isDeferredImpl = this.fDocumentClassName.equals(DEFAULT_DEFERRED_DOCUMENT_CLASS_NAME);
                if (deferNodeExpansion && (isDocumentImpl || isDeferredImpl)) {
                    boolean nsEnabled = false;
                    try {
                        nsEnabled = this.getNamespaces();
                    }
                    catch (SAXException sAXException) {
                        // empty catch block
                    }
                    this.fDeferredDocumentImpl = new DeferredDocumentImpl(this.fStringPool, nsEnabled, this.fGrammarAccess);
                    this.fStringPoolInUse = true;
                    this.fDocument = this.fDeferredDocumentImpl;
                    this.fCurrentNodeIndex = this.fDocumentIndex = this.fDeferredDocumentImpl.createDocument();
                    break block14;
                }
                if (isDocumentImpl) {
                    this.fDocumentImpl = new DocumentImpl(this.fGrammarAccess);
                    this.fDocument = this.fDocumentImpl;
                    this.fDocumentImpl.setErrorChecking(false);
                } else {
                    Class<?> documentClass = Class.forName(documentClassName);
                    try {
                        this.fDocument = (Document)documentClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create document object of class: " + documentClassName);
                    }
                    Class<?> defaultDocClass = Class.forName(DEFAULT_DOCUMENT_CLASS_NAME);
                    if (defaultDocClass.isAssignableFrom(documentClass)) {
                        this.fDocumentImpl = (DocumentImpl)this.fDocument;
                        this.fDocumentImpl.setErrorChecking(false);
                    }
                }
                this.fCurrentElementNode = this.fDocument;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(documentClassName);
            }
        }
    }

    public void endDocument() throws Exception {
        if (this.fDocumentImpl != null) {
            this.fDocumentImpl.setErrorChecking(true);
            if (this.fDocumentType != null) {
                ((DocumentTypeImpl)this.fDocumentType).setReadOnly(true, false);
            }
        }
    }

    public void xmlDecl(int versionIndex, int encodingIndex, int standaloneIndex) throws Exception {
        boolean standalone;
        boolean bl = standaloneIndex != -1 ? this.fStringPool.toString(standaloneIndex).equals("yes") : (standalone = false);
        if (this.fDocumentImpl != null) {
            this.fDocumentImpl.setVersion(this.fStringPool.toString(versionIndex));
            this.fDocumentImpl.setEncoding(this.fStringPool.toString(encodingIndex));
            this.fDocumentImpl.setStandalone(standalone);
        } else if (this.fDeferredDocumentImpl != null) {
            this.fDeferredDocumentImpl.setVersion(this.fStringPool.toString(versionIndex));
            this.fDeferredDocumentImpl.setEncoding(this.fStringPool.toString(encodingIndex));
            this.fDeferredDocumentImpl.setStandalone(standalone);
        }
    }

    public void textDecl(int versionIndex, int encodingIndex) throws Exception {
        EntityImpl entityNode;
        NamedNodeMap entities;
        if (this.fDeferredDocumentImpl != null) {
            String name = this.fStringPool.toString(this.fCurrentEntityName);
            if (this.fDocumentTypeIndex != -1 && name != null) {
                int entityDecl = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
                while (entityDecl != -1) {
                    if (this.fDeferredDocumentImpl.getNodeType(entityDecl, false) == 6 && this.fDeferredDocumentImpl.getNodeNameString(entityDecl, false).equals(name)) break;
                    entityDecl = this.fDeferredDocumentImpl.getPrevSibling(entityDecl, false);
                }
                this.fCurrentEntityNode = entityDecl;
                this.fDeferredDocumentImpl.setEntityInfo(entityDecl, versionIndex, encodingIndex);
            }
        } else if (this.fDocumentImpl != null && (entities = this.fDocumentType.getEntities()) != null && (entityNode = (EntityImpl)entities.getNamedItem(this.fCurrentElementNode.getNodeName())) != null) {
            entityNode.setVersion(this.fStringPool.toString(versionIndex));
            entityNode.setEncoding(this.fStringPool.toString(encodingIndex));
        }
    }

    public void startNamespaceDeclScope(int prefix, int uri) throws Exception {
    }

    public void endNamespaceDeclScope(int prefix) throws Exception {
    }

    public void startElement(QName elementQName, XMLAttrList xmlAttrList, int attrListIndex) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            if (!this.fSeenRootElement) {
                this.fSeenRootElement = true;
                if (this.fGrammarAccess && this.fGrammarResolver.size() > 0) {
                    Enumeration schemas;
                    Document schemaDocument;
                    if (this.fDocumentTypeIndex == -1) {
                        this.fDocumentTypeIndex = this.fDeferredDocumentImpl.createDocumentType(elementQName.rawname, -1, -1);
                        this.fDeferredDocumentImpl.appendChild(0, this.fDocumentTypeIndex);
                    }
                    if ((schemaDocument = this.fGrammarResolver.getGrammar((String)(schemas = this.fGrammarResolver.nameSpaceKeys()).nextElement()).getGrammarDocument()) != null) {
                        Element schema = schemaDocument.getDocumentElement();
                        this.copyInto(schema, this.fDocumentTypeIndex);
                    }
                }
            }
            int element = this.fDeferredDocumentImpl.createElement(elementQName.rawname, elementQName.uri, xmlAttrList, attrListIndex);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, element);
            this.fCurrentNodeIndex = element;
            this.fWithinElement = true;
            int index = xmlAttrList.getFirstAttr(attrListIndex);
            while (index != -1) {
                if (xmlAttrList.getAttType(index) == this.fStringPool.addSymbol("ID")) {
                    int nameIndex = xmlAttrList.getAttValue(index);
                    this.fDeferredDocumentImpl.putIdentifier(nameIndex, element);
                }
                index = xmlAttrList.getNextAttr(index);
            }
        } else {
            Element e;
            boolean nsEnabled = false;
            try {
                nsEnabled = this.getNamespaces();
            }
            catch (SAXException index) {
                // empty catch block
            }
            String elementName = this.fStringPool.toString(elementQName.rawname);
            if (!this.fSeenRootElement) {
                this.fSeenRootElement = true;
                if (this.fDocumentImpl != null && this.fGrammarAccess && this.fGrammarResolver.size() > 0) {
                    Enumeration schemas;
                    Document schemaDocument;
                    if (this.fDocumentType == null) {
                        String rootName = elementName;
                        String systemId = "";
                        String publicId = "";
                        this.fDocumentType = this.fDocumentImpl.createDocumentType(rootName, publicId, systemId);
                        this.fDocument.appendChild(this.fDocumentType);
                    }
                    if ((schemaDocument = this.fGrammarResolver.getGrammar((String)(schemas = this.fGrammarResolver.nameSpaceKeys()).nextElement()).getGrammarDocument()) != null) {
                        Element schema = schemaDocument.getDocumentElement();
                        XUtil.copyInto(schema, this.fDocumentType);
                    }
                }
            }
            if (nsEnabled) {
                String namespaceURI = this.fStringPool.toString(elementQName.uri);
                if (namespaceURI.length() == 0) {
                    namespaceURI = null;
                }
                e = this.fDocument.createElementNS(namespaceURI, elementName);
            } else {
                e = this.fDocument.createElement(elementName);
            }
            int attrHandle = xmlAttrList.getFirstAttr(attrListIndex);
            while (attrHandle != -1) {
                int attName = xmlAttrList.getAttrName(attrHandle);
                String attrName = this.fStringPool.toString(attName);
                String attrValue = this.fStringPool.toString(xmlAttrList.getAttValue(attrHandle));
                if (nsEnabled) {
                    int nsURIIndex = xmlAttrList.getAttrURI(attrHandle);
                    String namespaceURI = this.fStringPool.toString(nsURIIndex);
                    int prefixIndex = xmlAttrList.getAttrPrefix(attrHandle);
                    String prefix = this.fStringPool.toString(prefixIndex);
                    if (namespaceURI.length() == 0) {
                        namespaceURI = null;
                    }
                    if (namespaceURI == null) {
                        if (prefix != null) {
                            if (prefix.equals("xmlns")) {
                                namespaceURI = "http://www.w3.org/2000/xmlns/";
                            }
                        } else if (attrName.equals("xmlns")) {
                            namespaceURI = "http://www.w3.org/2000/xmlns/";
                        }
                    }
                    e.setAttributeNS(namespaceURI, attrName, attrValue);
                } else {
                    e.setAttribute(attrName, attrValue);
                }
                if (this.fDocumentImpl != null && !xmlAttrList.isSpecified(attrHandle)) {
                    ((AttrImpl)e.getAttributeNode(attrName)).setSpecified(false);
                }
                attrHandle = xmlAttrList.getNextAttr(attrHandle);
            }
            this.fCurrentElementNode.appendChild(e);
            this.fCurrentElementNode = e;
            this.fWithinElement = true;
            if (this.fDocumentImpl != null) {
                int index = xmlAttrList.getFirstAttr(attrListIndex);
                while (index != -1) {
                    if (xmlAttrList.getAttType(index) == this.fStringPool.addSymbol("ID")) {
                        String name = this.fStringPool.toString(xmlAttrList.getAttValue(index));
                        this.fDocumentImpl.putIdentifier(name, e);
                    }
                    index = xmlAttrList.getNextAttr(index);
                }
            }
            xmlAttrList.releaseAttrList(attrListIndex);
        }
    }

    public void endElement(QName elementQName) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(this.fCurrentNodeIndex, false);
            this.fWithinElement = false;
        } else {
            this.fCurrentElementNode = this.fCurrentElementNode.getParentNode();
            this.fWithinElement = false;
        }
    }

    public void characters(int dataIndex) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int text = this.fInCDATA ? this.fDeferredDocumentImpl.createCDATASection(dataIndex, false) : this.fDeferredDocumentImpl.createTextNode(dataIndex, false);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, text);
        } else {
            Text text;
            if (this.fInCDATA) {
                text = this.fDocument.createCDATASection(this.fStringPool.orphanString(dataIndex));
            } else {
                Node lastChild;
                if (this.fWithinElement && this.fCurrentElementNode.getNodeType() == 1 && (lastChild = this.fCurrentElementNode.getLastChild()) != null && lastChild.getNodeType() == 3) {
                    ((Text)lastChild).appendData(this.fStringPool.orphanString(dataIndex));
                    return;
                }
                text = this.fDocument.createTextNode(this.fStringPool.orphanString(dataIndex));
            }
            this.fCurrentElementNode.appendChild(text);
        }
    }

    public void ignorableWhitespace(int dataIndex) throws Exception {
        if (!this.fIncludeIgnorableWhitespace) {
            this.fStringPool.orphanString(dataIndex);
            return;
        }
        if (this.fDeferredDocumentImpl != null) {
            int text = this.fInCDATA ? this.fDeferredDocumentImpl.createCDATASection(dataIndex, true) : this.fDeferredDocumentImpl.createTextNode(dataIndex, true);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, text);
        } else {
            Text text;
            if (this.fInCDATA) {
                text = this.fDocument.createCDATASection(this.fStringPool.orphanString(dataIndex));
            } else {
                Node lastChild;
                if (this.fWithinElement && this.fCurrentElementNode.getNodeType() == 1 && (lastChild = this.fCurrentElementNode.getLastChild()) != null && lastChild.getNodeType() == 3) {
                    ((Text)lastChild).appendData(this.fStringPool.orphanString(dataIndex));
                    return;
                }
                text = this.fDocument.createTextNode(this.fStringPool.orphanString(dataIndex));
            }
            if (this.fDocumentImpl != null) {
                ((TextImpl)text).setIgnorableWhitespace(true);
            }
            this.fCurrentElementNode.appendChild(text);
        }
    }

    public void processingInstruction(int targetIndex, int dataIndex) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int pi = this.fDeferredDocumentImpl.createProcessingInstruction(targetIndex, dataIndex);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, pi);
        } else {
            String target = this.fStringPool.orphanString(targetIndex);
            String data = this.fStringPool.orphanString(dataIndex);
            ProcessingInstruction pi = this.fDocument.createProcessingInstruction(target, data);
            this.fCurrentElementNode.appendChild(pi);
        }
    }

    public void comment(int dataIndex) throws Exception {
        if (this.fInDTD && !this.fGrammarAccess) {
            this.fStringPool.orphanString(dataIndex);
        } else if (this.fDeferredDocumentImpl != null) {
            int comment = this.fDeferredDocumentImpl.createComment(dataIndex);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, comment);
        } else {
            Comment comment = this.fDocument.createComment(this.fStringPool.orphanString(dataIndex));
            this.fCurrentElementNode.appendChild(comment);
        }
    }

    public void characters(char[] ch, int start, int length) throws Exception {
        this.characters(this.fStringPool.addSymbol(new String(ch, start, length)));
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws Exception {
    }

    public void startCDATA() throws Exception {
        this.fInCDATA = true;
    }

    public void endCDATA() throws Exception {
        this.fInCDATA = false;
    }

    public void startEntityReference(int entityName, int entityType, int entityContext) throws Exception {
        this.fCurrentEntityName = entityName;
        if (!this.fCreateEntityReferenceNodes) {
            return;
        }
        if (entityName == this.fAmpIndex || entityName == this.fGtIndex || entityName == this.fLtIndex || entityName == this.fAposIndex || entityName == this.fQuotIndex) {
            return;
        }
        if (entityContext != 2) {
            return;
        }
        if (this.fDeferredDocumentImpl != null) {
            int entityRefIndex = this.fDeferredDocumentImpl.createEntityReference(entityName);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, entityRefIndex);
            this.fCurrentNodeIndex = entityRefIndex;
        } else {
            EntityReference er = this.fDocument.createEntityReference(this.fStringPool.toString(entityName));
            this.fCurrentElementNode.appendChild(er);
            this.fCurrentElementNode = er;
        }
    }

    public void endEntityReference(int entityName, int entityType, int entityContext) throws Exception {
        if (!this.fCreateEntityReferenceNodes) {
            return;
        }
        if (entityName == this.fAmpIndex || entityName == this.fGtIndex || entityName == this.fLtIndex || entityName == this.fAposIndex || entityName == this.fQuotIndex) {
            return;
        }
        if (entityContext != 2) {
            return;
        }
        if (this.fDeferredDocumentImpl != null) {
            String name = this.fStringPool.toString(entityName);
            int erChild = this.fCurrentNodeIndex;
            this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(erChild, false);
            if (this.fDeferredDocumentImpl.getNodeType(erChild, false) != 5) {
                return;
            }
            erChild = this.fDeferredDocumentImpl.getLastChild(erChild, false);
            if (this.fDocumentTypeIndex != -1) {
                if (this.fCurrentEntityNode == -1) {
                    int entityDecl = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
                    while (entityDecl != -1) {
                        if (this.fDeferredDocumentImpl.getNodeType(entityDecl, false) == 6 && this.fDeferredDocumentImpl.getNodeNameString(entityDecl, false).equals(name)) break;
                        entityDecl = this.fDeferredDocumentImpl.getPrevSibling(entityDecl, false);
                    }
                    this.fCurrentEntityNode = entityDecl;
                }
                if (this.fCurrentEntityNode != -1 && this.fDeferredDocumentImpl.getLastChild(this.fCurrentEntityNode, false) == -1) {
                    this.fDeferredDocumentImpl.setAsLastChild(this.fCurrentEntityNode, erChild);
                }
                this.fCurrentEntityNode = -1;
                this.fCurrentEntityName = -1;
            }
        } else {
            Node erNode = this.fCurrentElementNode;
            this.fCurrentElementNode = erNode.getParentNode();
            if (this.fDocumentImpl != null) {
                String name;
                NamedNodeMap entities = this.fDocumentType.getEntities();
                Node entityNode = entities.getNamedItem(name = this.fStringPool.toString(entityName));
                if (entityNode == null || entityNode.hasChildNodes()) {
                    return;
                }
                EntityImpl entity = (EntityImpl)entityNode;
                Node child = erNode.getFirstChild();
                while (child != null) {
                    Node childClone = child.cloneNode(true);
                    entity.appendChild(childClone);
                    child = child.getNextSibling();
                }
            }
        }
    }

    public void startDTD(QName rootElement, int publicId, int systemId) throws Exception {
        this.fInDTD = true;
        if (this.fDocumentImpl != null) {
            String rootElementName = this.fStringPool.toString(rootElement.rawname);
            String publicString = this.fStringPool.toString(publicId);
            String systemString = this.fStringPool.toString(systemId);
            this.fDocumentType = this.fDocumentImpl.createDocumentType(rootElementName, publicString, systemString);
            this.fDocumentImpl.appendChild(this.fDocumentType);
            if (this.fGrammarAccess) {
                Element schema = this.fDocument.createElement("schema");
                schema.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
                ((AttrImpl)schema.getAttributeNode("xmlns")).setSpecified(false);
                schema.setAttribute("finalDefault", "");
                ((AttrImpl)schema.getAttributeNode("finalDefault")).setSpecified(false);
                schema.setAttribute("exactDefault", "");
                ((AttrImpl)schema.getAttributeNode("exactDefault")).setSpecified(false);
                this.fDocumentType.appendChild(schema);
                this.fCurrentElementNode = schema;
            }
        } else if (this.fDeferredDocumentImpl != null) {
            this.fDocumentTypeIndex = this.fDeferredDocumentImpl.createDocumentType(rootElement.rawname, publicId, systemId);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentIndex, this.fDocumentTypeIndex);
            if (this.fGrammarAccess) {
                int handle = this.fAttrList.startAttrList();
                this.fAttrList.addAttr(this.fStringPool.addSymbol("xmlns"), this.fStringPool.addString("http://www.w3.org/2001/XMLSchema"), this.fStringPool.addSymbol("CDATA"), false, false);
                this.fAttrList.addAttr(this.fStringPool.addSymbol("finalDefault"), this.fStringPool.addString(""), this.fStringPool.addSymbol("CDATA"), false, false);
                this.fAttrList.addAttr(this.fStringPool.addSymbol("exactDefault"), this.fStringPool.addString(""), this.fStringPool.addSymbol("CDATA"), false, false);
                this.fAttrList.endAttrList();
                int schemaIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("schema"), this.fAttrList, handle);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, schemaIndex);
                this.fCurrentNodeIndex = schemaIndex;
            }
        }
    }

    public void internalSubset(int internalSubset) {
        if (this.fDocumentImpl != null && this.fDocumentType != null) {
            ((DocumentTypeImpl)this.fDocumentType).setInternalSubset(this.fStringPool.toString(internalSubset));
        } else if (this.fDeferredDocumentImpl != null) {
            this.fDeferredDocumentImpl.setInternalSubset(this.fDocumentTypeIndex, internalSubset);
        }
    }

    public void endDTD() throws Exception {
        this.fInDTD = false;
        if (this.fGrammarAccess) {
            if (this.fDocumentImpl != null) {
                this.fCurrentElementNode = this.fDocumentImpl;
            } else if (this.fDeferredDocumentImpl != null) {
                this.fCurrentNodeIndex = 0;
            }
        }
    }

    public void elementDecl(QName elementDecl, int contentSpecType, int contentSpecIndex, XMLContentSpec.Provider contentSpecProvider) throws Exception {
        block24: {
            block25: {
                int typeIndex;
                String elementName;
                if (!this.fGrammarAccess) break block24;
                if (this.fDeferredDocumentImpl == null) break block25;
                int schemaIndex = this.getLastChildElement(this.fDocumentTypeIndex, "schema");
                int elementIndex = this.getLastChildElement(schemaIndex, "element", "name", elementName = this.fStringPool.toString(elementDecl.rawname));
                if (elementIndex == -1) {
                    int handle = this.fAttrList.startAttrList();
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(elementName), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("1"), this.fStringPool.addSymbol("NMTOKEN"), false, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("nillable"), this.fStringPool.addString("false"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("abstract"), this.fStringPool.addString("false"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("final"), this.fStringPool.addString("false"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                    this.fAttrList.endAttrList();
                    elementIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("element"), this.fAttrList, handle);
                    this.fDeferredDocumentImpl.appendChild(schemaIndex, elementIndex);
                }
                if ((typeIndex = this.getLastChildElement(elementIndex, "complexType")) == -1 && contentSpecType != 2) {
                    typeIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("complexType"), null, -1);
                    this.fDeferredDocumentImpl.insertBefore(elementIndex, typeIndex, this.getFirstChildElement(elementIndex));
                }
                switch (contentSpecType) {
                    case 0: {
                        int attributeIndex = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("content"), this.fStringPool.addString("empty"), true);
                        this.fDeferredDocumentImpl.setAttributeNode(typeIndex, attributeIndex);
                        break;
                    }
                    case 1: {
                        int anyIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("any"), null, -1);
                        this.fDeferredDocumentImpl.insertBefore(typeIndex, anyIndex, this.getFirstChildElement(typeIndex));
                        break;
                    }
                    case 2: {
                        XMLContentSpec contentSpec = new XMLContentSpec();
                        contentSpecProvider.getContentSpec(contentSpecIndex, contentSpec);
                        contentSpecIndex = contentSpec.value;
                        if (contentSpecIndex == -1) {
                            int attributeIndex = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("type"), this.fStringPool.addString("string"), true);
                            this.fDeferredDocumentImpl.setAttributeNode(elementIndex, attributeIndex);
                            break;
                        }
                        if (typeIndex == -1) {
                            typeIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("complexType"), null, -1);
                            this.fDeferredDocumentImpl.insertBefore(elementIndex, typeIndex, this.getFirstChildElement(elementIndex));
                        }
                        int attributeIndex = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("content"), this.fStringPool.addString("mixed"), true);
                        this.fDeferredDocumentImpl.setAttributeNode(typeIndex, attributeIndex);
                        int handle = this.fAttrList.startAttrList();
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("0"), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("unbounded"), this.fStringPool.addSymbol("CDATA"), true, false);
                        this.fAttrList.endAttrList();
                        int choiceIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("choice"), this.fAttrList, handle);
                        this.fDeferredDocumentImpl.appendChild(typeIndex, choiceIndex);
                        while (contentSpecIndex != -1) {
                            contentSpecProvider.getContentSpec(contentSpecIndex, contentSpec);
                            int type = contentSpec.type;
                            int left = contentSpec.value;
                            int right = contentSpec.otherValue;
                            if (type != 0) {
                                contentSpecProvider.getContentSpec(right, contentSpec);
                                handle = this.fAttrList.startAttrList();
                                this.fAttrList.addAttr(this.fStringPool.addSymbol("ref"), this.fStringPool.addString(this.fStringPool.toString(contentSpec.value)), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                                this.fAttrList.endAttrList();
                                int rightIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("element"), this.fAttrList, handle);
                                int refIndex = this.getFirstChildElement(choiceIndex);
                                this.fDeferredDocumentImpl.insertBefore(choiceIndex, rightIndex, refIndex);
                                contentSpecIndex = left;
                                continue;
                            }
                            break block24;
                        }
                        break block24;
                    }
                    case 4: {
                        int attributeIndex = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("content"), this.fStringPool.addString("elementOnly"), true);
                        this.fDeferredDocumentImpl.setAttributeNode(typeIndex, attributeIndex);
                        int children = this.createChildren(contentSpecProvider, contentSpecIndex, new XMLContentSpec(), this.fDeferredDocumentImpl, -1);
                        this.fDeferredDocumentImpl.insertBefore(typeIndex, children, this.getFirstChildElement(typeIndex));
                    }
                }
                break block24;
            }
            if (this.fDocumentImpl != null) {
                Element type;
                String elementName;
                Element schema = XUtil.getLastChildElement((Node)this.fDocumentType, "schema");
                Element element = XUtil.getLastChildElement(schema, "element", "name", elementName = this.fStringPool.toString(elementDecl.rawname));
                if (element == null) {
                    element = this.fDocumentImpl.createElement("element");
                    element.setAttribute("name", elementName);
                    element.setAttribute("minOccurs", "1");
                    ((AttrImpl)element.getAttributeNode("minOccurs")).setSpecified(false);
                    element.setAttribute("nillable", "false");
                    ((AttrImpl)element.getAttributeNode("nillable")).setSpecified(false);
                    element.setAttribute("abstract", "false");
                    ((AttrImpl)element.getAttributeNode("abstract")).setSpecified(false);
                    element.setAttribute("final", "false");
                    ((AttrImpl)element.getAttributeNode("final")).setSpecified(false);
                    schema.appendChild(element);
                }
                if ((type = XUtil.getLastChildElement((Node)element, "complexType")) == null && contentSpecType != 2) {
                    type = this.fDocumentImpl.createElement("complexType");
                    element.insertBefore(type, XUtil.getFirstChildElement(element));
                }
                block6 : switch (contentSpecType) {
                    case 0: {
                        type.setAttribute("content", "empty");
                        break;
                    }
                    case 1: {
                        Element any = this.fDocumentImpl.createElement("any");
                        type.insertBefore(any, XUtil.getFirstChildElement(type));
                        break;
                    }
                    case 2: {
                        XMLContentSpec contentSpec = new XMLContentSpec();
                        contentSpecProvider.getContentSpec(contentSpecIndex, contentSpec);
                        contentSpecIndex = contentSpec.value;
                        if (contentSpecIndex == -1) {
                            element.setAttribute("type", "string");
                            break;
                        }
                        if (type == null) {
                            type = this.fDocumentImpl.createElement("complexType");
                            element.insertBefore(type, XUtil.getFirstChildElement(element));
                        }
                        type.setAttribute("content", "mixed");
                        Element choice = this.fDocumentImpl.createElement("choice");
                        choice.setAttribute("minOccurs", "0");
                        choice.setAttribute("maxOccurs", "unbounded");
                        type.appendChild(choice);
                        while (contentSpecIndex != -1) {
                            contentSpecProvider.getContentSpec(contentSpecIndex, contentSpec);
                            int cstype = contentSpec.type;
                            int csleft = contentSpec.value;
                            int csright = contentSpec.otherValue;
                            if (cstype == 0) break block6;
                            contentSpecProvider.getContentSpec(csright, contentSpec);
                            Element right = this.fDocumentImpl.createElement("element");
                            right.setAttribute("ref", this.fStringPool.toString(contentSpec.value));
                            Element ref = XUtil.getFirstChildElement(choice);
                            choice.insertBefore(right, ref);
                            contentSpecIndex = csleft;
                        }
                        break;
                    }
                    case 4: {
                        type.setAttribute("content", "elementOnly");
                        Element children = this.createChildren(contentSpecProvider, contentSpecIndex, new XMLContentSpec(), this.fDocumentImpl, null);
                        type.insertBefore(children, XUtil.getFirstChildElement(type));
                    }
                }
            }
        }
    }

    public void attlistDecl(QName elementDecl, QName attributeDecl, int attType, boolean attList, String enumString, int attDefaultType, int attDefaultValue) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            if (attDefaultValue != -1) {
                int elementDefIndex = this.fDeferredDocumentImpl.lookupElementDefinition(elementDecl.rawname);
                if (elementDefIndex == -1) {
                    elementDefIndex = this.fDeferredDocumentImpl.createElementDefinition(elementDecl.rawname);
                    this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, elementDefIndex);
                }
                int attrIndex = this.fDeferredDocumentImpl.createAttribute(attributeDecl.rawname, attributeDecl.uri, attDefaultValue, false);
                this.fDeferredDocumentImpl.appendChild(elementDefIndex, attrIndex);
            }
            if (this.fGrammarAccess) {
                String attributeName;
                int attributeIndex;
                int typeIndex;
                String elementName;
                int schemaIndex = this.getLastChildElement(this.fDocumentTypeIndex, "schema");
                int elementIndex = this.getLastChildElement(schemaIndex, "element", "name", elementName = this.fStringPool.toString(elementDecl.rawname));
                if (elementIndex == -1) {
                    int handle = this.fAttrList.startAttrList();
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(elementName), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                    this.fAttrList.endAttrList();
                    elementIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("element"), this.fAttrList, handle);
                    this.fDeferredDocumentImpl.appendChild(schemaIndex, elementIndex);
                }
                if ((typeIndex = this.getLastChildElement(elementIndex, "complexType")) == -1) {
                    typeIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("complexType"), null, -1);
                    this.fDeferredDocumentImpl.insertBefore(elementIndex, typeIndex, this.getLastChildElement(elementIndex));
                }
                if ((attributeIndex = this.getLastChildElement(elementIndex, "attribute", "name", attributeName = this.fStringPool.toString(attributeDecl.rawname))) == -1) {
                    int handle = this.fAttrList.startAttrList();
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(attributeName), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("1"), this.fStringPool.addSymbol("CDATA"), false, false);
                    this.fAttrList.endAttrList();
                    attributeIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("attribute"), this.fAttrList, handle);
                    this.fDeferredDocumentImpl.appendChild(typeIndex, attributeIndex);
                    if (attType == 2) {
                        handle = this.fAttrList.startAttrList();
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("base"), this.fStringPool.addString("NMTOKEN"), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                        this.fAttrList.endAttrList();
                        int simpleTypeIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("simpleType"), this.fAttrList, handle);
                        this.fDeferredDocumentImpl.appendChild(attributeIndex, simpleTypeIndex);
                        String tokenizerString = enumString.substring(1, enumString.length() - 1);
                        StringTokenizer tokenizer = new StringTokenizer(tokenizerString, "|");
                        while (tokenizer.hasMoreTokens()) {
                            handle = this.fAttrList.startAttrList();
                            this.fAttrList.addAttr(this.fStringPool.addSymbol("value"), this.fStringPool.addString(tokenizer.nextToken()), this.fStringPool.addSymbol("CDATA"), true, false);
                            this.fAttrList.endAttrList();
                            int enumerationIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("enumeration"), this.fAttrList, handle);
                            this.fDeferredDocumentImpl.appendChild(simpleTypeIndex, enumerationIndex);
                        }
                    } else {
                        int typeNameIndex = -1;
                        switch (attType) {
                            case 1: {
                                typeNameIndex = this.fStringPool.addString(attList ? "ENTITIES" : "ENTITY");
                                break;
                            }
                            case 3: {
                                typeNameIndex = this.fStringPool.addString("ID");
                                break;
                            }
                            case 4: {
                                typeNameIndex = this.fStringPool.addString(attList ? "IDREFS" : "IDREF");
                                break;
                            }
                            case 5: {
                                typeNameIndex = this.fStringPool.addString(attList ? "NMTOKENS" : "NMTOKEN");
                                break;
                            }
                            case 6: {
                                typeNameIndex = this.fStringPool.addString("NOTATION");
                                break;
                            }
                            default: {
                                typeNameIndex = this.fStringPool.addString("string");
                            }
                        }
                        int attrIndex = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("type"), typeNameIndex, true);
                        this.fDeferredDocumentImpl.setAttributeNode(attributeIndex, attrIndex);
                    }
                    boolean fixed = false;
                    switch (attDefaultType) {
                        case 2: {
                            int useAttrIndex = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("use"), this.fStringPool.addString("required"), true);
                            this.fDeferredDocumentImpl.setAttributeNode(attributeIndex, useAttrIndex);
                            break;
                        }
                        case 16: {
                            fixed = true;
                            int useAttrIndex = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("use"), this.fStringPool.addString("fixed"), true);
                            this.fDeferredDocumentImpl.setAttributeNode(attributeIndex, useAttrIndex);
                        }
                    }
                    if (attDefaultValue != -1) {
                        if (!fixed) {
                            int useAttrIndex = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("use"), this.fStringPool.addString("default"), true);
                            this.fDeferredDocumentImpl.setAttributeNode(attributeIndex, useAttrIndex);
                        }
                        int valueAttrIndex = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("value"), attDefaultValue, true);
                        this.fDeferredDocumentImpl.setAttributeNode(attributeIndex, valueAttrIndex);
                    }
                }
            }
        } else if (this.fDocumentImpl != null) {
            if (attDefaultValue != -1) {
                AttrImpl attr;
                String elementName = this.fStringPool.toString(elementDecl.rawname);
                NamedNodeMap elements = ((DocumentTypeImpl)this.fDocumentType).getElements();
                ElementDefinitionImpl elementDef = (ElementDefinitionImpl)elements.getNamedItem(elementName);
                if (elementDef == null) {
                    elementDef = this.fDocumentImpl.createElementDefinition(elementName);
                    ((DocumentTypeImpl)this.fDocumentType).getElements().setNamedItem(elementDef);
                }
                String attrName = this.fStringPool.toString(attributeDecl.rawname);
                String attrValue = this.fStringPool.toString(attDefaultValue);
                boolean nsEnabled = false;
                try {
                    nsEnabled = this.getNamespaces();
                }
                catch (SAXException handle) {
                    // empty catch block
                }
                if (nsEnabled) {
                    String namespaceURI = this.fStringPool.toString(attributeDecl.uri);
                    String prefix = this.fStringPool.toString(attributeDecl.prefix);
                    if (namespaceURI.length() == 0) {
                        namespaceURI = null;
                    }
                    if (namespaceURI == null) {
                        if (prefix != null) {
                            if (prefix.equals("xmlns")) {
                                namespaceURI = "http://www.w3.org/2000/xmlns/";
                            }
                        } else if (attrName.equals("xmlns")) {
                            namespaceURI = "http://www.w3.org/2000/xmlns/";
                        }
                    }
                    attr = (AttrImpl)this.fDocumentImpl.createAttributeNS(namespaceURI, attrName);
                } else {
                    attr = (AttrImpl)this.fDocumentImpl.createAttribute(attrName);
                }
                attr.setValue(attrValue);
                attr.setSpecified(false);
                if (nsEnabled) {
                    elementDef.getAttributes().setNamedItemNS(attr);
                } else {
                    elementDef.getAttributes().setNamedItem(attr);
                }
            }
            try {
                if (this.fGrammarAccess) {
                    String attributeName;
                    Element attribute;
                    Element type;
                    String elementName;
                    Element schema = XUtil.getLastChildElement((Node)this.fDocumentType, "schema");
                    Element element = XUtil.getLastChildElement(schema, "element", "name", elementName = this.fStringPool.toString(elementDecl.rawname));
                    if (element == null) {
                        element = this.fDocumentImpl.createElement("element");
                        element.setAttribute("name", elementName);
                        schema.appendChild(element);
                    }
                    if ((type = XUtil.getLastChildElement((Node)element, "complexType")) == null) {
                        type = this.fDocumentImpl.createElement("complexType");
                        element.insertBefore(type, XUtil.getLastChildElement(element));
                    }
                    if ((attribute = XUtil.getLastChildElement(element, "attribute", "name", attributeName = this.fStringPool.toString(attributeDecl.rawname))) == null) {
                        attribute = this.fDocumentImpl.createElement("attribute");
                        attribute.setAttribute("name", attributeName);
                        attribute.setAttribute("maxOccurs", "1");
                        ((AttrImpl)attribute.getAttributeNode("maxOccurs")).setSpecified(false);
                        type.appendChild(attribute);
                        if (attType == 2) {
                            Element simpleType = this.fDocumentImpl.createElement("simpleType");
                            simpleType.setAttribute("base", "NMTOKEN");
                            attribute.appendChild(simpleType);
                            String tokenizerString = enumString.substring(1, enumString.length() - 1);
                            StringTokenizer tokenizer = new StringTokenizer(tokenizerString, "|");
                            while (tokenizer.hasMoreTokens()) {
                                Element enumeration = this.fDocumentImpl.createElement("enumeration");
                                enumeration.setAttribute("value", tokenizer.nextToken());
                                simpleType.appendChild(enumeration);
                            }
                        } else {
                            String typeName = null;
                            switch (attType) {
                                case 1: {
                                    typeName = attList ? "ENTITIES" : "ENTITY";
                                    break;
                                }
                                case 3: {
                                    typeName = "ID";
                                    break;
                                }
                                case 4: {
                                    typeName = attList ? "IDREFS" : "IDREF";
                                    break;
                                }
                                case 5: {
                                    typeName = attList ? "NMTOKENS" : "NMTOKEN";
                                    break;
                                }
                                case 6: {
                                    typeName = "NOTATION";
                                    break;
                                }
                                default: {
                                    typeName = "string";
                                }
                            }
                            attribute.setAttribute("type", typeName);
                        }
                        boolean fixed = false;
                        switch (attDefaultType) {
                            case 2: {
                                attribute.setAttribute("use", "required");
                                break;
                            }
                            case 16: {
                                attribute.setAttribute("use", "fixed");
                                fixed = true;
                            }
                        }
                        if (attDefaultValue != -1) {
                            if (!fixed) {
                                attribute.setAttribute("use", "default");
                            }
                            attribute.setAttribute("value", this.fStringPool.toString(attDefaultValue));
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public void internalPEDecl(int entityNameIndex, int entityValueIndex) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            if (this.fGrammarAccess) {
                StringBuffer str = new StringBuffer();
                str.append("<!ENTITY % ");
                str.append(this.fStringPool.toString(entityNameIndex));
                str.append(" \"");
                str.append(this.fStringPool.toString(entityValueIndex));
                str.append("\">");
                int commentIndex = this.fStringPool.addString(str.toString());
                int internalPEEntityIndex = this.fDeferredDocumentImpl.createComment(commentIndex);
                int schemaIndex = this.getFirstChildElement(this.fDocumentTypeIndex, "schema");
                this.fDeferredDocumentImpl.appendChild(schemaIndex, internalPEEntityIndex);
            }
        } else if (this.fDocumentImpl != null) {
            if (this.fGrammarAccess) {
                StringBuffer str = new StringBuffer();
                str.append("<!ENTITY % ");
                str.append(this.fStringPool.toString(entityNameIndex));
                str.append(" \"");
                str.append(this.fStringPool.toString(entityValueIndex));
                str.append("\">");
                Comment internalPEEntity = this.fDocumentImpl.createComment(str.toString());
                Element schema = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema");
                schema.appendChild(internalPEEntity);
            }
        } else {
            this.fStringPool.orphanString(entityValueIndex);
        }
    }

    public void externalPEDecl(int entityNameIndex, int publicIdIndex, int systemIdIndex) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            if (this.fGrammarAccess) {
                StringBuffer str = new StringBuffer();
                str.append("<!ENTITY ");
                str.append(this.fStringPool.toString(entityNameIndex));
                str.append(' ');
                if (publicIdIndex != -1) {
                    str.append("PUBLIC \"");
                    str.append(this.fStringPool.toString(publicIdIndex));
                    str.append('\"');
                    if (systemIdIndex != -1) {
                        str.append(" \"");
                        str.append(this.fStringPool.toString(systemIdIndex));
                        str.append('\"');
                    }
                } else if (systemIdIndex != -1) {
                    str.append("SYSTEM \"");
                    str.append(this.fStringPool.toString(systemIdIndex));
                    str.append('\"');
                }
                str.append('>');
                int commentIndex = this.fStringPool.addString(str.toString());
                int externalPEEntityIndex = this.fDeferredDocumentImpl.createComment(commentIndex);
                int schemaIndex = this.getFirstChildElement(this.fDocumentTypeIndex, "schema");
                this.fDeferredDocumentImpl.appendChild(schemaIndex, externalPEEntityIndex);
            }
        } else if (this.fDocumentImpl != null && this.fGrammarAccess) {
            StringBuffer str = new StringBuffer();
            str.append("<!ENTITY ");
            str.append(this.fStringPool.toString(entityNameIndex));
            str.append(' ');
            if (publicIdIndex != -1) {
                str.append("PUBLIC \"");
                str.append(this.fStringPool.toString(publicIdIndex));
                str.append('\"');
                if (systemIdIndex != -1) {
                    str.append(" \"");
                    str.append(this.fStringPool.toString(systemIdIndex));
                    str.append('\"');
                }
            } else if (systemIdIndex != -1) {
                str.append("SYSTEM \"");
                str.append(this.fStringPool.toString(systemIdIndex));
                str.append('\"');
            }
            str.append('>');
            Comment externalPEEntity = this.fDocumentImpl.createComment(str.toString());
            Element schema = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema");
            schema.appendChild(externalPEEntity);
        }
    }

    public void internalEntityDecl(int entityNameIndex, int entityValueIndex) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            if (this.fDocumentTypeIndex == -1) {
                return;
            }
            int newEntityIndex = this.fDeferredDocumentImpl.createEntity(entityNameIndex, -1, -1, -1);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, newEntityIndex);
            if (this.fGrammarAccess) {
                StringBuffer str = new StringBuffer();
                str.append("<!ENTITY ");
                str.append(this.fStringPool.toString(entityNameIndex));
                str.append(" \"");
                str.append(this.fStringPool.toString(entityValueIndex));
                str.append("\">");
                int commentIndex = this.fStringPool.addString(str.toString());
                int textEntityIndex = this.fDeferredDocumentImpl.createComment(commentIndex);
                int schemaIndex = this.getFirstChildElement(this.fDocumentTypeIndex, "schema");
                this.fDeferredDocumentImpl.appendChild(schemaIndex, textEntityIndex);
            }
        } else if (this.fDocumentImpl != null) {
            if (this.fDocumentType == null) {
                return;
            }
            String entityName = this.fStringPool.toString(entityNameIndex);
            Entity entity = this.fDocumentImpl.createEntity(entityName);
            this.fDocumentType.getEntities().setNamedItem(entity);
            if (this.fGrammarAccess) {
                StringBuffer str = new StringBuffer();
                str.append("<!ENTITY ");
                str.append(this.fStringPool.toString(entityNameIndex));
                str.append(" \"");
                str.append(this.fStringPool.toString(entityValueIndex));
                str.append("\">");
                Comment textEntity = this.fDocumentImpl.createComment(str.toString());
                Element schema = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema");
                schema.appendChild(textEntity);
            }
        }
    }

    public void externalEntityDecl(int entityNameIndex, int publicIdIndex, int systemIdIndex) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int newEntityIndex = this.fDeferredDocumentImpl.createEntity(entityNameIndex, publicIdIndex, systemIdIndex, -1);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, newEntityIndex);
            if (this.fGrammarAccess) {
                StringBuffer str = new StringBuffer();
                str.append("<!ENTITY ");
                str.append(this.fStringPool.toString(entityNameIndex));
                str.append(' ');
                if (publicIdIndex != -1) {
                    str.append("PUBLIC \"");
                    str.append(this.fStringPool.toString(publicIdIndex));
                    str.append('\"');
                    if (systemIdIndex != -1) {
                        str.append(" \"");
                        str.append(this.fStringPool.toString(systemIdIndex));
                        str.append('\"');
                    }
                } else if (systemIdIndex != -1) {
                    str.append("SYSTEM \"");
                    str.append(this.fStringPool.toString(systemIdIndex));
                    str.append('\"');
                }
                str.append('>');
                int commentIndex = this.fStringPool.addString(str.toString());
                int externalEntityIndex = this.fDeferredDocumentImpl.createComment(commentIndex);
                int schemaIndex = this.getFirstChildElement(this.fDocumentTypeIndex, "schema");
                this.fDeferredDocumentImpl.appendChild(schemaIndex, externalEntityIndex);
            }
        } else if (this.fDocumentImpl != null) {
            String entityName = this.fStringPool.toString(entityNameIndex);
            String publicId = this.fStringPool.toString(publicIdIndex);
            String systemId = this.fStringPool.toString(systemIdIndex);
            EntityImpl entity = (EntityImpl)this.fDocumentImpl.createEntity(entityName);
            if (publicIdIndex != -1) {
                entity.setPublicId(publicId);
            }
            entity.setSystemId(systemId);
            this.fDocumentType.getEntities().setNamedItem(entity);
            if (this.fGrammarAccess) {
                StringBuffer str = new StringBuffer();
                str.append("<!ENTITY ");
                str.append(this.fStringPool.toString(entityNameIndex));
                str.append(' ');
                if (publicIdIndex != -1) {
                    str.append("PUBLIC \"");
                    str.append(this.fStringPool.toString(publicIdIndex));
                    str.append('\"');
                    if (systemIdIndex != -1) {
                        str.append(" \"");
                        str.append(this.fStringPool.toString(systemIdIndex));
                        str.append('\"');
                    }
                } else if (systemIdIndex != -1) {
                    str.append("SYSTEM \"");
                    str.append(this.fStringPool.toString(systemIdIndex));
                    str.append('\"');
                }
                str.append('>');
                Comment externalEntity = this.fDocumentImpl.createComment(str.toString());
                Element schema = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema");
                schema.appendChild(externalEntity);
            }
        }
    }

    public void unparsedEntityDecl(int entityNameIndex, int publicIdIndex, int systemIdIndex, int notationNameIndex) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int newEntityIndex = this.fDeferredDocumentImpl.createEntity(entityNameIndex, publicIdIndex, systemIdIndex, notationNameIndex);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, newEntityIndex);
            if (this.fGrammarAccess) {
                StringBuffer str = new StringBuffer();
                str.append("<!ENTITY ");
                str.append(this.fStringPool.toString(entityNameIndex));
                str.append(' ');
                if (publicIdIndex != -1) {
                    str.append("PUBLIC \"");
                    str.append(this.fStringPool.toString(publicIdIndex));
                    str.append('\"');
                    if (systemIdIndex != -1) {
                        str.append(" \"");
                        str.append(this.fStringPool.toString(systemIdIndex));
                        str.append('\"');
                    }
                } else if (systemIdIndex != -1) {
                    str.append("SYSTEM \"");
                    str.append(this.fStringPool.toString(systemIdIndex));
                    str.append('\"');
                }
                str.append(" NDATA ");
                str.append(this.fStringPool.toString(notationNameIndex));
                str.append('>');
                int commentIndex = this.fStringPool.addString(str.toString());
                int unparsedEntityIndex = this.fDeferredDocumentImpl.createComment(commentIndex);
                int schemaIndex = this.getFirstChildElement(this.fDocumentTypeIndex, "schema");
                this.fDeferredDocumentImpl.appendChild(schemaIndex, unparsedEntityIndex);
            }
        } else if (this.fDocumentImpl != null) {
            String entityName = this.fStringPool.toString(entityNameIndex);
            String publicId = this.fStringPool.toString(publicIdIndex);
            String systemId = this.fStringPool.toString(systemIdIndex);
            String notationName = this.fStringPool.toString(notationNameIndex);
            EntityImpl entity = (EntityImpl)this.fDocumentImpl.createEntity(entityName);
            if (publicIdIndex != -1) {
                entity.setPublicId(publicId);
            }
            entity.setSystemId(systemId);
            entity.setNotationName(notationName);
            this.fDocumentType.getEntities().setNamedItem(entity);
            if (this.fGrammarAccess) {
                StringBuffer str = new StringBuffer();
                str.append("<!ENTITY ");
                str.append(this.fStringPool.toString(entityNameIndex));
                str.append(' ');
                if (publicIdIndex != -1) {
                    str.append("PUBLIC \"");
                    str.append(this.fStringPool.toString(publicIdIndex));
                    str.append('\"');
                    if (systemIdIndex != -1) {
                        str.append(" \"");
                        str.append(this.fStringPool.toString(systemIdIndex));
                        str.append('\"');
                    }
                } else if (systemIdIndex != -1) {
                    str.append("SYSTEM \"");
                    str.append(this.fStringPool.toString(systemIdIndex));
                    str.append('\"');
                }
                str.append(" NDATA ");
                str.append(this.fStringPool.toString(notationNameIndex));
                str.append('>');
                Comment unparsedEntity = this.fDocumentImpl.createComment(str.toString());
                Element schema = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema");
                schema.appendChild(unparsedEntity);
            }
        }
    }

    public void notationDecl(int notationNameIndex, int publicIdIndex, int systemIdIndex) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            String notationName;
            int schemaIndex;
            int notationIndex;
            int newNotationIndex = this.fDeferredDocumentImpl.createNotation(notationNameIndex, publicIdIndex, systemIdIndex);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, newNotationIndex);
            if (this.fGrammarAccess && (notationIndex = this.getLastChildElement(schemaIndex = this.getLastChildElement(this.fDocumentTypeIndex, "schema"), "notation", "name", notationName = this.fStringPool.toString(notationNameIndex))) == -1) {
                int handle = this.fAttrList.startAttrList();
                this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(notationName), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                if (publicIdIndex != -1) {
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("public"), publicIdIndex, this.fStringPool.addSymbol("CDATA"), true, false);
                }
                if (systemIdIndex != -1) {
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("system"), systemIdIndex, this.fStringPool.addSymbol("CDATA"), true, false);
                }
                this.fAttrList.endAttrList();
                notationIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("notation"), this.fAttrList, handle);
                this.fDeferredDocumentImpl.appendChild(schemaIndex, notationIndex);
            }
        } else if (this.fDocumentImpl != null) {
            Element schema;
            Element notation;
            String notationName = this.fStringPool.toString(notationNameIndex);
            String publicId = this.fStringPool.toString(publicIdIndex);
            String systemId = this.fStringPool.toString(systemIdIndex);
            NotationImpl notationImpl = (NotationImpl)this.fDocumentImpl.createNotation(notationName);
            notationImpl.setPublicId(publicId);
            if (systemIdIndex != -1) {
                notationImpl.setSystemId(systemId);
            }
            this.fDocumentType.getNotations().setNamedItem(notationImpl);
            if (this.fGrammarAccess && (notation = XUtil.getFirstChildElement(schema = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema"), "notation", "name", notationName)) == null) {
                notation = this.fDocument.createElement("notation");
                notation.setAttribute("name", notationName);
                if (publicId != null) {
                    notation.setAttribute("public", publicId);
                }
                if (systemIdIndex != -1) {
                    notation.setAttribute("system", systemId);
                }
                schema.appendChild(notation);
            }
        }
    }

    private int getFirstChildElement(int nodeIndex) {
        int childIndex = this.getLastChildElement(nodeIndex);
        while (childIndex != -1) {
            int prevIndex = this.getPrevSiblingElement(childIndex);
            if (prevIndex == -1) break;
            childIndex = prevIndex;
        }
        return childIndex;
    }

    private int getFirstChildElement(int nodeIndex, String name) {
        int childIndex = this.getLastChildElement(nodeIndex);
        if (childIndex != -1) {
            int nameIndex = this.fStringPool.addSymbol(name);
            while (childIndex != -1) {
                int prevIndex;
                if (this.fDeferredDocumentImpl.getNodeName(childIndex, false) == nameIndex) break;
                childIndex = prevIndex = this.getPrevSiblingElement(childIndex);
            }
        }
        return childIndex;
    }

    private int getLastChildElement(int nodeIndex) {
        int childIndex = this.fDeferredDocumentImpl.getLastChild(nodeIndex, false);
        while (childIndex != -1) {
            if (this.fDeferredDocumentImpl.getNodeType(childIndex, false) == 1) {
                return childIndex;
            }
            childIndex = this.fDeferredDocumentImpl.getPrevSibling(childIndex, false);
        }
        return -1;
    }

    private int getPrevSiblingElement(int nodeIndex) {
        int siblingIndex = this.fDeferredDocumentImpl.getPrevSibling(nodeIndex, false);
        while (siblingIndex != -1) {
            if (this.fDeferredDocumentImpl.getNodeType(siblingIndex, false) == 1) {
                return siblingIndex;
            }
            siblingIndex = this.fDeferredDocumentImpl.getPrevSibling(siblingIndex, false);
        }
        return -1;
    }

    private int getLastChildElement(int nodeIndex, String elementName) {
        int childIndex = this.getLastChildElement(nodeIndex);
        if (childIndex != -1) {
            while (childIndex != -1) {
                String nodeName = this.fDeferredDocumentImpl.getNodeNameString(childIndex, false);
                if (nodeName.equals(elementName)) {
                    return childIndex;
                }
                childIndex = this.getPrevSiblingElement(childIndex);
            }
        }
        return -1;
    }

    private int getPrevSiblingElement(int nodeIndex, String elementName) {
        int siblingIndex = this.getPrevSiblingElement(nodeIndex);
        if (siblingIndex != -1) {
            while (siblingIndex != -1) {
                String nodeName = this.fDeferredDocumentImpl.getNodeNameString(siblingIndex, false);
                if (nodeName.equals(elementName)) {
                    return siblingIndex;
                }
                siblingIndex = this.getPrevSiblingElement(siblingIndex);
            }
        }
        return -1;
    }

    private int getLastChildElement(int nodeIndex, String elemName, String attrName, String attrValue) {
        int childIndex = this.getLastChildElement(nodeIndex, elemName);
        if (childIndex != -1) {
            while (childIndex != -1) {
                int attrIndex = this.fDeferredDocumentImpl.getNodeValue(childIndex, false);
                while (attrIndex != -1) {
                    int textIndex;
                    String nodeValue;
                    String nodeName = this.fDeferredDocumentImpl.getNodeNameString(attrIndex, false);
                    if (nodeName.equals(attrName) && (nodeValue = this.fDeferredDocumentImpl.getNodeValueString(textIndex = this.fDeferredDocumentImpl.getLastChild(attrIndex, false), false)).equals(attrValue)) {
                        return childIndex;
                    }
                    attrIndex = this.fDeferredDocumentImpl.getPrevSibling(attrIndex, false);
                }
                childIndex = this.getPrevSiblingElement(childIndex, elemName);
            }
        }
        return -1;
    }

    private int getPrevSiblingElement(int nodeIndex, String elemName, String attrName, String attrValue) {
        int siblingIndex = this.getPrevSiblingElement(nodeIndex, elemName);
        if (siblingIndex != -1) {
            int attributeNameIndex = this.fStringPool.addSymbol(attrName);
            while (siblingIndex != -1) {
                int attrIndex = this.fDeferredDocumentImpl.getNodeValue(siblingIndex, false);
                while (attrIndex != -1) {
                    int attrValueIndex = this.fDeferredDocumentImpl.getNodeValue(attrIndex, false);
                    if (attrValue.equals(this.fStringPool.toString(attrValueIndex))) {
                        return siblingIndex;
                    }
                    attrIndex = this.fDeferredDocumentImpl.getPrevSibling(attrIndex, false);
                }
                siblingIndex = this.getPrevSiblingElement(siblingIndex, elemName);
            }
        }
        return -1;
    }

    private void copyInto(Node src, int destIndex) throws Exception {
        boolean domimpl = src != null && src instanceof DocumentImpl;
        Node start = src;
        Node parent = src;
        Node place = src;
        while (place != null) {
            int nodeIndex = -1;
            short type = place.getNodeType();
            switch (type) {
                case 4: {
                    boolean ignorable = domimpl && ((TextImpl)place).isIgnorableWhitespace();
                    nodeIndex = this.fDeferredDocumentImpl.createCDATASection(this.fStringPool.addString(place.getNodeValue()), ignorable);
                    break;
                }
                case 8: {
                    nodeIndex = this.fDeferredDocumentImpl.createComment(this.fStringPool.addString(place.getNodeValue()));
                    break;
                }
                case 1: {
                    int length;
                    XMLAttrList attrList = null;
                    int handle = -1;
                    NamedNodeMap attrs = place.getAttributes();
                    if (attrs != null && (length = attrs.getLength()) > 0) {
                        handle = this.fAttrList.startAttrList();
                        int i = 0;
                        while (i < length) {
                            Attr attr = (Attr)attrs.item(i);
                            String attrName = attr.getNodeName();
                            String attrValue = attr.getNodeValue();
                            this.fAttrList.addAttr(this.fStringPool.addSymbol(attrName), this.fStringPool.addString(attrValue), this.fStringPool.addSymbol("CDATA"), attr.getSpecified(), false);
                            ++i;
                        }
                        this.fAttrList.endAttrList();
                        attrList = this.fAttrList;
                    }
                    nodeIndex = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol(place.getNodeName()), attrList, handle);
                    break;
                }
                case 5: {
                    nodeIndex = this.fDeferredDocumentImpl.createEntityReference(this.fStringPool.addSymbol(place.getNodeName()));
                    break;
                }
                case 7: {
                    nodeIndex = this.fDeferredDocumentImpl.createProcessingInstruction(this.fStringPool.addSymbol(place.getNodeName()), this.fStringPool.addString(place.getNodeValue()));
                    break;
                }
                case 3: {
                    boolean ignorable = domimpl && ((TextImpl)place).isIgnorableWhitespace();
                    nodeIndex = this.fDeferredDocumentImpl.createTextNode(this.fStringPool.addString(place.getNodeValue()), ignorable);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("PAR010 Can't copy node type, " + type + " (" + place.getNodeName() + ')' + "\n" + type + "\t" + place.getNodeName());
                }
            }
            this.fDeferredDocumentImpl.appendChild(destIndex, nodeIndex);
            if (place.hasChildNodes()) {
                parent = place;
                place = place.getFirstChild();
                destIndex = nodeIndex;
                continue;
            }
            place = place.getNextSibling();
            while (place == null && parent != start) {
                place = parent.getNextSibling();
                parent = parent.getParentNode();
                destIndex = this.fDeferredDocumentImpl.getParentNode(destIndex, false);
            }
        }
    }

    private void setOccurrenceCount(Element model, int minOccur, int maxOccur) {
        model.setAttribute("minOccurs", Integer.toString(minOccur));
        if (minOccur == 1) {
            ((AttrImpl)model.getAttributeNode("minOccurs")).setSpecified(false);
        }
        if (maxOccur == -1) {
            model.setAttribute("maxOccurs", "*");
        } else if (maxOccur != 1) {
            model.setAttribute("maxOccurs", Integer.toString(maxOccur));
        }
    }

    private Element createChildren(XMLContentSpec.Provider provider, int index, XMLContentSpec node, DocumentImpl factory, Element parent) throws Exception {
        provider.getContentSpec(index, node);
        int occurs = -1;
        switch (node.type) {
            case 3: {
                occurs = 43;
                provider.getContentSpec(node.value, node);
                break;
            }
            case 2: {
                occurs = 42;
                provider.getContentSpec(node.value, node);
                break;
            }
            case 1: {
                occurs = 63;
                provider.getContentSpec(node.value, node);
            }
        }
        int nodeType = node.type;
        switch (nodeType) {
            case 4: 
            case 5: {
                int leftIndex = node.value;
                int rightIndex = node.otherValue;
                Element left = this.createChildren(provider, leftIndex, node, factory, parent);
                Element right = this.createChildren(provider, rightIndex, node, factory, null);
                boolean choice = nodeType == 4;
                String type = choice ? "choice" : "sequence";
                Element model = left;
                if (!left.getNodeName().equals(type)) {
                    boolean max1;
                    String minOccurs = left.getAttribute("minOccurs");
                    String maxOccurs = left.getAttribute("maxOccurs");
                    boolean min1 = minOccurs.length() == 0 || minOccurs.equals("1");
                    boolean bl = max1 = maxOccurs.length() == 0 || maxOccurs.equals("1");
                    if (parent == null || min1 && max1) {
                        model = factory.createElement(type);
                        model.appendChild(left);
                    } else {
                        model = parent;
                    }
                }
                switch (occurs) {
                    case 43: {
                        model.setAttribute("maxOccurs", "unbounded");
                        break;
                    }
                    case 42: {
                        model.setAttribute("minOccurs", "0");
                        model.setAttribute("maxOccurs", "unbounded");
                        break;
                    }
                    case 63: {
                        model.setAttribute("minOccurs", "0");
                    }
                }
                model.appendChild(right);
                return model;
            }
            case 0: {
                Element leaf = factory.createElement("element");
                leaf.setAttribute("ref", this.fStringPool.toString(node.value));
                switch (occurs) {
                    case 43: {
                        leaf.setAttribute("maxOccurs", "unbounded");
                        break;
                    }
                    case 42: {
                        leaf.setAttribute("minOccurs", "0");
                        leaf.setAttribute("maxOccurs", "unbounded");
                        break;
                    }
                    case 63: {
                        leaf.setAttribute("minOccurs", "0");
                    }
                }
                return leaf;
            }
        }
        return null;
    }

    private int createChildren(XMLContentSpec.Provider provider, int index, XMLContentSpec node, DeferredDocumentImpl factory, int parent) throws Exception {
        provider.getContentSpec(index, node);
        int occurs = -1;
        switch (node.type) {
            case 3: {
                occurs = 43;
                provider.getContentSpec(node.value, node);
                break;
            }
            case 2: {
                occurs = 42;
                provider.getContentSpec(node.value, node);
                break;
            }
            case 1: {
                occurs = 63;
                provider.getContentSpec(node.value, node);
            }
        }
        int nodeType = node.type;
        switch (nodeType) {
            case 4: 
            case 5: {
                int maxOccurs;
                int minOccurs;
                int leftIndex = node.value;
                int rightIndex = node.otherValue;
                int left = this.createChildren(provider, leftIndex, node, factory, parent);
                int right = this.createChildren(provider, rightIndex, node, factory, -1);
                boolean choice = nodeType == 4;
                int type = this.fStringPool.addSymbol(choice ? "choice" : "sequence");
                int model = left;
                if (factory.getNodeName(left, false) != type) {
                    boolean max1;
                    minOccurs = factory.getAttribute(left, this.fStringPool.addSymbol("minOccurs"));
                    maxOccurs = factory.getAttribute(left, this.fStringPool.addSymbol("maxOccurs"));
                    boolean min1 = minOccurs == -1 || this.fStringPool.toString(minOccurs).equals("1");
                    boolean bl = max1 = maxOccurs == -1 || this.fStringPool.toString(maxOccurs).equals("1");
                    if (parent == -1 || min1 && max1) {
                        model = factory.createElement(type, null, -1);
                        factory.appendChild(model, left);
                    } else {
                        model = parent;
                    }
                }
                switch (occurs) {
                    case 43: {
                        int maxOccurs2 = factory.createAttribute(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("unbounded"), true);
                        factory.setAttributeNode(model, maxOccurs2);
                        break;
                    }
                    case 42: {
                        minOccurs = factory.createAttribute(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("0"), true);
                        factory.setAttributeNode(model, minOccurs);
                        maxOccurs = factory.createAttribute(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("unbounded"), true);
                        factory.setAttributeNode(model, maxOccurs);
                        break;
                    }
                    case 63: {
                        minOccurs = factory.createAttribute(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("0"), true);
                        factory.setAttributeNode(model, minOccurs);
                    }
                }
                factory.appendChild(model, right);
                return model;
            }
            case 0: {
                int handle = this.fAttrList.startAttrList();
                this.fAttrList.addAttr(this.fStringPool.addSymbol("ref"), this.fStringPool.addString(this.fStringPool.toString(node.value)), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                switch (occurs) {
                    case 43: {
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("unbounded"), this.fStringPool.addSymbol("CDATA"), true, false);
                        break;
                    }
                    case 42: {
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("0"), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("unbounded"), this.fStringPool.addSymbol("CDATA"), true, false);
                        break;
                    }
                    case 63: {
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("0"), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                    }
                }
                this.fAttrList.endAttrList();
                int leaf = factory.createElement(this.fStringPool.addSymbol("element"), this.fAttrList, handle);
                return leaf;
            }
        }
        return -1;
    }
}

