/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLParser;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.xml.sax.AttributeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXParser
extends XMLParser
implements XMLDocumentHandler,
XMLDocumentHandler.DTDHandler,
Parser,
XMLReader {
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespace-prefixes", "http://xml.org/sax/features/string-interning"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/properties/declaration-handler", "http://xml.org/sax/properties/dom-node"};
    private static final boolean DEBUG_CALLBACKS = false;
    private DocumentHandler fDocumentHandler;
    private DTDHandler fDTDHandler;
    private ContentHandler fContentHandler;
    private DeclHandler fDeclHandler;
    private LexicalHandler fLexicalHandler;
    private boolean fNamespacePrefixes = false;
    private transient AttributesImpl fAttributes = new AttributesImpl();

    public SAXParser() {
        this.initHandlers(true, this, this);
    }

    protected SAXParser(StringPool stringPool) {
        super(stringPool);
        this.initHandlers(true, this, this);
    }

    public String[] getFeaturesRecognized() {
        String[] superRecognized = super.getFeaturesRecognized();
        String[] thisRecognized = RECOGNIZED_FEATURES;
        int thisLength = thisRecognized.length;
        if (thisLength == 0) {
            return superRecognized;
        }
        int superLength = superRecognized.length;
        if (superLength == 0) {
            return thisRecognized;
        }
        String[] recognized = new String[superLength + thisLength];
        System.arraycopy(superRecognized, 0, recognized, 0, superLength);
        System.arraycopy(thisRecognized, 0, recognized, superLength, thisLength);
        return recognized;
    }

    public String[] getPropertiesRecognized() {
        String[] superRecognized = super.getPropertiesRecognized();
        String[] thisRecognized = RECOGNIZED_PROPERTIES;
        int thisLength = thisRecognized.length;
        if (thisLength == 0) {
            return superRecognized;
        }
        int superLength = superRecognized.length;
        if (superLength == 0) {
            return thisRecognized;
        }
        String[] recognized = new String[superLength + thisLength];
        System.arraycopy(superRecognized, 0, recognized, 0, superLength);
        System.arraycopy(thisRecognized, 0, recognized, superLength, thisLength);
        return recognized;
    }

    protected void setDeclHandler(DeclHandler handler) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR011 Feature: http://xml.org/sax/properties/declaration-handler is not supported during parse.\nhttp://xml.org/sax/properties/declaration-handler");
        }
        this.fDeclHandler = handler;
    }

    protected DeclHandler getDeclHandler() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fDeclHandler;
    }

    protected void setLexicalHandler(LexicalHandler handler) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR011 Feature: http://xml.org/sax/properties/lexical-handler is not supported during parse.\nhttp://xml.org/sax/properties/lexical-handler");
        }
        this.fLexicalHandler = handler;
    }

    protected LexicalHandler getLexicalHandler() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fLexicalHandler;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.fDocumentHandler = handler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.fDTDHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    protected void setNamespacePrefixes(boolean process) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR004 Cannot setFeature(http://xml.org/sax/features/namespace-prefixes): parse is in progress.\nhttp://xml.org/sax/features/namespace-prefixes");
        }
        this.fNamespacePrefixes = process;
    }

    protected boolean getNamespacePrefixes() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fNamespacePrefixes;
    }

    public void setFeature(String featureId, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (featureId.startsWith("http://xml.org/sax/features/")) {
            String feature = featureId.substring("http://xml.org/sax/features/".length());
            if (feature.equals("namespace-prefixes")) {
                this.setNamespacePrefixes(state);
                return;
            }
            if (feature.equals("string-interning")) {
                if (state) {
                    throw new SAXNotSupportedException("PAR018 " + state + " state for feature \"" + featureId + "\" is not supported.\n" + state + '\t' + featureId);
                }
                return;
            }
        }
        super.setFeature(featureId, state);
    }

    public boolean getFeature(String featureId) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (featureId.startsWith("http://xml.org/sax/features/")) {
            String feature = featureId.substring("http://xml.org/sax/features/".length());
            if (feature.equals("namespace-prefixes")) {
                return this.getNamespacePrefixes();
            }
            if (feature.equals("string-interning")) {
                return false;
            }
        }
        return super.getFeature(featureId);
    }

    public void setProperty(String propertyId, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (propertyId.startsWith("http://xml.org/sax/properties/")) {
            String property = propertyId.substring("http://xml.org/sax/properties/".length());
            if (property.equals("lexical-handler")) {
                try {
                    this.setLexicalHandler((LexicalHandler)value);
                }
                catch (ClassCastException e) {
                    throw new SAXNotSupportedException("PAR012 For propertyID \"" + propertyId + "\", the value \"" + value + "\" cannot be cast to LexicalHandler." + '\n' + propertyId + '\t' + value + "\tLexicalHandler");
                }
                return;
            }
            if (property.equals("declaration-handler")) {
                try {
                    this.setDeclHandler((DeclHandler)value);
                }
                catch (ClassCastException e) {
                    throw new SAXNotSupportedException("PAR012 For propertyID \"" + propertyId + "\", the value \"" + value + "\" cannot be cast to DeclHandler." + '\n' + propertyId + '\t' + value + "\tDeclHandler");
                }
                return;
            }
            if (property.equals("dom-node")) {
                throw new SAXNotSupportedException("PAR013 Property \"" + propertyId + "\" is read only." + '\n' + propertyId);
            }
        }
        super.setProperty(propertyId, value);
    }

    public Object getProperty(String propertyId) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (propertyId.startsWith("http://xml.org/sax/properties/")) {
            String property = propertyId.substring("http://xml.org/sax/properties/".length());
            if (property.equals("lexical-handler")) {
                return this.getLexicalHandler();
            }
            if (property.equals("declaration-handler")) {
                return this.getDeclHandler();
            }
            if (property.equals("dom-node")) {
                throw new SAXNotSupportedException("PAR014 Cannot getProperty(\"" + propertyId + "\". No DOM Tree exists.\n" + propertyId);
            }
        }
        return super.getProperty(propertyId);
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.fContentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    public void startDTD(QName rootElement, int publicId, int systemId) throws Exception {
        if (this.fLexicalHandler != null) {
            String name = this.fStringPool.toString(rootElement.rawname);
            String pubid = this.fStringPool.toString(publicId);
            String sysid = this.fStringPool.toString(systemId);
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startDTD(name, pubid, sysid);
            }
        }
    }

    public void endDTD() throws Exception {
        if (this.fLexicalHandler != null) {
            this.fLexicalHandler.endDTD();
        }
    }

    public void elementDecl(QName elementDecl, int contentSpecType, int contentSpecIndex, XMLContentSpec.Provider contentSpecProvider) throws Exception {
        if (this.fDeclHandler != null) {
            String name = this.fStringPool.toString(elementDecl.rawname);
            String contentModel = contentSpecType == 1 ? "ANY" : (contentSpecType == 0 ? "EMPTY" : XMLContentSpec.toString(contentSpecProvider, this.fStringPool, contentSpecIndex));
            if (this.fDeclHandler != null) {
                this.fDeclHandler.elementDecl(name, contentModel);
            }
        }
    }

    public void attlistDecl(QName elementDecl, QName attributeDecl, int attType, boolean attList, String enumString, int attDefaultType, int attDefaultValue) throws Exception {
        if (this.fDeclHandler != null) {
            String eName = this.fStringPool.toString(elementDecl.rawname);
            String aName = this.fStringPool.toString(attributeDecl.rawname);
            String aType = enumString;
            if (attType != 2) {
                switch (attType) {
                    case 0: {
                        aType = "CDATA";
                        break;
                    }
                    case 1: {
                        aType = attList ? "ENTITIES" : "ENTITY";
                        break;
                    }
                    case 3: {
                        aType = "ID";
                        break;
                    }
                    case 4: {
                        aType = attList ? "IDREFS" : "IDREF";
                        break;
                    }
                    case 5: {
                        aType = attList ? "NMTOKENS" : "NMTOKEN";
                        break;
                    }
                    case 6: {
                        aType = "NOTATION " + enumString;
                    }
                }
            }
            String aDefaultType = null;
            switch (attDefaultType) {
                case 16: {
                    aDefaultType = "#FIXED";
                    break;
                }
                case 1: {
                    aDefaultType = "#IMPLIED";
                    break;
                }
                case 2: {
                    aDefaultType = "#REQUIRED";
                }
            }
            String aDefaultValue = this.fStringPool.toString(attDefaultValue);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.attributeDecl(eName, aName, aType, aDefaultType, aDefaultValue);
            }
        }
    }

    public void internalPEDecl(int entityName, int entityValue) throws Exception {
        if (this.fDeclHandler != null) {
            String name = "%" + this.fStringPool.toString(entityName);
            String value = this.fStringPool.toString(entityValue);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.internalEntityDecl(name, value);
            }
        }
    }

    public void externalPEDecl(int entityName, int publicId, int systemId) throws Exception {
        if (this.fDeclHandler != null) {
            String name = "%" + this.fStringPool.toString(entityName);
            String pubid = this.fStringPool.toString(publicId);
            String sysid = this.fStringPool.toString(systemId);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.externalEntityDecl(name, pubid, sysid);
            }
        }
    }

    public void internalEntityDecl(int entityName, int entityValue) throws Exception {
        if (this.fDeclHandler != null) {
            String name = this.fStringPool.toString(entityName);
            String value = this.fStringPool.toString(entityValue);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.internalEntityDecl(name, value);
            }
        }
    }

    public void externalEntityDecl(int entityName, int publicId, int systemId) throws Exception {
        if (this.fDeclHandler != null) {
            String name = this.fStringPool.toString(entityName);
            String pubid = this.fStringPool.toString(publicId);
            String sysid = this.fStringPool.toString(systemId);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.externalEntityDecl(name, pubid, sysid);
            }
        }
    }

    public void unparsedEntityDecl(int entityName, int publicId, int systemId, int notationName) throws Exception {
        if (this.fDTDHandler != null) {
            String name = this.fStringPool.toString(entityName);
            String pubid = this.fStringPool.toString(publicId);
            String sysid = this.fStringPool.toString(systemId);
            String notation = this.fStringPool.toString(notationName);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.unparsedEntityDecl(name, pubid, sysid, notation);
            }
        }
    }

    public void notationDecl(int notationName, int publicId, int systemId) throws Exception {
        if (this.fDTDHandler != null) {
            String name = this.fStringPool.toString(notationName);
            String pubid = this.fStringPool.toString(publicId);
            String sysid = this.fStringPool.toString(systemId);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.notationDecl(name, pubid, sysid);
            }
        }
    }

    public void startDocument() throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.setDocumentLocator(this.getLocator());
            this.fDocumentHandler.startDocument();
        }
        if (this.fContentHandler != null) {
            this.fContentHandler.setDocumentLocator(this.getLocator());
            this.fContentHandler.startDocument();
        }
    }

    public void endDocument() throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument();
        }
        if (this.fContentHandler != null) {
            this.fContentHandler.endDocument();
        }
    }

    public void xmlDecl(int versionIndex, int encodingIndex, int standaloneIndex) throws Exception {
        this.fStringPool.releaseString(versionIndex);
        this.fStringPool.releaseString(encodingIndex);
        this.fStringPool.releaseString(standaloneIndex);
    }

    public void textDecl(int versionIndex, int encodingIndex) throws Exception {
        this.fStringPool.releaseString(versionIndex);
        this.fStringPool.releaseString(encodingIndex);
    }

    public void startNamespaceDeclScope(int prefix, int uri) throws Exception {
        if (this.fContentHandler != null) {
            String p = this.fStringPool.toString(prefix);
            String ns = this.fStringPool.toString(uri);
            if (this.fContentHandler != null) {
                this.fContentHandler.startPrefixMapping(p, ns);
            }
        }
    }

    public void endNamespaceDeclScope(int prefix) throws Exception {
        if (this.fContentHandler != null) {
            String p = this.fStringPool.toString(prefix);
            if (this.fContentHandler != null) {
                this.fContentHandler.endPrefixMapping(p);
            }
        }
    }

    public void internalSubset(int internalSubset) {
    }

    public void startElement(QName element, XMLAttrList attrList, int attrListIndex) throws Exception {
        String name = this.fStringPool.toString(element.rawname);
        AttributeList attrs = attrList.getAttributeList(attrListIndex);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startElement(name, attrs);
        }
        if (this.fContentHandler != null) {
            boolean namespaces = this.getNamespaces();
            int uriIndex = element.uri;
            String uri = uriIndex != 0 && namespaces ? this.fStringPool.toString(uriIndex) : "";
            int localIndex = element.localpart;
            String local = localIndex != -1 && namespaces ? this.fStringPool.toString(localIndex) : "";
            String raw = name;
            this.fAttributes.clear();
            int attrIndex = attrList.getFirstAttr(attrListIndex);
            while (attrIndex != -1) {
                int attrNameIndex = attrList.getAttrName(attrIndex);
                int attrUriIndex = attrList.getAttrURI(attrIndex);
                String attrUri = attrUriIndex != -1 && namespaces ? this.fStringPool.toString(attrUriIndex) : "";
                int attrLocalIndex = attrList.getAttrLocalpart(attrIndex);
                String attrLocal = attrLocalIndex != -1 && namespaces ? this.fStringPool.toString(attrLocalIndex) : "";
                String attrRaw = this.fStringPool.toString(attrNameIndex);
                String attrType = this.fStringPool.toString(attrList.getAttType(attrIndex));
                String attrValue = this.fStringPool.toString(attrList.getAttValue(attrIndex));
                int attrPrefix = attrList.getAttrPrefix(attrIndex);
                boolean namespacePrefixes = this.getNamespacePrefixes();
                if (!namespaces || namespacePrefixes || attrPrefix != this.fStringPool.addSymbol("xmlns") && attrLocalIndex != this.fStringPool.addSymbol("xmlns")) {
                    this.fAttributes.addAttribute(attrUri, attrLocal, attrRaw, attrType, attrValue);
                }
                attrIndex = attrList.getNextAttr(attrIndex);
            }
            this.fContentHandler.startElement(uri, local, raw, this.fAttributes);
        }
        attrList.releaseAttrList(attrListIndex);
    }

    public void endElement(QName element) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endElement(this.fStringPool.toString(element.rawname));
        }
        if (this.fContentHandler != null) {
            boolean namespaces = this.getNamespaces();
            int uriIndex = element.uri;
            String uri = uriIndex != 0 && namespaces ? this.fStringPool.toString(uriIndex) : "";
            int localIndex = element.localpart;
            String local = localIndex != -1 && namespaces ? this.fStringPool.toString(localIndex) : "";
            String raw = this.fStringPool.toString(element.rawname);
            this.fContentHandler.endElement(uri, local, raw);
        }
    }

    public void startEntityReference(int entityName, int entityType, int entityContext) throws Exception {
        if (this.fLexicalHandler != null) {
            switch (entityType) {
                case 0: 
                case 1: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.startEntity("%" + this.fStringPool.toString(entityName));
                    break;
                }
                case 2: 
                case 3: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.startEntity(this.fStringPool.toString(entityName));
                    break;
                }
                case 4: {
                    throw new RuntimeException("PAR015 startEntityReference(): ENTITYTYPE_UNPARSED");
                }
                case 5: {
                    break;
                }
                case 6: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.startEntity("[dtd]");
                }
            }
        }
    }

    public void endEntityReference(int entityName, int entityType, int entityContext) throws Exception {
        if (this.fLexicalHandler != null) {
            switch (entityType) {
                case 0: 
                case 1: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.endEntity("%" + this.fStringPool.toString(entityName));
                    break;
                }
                case 2: 
                case 3: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.endEntity(this.fStringPool.toString(entityName));
                    break;
                }
                case 4: {
                    throw new RuntimeException("PAR016 endEntityReference(): ENTITYTYPE_UNPARSED");
                }
                case 5: {
                    break;
                }
                case 6: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.endEntity("[dtd]");
                }
            }
        }
    }

    public void startCDATA() throws Exception {
        if (this.fLexicalHandler != null) {
            this.fLexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws Exception {
        if (this.fLexicalHandler != null) {
            this.fLexicalHandler.endCDATA();
        }
    }

    public void characters(int dataIndex) throws Exception {
        throw new RuntimeException("PAR017 cannot happen 5\n5");
    }

    public void ignorableWhitespace(int dataIndex) throws Exception {
        throw new RuntimeException("PAR017 cannot happen 6\n6");
    }

    public void processingInstruction(int piTarget, int piData) throws Exception {
        if (this.fDocumentHandler != null || this.fContentHandler != null) {
            String data;
            String target = this.fStringPool.orphanString(piTarget);
            String string = data = piData == -1 ? "" : this.fStringPool.orphanString(piData);
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.processingInstruction(target, data);
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.processingInstruction(target, data);
            }
        } else {
            this.fStringPool.releaseString(piTarget);
            this.fStringPool.releaseString(piData);
        }
    }

    public void comment(int dataIndex) throws Exception {
        if (this.fLexicalHandler != null) {
            String data = this.fStringPool.orphanString(dataIndex);
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.comment(data.toCharArray(), 0, data.length());
            }
        } else {
            this.fStringPool.releaseString(dataIndex);
        }
    }

    public void characters(char[] ch, int start, int length) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.characters(ch, start, length);
        }
        if (this.fContentHandler != null) {
            this.fContentHandler.characters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(ch, start, length);
        }
        if (this.fContentHandler != null) {
            this.fContentHandler.ignorableWhitespace(ch, start, length);
        }
    }
}

