/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.util.Vector;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.utils.CharDataChunk;
import org.apache.xerces.utils.ImplementationMessages;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringHasher;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;

abstract class AbstractCharReader
extends XMLEntityReader {
    protected CharDataChunk fCurrentChunk = null;
    protected int fCurrentIndex = 0;
    protected char[] fMostRecentData = null;
    protected int fMostRecentChar = 0;
    protected int fLength = 0;
    private static final char[] cdata_string = new char[]{'C', 'D', 'A', 'T', 'A', '['};
    private StringPool fStringPool = null;
    private boolean fCalledCharPropInit = false;
    private boolean fCallClearPreviousChunk = true;
    private Vector fDeferredErrors = null;

    protected AbstractCharReader(XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, StringPool stringPool) {
        super(entityHandler, errorReporter, sendCharDataAsCharArray);
        this.fStringPool = stringPool;
        this.fCurrentChunk = CharDataChunk.createChunk(this.fStringPool, null);
    }

    protected abstract int fillCurrentChunk() throws Exception;

    protected void deferException(int errorCode, Object[] args, int offset) {
        if (this.fDeferredErrors == null) {
            this.fDeferredErrors = new Vector();
        }
        DeferredError de = new DeferredError(errorCode, args, offset);
        this.fDeferredErrors.addElement(de);
    }

    protected XMLEntityHandler.EntityReader changeReaders() throws Exception {
        XMLEntityHandler.EntityReader nextReader = super.changeReaders();
        this.fCurrentChunk.releaseChunk();
        this.fCurrentChunk = null;
        return nextReader;
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int offset, int length) {
        this.fCurrentChunk.append(charBuffer, offset, length);
    }

    public int addString(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(offset, length);
    }

    public int addSymbol(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(offset, length, 0);
    }

    public boolean lookingAtChar(char chr, boolean skipPastChar) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch != chr) {
            if (ch == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtChar(chr, skipPastChar);
            }
            return false;
        }
        if (skipPastChar) {
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            if (++this.fCurrentIndex == 16384) {
                this.slowLoadNextChar();
            } else {
                this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
            }
        }
        return true;
    }

    public boolean lookingAtValidChar(boolean skipPastChar) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch < 55296) {
            if (ch >= 32 || ch == 9) {
                if (skipPastChar) {
                    ++this.fCharacterCounter;
                    this.loadNextChar();
                }
                return true;
            }
            if (ch == 10) {
                if (skipPastChar) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    this.loadNextChar();
                }
                return true;
            }
            if (ch == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtValidChar(skipPastChar);
            }
            return false;
        }
        if (ch > 65533) {
            return false;
        }
        if (ch < 56320) {
            boolean valid;
            CharDataChunk savedChunk = this.fCurrentChunk;
            int savedIndex = this.fCurrentIndex;
            int savedOffset = this.fCurrentOffset;
            ch = this.loadNextChar();
            boolean bl = valid = ch >= 56320 && ch < 57344;
            if (!valid || !skipPastChar) {
                this.fCurrentChunk = savedChunk;
                this.fCurrentIndex = savedIndex;
                this.fCurrentOffset = savedOffset;
                this.fMostRecentData = savedChunk.toCharArray();
                this.fMostRecentChar = this.fMostRecentData[savedIndex] & 0xFFFF;
                return valid;
            }
        } else if (ch < 57344) {
            return false;
        }
        if (skipPastChar) {
            ++this.fCharacterCounter;
            this.loadNextChar();
        }
        return true;
    }

    public boolean lookingAtSpace(boolean skipPastChar) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch > 32) {
            return false;
        }
        if (ch == 32 || ch == 9) {
            if (!skipPastChar) {
                return true;
            }
            ++this.fCharacterCounter;
        } else if (ch == 10) {
            if (!skipPastChar) {
                return true;
            }
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else {
            if (ch == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtSpace(skipPastChar);
            }
            return false;
        }
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        }
        return true;
    }

    public void skipToChar(char chr) throws Exception {
        int ch = this.fMostRecentChar;
        while (ch != chr) {
            if (ch == 0) {
                if (this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders().skipToChar(chr);
                    return;
                }
                ++this.fCharacterCounter;
            } else if (ch == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (ch >= 55296 && ch < 56320) {
                ++this.fCharacterCounter;
                ch = this.loadNextChar();
                if (ch < 56320 || ch >= 57344) {
                    continue;
                }
            } else {
                ++this.fCharacterCounter;
            }
            ch = this.loadNextChar();
        }
        return;
    }

    public void skipPastSpaces() throws Exception {
        int ch = this.fMostRecentChar;
        while (true) {
            if (ch == 32 || ch == 9) {
                ++this.fCharacterCounter;
            } else if (ch == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else {
                if (ch == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders().skipPastSpaces();
                }
                return;
            }
            ch = this.loadNextChar();
        }
    }

    public void skipPastName(char fastcheck) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[ch] == 0) {
                return;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                return;
            }
        }
        while (true) {
            ++this.fCharacterCounter;
            ch = this.loadNextChar();
            if (fastcheck == ch) {
                return;
            }
            if (ch < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[ch] != 0) continue;
                return;
            }
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) break;
        }
    }

    public void skipPastNmtoken(char fastcheck) throws Exception {
        int ch = this.fMostRecentChar;
        while (fastcheck != ch) {
            if (ch < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[ch] == 0) {
                    return;
                }
            } else {
                if (!this.fCalledCharPropInit) {
                    XMLCharacterProperties.initCharFlags();
                    this.fCalledCharPropInit = true;
                }
                if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) {
                    return;
                }
            }
            ++this.fCharacterCounter;
            ch = this.loadNextChar();
        }
        return;
    }

    public boolean skippedString(char[] s) throws Exception {
        int length = s.length;
        char[] data = this.fMostRecentData;
        int index = this.fCurrentIndex;
        if (index + length <= 16384) {
            int i = 0;
            while (i < length) {
                if (data[index++] != s[i]) {
                    return false;
                }
                ++i;
            }
            this.fCharacterCounter += length;
            this.fCurrentOffset += length;
            this.fCurrentIndex = index;
            if (index == 16384) {
                this.slowLoadNextChar();
            } else {
                this.fMostRecentChar = data[index] & 0xFFFF;
            }
            return true;
        }
        CharDataChunk dataChunk = this.fCurrentChunk;
        int offset = this.fCurrentOffset;
        int savedIndex = index;
        int i = 0;
        while (index < 16384) {
            if (data[index++] == s[i++]) continue;
            return false;
        }
        this.slowLoadNextChar();
        data = this.fMostRecentData;
        index = 0;
        while (i < length) {
            if (data[index++] == s[i++]) continue;
            this.fCurrentChunk = dataChunk;
            this.fCurrentIndex = savedIndex;
            this.fCurrentOffset = offset;
            this.fMostRecentData = dataChunk.toCharArray();
            this.fMostRecentChar = this.fMostRecentData[savedIndex] & 0xFFFF;
            return false;
        }
        this.fCharacterCounter += length;
        this.fCurrentOffset += length;
        this.fCurrentIndex = index;
        if (index == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = data[index] & 0xFFFF;
        }
        return true;
    }

    public int scanInvalidChar() throws Exception {
        int ch = this.fMostRecentChar;
        if (ch == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
            this.loadNextChar();
        } else if (ch == 0) {
            if (this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().scanInvalidChar();
            }
            if (this.fDeferredErrors != null) {
                int i = 0;
                while (i < this.fDeferredErrors.size()) {
                    DeferredError de = (DeferredError)this.fDeferredErrors.elementAt(i);
                    if (de.offset == this.fCurrentIndex) {
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", de.errorCode, 0, de.args, 2);
                        this.fDeferredErrors.removeElementAt(i);
                        ++this.fCharacterCounter;
                        this.loadNextChar();
                        return -1;
                    }
                    ++i;
                }
            }
            ++this.fCharacterCounter;
            this.loadNextChar();
        } else {
            ++this.fCharacterCounter;
            if (ch >= 55296 && ch < 56320) {
                int ch2 = this.loadNextChar();
                if (ch2 >= 56320 && ch2 < 57344) {
                    ch = (ch - 55296 << 10) + (ch2 - 56320) + 65536;
                    this.loadNextChar();
                }
            } else {
                this.loadNextChar();
            }
        }
        return ch;
    }

    public int scanCharRef(boolean hex) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch == 0) {
            if (this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().scanCharRef(hex);
            }
            return -2;
        }
        int num = 0;
        if (hex) {
            if (ch > 102 || XMLCharacterProperties.fgAsciiXDigitChar[ch] == 0) {
                return -2;
            }
            num = ch - (ch < 65 ? 48 : (ch < 97 ? 65 : 97) - 10);
        } else {
            if (ch < 48 || ch > 57) {
                return -2;
            }
            num = ch - 48;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        boolean toobig = false;
        while ((ch = this.fMostRecentChar) != 0 && !(hex ? ch > 102 || XMLCharacterProperties.fgAsciiXDigitChar[ch] == 0 : ch < 48 || ch > 57)) {
            int dig;
            ++this.fCharacterCounter;
            this.loadNextChar();
            if (hex) {
                dig = ch - (ch < 65 ? 48 : (ch < 97 ? 65 : 97) - 10);
                num = (num << 4) + dig;
            } else {
                dig = ch - 48;
                num = num * 10 + dig;
            }
            if (num <= 0x10FFFF) continue;
            toobig = true;
            num = 0;
        }
        if (ch != 59) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        if (toobig) {
            return -3;
        }
        return num;
    }

    public int scanStringLiteral() throws Exception {
        boolean single = this.lookingAtChar('\'', true);
        if (!single && !this.lookingAtChar('\"', true)) {
            return -1;
        }
        int offset = this.fCurrentOffset;
        char qchar = single ? (char)'\'' : '\"';
        while (!this.lookingAtChar(qchar, false)) {
            if (this.lookingAtValidChar(true)) continue;
            return -2;
        }
        int stringIndex = this.addString(offset, this.fCurrentOffset - offset);
        this.lookingAtChar(qchar, true);
        return stringIndex;
    }

    public int scanAttValue(char qchar, boolean asSymbol) throws Exception {
        int offset = this.fCurrentOffset;
        while (!this.lookingAtChar(qchar, false)) {
            if (this.lookingAtChar(' ', true)) continue;
            if (this.lookingAtSpace(false)) {
                return -1;
            }
            if (this.lookingAtChar('&', false)) {
                return -1;
            }
            if (this.lookingAtChar('<', false)) {
                return -2;
            }
            if (this.lookingAtValidChar(true)) continue;
            return -3;
        }
        int result = asSymbol ? this.addSymbol(offset, this.fCurrentOffset - offset) : this.addString(offset, this.fCurrentOffset - offset);
        this.lookingAtChar(qchar, true);
        return result;
    }

    public int scanEntityValue(int qchar, boolean createString) throws Exception {
        int offset;
        block5: {
            offset = this.fCurrentOffset;
            do {
                if (this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders();
                    return -5;
                }
                if (qchar != -1 && this.lookingAtChar((char)qchar, false)) {
                    if (!createString) {
                        return -1;
                    }
                    break block5;
                }
                if (this.lookingAtChar('&', false)) {
                    return -2;
                }
                if (!this.lookingAtChar('%', false)) continue;
                return -3;
            } while (this.lookingAtValidChar(true));
            return -4;
        }
        int result = this.addString(offset, this.fCurrentOffset - offset);
        this.lookingAtChar((char)qchar, true);
        return result;
    }

    public int scanName(char fastcheck) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[ch] == 0) {
                return -1;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                return -1;
            }
        }
        int offset = this.fCurrentOffset;
        int index = this.fCurrentIndex;
        char[] data = this.fMostRecentData;
        if (++index == 16384) {
            this.slowLoadNextChar();
            index = 0;
            data = this.fMostRecentData;
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        int hashcode = 0;
        while (true) {
            hashcode = StringHasher.hashChar(hashcode, ch);
            ch = data[index] & 0xFFFF;
            if (fastcheck == ch) break;
            if (ch < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[ch] == 0) {
                    break;
                }
            } else {
                if (!this.fCalledCharPropInit) {
                    XMLCharacterProperties.initCharFlags();
                    this.fCalledCharPropInit = true;
                }
                if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) break;
            }
            if (++index == 16384) {
                this.slowLoadNextChar();
                index = 0;
                data = this.fMostRecentData;
            }
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
        }
        this.fCurrentIndex = index;
        this.fMostRecentChar = ch;
        hashcode = StringHasher.finishHash(hashcode);
        int length = this.fCurrentOffset - offset;
        int nameIndex = this.fCurrentChunk.addSymbol(offset, length, hashcode);
        return nameIndex;
    }

    public boolean scanExpectedName(char fastcheck, StringPool.CharArrayRange expectedName) throws Exception {
        char[] expected = expectedName.chars;
        int offset = expectedName.offset;
        int len = expectedName.length;
        int ch = this.fMostRecentChar;
        int i = 0;
        while (i < len) {
            if (ch != expected[offset++]) {
                this.skipPastNmtoken(fastcheck);
                return false;
            }
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            ch = ++this.fCurrentIndex == 16384 ? this.slowLoadNextChar() : (this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF);
            ++i;
        }
        if (ch == fastcheck) {
            return true;
        }
        if (ch < 128) {
            if (XMLCharacterProperties.fgAsciiNameChar[ch] == 0) {
                return true;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) {
                return true;
            }
        }
        this.skipPastNmtoken(fastcheck);
        return false;
    }

    public void scanQName(char fastcheck, QName qname) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[ch] == 0) {
                qname.clear();
                return;
            }
            if (ch == 58) {
                qname.clear();
                return;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                qname.clear();
                return;
            }
        }
        int offset = this.fCurrentOffset;
        int index = this.fCurrentIndex;
        char[] data = this.fMostRecentData;
        if (++index == 16384) {
            this.slowLoadNextChar();
            index = 0;
            data = this.fMostRecentData;
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        int hashcode = 0;
        int prefixend = -1;
        while (true) {
            hashcode = StringHasher.hashChar(hashcode, ch);
            ch = data[index] & 0xFFFF;
            if (fastcheck == ch) break;
            if (ch < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[ch] == 0) break;
                if (ch == 58) {
                    if (prefixend != -1) break;
                    prefixend = this.fCurrentOffset;
                    if (index + 1 == 16384) {
                        CharDataChunk savedChunk = this.fCurrentChunk;
                        int savedOffset = this.fCurrentOffset;
                        ch = this.slowLoadNextChar();
                        this.fCurrentChunk = savedChunk;
                        this.fCurrentOffset = savedOffset;
                        this.fMostRecentData = savedChunk.toCharArray();
                    } else {
                        ch = data[index + 1] & 0xFFFF;
                    }
                    boolean lpok = true;
                    if (ch < 128) {
                        if (XMLCharacterProperties.fgAsciiInitialNameChar[ch] == 0 || ch == 58) {
                            lpok = false;
                        }
                    } else {
                        if (!this.fCalledCharPropInit) {
                            XMLCharacterProperties.initCharFlags();
                            this.fCalledCharPropInit = true;
                        }
                        if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                            lpok = false;
                        }
                    }
                    ch = 58;
                    if (!lpok) {
                        prefixend = -1;
                        break;
                    }
                }
            } else {
                if (!this.fCalledCharPropInit) {
                    XMLCharacterProperties.initCharFlags();
                    this.fCalledCharPropInit = true;
                }
                if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) break;
            }
            if (++index == 16384) {
                this.slowLoadNextChar();
                index = 0;
                data = this.fMostRecentData;
            }
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
        }
        this.fCurrentIndex = index;
        this.fMostRecentChar = ch;
        hashcode = StringHasher.finishHash(hashcode);
        int length = this.fCurrentOffset - offset;
        qname.rawname = this.fCurrentChunk.addSymbol(offset, length, hashcode);
        qname.prefix = prefixend == -1 ? -1 : this.addSymbol(offset, prefixend - offset);
        qname.localpart = prefixend == -1 ? qname.rawname : this.addSymbol(prefixend + 1, this.fCurrentOffset - (prefixend + 1));
        qname.uri = 0;
    }

    public int scanContent(QName element) throws Exception {
        int offset;
        int index;
        int ch;
        int charDataOffset;
        block55: {
            block54: {
                if (this.fCallClearPreviousChunk && this.fCurrentChunk.clearPreviousChunk()) {
                    this.fCallClearPreviousChunk = false;
                }
                charDataOffset = this.fCurrentOffset++;
                ch = this.fMostRecentChar;
                if (ch >= 128) break block54;
                block0 : switch (XMLCharacterProperties.fgAsciiWSCharData[ch]) {
                    case 0: {
                        ++this.fCharacterCounter;
                        ch = this.loadNextChar();
                        break;
                    }
                    case 1: {
                        ++this.fCharacterCounter;
                        ch = this.loadNextChar();
                        if (!this.fInCDSect) {
                            return this.recognizeMarkup(ch);
                        }
                        break block55;
                    }
                    case 2: {
                        ++this.fCharacterCounter;
                        ch = this.loadNextChar();
                        if (!this.fInCDSect) {
                            return this.recognizeReference(ch);
                        }
                        break block55;
                    }
                    case 3: {
                        ++this.fCharacterCounter;
                        ch = this.loadNextChar();
                        if (ch != 93) break;
                        if (this.fCurrentIndex + 1 == 16384) {
                            CharDataChunk dataChunk = this.fCurrentChunk;
                            int index2 = this.fCurrentIndex;
                            int offset2 = this.fCurrentOffset;
                            if (this.loadNextChar() != 62) {
                                this.fCurrentChunk = dataChunk;
                                this.fCurrentIndex = index2;
                                this.fCurrentOffset = offset2;
                                this.fMostRecentData = dataChunk.toCharArray();
                                this.fMostRecentChar = 93;
                                break;
                            }
                        } else {
                            if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') break;
                            ++this.fCurrentIndex;
                        }
                        this.loadNextChar();
                        this.fCharacterCounter += 2;
                        return 3;
                    }
                    case 4: {
                        if (ch == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                            this.changeReaders();
                            return 9;
                        }
                        return 9;
                    }
                    case 5: {
                        do {
                            if (ch == 10) {
                                ++this.fLinefeedCounter;
                                this.fCharacterCounter = 1;
                                continue;
                            }
                            ++this.fCharacterCounter;
                        } while ((ch = this.loadNextChar()) == 32 || ch == 9 || ch == 10);
                        if (ch < 128) {
                            switch (XMLCharacterProperties.fgAsciiCharData[ch]) {
                                case 0: {
                                    ++this.fCharacterCounter;
                                    ch = this.loadNextChar();
                                    break block0;
                                }
                                case 1: {
                                    if (!this.fInCDSect) {
                                        this.callCharDataHandler(charDataOffset, this.fCurrentOffset, true);
                                        ++this.fCharacterCounter;
                                        ch = this.loadNextChar();
                                        return this.recognizeMarkup(ch);
                                    }
                                    ++this.fCharacterCounter;
                                    ch = this.loadNextChar();
                                    break block0;
                                }
                                case 2: {
                                    if (!this.fInCDSect) {
                                        this.callCharDataHandler(charDataOffset, this.fCurrentOffset, true);
                                        ++this.fCharacterCounter;
                                        ch = this.loadNextChar();
                                        return this.recognizeReference(ch);
                                    }
                                    ++this.fCharacterCounter;
                                    ch = this.loadNextChar();
                                    break block0;
                                }
                                case 3: {
                                    int endOffset = this.fCurrentOffset++;
                                    ch = this.loadNextChar();
                                    if (ch != 93) {
                                        ++this.fCharacterCounter;
                                        break block0;
                                    }
                                    if (this.fCurrentIndex + 1 == 16384) {
                                        CharDataChunk dataChunk = this.fCurrentChunk;
                                        index = this.fCurrentIndex;
                                        offset = this.fCurrentOffset;
                                        if (this.loadNextChar() != 62) {
                                            this.fCurrentChunk = dataChunk;
                                            this.fCurrentIndex = index;
                                            this.fCurrentOffset = offset;
                                            this.fMostRecentData = dataChunk.toCharArray();
                                            this.fMostRecentChar = 93;
                                            ++this.fCharacterCounter;
                                            break block0;
                                        }
                                    } else {
                                        if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') {
                                            ++this.fCharacterCounter;
                                            break block0;
                                        }
                                        ++this.fCurrentIndex;
                                    }
                                    this.loadNextChar();
                                    this.callCharDataHandler(charDataOffset, endOffset, true);
                                    this.fCharacterCounter += 3;
                                    return 3;
                                }
                                case 4: {
                                    this.callCharDataHandler(charDataOffset, this.fCurrentOffset, true);
                                    if (ch == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                                        this.changeReaders();
                                        return 9;
                                    }
                                    return 9;
                                }
                            }
                            break;
                        }
                        if (!this.skipMultiByteCharData(ch)) {
                            this.callCharDataHandler(charDataOffset, this.fCurrentOffset, true);
                            return 9;
                        }
                        break block55;
                    }
                }
                break block55;
            }
            if (!this.skipMultiByteCharData(ch)) {
                return 9;
            }
        }
        ch = this.skipAsciiCharData();
        block23: while (true) {
            if (ch < 128) {
                switch (XMLCharacterProperties.fgAsciiCharData[ch]) {
                    case 0: {
                        ++this.fCharacterCounter;
                        ch = this.loadNextChar();
                        continue block23;
                    }
                    case 1: {
                        if (!this.fInCDSect) {
                            this.callCharDataHandler(charDataOffset, this.fCurrentOffset, false);
                            ++this.fCharacterCounter;
                            ch = this.loadNextChar();
                            return this.recognizeMarkup(ch);
                        }
                        ++this.fCharacterCounter;
                        ch = this.loadNextChar();
                        continue block23;
                    }
                    case 2: {
                        if (!this.fInCDSect) {
                            this.callCharDataHandler(charDataOffset, this.fCurrentOffset, false);
                            ++this.fCharacterCounter;
                            ch = this.loadNextChar();
                            return this.recognizeReference(ch);
                        }
                        ++this.fCharacterCounter;
                        ch = this.loadNextChar();
                        continue block23;
                    }
                    case 3: {
                        int endOffset = this.fCurrentOffset++;
                        ch = this.loadNextChar();
                        if (ch != 93) {
                            ++this.fCharacterCounter;
                            continue block23;
                        }
                        if (this.fCurrentIndex + 1 == 16384) {
                            CharDataChunk dataChunk = this.fCurrentChunk;
                            index = this.fCurrentIndex;
                            offset = this.fCurrentOffset;
                            if (this.loadNextChar() != 62) {
                                this.fCurrentChunk = dataChunk;
                                this.fCurrentIndex = index;
                                this.fCurrentOffset = offset;
                                this.fMostRecentData = dataChunk.toCharArray();
                                this.fMostRecentChar = 93;
                                ++this.fCharacterCounter;
                                continue block23;
                            }
                        } else {
                            if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') {
                                ++this.fCharacterCounter;
                                continue block23;
                            }
                            ++this.fCurrentIndex;
                        }
                        this.loadNextChar();
                        this.callCharDataHandler(charDataOffset, endOffset, false);
                        this.fCharacterCounter += 3;
                        return 3;
                    }
                    case 4: {
                        if (ch == 10) {
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                            ch = this.loadNextChar();
                            continue block23;
                        }
                        this.callCharDataHandler(charDataOffset, this.fCurrentOffset, false);
                        if (ch == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                            this.changeReaders();
                            return 9;
                        }
                        return 9;
                    }
                }
                continue;
            }
            if (!this.skipMultiByteCharData(ch)) {
                this.callCharDataHandler(charDataOffset, this.fCurrentOffset, false);
                return 9;
            }
            ch = this.fMostRecentChar;
        }
    }

    private int recognizeMarkup(int ch) throws Exception {
        switch (ch) {
            case 0: {
                return 11;
            }
            case 63: {
                ++this.fCharacterCounter;
                this.loadNextChar();
                return 0;
            }
            case 33: {
                ++this.fCharacterCounter;
                ch = this.loadNextChar();
                if (ch == 0) {
                    --this.fCharacterCounter;
                    --this.fCurrentOffset;
                    return 11;
                }
                if (ch == 45) {
                    ++this.fCharacterCounter;
                    ch = this.loadNextChar();
                    if (ch == 0) {
                        this.fCharacterCounter -= 2;
                        this.fCurrentOffset -= 2;
                        return 11;
                    }
                    if (ch != 45) break;
                    ++this.fCharacterCounter;
                    this.loadNextChar();
                    return 1;
                }
                if (ch != 91) break;
                int i = 0;
                while (i < 6) {
                    ++this.fCharacterCounter;
                    ch = this.loadNextChar();
                    if (ch == 0) {
                        this.fCharacterCounter -= 2 + i;
                        this.fCurrentOffset -= 2 + i;
                        return 11;
                    }
                    if (ch != cdata_string[i]) {
                        return 10;
                    }
                    ++i;
                }
                ++this.fCharacterCounter;
                this.loadNextChar();
                return 2;
            }
            case 47: {
                ++this.fCharacterCounter;
                this.loadNextChar();
                return 4;
            }
            default: {
                return 6;
            }
        }
        return 10;
    }

    private int recognizeReference(int ch) throws Exception {
        if (ch == 0) {
            return 12;
        }
        if (ch == 35) {
            ++this.fCharacterCounter;
            this.loadNextChar();
            return 7;
        }
        return 8;
    }

    private boolean skipMultiByteCharData(int ch) throws Exception {
        if (ch < 55296) {
            this.loadNextChar();
            return true;
        }
        if (ch > 65533) {
            return false;
        }
        if (ch >= 56320 && ch < 57344) {
            return false;
        }
        if (ch >= 55296 && ch < 56320) {
            CharDataChunk savedChunk = this.fCurrentChunk;
            int savedIndex = this.fCurrentIndex;
            int savedOffset = this.fCurrentOffset;
            ch = this.loadNextChar();
            if (ch < 56320 || ch >= 57344) {
                this.fCurrentChunk = savedChunk;
                this.fCurrentIndex = savedIndex;
                this.fCurrentOffset = savedOffset;
                this.fMostRecentData = savedChunk.toCharArray();
                this.fMostRecentChar = this.fMostRecentData[savedIndex] & 0xFFFF;
                return false;
            }
        }
        this.loadNextChar();
        return true;
    }

    private int skipAsciiCharData() throws Exception {
        int index = this.fCurrentIndex;
        int offset = this.fCurrentOffset - index;
        while (true) {
            char[] data = this.fMostRecentData;
            while (index < 16384) {
                int ch = data[index] & 0xFFFF;
                if (ch >= 128) {
                    this.fCurrentOffset = offset + index;
                    this.fCurrentIndex = index;
                    this.fMostRecentChar = ch;
                    return ch;
                }
                if (XMLCharacterProperties.fgAsciiCharData[ch] == 0) {
                    ++this.fCharacterCounter;
                } else if (ch == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else {
                    this.fCurrentOffset = offset + index;
                    this.fCurrentIndex = index;
                    this.fMostRecentChar = ch;
                    return ch;
                }
                ++index;
            }
            offset += index;
            this.slowLoadNextChar();
            index = 0;
        }
    }

    private void callCharDataHandler(int offset, int endOffset, boolean isWhitespace) throws Exception {
        int length = endOffset - offset;
        if (!this.fSendCharDataAsCharArray) {
            int stringIndex = this.addString(offset, length);
            if (isWhitespace) {
                this.fCharDataHandler.processWhitespace(stringIndex);
            } else {
                this.fCharDataHandler.processCharacters(stringIndex);
            }
            return;
        }
        CharDataChunk dataChunk = this.fCurrentChunk.chunkFor(offset);
        int index = offset & 0x3FFF;
        if (index + length <= 16384) {
            if (length != 0) {
                if (isWhitespace) {
                    this.fCharDataHandler.processWhitespace(dataChunk.toCharArray(), index, length);
                } else {
                    this.fCharDataHandler.processCharacters(dataChunk.toCharArray(), index, length);
                }
            }
            return;
        }
        int count = length;
        int nbytes = 16384 - index;
        if (isWhitespace) {
            this.fCharDataHandler.processWhitespace(dataChunk.toCharArray(), index, nbytes);
        } else {
            this.fCharDataHandler.processCharacters(dataChunk.toCharArray(), index, nbytes);
        }
        count -= nbytes;
        do {
            if ((dataChunk = dataChunk.nextChunk()) == null) {
                throw new RuntimeException(new ImplementationMessages().createMessage(null, 14, 0, null));
            }
            int n = nbytes = count <= 16384 ? count : 16384;
            if (isWhitespace) {
                this.fCharDataHandler.processWhitespace(dataChunk.toCharArray(), 0, nbytes);
                continue;
            }
            this.fCharDataHandler.processCharacters(dataChunk.toCharArray(), 0, nbytes);
        } while ((count -= nbytes) > 0);
    }

    private int slowLoadNextChar() throws Exception {
        this.fCallClearPreviousChunk = true;
        if (this.fCurrentChunk.nextChunk() != null) {
            this.fCurrentChunk = this.fCurrentChunk.nextChunk();
            this.fCurrentIndex = 0;
            this.fMostRecentData = this.fCurrentChunk.toCharArray();
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
            return this.fMostRecentChar;
        }
        this.fCurrentChunk = CharDataChunk.createChunk(this.fStringPool, this.fCurrentChunk);
        return this.fillCurrentChunk();
    }

    private int loadNextChar() throws Exception {
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            return this.slowLoadNextChar();
        }
        this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        return this.fMostRecentChar;
    }

    private boolean atEOF(int offset) {
        return offset > this.fLength;
    }

    private class DeferredError {
        int errorCode;
        Object[] args;
        int offset;

        DeferredError(int ec, Object[] a, int o) {
            this.errorCode = ec;
            this.args = a;
            this.offset = o;
        }
    }
}

