/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.IOException;
import java.io.Reader;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.AbstractCharReader;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.StringPool;

final class CharReader
extends AbstractCharReader {
    private Reader fCharacterStream = null;
    private boolean fCheckOverflow = false;
    private char[] fOverflow = null;
    private int fOverflowOffset = 0;
    private int fOverflowEnd = 0;
    private int fOutputOffset = 0;
    private boolean fSkipLinefeed = false;

    CharReader(XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, Reader reader, StringPool stringPool) throws Exception {
        super(entityHandler, errorReporter, sendCharDataAsCharArray, stringPool);
        this.fCharacterStream = reader;
        this.fillCurrentChunk();
    }

    /*
     * Unable to fully structure code
     */
    protected int fillCurrentChunk() throws Exception {
        recycledData = this.fCurrentChunk.toCharArray();
        this.fOutputOffset = 0;
        if (this.fCheckOverflow) {
            this.fMostRecentData = recycledData;
            if (this.fOverflowEnd < 16384) {
                recycledData = null;
                if (this.fOverflowEnd > 0) {
                    if (this.fMostRecentData == null || this.fMostRecentData.length < 1 + this.fOverflowEnd - this.fOverflowOffset) {
                        this.fMostRecentData = new char[1 + this.fOverflowEnd - this.fOverflowOffset];
                    }
                    this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                } else if (this.fMostRecentData == null) {
                    this.fMostRecentData = new char[1];
                }
                this.fMostRecentData[this.fOutputOffset] = '\u0000';
                this.fOverflow = null;
                this.fLength += this.fOutputOffset;
                this.fCurrentIndex = 0;
                this.fCurrentChunk.setCharArray(this.fMostRecentData);
                this.fMostRecentChar = this.fMostRecentData[0];
                return this.fMostRecentChar;
            }
            if (this.fMostRecentData == null || this.fMostRecentData.length < 16384) {
                this.fMostRecentData = new char[16384];
            } else {
                recycledData = null;
            }
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
            this.fCheckOverflow = false;
        } else {
            if (this.fOverflow == null) {
                this.fOverflow = recycledData;
                if (this.fOverflow == null || this.fOverflow.length < 16384) {
                    this.fOverflow = new char[16384];
                } else {
                    recycledData = null;
                }
            }
            this.fMostRecentData = null;
        }
        do lbl-1000:
        // 3 sources

        {
            block24: {
                this.fOverflowOffset = 0;
                this.fOverflowEnd = 0;
                capacity = 16384;
                result = 0;
                do {
                    try {
                        result = this.fCharacterStream.read(this.fOverflow, this.fOverflowEnd, capacity);
                    }
                    catch (IOException ex) {
                        result = -1;
                    }
                    if (result == -1) {
                        this.fCharacterStream.close();
                        this.fCharacterStream = null;
                        if (this.fMostRecentData == null) {
                            this.fMostRecentData = recycledData;
                            if (this.fMostRecentData == null || this.fMostRecentData.length < 1 + this.fOverflowEnd) {
                                this.fMostRecentData = new char[1 + this.fOverflowEnd];
                            } else {
                                recycledData = null;
                            }
                            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = '\u0000';
                            break;
                        }
                        alldone = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                        if (alldone) {
                            if (this.fOutputOffset == 16384) {
                                this.fCheckOverflow = true;
                                this.fOverflowOffset = 0;
                                this.fOverflowEnd = 0;
                                break;
                            }
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = '\u0000';
                            break;
                        }
                        this.fCheckOverflow = true;
                        break;
                    }
                    if (result <= 0) continue;
                    this.fOverflowEnd += result;
                    capacity -= result;
                } while (capacity > 0);
                if (result == -1) break;
                if (this.fMostRecentData == null) break block24;
                alldone = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                if (this.fOutputOffset != 16384) ** GOTO lbl-1000
                if (alldone) break;
                this.fCheckOverflow = true;
                break;
            }
            this.fMostRecentData = recycledData;
            if (this.fMostRecentData == null || this.fMostRecentData.length < 16384) {
                this.fMostRecentData = new char[16384];
            } else {
                recycledData = null;
            }
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
        } while (this.fOutputOffset != 16384);
        this.fLength += this.fOutputOffset;
        this.fCurrentIndex = 0;
        this.fCurrentChunk.setCharArray(this.fMostRecentData);
        this.fMostRecentChar = this.fMostRecentData[0];
        return this.fMostRecentChar;
    }

    private boolean copyNormalize(char[] in, int inOffset, char[] out, int outOffset) throws Exception {
        int inEnd = this.fOverflowEnd;
        int outEnd = out.length;
        if (inOffset == inEnd) {
            return true;
        }
        char b = in[inOffset];
        if (this.fSkipLinefeed) {
            this.fSkipLinefeed = false;
            if (b == '\n') {
                if (++inOffset == inEnd) {
                    return this.exitNormalize(inOffset, outOffset, true);
                }
                b = in[inOffset];
            }
        }
        while (outOffset < outEnd) {
            int inCount = inEnd - inOffset;
            int outCount = outEnd - outOffset;
            if (inCount > outCount) {
                inCount = outCount;
            }
            ++inOffset;
            while (true) {
                if (b == '\r') {
                    out[outOffset++] = 10;
                    if (inOffset == inEnd) {
                        this.fSkipLinefeed = true;
                        return this.exitNormalize(inOffset, outOffset, true);
                    }
                    b = in[inOffset];
                    if (b == '\n') {
                        if (++inOffset == inEnd) {
                            return this.exitNormalize(inOffset, outOffset, true);
                        }
                        b = in[inOffset];
                    }
                    if (outOffset == outEnd) {
                        return this.exitNormalize(inOffset, outOffset, false);
                    }
                    inCount = inEnd - inOffset;
                    outCount = outEnd - outOffset;
                    if (inCount > outCount) {
                        inCount = outCount;
                    }
                    ++inOffset;
                    continue;
                }
                do {
                    out[outOffset++] = b;
                } while (--inCount != 0 && (b = in[inOffset++]) != '\r');
                if (inCount == 0) break;
            }
            if (inOffset == inEnd) break;
        }
        return this.exitNormalize(inOffset, outOffset, inOffset == inEnd);
    }

    private boolean exitNormalize(int inOffset, int outOffset, boolean result) {
        this.fOverflowOffset = inOffset;
        this.fOutputOffset = outOffset;
        return result;
    }
}

