/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.DefaultReaderFactory;
import org.apache.xerces.readers.XMLDeclRecognizer;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.URI;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public class DefaultEntityHandler
implements XMLEntityHandler,
XMLEntityHandler.DTDHandler {
    private ReaderState fReaderStateFreeList = null;
    private StringPool fStringPool = null;
    private EventHandler fEventHandler = null;
    private XMLEntityHandler.CharDataHandler fCharDataHandler = null;
    private XMLErrorReporter fErrorReporter = null;
    private EntityResolver fResolver = null;
    private EntityPool fEntityPool = null;
    private EntityPool fParameterEntityPool = null;
    private byte[] fEntityTypeStack = null;
    private int[] fEntityNameStack = null;
    private int fEntityStackDepth = 0;
    private Stack fReaderStack = new Stack();
    private XMLEntityHandler.EntityReader fReader = null;
    private InputSource fSource = null;
    private int fEntityName = -1;
    private int fEntityType = -1;
    private int fEntityContext = -1;
    private String fPublicId = null;
    private String fSystemId = null;
    private int fReaderId = -1;
    private int fReaderDepth = -1;
    private int fNextReaderId = 0;
    private NullReader fNullReader = null;
    protected XMLEntityReaderFactory fReaderFactory = null;
    private boolean fSendCharDataAsCharArray = false;
    static final int CHUNK_SHIFT = 5;
    static final int CHUNK_SIZE = 32;
    static final int CHUNK_MASK = 31;
    static final int INITIAL_CHUNK_COUNT = 32;

    public DefaultEntityHandler(StringPool stringPool, XMLErrorReporter errorReporter) {
        this.fStringPool = stringPool;
        this.fErrorReporter = errorReporter;
        this.fReaderFactory = new DefaultReaderFactory();
        this.fEntityPool = new EntityPool(this.fStringPool, this.fErrorReporter, true);
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    public void setCharDataHandler(XMLEntityHandler.CharDataHandler charDataHandler) {
        this.fCharDataHandler = charDataHandler;
    }

    public XMLEntityHandler.CharDataHandler getCharDataHandler() {
        return this.fCharDataHandler;
    }

    public void setSendCharDataAsCharArray(boolean flag) {
        this.fSendCharDataAsCharArray = flag;
        this.fReaderFactory.setSendCharDataAsCharArray(this.fSendCharDataAsCharArray);
    }

    public void setReaderFactory(XMLEntityReaderFactory readerFactory) {
        this.fReaderFactory = readerFactory;
        this.fReaderFactory.setSendCharDataAsCharArray(this.fSendCharDataAsCharArray);
    }

    public void reset(StringPool stringPool) {
        this.fStringPool = stringPool;
        this.fEntityPool.reset(this.fStringPool);
        this.fParameterEntityPool = null;
        this.fReaderStack.removeAllElements();
        this.fEntityStackDepth = 0;
        this.fReader = null;
        this.fSource = null;
        this.fEntityName = -1;
        this.fEntityType = -1;
        this.fEntityContext = -1;
        this.fPublicId = null;
        this.fSystemId = null;
        this.fReaderId = -1;
        this.fReaderDepth = -1;
        this.fNextReaderId = 0;
    }

    public void setAllowJavaEncodings(boolean flag) {
        this.fReaderFactory.setAllowJavaEncodingName(flag);
    }

    public boolean getAllowJavaEncodings() {
        return this.fReaderFactory.getAllowJavaEncodingName();
    }

    public int addInternalPEDecl(int name, int value, boolean isExternal) throws Exception {
        if (this.fParameterEntityPool == null) {
            this.fParameterEntityPool = new EntityPool(this.fStringPool, this.fErrorReporter, false);
        }
        int entityHandle = this.fParameterEntityPool.addEntityDecl(name, value, -1, -1, -1, -1, isExternal);
        return entityHandle;
    }

    public int addExternalPEDecl(int name, int publicId, int systemId, boolean isExternal) throws Exception {
        if (this.fParameterEntityPool == null) {
            this.fParameterEntityPool = new EntityPool(this.fStringPool, this.fErrorReporter, false);
        }
        int entityHandle = this.fParameterEntityPool.addEntityDecl(name, -1, publicId, systemId, this.fStringPool.addSymbol(this.fSystemId), -1, isExternal);
        return entityHandle;
    }

    public int addInternalEntityDecl(int name, int value, boolean isExternal) throws Exception {
        int entityHandle = this.fEntityPool.addEntityDecl(name, value, -1, -1, -1, -1, isExternal);
        return entityHandle;
    }

    public int addExternalEntityDecl(int name, int publicId, int systemId, boolean isExternal) throws Exception {
        int entityHandle = this.fEntityPool.addEntityDecl(name, -1, publicId, systemId, this.fStringPool.addSymbol(this.fSystemId), -1, isExternal);
        return entityHandle;
    }

    public int addUnparsedEntityDecl(int name, int publicId, int systemId, int notationName, boolean isExternal) throws Exception {
        int entityHandle = this.fEntityPool.addEntityDecl(name, -1, publicId, systemId, this.fStringPool.addSymbol(this.fSystemId), notationName, isExternal);
        if (!this.fEntityPool.isNotationDeclared(notationName)) {
            Object[] args = new Object[]{this.fStringPool.toString(name), this.fStringPool.toString(notationName)};
            this.fEntityPool.addRequiredNotation(notationName, this.fErrorReporter.getLocator(), 114, 89, args);
        }
        return entityHandle;
    }

    public int addNotationDecl(int notationName, int publicId, int systemId, boolean isExternal) throws Exception {
        int notationHandle = this.fEntityPool.addNotationDecl(notationName, publicId, systemId, this.fStringPool.addSymbol(this.fSystemId), isExternal);
        return notationHandle;
    }

    public boolean isUnparsedEntity(int entityName) {
        int entityHandle = this.fEntityPool.lookupEntity(entityName);
        return entityHandle != -1 && this.fEntityPool.isUnparsedEntity(entityHandle);
    }

    public boolean isNotationDeclared(int notationName) {
        return this.fEntityPool.isNotationDeclared(notationName);
    }

    public void addRequiredNotation(int notationName, Locator locator, int majorCode, int minorCode, Object[] args) {
        this.fEntityPool.addRequiredNotation(notationName, locator, majorCode, minorCode, args);
    }

    public void checkRequiredNotations() throws Exception {
        this.fEntityPool.checkRequiredNotations();
    }

    protected int lookupEntity(int entityNameIndex) {
        int entityIndex = this.fEntityPool.lookupEntity(entityNameIndex);
        return entityIndex;
    }

    private void reportRecoverableXMLError(int majorCode, int minorCode, int stringIndex1) throws Exception {
        Object[] args = new Object[]{this.fStringPool.toString(stringIndex1)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 1);
    }

    public boolean externalReferenceInContent(int entityHandle) throws Exception {
        boolean external = this.fEntityPool.isExternalEntity(entityHandle);
        if (this.fEventHandler.externalEntityStandaloneCheck()) {
            if (external) {
                this.reportRecoverableXMLError(102, 80, this.fEntityName);
            } else if (this.fEntityPool.getEntityDeclIsExternal(entityHandle)) {
                this.reportRecoverableXMLError(132, 80, this.fEntityName);
            }
        }
        return external;
    }

    protected int valueOfReferenceInAttValue(int entityHandle) throws Exception {
        if (this.fEventHandler.externalEntityStandaloneCheck() && this.fEntityPool.getEntityDeclIsExternal(entityHandle)) {
            this.reportRecoverableXMLError(132, 80, this.fEntityName);
        }
        int entityValue = this.fEntityPool.getEntityValue(entityHandle);
        return entityValue;
    }

    protected boolean isExternalEntity(int entityHandle) {
        boolean external = this.fEntityPool.isExternalEntity(entityHandle);
        return external;
    }

    protected int getEntityValue(int entityHandle) {
        int value = this.fEntityPool.getEntityValue(entityHandle);
        return value;
    }

    protected String getPublicIdOfEntity(int entityHandle) {
        int publicId = this.fEntityPool.getPublicId(entityHandle);
        return this.fStringPool.toString(publicId);
    }

    protected String getSystemIdOfEntity(int entityHandle) {
        int systemId = this.fEntityPool.getSystemId(entityHandle);
        return this.fStringPool.toString(systemId);
    }

    protected int lookupParameterEntity(int peName) throws Exception {
        int entityHandle = -1;
        if (this.fParameterEntityPool != null) {
            entityHandle = this.fParameterEntityPool.lookupEntity(peName);
        }
        return entityHandle;
    }

    protected boolean isExternalParameterEntity(int peIndex) {
        boolean external = this.fParameterEntityPool.isExternalEntity(peIndex);
        return external;
    }

    protected int getParameterEntityValue(int peIndex) {
        int value = this.fParameterEntityPool.getEntityValue(peIndex);
        return value;
    }

    protected String getPublicIdOfParameterEntity(int peIndex) {
        int publicId = this.fParameterEntityPool.getPublicId(peIndex);
        return this.fStringPool.toString(publicId);
    }

    protected String getSystemIdOfParameterEntity(int peIndex) {
        int systemId = this.fParameterEntityPool.getSystemId(peIndex);
        return this.fStringPool.toString(systemId);
    }

    public XMLEntityHandler.EntityReader getEntityReader() {
        return this.fReader;
    }

    public void addRecognizer(XMLDeclRecognizer recognizer) {
        this.fReaderFactory.addRecognizer(recognizer);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.fResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.fResolver;
    }

    public String expandSystemId(String systemId) {
        return this.expandSystemId(systemId, this.fSystemId);
    }

    private String expandSystemId(String systemId, String currentSystemId) {
        String id = systemId;
        if (id == null || id.length() == 0) {
            return "";
        }
        try {
            URI uri = new URI(id);
            if (uri != null) {
                return systemId;
            }
        }
        catch (URI.MalformedURIException uri) {
            // empty catch block
        }
        id = DefaultEntityHandler.fixURI(id);
        URI base = null;
        URI uri = null;
        try {
            if (currentSystemId == null) {
                String dir;
                try {
                    dir = DefaultEntityHandler.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException se) {
                    dir = "";
                }
                if (!dir.endsWith("/")) {
                    dir = String.valueOf(dir) + "/";
                }
                base = new URI("file", "", dir, null, null);
            } else {
                base = new URI(currentSystemId);
            }
            uri = new URI(base, id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uri == null) {
            return systemId;
        }
        return uri.toString();
    }

    private static String fixURI(String str) {
        char ch0;
        char ch1;
        if ((str = str.replace(File.separatorChar, '/')).length() >= 2 && (ch1 = str.charAt(1)) == ':' && (ch0 = Character.toUpperCase(str.charAt(0))) >= 'A' && ch0 <= 'Z') {
            str = "/" + str;
        }
        return str;
    }

    public boolean startReadingFromDocument(InputSource source) throws Exception {
        this.pushEntity(false, -2);
        this.fSystemId = null;
        this.pushNullReader();
        this.fEntityName = -2;
        this.fEntityType = 5;
        this.fEntityContext = 6;
        this.fReaderDepth = 0;
        this.fReaderId = this.fNextReaderId++;
        this.fPublicId = source.getPublicId();
        this.fSystemId = source.getSystemId();
        this.fEventHandler.startEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
        this.fSystemId = this.expandSystemId(this.fSystemId, null);
        this.fSource = source;
        boolean xmlDecl = true;
        try {
            this.fReader = this.fReaderFactory.createReader(this, this.fErrorReporter, source, this.fSystemId, xmlDecl, this.fStringPool);
        }
        catch (MalformedURLException mu) {
            String errorSystemId = this.fSystemId;
            this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
            this.popReader();
            this.popEntity();
            this.fReader = null;
            Object[] args = new Object[]{errorSystemId};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 5, 0, args, 2);
        }
        catch (FileNotFoundException fnf) {
            String errorSystemId = this.fSystemId;
            this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
            this.popReader();
            this.popEntity();
            this.fReader = null;
            Object[] args = new Object[]{errorSystemId};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 5, 0, args, 1);
            throw fnf;
        }
        catch (UnsupportedEncodingException uee) {
            this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
            this.popReader();
            this.popEntity();
            this.fReader = null;
            String encoding = uee.getMessage();
            if (encoding == null) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 70, 72, null, 2);
            }
            if (!XMLCharacterProperties.validEncName(encoding)) {
                Object[] args = new Object[]{encoding};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 40, 42, args, 2);
            }
            Object[] args = new Object[]{encoding};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 61, 60, args, 2);
        }
        this.fEventHandler.sendReaderChangeNotifications(this.fReader, this.fReaderId);
        return this.fReader != null;
    }

    public void startReadingFromExternalSubset(String publicId, String systemId, int readerDepth) throws Exception {
        this.pushEntity(true, -1);
        this.pushReader();
        this.pushNullReader();
        this.fEntityName = -1;
        this.fEntityType = 6;
        this.fEntityContext = 7;
        this.fReaderDepth = readerDepth;
        this.fReaderId = this.fNextReaderId++;
        this.fPublicId = publicId;
        this.fSystemId = systemId;
        this.startReadingFromExternalEntity(false, -1);
    }

    public void stopReadingFromExternalSubset() throws Exception {
        if (!(this.fReader instanceof NullReader)) {
            throw new RuntimeException("FWK004 cannot happen 18\n18");
        }
        this.popReader();
        this.fEventHandler.sendReaderChangeNotifications(this.fReader, this.fReaderId);
    }

    public boolean startReadingFromEntity(int entityName, int readerDepth, int context) throws Exception {
        if (context > 2) {
            return this.startReadingFromParameterEntity(entityName, readerDepth, context);
        }
        int entityHandle = this.lookupEntity(entityName);
        if (entityHandle < 0) {
            int minorCode = 62;
            int errorType = 1;
            if (this.fEntityContext == 6 || this.fEntityContext == 0) {
                minorCode = 61;
                errorType = 2;
            } else if (!this.fEventHandler.getValidating()) {
                return false;
            }
            Object[] args = new Object[]{this.fStringPool.toString(entityName)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 62, minorCode, args, errorType);
            return false;
        }
        if (context == 2) {
            if (this.fEntityPool.isUnparsedEntity(entityHandle)) {
                Object[] args = new Object[]{this.fStringPool.toString(entityName)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 63, 63, args, 2);
                return false;
            }
        } else if (this.isExternalEntity(entityHandle)) {
            Object[] args = new Object[]{this.fStringPool.toString(entityName)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 64, 64, args, 2);
            return false;
        }
        if (!this.pushEntity(false, entityName)) {
            Object[] args = new Object[]{this.fStringPool.toString(entityName), this.entityReferencePath(false, entityName)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 71, 73, args, 2);
            return false;
        }
        this.pushReader();
        this.fEntityName = entityName;
        this.fEntityContext = context;
        this.fReaderDepth = readerDepth;
        this.fReaderId = this.fNextReaderId++;
        if (context != 2 || !this.externalReferenceInContent(entityHandle)) {
            this.fEntityType = 2;
            this.fPublicId = null;
            this.fSystemId = this.fSystemId;
            int value = -1;
            value = context == 2 || context == 1 ? this.getEntityValue(entityHandle) : this.valueOfReferenceInAttValue(entityHandle);
            this.startReadingFromInternalEntity(value, false);
            return false;
        }
        this.fEntityType = 3;
        this.fPublicId = this.getPublicIdOfEntity(entityHandle);
        this.fSystemId = this.getSystemIdOfEntity(entityHandle);
        return this.startReadingFromExternalEntity(true, entityHandle);
    }

    private boolean startReadingFromParameterEntity(int peName, int readerDepth, int context) throws Exception {
        int entityHandle = this.lookupParameterEntity(peName);
        if (entityHandle == -1) {
            if (this.fEventHandler.getValidating()) {
                this.reportRecoverableXMLError(62, 62, peName);
            }
            return false;
        }
        if (!this.pushEntity(true, peName)) {
            Object[] args = new Object[]{this.fStringPool.toString(peName), this.entityReferencePath(true, peName)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 72, 73, args, 2);
            return false;
        }
        this.pushReader();
        this.fEntityName = peName;
        this.fEntityContext = context;
        this.fReaderDepth = readerDepth;
        this.fReaderId = this.fNextReaderId++;
        if (!this.isExternalParameterEntity(entityHandle)) {
            this.fEntityType = 0;
            this.fPublicId = null;
            this.fSystemId = this.fSystemId;
            int value = this.getParameterEntityValue(entityHandle);
            this.startReadingFromInternalEntity(value, this.fEntityContext != 4);
            return false;
        }
        this.fEntityType = 1;
        this.fPublicId = this.getPublicIdOfParameterEntity(entityHandle);
        this.fSystemId = this.getSystemIdOfParameterEntity(entityHandle);
        return this.startReadingFromExternalEntity(true, entityHandle);
    }

    private void startReadingFromInternalEntity(int value, boolean addSpaces) throws Exception {
        this.fSource = null;
        this.fEventHandler.startEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
        this.fReader = this.fReaderFactory.createStringReader(this, this.fErrorReporter, this.fSendCharDataAsCharArray, this.getLineNumber(), this.getColumnNumber(), value, this.fStringPool, addSpaces);
        this.fEventHandler.sendReaderChangeNotifications(this.fReader, this.fReaderId);
    }

    private boolean startReadingFromExternalEntity(boolean checkForTextDecl, int entityHandle) throws Exception {
        String errorSystemId;
        this.fEventHandler.startEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
        String baseSystemId = null;
        if (entityHandle != -1) {
            baseSystemId = this.fEntityType == 1 ? this.fParameterEntityPool.getBaseSystemId(entityHandle) : this.fEntityPool.getBaseSystemId(entityHandle);
        }
        if (baseSystemId == null) {
            ReaderState rs = (ReaderState)this.fReaderStack.peek();
            baseSystemId = rs.systemId;
        }
        this.fSystemId = this.expandSystemId(this.fSystemId, baseSystemId);
        InputSource inputSource = this.fSource = this.fResolver == null ? null : this.fResolver.resolveEntity(this.fPublicId, this.fSystemId);
        if (this.fSource == null) {
            this.fSource = new InputSource(this.fSystemId);
            if (this.fPublicId != null) {
                this.fSource.setPublicId(this.fPublicId);
            }
        } else {
            if (this.fSource.getSystemId() != null) {
                this.fSystemId = this.expandSystemId(this.fSource.getSystemId(), baseSystemId);
            }
            if (this.fSource.getPublicId() != null) {
                this.fPublicId = this.fSource.getPublicId();
            }
        }
        boolean textDecl = false;
        try {
            this.fReader = this.fReaderFactory.createReader(this, this.fErrorReporter, this.fSource, this.fSystemId, textDecl, this.fStringPool);
        }
        catch (MalformedURLException mu) {
            errorSystemId = this.fSystemId;
            this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
            this.popReader();
            this.popEntity();
            this.fReader = null;
            Object[] args = new Object[]{errorSystemId};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 5, 0, args, 2);
        }
        catch (FileNotFoundException fnf) {
            errorSystemId = this.fSystemId;
            this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
            this.popReader();
            this.popEntity();
            this.fReader = null;
            Object[] args = new Object[]{errorSystemId};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 5, 0, args, 2);
        }
        catch (UnsupportedEncodingException uee) {
            this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
            this.popReader();
            this.popEntity();
            this.fReader = null;
            String encoding = uee.getMessage();
            if (encoding == null) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 70, 72, null, 2);
            }
            if (!XMLCharacterProperties.validEncName(encoding)) {
                Object[] args = new Object[]{encoding};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 40, 42, args, 2);
            }
            Object[] args = new Object[]{encoding};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 61, 60, args, 2);
        }
        if (this.fReader == null || !checkForTextDecl) {
            this.fEventHandler.sendReaderChangeNotifications(this.fReader, this.fReaderId);
            return false;
        }
        int readerId = this.fReaderId;
        this.fEventHandler.sendReaderChangeNotifications(this.fReader, this.fReaderId);
        boolean parseTextDecl = this.fReader.lookingAtChar('<', false);
        if (readerId != this.fReaderId) {
            parseTextDecl = false;
        }
        return parseTextDecl;
    }

    private void pushNullReader() {
        ReaderState rs = this.fReaderStateFreeList;
        if (rs == null) {
            rs = new ReaderState();
        } else {
            this.fReaderStateFreeList = rs.nextReaderState;
        }
        if (this.fNullReader == null) {
            this.fNullReader = new NullReader();
        }
        rs.reader = this.fNullReader;
        rs.source = null;
        rs.entityName = -1;
        rs.entityType = -1;
        rs.entityContext = -1;
        rs.publicId = "Null Entity";
        rs.systemId = this.fSystemId;
        rs.readerId = this.fNextReaderId++;
        rs.depth = -1;
        rs.nextReaderState = null;
        this.fReaderStack.push(rs);
    }

    private void pushReader() {
        ReaderState rs = this.fReaderStateFreeList;
        if (rs == null) {
            rs = new ReaderState();
        } else {
            this.fReaderStateFreeList = rs.nextReaderState;
        }
        rs.reader = this.fReader;
        rs.source = this.fSource;
        rs.entityName = this.fEntityName;
        rs.entityType = this.fEntityType;
        rs.entityContext = this.fEntityContext;
        rs.publicId = this.fPublicId;
        rs.systemId = this.fSystemId;
        rs.readerId = this.fReaderId;
        rs.depth = this.fReaderDepth;
        rs.nextReaderState = null;
        this.fReaderStack.push(rs);
    }

    private void popReader() {
        if (this.fReaderStack.empty()) {
            throw new RuntimeException("FWK004 cannot happen 19\n19");
        }
        ReaderState rs = (ReaderState)this.fReaderStack.pop();
        this.fReader = rs.reader;
        this.fSource = rs.source;
        this.fEntityName = rs.entityName;
        this.fEntityType = rs.entityType;
        this.fEntityContext = rs.entityContext;
        this.fPublicId = rs.publicId;
        this.fSystemId = rs.systemId;
        this.fReaderId = rs.readerId;
        this.fReaderDepth = rs.depth;
        rs.nextReaderState = this.fReaderStateFreeList;
        this.fReaderStateFreeList = rs;
    }

    public boolean startEntityDecl(boolean isPE, int entityName) throws Exception {
        if (!this.pushEntity(isPE, entityName)) {
            int majorCode = isPE ? 72 : 71;
            Object[] args = new Object[]{this.fStringPool.toString(entityName), this.entityReferencePath(isPE, entityName)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, 73, args, 2);
            return false;
        }
        return true;
    }

    public void endEntityDecl() throws Exception {
        this.popEntity();
    }

    private boolean pushEntity(boolean isPE, int entityName) throws Exception {
        if (entityName >= 0) {
            int i = 0;
            while (i < this.fEntityStackDepth) {
                if (this.fEntityNameStack[i] == entityName && this.fEntityTypeStack[i] == (isPE ? (byte)1 : 0)) {
                    return false;
                }
                ++i;
            }
        }
        if (this.fEntityTypeStack == null) {
            this.fEntityTypeStack = new byte[8];
            this.fEntityNameStack = new int[8];
        } else if (this.fEntityStackDepth == this.fEntityTypeStack.length) {
            byte[] newTypeStack = new byte[this.fEntityStackDepth * 2];
            System.arraycopy(this.fEntityTypeStack, 0, newTypeStack, 0, this.fEntityStackDepth);
            this.fEntityTypeStack = newTypeStack;
            int[] newNameStack = new int[this.fEntityStackDepth * 2];
            System.arraycopy(this.fEntityNameStack, 0, newNameStack, 0, this.fEntityStackDepth);
            this.fEntityNameStack = newNameStack;
        }
        this.fEntityTypeStack[this.fEntityStackDepth] = (byte)(isPE ? 1 : 0);
        this.fEntityNameStack[this.fEntityStackDepth] = entityName;
        ++this.fEntityStackDepth;
        return true;
    }

    private String entityReferencePath(boolean isPE, int entityName) {
        StringBuffer sb = new StringBuffer();
        sb.append("(top-level)");
        int i = 0;
        while (i < this.fEntityStackDepth) {
            if (this.fEntityNameStack[i] >= 0) {
                sb.append('-');
                sb.append(this.fEntityTypeStack[i] == 1 ? (char)'%' : '&');
                sb.append(this.fStringPool.toString(this.fEntityNameStack[i]));
                sb.append(';');
            }
            ++i;
        }
        sb.append('-');
        sb.append(isPE ? (char)'%' : '&');
        sb.append(this.fStringPool.toString(entityName));
        sb.append(';');
        return sb.toString();
    }

    private void popEntity() throws Exception {
        --this.fEntityStackDepth;
    }

    public int getReaderId() {
        return this.fReaderId;
    }

    public void setReaderDepth(int depth) {
        this.fReaderDepth = depth;
    }

    public int getReaderDepth() {
        return this.fReaderDepth;
    }

    public String getPublicId() {
        return this.fPublicId;
    }

    public String getSystemId() {
        return this.fSystemId;
    }

    public int getLineNumber() {
        return this.fReader == null ? 0 : this.fReader.getLineNumber();
    }

    public int getColumnNumber() {
        return this.fReader == null ? 0 : this.fReader.getColumnNumber();
    }

    public XMLEntityHandler.EntityReader changeReaders() throws Exception {
        this.fEventHandler.sendEndOfInputNotifications(this.fEntityName, this.fReaderStack.size() > 1);
        this.fEventHandler.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
        this.popReader();
        this.fEventHandler.sendReaderChangeNotifications(this.fReader, this.fReaderId);
        this.popEntity();
        return this.fReader;
    }

    public final class EntityPool {
        private StringPool fStringPool = null;
        private XMLErrorReporter fErrorReporter = null;
        private int fEntityCount = 0;
        private int[][] fName = new int[32][];
        private int[][] fValue = new int[32][];
        private int[][] fPublicId = new int[32][];
        private int[][] fSystemId = new int[32][];
        private int[][] fBaseSystemId = new int[32][];
        private int[][] fNotationName = new int[32][];
        private byte[][] fDeclIsExternal = new byte[32][];
        private int fNotationListHead = -1;
        private boolean fCreateStandardEntities = false;
        private Vector fRequiredNotations = null;

        public EntityPool(StringPool stringPool, XMLErrorReporter errorReporter, boolean createStandardEntities) {
            this.fStringPool = stringPool;
            this.fErrorReporter = errorReporter;
            this.fCreateStandardEntities = createStandardEntities;
            if (this.fCreateStandardEntities) {
                this.createInternalEntity("lt", "&#60;");
                this.createInternalEntity("gt", ">");
                this.createInternalEntity("amp", "&#38;");
                this.createInternalEntity("apos", "'");
                this.createInternalEntity("quot", "\"");
            }
        }

        public void reset(StringPool stringPool) {
            this.fStringPool = stringPool;
            this.fEntityCount = 0;
            this.fNotationListHead = -1;
            if (this.fRequiredNotations != null) {
                this.fRequiredNotations.removeAllElements();
            }
            if (this.fCreateStandardEntities) {
                this.createInternalEntity("lt", "&#60;");
                this.createInternalEntity("gt", ">");
                this.createInternalEntity("amp", "&#38;");
                this.createInternalEntity("apos", "'");
                this.createInternalEntity("quot", "\"");
            }
        }

        private void createInternalEntity(String name, String value) {
            int chunk = this.fEntityCount >> 5;
            int index = this.fEntityCount & 0x1F;
            this.ensureCapacity(chunk);
            this.fName[chunk][index] = this.fStringPool.addSymbol(name);
            this.fValue[chunk][index] = this.fStringPool.addString(value);
            this.fPublicId[chunk][index] = -1;
            this.fSystemId[chunk][index] = -1;
            this.fBaseSystemId[chunk][index] = -1;
            this.fNotationName[chunk][index] = -1;
            ++this.fEntityCount;
        }

        private void ensureCapacity(int chunk) {
            if (chunk >= this.fName.length) {
                int[][] newIntArray = new int[chunk * 2][];
                System.arraycopy(this.fName, 0, newIntArray, 0, chunk);
                this.fName = newIntArray;
                newIntArray = new int[chunk * 2][];
                System.arraycopy(this.fValue, 0, newIntArray, 0, chunk);
                this.fValue = newIntArray;
                newIntArray = new int[chunk * 2][];
                System.arraycopy(this.fPublicId, 0, newIntArray, 0, chunk);
                this.fPublicId = newIntArray;
                newIntArray = new int[chunk * 2][];
                System.arraycopy(this.fSystemId, 0, newIntArray, 0, chunk);
                this.fSystemId = newIntArray;
                newIntArray = new int[chunk * 2][];
                System.arraycopy(this.fBaseSystemId, 0, newIntArray, 0, chunk);
                this.fBaseSystemId = newIntArray;
                newIntArray = new int[chunk * 2][];
                System.arraycopy(this.fNotationName, 0, newIntArray, 0, chunk);
                this.fNotationName = newIntArray;
                byte[][] newByteArray = new byte[chunk * 2][];
                System.arraycopy(this.fDeclIsExternal, 0, newByteArray, 0, chunk);
                this.fDeclIsExternal = newByteArray;
            } else if (this.fName[chunk] != null) {
                return;
            }
            this.fName[chunk] = new int[32];
            this.fValue[chunk] = new int[32];
            this.fPublicId[chunk] = new int[32];
            this.fSystemId[chunk] = new int[32];
            this.fBaseSystemId[chunk] = new int[32];
            this.fNotationName[chunk] = new int[32];
            this.fDeclIsExternal[chunk] = new byte[32];
        }

        public int addEntityDecl(int name, int value, int publicId, int systemId, int baseSystemId, int notationName, boolean isExternal) {
            int chunk = this.fEntityCount >> 5;
            int index = this.fEntityCount & 0x1F;
            this.ensureCapacity(chunk);
            this.fName[chunk][index] = name;
            this.fValue[chunk][index] = value;
            this.fPublicId[chunk][index] = publicId;
            this.fSystemId[chunk][index] = systemId;
            this.fBaseSystemId[chunk][index] = baseSystemId;
            this.fNotationName[chunk][index] = notationName;
            this.fDeclIsExternal[chunk][index] = isExternal ? -128 : 0;
            int entityIndex = this.fEntityCount++;
            return entityIndex;
        }

        public int addNotationDecl(int notationName, int publicId, int systemId, int baseSystemId, boolean isExternal) {
            int index;
            int chunk;
            int nIndex = this.fNotationListHead;
            while (nIndex != -1) {
                chunk = nIndex >> 5;
                index = nIndex & 0x1F;
                if (this.fNotationName[chunk][index] == notationName) {
                    return -1;
                }
                nIndex = this.fValue[chunk][index];
            }
            chunk = this.fEntityCount >> 5;
            index = this.fEntityCount & 0x1F;
            this.ensureCapacity(chunk);
            this.fName[chunk][index] = -1;
            this.fValue[chunk][index] = this.fNotationListHead;
            this.fPublicId[chunk][index] = publicId;
            this.fSystemId[chunk][index] = systemId;
            this.fBaseSystemId[chunk][index] = baseSystemId;
            this.fNotationName[chunk][index] = notationName;
            this.fDeclIsExternal[chunk][index] = isExternal ? -128 : 0;
            this.fNotationListHead = this.fEntityCount++;
            return this.fNotationListHead;
        }

        public int lookupEntity(int nameIndex) {
            if (nameIndex == -1) {
                return -1;
            }
            int chunk = 0;
            int index = 0;
            int entityIndex = 0;
            while (entityIndex < this.fEntityCount) {
                if (this.fName[chunk][index] == nameIndex) {
                    return entityIndex;
                }
                if (++index == 32) {
                    ++chunk;
                    index = 0;
                }
                ++entityIndex;
            }
            return -1;
        }

        public boolean isExternalEntity(int entityIndex) {
            int chunk = entityIndex >> 5;
            int index = entityIndex & 0x1F;
            return this.fValue[chunk][index] == -1;
        }

        public boolean isUnparsedEntity(int entityIndex) {
            int chunk = entityIndex >> 5;
            int index = entityIndex & 0x1F;
            return this.fNotationName[chunk][index] != -1;
        }

        public boolean getEntityDeclIsExternal(int entityIndex) {
            int chunk = entityIndex >> 5;
            int index = entityIndex & 0x1F;
            return this.fDeclIsExternal[chunk][index] < 0;
        }

        public int getEntityName(int entityIndex) {
            int chunk = entityIndex >> 5;
            int index = entityIndex & 0x1F;
            return this.fName[chunk][index];
        }

        public int getEntityValue(int entityIndex) {
            int chunk = entityIndex >> 5;
            int index = entityIndex & 0x1F;
            return this.fValue[chunk][index];
        }

        public int getPublicId(int entityIndex) {
            int chunk = entityIndex >> 5;
            int index = entityIndex & 0x1F;
            return this.fPublicId[chunk][index];
        }

        public int getSystemId(int entityIndex) {
            int chunk = entityIndex >> 5;
            int index = entityIndex & 0x1F;
            return this.fSystemId[chunk][index];
        }

        public String getBaseSystemId(int entityIndex) {
            int chunk = entityIndex >> 5;
            int index = entityIndex & 0x1F;
            int baseIndex = this.fBaseSystemId[chunk][index];
            if (baseIndex == -1) {
                return null;
            }
            return this.fStringPool.toString(baseIndex);
        }

        public boolean isNotationDeclared(int nameIndex) {
            int nIndex = this.fNotationListHead;
            while (nIndex != -1) {
                int chunk = nIndex >> 5;
                int index = nIndex & 0x1F;
                if (this.fNotationName[chunk][index] == nameIndex) {
                    return true;
                }
                nIndex = this.fValue[chunk][index];
            }
            return false;
        }

        public boolean getNotationDeclIsExternal(int entityIndex) {
            int chunk = entityIndex >> 5;
            int index = entityIndex & 0x1F;
            return this.fDeclIsExternal[chunk][index] < 0;
        }

        public int getNotationName(int entityIndex) {
            int chunk = entityIndex >> 5;
            int index = entityIndex & 0x1F;
            return this.fNotationName[chunk][index];
        }

        public void addRequiredNotation(int notationName, Locator locator, int majorCode, int minorCode, Object[] args) {
            if (this.fRequiredNotations == null) {
                this.fRequiredNotations = new Vector();
            }
            int index = 0;
            while (index < this.fRequiredNotations.size()) {
                RequiredNotation rn = (RequiredNotation)this.fRequiredNotations.elementAt(index);
                if (rn.fNotationName == notationName) {
                    return;
                }
                ++index;
            }
            this.fRequiredNotations.addElement(new RequiredNotation(notationName, locator, majorCode, minorCode, args));
        }

        public void checkRequiredNotations() throws Exception {
            if (this.fRequiredNotations == null) {
                return;
            }
            int index = 0;
            while (index < this.fRequiredNotations.size()) {
                RequiredNotation rn = (RequiredNotation)this.fRequiredNotations.elementAt(index);
                if (!this.isNotationDeclared(rn.fNotationName)) {
                    this.fErrorReporter.reportError(rn.fLocator, "http://www.w3.org/TR/1998/REC-xml-19980210", rn.fMajorCode, rn.fMinorCode, rn.fArgs, 1);
                }
                ++index;
            }
        }

        class RequiredNotation {
            int fNotationName;
            LocatorImpl fLocator;
            int fMajorCode;
            int fMinorCode;
            Object[] fArgs;

            RequiredNotation(int notationName, Locator locator, int majorCode, int minorCode, Object[] args) {
                this.fNotationName = notationName;
                this.fLocator = new LocatorImpl(locator);
                this.fMajorCode = majorCode;
                this.fMinorCode = minorCode;
                this.fArgs = args;
            }
        }
    }

    public static interface EventHandler {
        public void startEntityReference(int var1, int var2, int var3) throws Exception;

        public void endEntityReference(int var1, int var2, int var3) throws Exception;

        public void sendEndOfInputNotifications(int var1, boolean var2) throws Exception;

        public void sendReaderChangeNotifications(XMLEntityHandler.EntityReader var1, int var2) throws Exception;

        public boolean externalEntityStandaloneCheck();

        public boolean getValidating();
    }

    private final class NullReader
    implements XMLEntityHandler.EntityReader {
        public int currentOffset() {
            return -1;
        }

        public int getLineNumber() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        public void setInCDSect(boolean inCDSect) {
        }

        public boolean getInCDSect() {
            return false;
        }

        public void append(XMLEntityHandler.CharBuffer charBuffer, int offset, int length) {
        }

        public int addString(int offset, int length) {
            return -1;
        }

        public int addSymbol(int offset, int length) {
            return -1;
        }

        public boolean lookingAtChar(char ch, boolean skipPastChar) {
            return false;
        }

        public boolean lookingAtValidChar(boolean skipPastChar) {
            return false;
        }

        public boolean lookingAtSpace(boolean skipPastChar) {
            return false;
        }

        public void skipToChar(char ch) {
        }

        public void skipPastSpaces() {
        }

        public void skipPastName(char fastcheck) {
        }

        public void skipPastNmtoken(char fastcheck) {
        }

        public boolean skippedString(char[] s) {
            return false;
        }

        public int scanInvalidChar() {
            return -1;
        }

        public int scanCharRef(boolean hex) {
            return -2;
        }

        public int scanStringLiteral() {
            return -1;
        }

        public int scanAttValue(char qchar, boolean asSymbol) {
            return -3;
        }

        public int scanEntityValue(int qchar, boolean createString) {
            return -4;
        }

        public boolean scanExpectedName(char fastcheck, StringPool.CharArrayRange expectedName) {
            return false;
        }

        public void scanQName(char fastcheck, QName qname) {
            qname.clear();
        }

        public int scanName(char fastcheck) {
            return -1;
        }

        public int scanContent(QName element) throws Exception {
            return 9;
        }
    }

    private class ReaderState {
        XMLEntityHandler.EntityReader reader;
        InputSource source;
        int entityName;
        int entityType;
        int entityContext;
        String publicId;
        String systemId;
        int readerId;
        int depth;
        ReaderState nextReaderState;

        private ReaderState() {
        }
    }
}

