/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Stack;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.CharReader;
import org.apache.xerces.readers.StringReader;
import org.apache.xerces.readers.UTF8Reader;
import org.apache.xerces.readers.XMLDeclRecognizer;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.ChunkyByteArray;
import org.apache.xerces.utils.StringPool;
import org.xml.sax.InputSource;

public class DefaultReaderFactory
implements XMLEntityReaderFactory {
    private static final boolean USE_CHAR_READER_FOR_UTF8 = false;
    private static final boolean USE_BYTE_READER_FOR_UTF8 = true;
    private boolean fSendCharDataAsCharArray = false;
    private boolean fAllowJavaEncodingName = false;
    private Stack fRecognizers = null;

    public void addRecognizer(XMLDeclRecognizer recognizer) {
        if (this.fRecognizers == null) {
            this.fRecognizers = new Stack();
            XMLDeclRecognizer.registerDefaultRecognizers(this.fRecognizers);
        }
        this.fRecognizers.push(recognizer);
    }

    public void setSendCharDataAsCharArray(boolean flag) {
        this.fSendCharDataAsCharArray = flag;
    }

    public void setAllowJavaEncodingName(boolean flag) {
        this.fAllowJavaEncodingName = flag;
    }

    public boolean getAllowJavaEncodingName() {
        return this.fAllowJavaEncodingName;
    }

    public XMLEntityHandler.EntityReader createReader(XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, InputSource source, String systemId, boolean xmlDecl, StringPool stringPool) throws Exception {
        if (source.getCharacterStream() != null) {
            return this.createCharReader(entityHandler, errorReporter, this.fSendCharDataAsCharArray, source.getCharacterStream(), stringPool);
        }
        if (source.getEncoding() != null && source.getByteStream() != null) {
            InputStreamReader reader = new InputStreamReader(source.getByteStream(), source.getEncoding());
            return this.createCharReader(entityHandler, errorReporter, this.fSendCharDataAsCharArray, reader, stringPool);
        }
        InputStream is = source.getByteStream();
        if (is == null) {
            URL url = new URL(systemId);
            is = url.openStream();
        }
        ChunkyByteArray data = new ChunkyByteArray(is);
        if (this.fRecognizers == null) {
            this.fRecognizers = new Stack();
            XMLDeclRecognizer.registerDefaultRecognizers(this.fRecognizers);
        }
        int i = this.fRecognizers.size() - 1;
        while (i >= 0) {
            XMLDeclRecognizer recognizer = (XMLDeclRecognizer)this.fRecognizers.elementAt(i);
            XMLEntityHandler.EntityReader reader = recognizer.recognize(this, entityHandler, errorReporter, this.fSendCharDataAsCharArray, stringPool, data, xmlDecl, this.fAllowJavaEncodingName);
            if (reader != null) {
                return reader;
            }
            --i;
        }
        return this.createUTF8Reader(entityHandler, errorReporter, this.fSendCharDataAsCharArray, data, stringPool);
    }

    public XMLEntityHandler.EntityReader createCharReader(XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, Reader reader, StringPool stringPool) throws Exception {
        return new CharReader(entityHandler, errorReporter, sendCharDataAsCharArray, reader, stringPool);
    }

    public XMLEntityHandler.EntityReader createUTF8Reader(XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, InputStream data, StringPool stringPool) throws Exception {
        UTF8Reader reader = new UTF8Reader(entityHandler, errorReporter, sendCharDataAsCharArray, data, stringPool);
        return reader;
    }

    public XMLEntityHandler.EntityReader createStringReader(XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, int lineNumber, int columnNumber, int stringHandle, StringPool stringPool, boolean addEnclosingSpaces) throws Exception {
        return StringReader.createStringReader(entityHandler, errorReporter, sendCharDataAsCharArray, lineNumber, columnNumber, stringHandle, stringPool, addEnclosingSpaces);
    }
}

