/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.MIME2Java;
import org.apache.xerces.readers.XMLDeclRecognizer;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.ChunkyByteArray;
import org.apache.xerces.utils.StringPool;

final class EBCDICRecognizer
extends XMLDeclRecognizer {
    EBCDICRecognizer() {
    }

    public XMLEntityHandler.EntityReader recognize(XMLEntityReaderFactory readerFactory, XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, StringPool stringPool, ChunkyByteArray data, boolean xmlDecl, boolean allowJavaEncodingName) throws Exception {
        XMLEntityHandler.EntityReader reader;
        block11: {
            reader = null;
            byte b0 = data.byteAt(0);
            byte b1 = data.byteAt(1);
            byte b2 = data.byteAt(2);
            byte b3 = data.byteAt(3);
            boolean debug = false;
            if (b0 != 76 || b1 != 111 || b2 != -89 || b3 != -108) {
                return reader;
            }
            XMLEntityHandler.EntityReader declReader = readerFactory.createCharReader(entityHandler, errorReporter, sendCharDataAsCharArray, new InputStreamReader((InputStream)data, "CP037"), stringPool);
            int encoding = this.prescanXMLDeclOrTextDecl(declReader, xmlDecl);
            if (encoding == -1) {
                data.rewind();
                throw new UnsupportedEncodingException(null);
            }
            String enc = stringPool.orphanString(encoding).toUpperCase();
            if ("ISO-10646-UCS-2".equals(enc)) {
                throw new UnsupportedEncodingException(enc);
            }
            if ("ISO-10646-UCS-4".equals(enc)) {
                throw new UnsupportedEncodingException(enc);
            }
            if ("UTF-16".equals(enc)) {
                throw new UnsupportedEncodingException(enc);
            }
            String javaencname = MIME2Java.convert(enc);
            if (javaencname == null) {
                if (allowJavaEncodingName) {
                    javaencname = enc;
                } else {
                    throw new UnsupportedEncodingException(enc);
                }
            }
            try {
                data.rewind();
                reader = readerFactory.createCharReader(entityHandler, errorReporter, sendCharDataAsCharArray, new InputStreamReader((InputStream)data, javaencname), stringPool);
            }
            catch (UnsupportedEncodingException e) {
                throw e;
            }
            catch (Exception e) {
                if (!debug) break block11;
                e.printStackTrace();
            }
        }
        return reader;
    }
}

