/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;

final class StringReader
extends XMLEntityReader {
    public static final byte[] fgAsciiEntityValueChar;
    private static final char[] cdata_string;
    private StringPool fStringPool = null;
    private String fData = null;
    private int fEndOffset;
    private boolean hadTrailingSpace = false;
    private boolean oweTrailingSpace = false;
    private int fMostRecentChar;
    private StringReader fNextFreeReader = null;
    private static StringReader fgFreeReaders;
    private boolean fCalledCharPropInit = false;
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 4;
        byArray[1] = 4;
        byArray[2] = 4;
        byArray[3] = 4;
        byArray[4] = 4;
        byArray[5] = 4;
        byArray[6] = 4;
        byArray[7] = 4;
        byArray[8] = 4;
        byArray[11] = 4;
        byArray[12] = 4;
        byArray[14] = 4;
        byArray[15] = 4;
        byArray[16] = 4;
        byArray[17] = 4;
        byArray[18] = 4;
        byArray[19] = 4;
        byArray[20] = 4;
        byArray[21] = 4;
        byArray[22] = 4;
        byArray[23] = 4;
        byArray[24] = 4;
        byArray[25] = 4;
        byArray[26] = 4;
        byArray[27] = 4;
        byArray[28] = 4;
        byArray[29] = 4;
        byArray[30] = 4;
        byArray[31] = 4;
        byArray[34] = 1;
        byArray[37] = 3;
        byArray[38] = 2;
        byArray[39] = 1;
        fgAsciiEntityValueChar = byArray;
        cdata_string = new char[]{'C', 'D', 'A', 'T', 'A', '['};
        fgFreeReaders = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringReader createStringReader(XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, int lineNumber, int columnNumber, int stringHandle, StringPool stringPool, boolean addEnclosingSpaces) {
        StringReader reader = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.xerces.readers.StringReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            reader = fgFreeReaders;
            if (reader == null) {
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return new StringReader(entityHandler, errorReporter, sendCharDataAsCharArray, lineNumber, columnNumber, stringHandle, stringPool, addEnclosingSpaces);
            }
            fgFreeReaders = reader.fNextFreeReader;
            // ** MonitorExit[var9_9] (shouldn't be in output)
            reader.init(entityHandler, errorReporter, sendCharDataAsCharArray, lineNumber, columnNumber, stringHandle, stringPool, addEnclosingSpaces);
            return reader;
        }
    }

    private StringReader(XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, int lineNumber, int columnNumber, int stringHandle, StringPool stringPool, boolean addEnclosingSpaces) {
        super(entityHandler, errorReporter, sendCharDataAsCharArray, lineNumber, columnNumber);
        this.fStringPool = stringPool;
        this.fData = this.fStringPool.toString(stringHandle);
        this.fCurrentOffset = 0;
        this.fEndOffset = this.fData.length();
        if (addEnclosingSpaces) {
            this.fMostRecentChar = 32;
            --this.fCurrentOffset;
            this.hadTrailingSpace = true;
            this.oweTrailingSpace = true;
        } else {
            this.fMostRecentChar = this.fEndOffset == 0 ? -1 : (int)this.fData.charAt(0);
        }
    }

    private void init(XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, int lineNumber, int columnNumber, int stringHandle, StringPool stringPool, boolean addEnclosingSpaces) {
        super.init(entityHandler, errorReporter, sendCharDataAsCharArray, lineNumber, columnNumber);
        this.fStringPool = stringPool;
        this.fData = this.fStringPool.toString(stringHandle);
        this.fCurrentOffset = 0;
        this.fEndOffset = this.fData.length();
        this.fNextFreeReader = null;
        if (addEnclosingSpaces) {
            this.fMostRecentChar = 32;
            --this.fCurrentOffset;
            this.hadTrailingSpace = true;
            this.oweTrailingSpace = true;
        } else {
            this.fMostRecentChar = this.fEndOffset == 0 ? -1 : (int)this.fData.charAt(0);
            this.hadTrailingSpace = false;
            this.oweTrailingSpace = false;
        }
    }

    public int addString(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fStringPool.addString(this.fData.substring(offset, offset + length));
    }

    public int addSymbol(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fStringPool.addSymbol(this.fData.substring(offset, offset + length));
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int offset, int length) {
        boolean addSpace = false;
        int i = 0;
        while (i < length) {
            try {
                charBuffer.append(this.fData.charAt(offset++));
            }
            catch (StringIndexOutOfBoundsException ex) {
                if (offset == this.fEndOffset + 1 && this.hadTrailingSpace) {
                    charBuffer.append(' ');
                }
                System.err.println("StringReader.append()");
                throw ex;
            }
            ++i;
        }
    }

    private int loadNextChar() {
        if (++this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                this.fMostRecentChar = 32;
            } else {
                this.fMostRecentChar = -1;
            }
        } else {
            this.fMostRecentChar = this.fData.charAt(this.fCurrentOffset);
        }
        return this.fMostRecentChar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLEntityHandler.EntityReader changeReaders() throws Exception {
        XMLEntityHandler.EntityReader nextReader = super.changeReaders();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.xerces.readers.StringReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            this.fNextFreeReader = fgFreeReaders;
            fgFreeReaders = this;
            this.fStringPool = null;
            this.fData = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return nextReader;
        }
    }

    public boolean lookingAtChar(char chr, boolean skipPastChar) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch != chr) {
            if (ch == -1) {
                return this.changeReaders().lookingAtChar(chr, skipPastChar);
            }
            return false;
        }
        if (skipPastChar) {
            if (++this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    this.oweTrailingSpace = false;
                    this.fMostRecentChar = 32;
                } else {
                    this.fMostRecentChar = -1;
                }
            } else {
                this.fMostRecentChar = this.fData.charAt(this.fCurrentOffset);
            }
        }
        return true;
    }

    public boolean lookingAtValidChar(boolean skipPastChar) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch < 55296) {
            if (ch < 32 && ch != 9 && ch != 10 && ch != 13) {
                if (ch == -1) {
                    return this.changeReaders().lookingAtValidChar(skipPastChar);
                }
                return false;
            }
            if (skipPastChar) {
                if (++this.fCurrentOffset >= this.fEndOffset) {
                    if (this.oweTrailingSpace) {
                        this.oweTrailingSpace = false;
                        this.fMostRecentChar = 32;
                    } else {
                        this.fMostRecentChar = -1;
                    }
                } else {
                    this.fMostRecentChar = this.fData.charAt(this.fCurrentOffset);
                }
            }
            return true;
        }
        if (ch > 65533) {
            return false;
        }
        if (ch < 56320) {
            if (this.fCurrentOffset + 1 >= this.fEndOffset) {
                return false;
            }
            ch = this.fData.charAt(this.fCurrentOffset + 1);
            if (ch < 56320 || ch >= 57344) {
                return false;
            }
            if (!skipPastChar) {
                return true;
            }
            ++this.fCurrentOffset;
        } else if (ch < 57344) {
            return false;
        }
        if (skipPastChar) {
            if (++this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    this.oweTrailingSpace = false;
                    this.fMostRecentChar = 32;
                } else {
                    this.fMostRecentChar = -1;
                }
            } else {
                this.fMostRecentChar = this.fData.charAt(this.fCurrentOffset);
            }
        }
        return true;
    }

    public boolean lookingAtSpace(boolean skipPastChar) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch > 32) {
            return false;
        }
        if (ch == 32 || ch == 10 || ch == 13 || ch == 9) {
            if (skipPastChar) {
                this.loadNextChar();
            }
            return true;
        }
        if (ch == -1) {
            return this.changeReaders().lookingAtSpace(skipPastChar);
        }
        return false;
    }

    public void skipToChar(char chr) throws Exception {
        int ch = this.fMostRecentChar;
        while (ch != chr) {
            if (ch == -1) {
                this.changeReaders().skipToChar(chr);
                return;
            }
            ch = this.loadNextChar();
        }
        return;
    }

    public void skipPastSpaces() throws Exception {
        int ch = this.fMostRecentChar;
        if (ch == -1) {
            this.changeReaders().skipPastSpaces();
            return;
        }
        while (true) {
            if (ch > 32 || ch != 32 && ch != 10 && ch != 9 && ch != 13) {
                this.fMostRecentChar = ch;
                return;
            }
            if (++this.fCurrentOffset >= this.fEndOffset) {
                this.changeReaders().skipPastSpaces();
                return;
            }
            ch = this.fData.charAt(this.fCurrentOffset);
        }
    }

    public void skipPastName(char fastcheck) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch < 128) {
            if (ch == -1 || XMLCharacterProperties.fgAsciiInitialNameChar[ch] == 0) {
                return;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                return;
            }
        }
        while (true) {
            if (fastcheck == (ch = this.loadNextChar())) {
                return;
            }
            if (ch < 128) {
                if (ch != -1 && XMLCharacterProperties.fgAsciiNameChar[ch] != 0) continue;
                return;
            }
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) break;
        }
    }

    public void skipPastNmtoken(char fastcheck) throws Exception {
        int ch = this.fMostRecentChar;
        while (fastcheck != ch) {
            if (ch < 128) {
                if (ch == -1 || XMLCharacterProperties.fgAsciiNameChar[ch] == 0) {
                    return;
                }
            } else {
                if (!this.fCalledCharPropInit) {
                    XMLCharacterProperties.initCharFlags();
                    this.fCalledCharPropInit = true;
                }
                if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) {
                    return;
                }
            }
            ch = this.loadNextChar();
        }
        return;
    }

    public boolean skippedString(char[] s) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch != s[0]) {
            if (ch == -1) {
                return this.changeReaders().skippedString(s);
            }
            return false;
        }
        if (this.fCurrentOffset + s.length > this.fEndOffset) {
            return false;
        }
        int i = 1;
        while (i < s.length) {
            if (this.fData.charAt(this.fCurrentOffset + i) != s[i]) {
                return false;
            }
            ++i;
        }
        this.fCurrentOffset += s.length - 1;
        this.loadNextChar();
        return true;
    }

    public int scanInvalidChar() throws Exception {
        int ch = this.fMostRecentChar;
        if (ch == -1) {
            return this.changeReaders().scanInvalidChar();
        }
        this.loadNextChar();
        return ch;
    }

    public int scanCharRef(boolean hex) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch == -1) {
            return this.changeReaders().scanCharRef(hex);
        }
        int num = 0;
        if (hex) {
            if (ch > 102 || XMLCharacterProperties.fgAsciiXDigitChar[ch] == 0) {
                return -2;
            }
            num = ch - (ch < 65 ? 48 : (ch < 97 ? 65 : 97) - 10);
        } else {
            if (ch < 48 || ch > 57) {
                return -2;
            }
            num = ch - 48;
        }
        boolean toobig = false;
        while (true) {
            int dig;
            if ((ch = this.loadNextChar()) == -1) {
                return -1;
            }
            if (!hex ? ch < 48 || ch > 57 : ch > 102 || XMLCharacterProperties.fgAsciiXDigitChar[ch] == 0) break;
            if (hex) {
                dig = ch - (ch < 65 ? 48 : (ch < 97 ? 65 : 97) - 10);
                num = (num << 4) + dig;
            } else {
                dig = ch - 48;
                num = num * 10 + dig;
            }
            if (num <= 0x10FFFF) continue;
            toobig = true;
            num = 0;
        }
        if (ch != 59) {
            return -1;
        }
        this.loadNextChar();
        if (toobig) {
            return -3;
        }
        return num;
    }

    public int scanStringLiteral() throws Exception {
        boolean single = this.lookingAtChar('\'', true);
        if (!single && !this.lookingAtChar('\"', true)) {
            return -1;
        }
        int offset = this.fCurrentOffset;
        char qchar = single ? (char)'\'' : '\"';
        while (!this.lookingAtChar(qchar, false)) {
            if (this.lookingAtValidChar(true)) continue;
            return -2;
        }
        int stringIndex = this.addString(offset, this.fCurrentOffset - offset);
        this.lookingAtChar(qchar, true);
        return stringIndex;
    }

    public int scanAttValue(char qchar, boolean asSymbol) throws Exception {
        int offset = this.fCurrentOffset;
        while (!this.lookingAtChar(qchar, false)) {
            if (this.lookingAtChar(' ', true)) continue;
            if (this.lookingAtSpace(false)) {
                return -1;
            }
            if (this.lookingAtChar('&', false)) {
                return -1;
            }
            if (this.lookingAtChar('<', false)) {
                return -2;
            }
            if (this.lookingAtValidChar(true)) continue;
            return -3;
        }
        int result = asSymbol ? this.addSymbol(offset, this.fCurrentOffset - offset) : this.addString(offset, this.fCurrentOffset - offset);
        this.lookingAtChar(qchar, true);
        return result;
    }

    public int scanEntityValue(int qchar, boolean createString) throws Exception {
        int offset = this.fCurrentOffset;
        int ch = this.fMostRecentChar;
        block7: while (true) {
            if (ch == -1) {
                this.changeReaders();
                return -5;
            }
            if (ch < 128) {
                switch (fgAsciiEntityValueChar[ch]) {
                    case 1: {
                        if (ch == qchar) {
                            if (!createString) {
                                return -1;
                            }
                            int length = this.fCurrentOffset - offset;
                            int result = length == 0 ? 0 : this.addString(offset, length);
                            this.loadNextChar();
                            return result;
                        }
                    }
                    case 0: {
                        if (++this.fCurrentOffset >= this.fEndOffset) {
                            if (this.oweTrailingSpace) {
                                this.oweTrailingSpace = false;
                                this.fMostRecentChar = 32;
                                ch = 32;
                                continue block7;
                            }
                            this.fMostRecentChar = -1;
                            ch = -1;
                            continue block7;
                        }
                        char c = this.fData.charAt(this.fCurrentOffset);
                        this.fMostRecentChar = c;
                        ch = c;
                        continue block7;
                    }
                    case 2: {
                        return -2;
                    }
                    case 3: {
                        return -3;
                    }
                    case 4: {
                        return -4;
                    }
                }
                continue;
            }
            if (ch < 55296) {
                ch = this.loadNextChar();
                continue;
            }
            if (ch < 57344 || ch > 65533 && (ch < 65536 || ch > 0x10FFFF)) break;
            ch = this.loadNextChar();
        }
        return -4;
    }

    public boolean scanExpectedName(char fastcheck, StringPool.CharArrayRange expectedName) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch == -1) {
            return this.changeReaders().scanExpectedName(fastcheck, expectedName);
        }
        if (!this.fCalledCharPropInit) {
            XMLCharacterProperties.initCharFlags();
            this.fCalledCharPropInit = true;
        }
        int nameOffset = this.fCurrentOffset;
        if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
            return false;
        }
        while (fastcheck != (ch = this.loadNextChar()) && ch != -1 && (XMLCharacterProperties.fgCharFlags[ch] & 4) != 0) {
        }
        int nameIndex = this.fStringPool.addSymbol(this.fData.substring(nameOffset, this.fCurrentOffset));
        return true;
    }

    public void scanQName(char fastcheck, QName qname) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch == -1) {
            this.changeReaders().scanQName(fastcheck, qname);
            return;
        }
        if (!this.fCalledCharPropInit) {
            XMLCharacterProperties.initCharFlags();
            this.fCalledCharPropInit = true;
        }
        int nameOffset = this.fCurrentOffset;
        if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
            qname.clear();
            return;
        }
        while (fastcheck != (ch = this.loadNextChar()) && ch != -1 && (XMLCharacterProperties.fgCharFlags[ch] & 4) != 0) {
        }
        qname.clear();
        qname.rawname = this.fStringPool.addSymbol(this.fData.substring(nameOffset, this.fCurrentOffset));
        int index = this.fData.indexOf(58, nameOffset);
        if (index != -1 && index < this.fCurrentOffset) {
            String localPart;
            qname.prefix = this.fStringPool.addSymbol(this.fData.substring(nameOffset, index));
            int indexOfSpaceChar = this.fData.indexOf(32, index + 1);
            if (indexOfSpaceChar != -1) {
                localPart = this.fData.substring(index + 1, indexOfSpaceChar);
                qname.localpart = this.fStringPool.addSymbol(localPart);
            } else {
                int lenfData = this.fData.length();
                localPart = this.fData.substring(index + 1, lenfData);
                qname.localpart = this.fStringPool.addSymbol(localPart);
            }
            qname.localpart = this.fStringPool.addSymbol(localPart);
        } else {
            qname.localpart = qname.rawname;
        }
    }

    public int scanName(char fastcheck) throws Exception {
        char c;
        int ch = this.fMostRecentChar;
        if (ch == -1) {
            return this.changeReaders().scanName(fastcheck);
        }
        if (!this.fCalledCharPropInit) {
            XMLCharacterProperties.initCharFlags();
            this.fCalledCharPropInit = true;
        }
        int nameOffset = this.fCurrentOffset;
        if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
            return -1;
        }
        do {
            if (++this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    this.oweTrailingSpace = false;
                    this.fMostRecentChar = 32;
                    break;
                }
                this.fMostRecentChar = -1;
                break;
            }
            c = this.fData.charAt(this.fCurrentOffset);
            this.fMostRecentChar = c;
        } while (fastcheck != (ch = (int)c) && (XMLCharacterProperties.fgCharFlags[ch] & 4) != 0);
        int nameIndex = this.fStringPool.addSymbol(this.fData.substring(nameOffset, this.fCurrentOffset));
        return nameIndex;
    }

    private int recognizeMarkup(int ch) throws Exception {
        if (ch == -1) {
            return 11;
        }
        switch (ch) {
            case 63: {
                this.loadNextChar();
                return 0;
            }
            case 33: {
                ch = this.loadNextChar();
                if (ch == -1) {
                    this.fCurrentOffset -= 2;
                    this.loadNextChar();
                    return 11;
                }
                if (ch == 45) {
                    ch = this.loadNextChar();
                    if (ch == -1) {
                        this.fCurrentOffset -= 3;
                        this.loadNextChar();
                        return 11;
                    }
                    if (ch != 45) break;
                    this.loadNextChar();
                    return 1;
                }
                if (ch != 91) break;
                int i = 0;
                while (i < 6) {
                    ch = this.loadNextChar();
                    if (ch == -1) {
                        this.fCurrentOffset -= 3 + i;
                        this.loadNextChar();
                        return 11;
                    }
                    if (ch != cdata_string[i]) {
                        return 10;
                    }
                    ++i;
                }
                this.loadNextChar();
                return 2;
            }
            case 47: {
                this.loadNextChar();
                return 4;
            }
            default: {
                return 6;
            }
        }
        return 10;
    }

    private int recognizeReference(int ch) throws Exception {
        if (ch == -1) {
            return 11;
        }
        if (ch == 35) {
            this.loadNextChar();
            return 7;
        }
        return 8;
    }

    /*
     * Unable to fully structure code
     */
    public int scanContent(QName element) throws Exception {
        block38: {
            block37: {
                ch = this.fMostRecentChar;
                if (ch == -1) {
                    return this.changeReaders().scanContent(element);
                }
                offset = this.fCurrentOffset;
                if (ch >= 128) break block37;
                switch (XMLCharacterProperties.fgAsciiWSCharData[ch]) {
                    case 0: {
                        ch = this.loadNextChar();
                        break;
                    }
                    case 1: {
                        ch = this.loadNextChar();
                        if (!this.fInCDSect) {
                            return this.recognizeMarkup(ch);
                        }
                        break block38;
                    }
                    case 2: {
                        ch = this.loadNextChar();
                        if (!this.fInCDSect) {
                            return this.recognizeReference(ch);
                        }
                        break block38;
                    }
                    case 3: {
                        ch = this.loadNextChar();
                        if (ch == 93 && this.fCurrentOffset + 1 < this.fEndOffset && this.fData.charAt(this.fCurrentOffset + 1) == '>') {
                            this.loadNextChar();
                            this.loadNextChar();
                            return 3;
                        }
                        break block38;
                    }
                    case 4: {
                        return 9;
                    }
                    case 5: {
                        do {
                            if ((ch = this.loadNextChar()) != -1) continue;
                            this.callCharDataHandler(offset, this.fEndOffset, true);
                            return this.changeReaders().scanContent(element);
                        } while (ch == 32 || ch == 10 || ch == 13 || ch == 9);
                        if (ch >= 128) ** GOTO lbl68
                        switch (XMLCharacterProperties.fgAsciiCharData[ch]) {
                            case 0: {
                                ch = this.loadNextChar();
                                break;
                            }
                            case 1: {
                                ch = this.loadNextChar();
                                if (!this.fInCDSect) {
                                    this.callCharDataHandler(offset, this.fCurrentOffset - 1, true);
                                    return this.recognizeMarkup(ch);
                                }
                                break block38;
                            }
                            case 2: {
                                ch = this.loadNextChar();
                                if (!this.fInCDSect) {
                                    this.callCharDataHandler(offset, this.fCurrentOffset - 1, true);
                                    return this.recognizeReference(ch);
                                }
                                break block38;
                            }
                            case 3: {
                                ch = this.loadNextChar();
                                if (ch == 93 && this.fCurrentOffset + 1 < this.fEndOffset && this.fData.charAt(this.fCurrentOffset + 1) == '>') {
                                    this.callCharDataHandler(offset, this.fCurrentOffset - 1, true);
                                    this.loadNextChar();
                                    this.loadNextChar();
                                    return 3;
                                }
                                break block38;
                            }
                            case 4: {
                                this.callCharDataHandler(offset, this.fCurrentOffset, true);
                                return 9;
                            }
                        }
                        break block38;
lbl68:
                        // 1 sources

                        if (ch == 65534 || ch == 65535) {
                            this.callCharDataHandler(offset, this.fCurrentOffset, true);
                            return 9;
                        }
                        ch = this.loadNextChar();
                    }
                }
                break block38;
            }
            if (ch == 65534 || ch == 65535) {
                this.callCharDataHandler(offset, this.fCurrentOffset, false);
                return 9;
            }
            ch = this.loadNextChar();
        }
        while (true) {
            if (ch == -1) {
                this.callCharDataHandler(offset, this.fEndOffset, false);
                return this.changeReaders().scanContent(element);
            }
            if (ch >= 128 || XMLCharacterProperties.fgAsciiCharData[ch] != 0) break;
            ch = this.loadNextChar();
        }
        block24: do {
            if (ch < 128) {
                switch (XMLCharacterProperties.fgAsciiCharData[ch]) {
                    case 0: {
                        ch = this.loadNextChar();
                        break;
                    }
                    case 1: {
                        ch = this.loadNextChar();
                        if (this.fInCDSect) continue block24;
                        this.callCharDataHandler(offset, this.fCurrentOffset - 1, false);
                        return this.recognizeMarkup(ch);
                    }
                    case 2: {
                        ch = this.loadNextChar();
                        if (this.fInCDSect) continue block24;
                        this.callCharDataHandler(offset, this.fCurrentOffset - 1, false);
                        return this.recognizeReference(ch);
                    }
                    case 3: {
                        ch = this.loadNextChar();
                        if (ch != 93 || this.fCurrentOffset + 1 >= this.fEndOffset || this.fData.charAt(this.fCurrentOffset + 1) != '>') continue block24;
                        this.callCharDataHandler(offset, this.fCurrentOffset - 1, false);
                        this.loadNextChar();
                        this.loadNextChar();
                        return 3;
                    }
                    case 4: {
                        this.callCharDataHandler(offset, this.fCurrentOffset, false);
                        return 9;
                    }
                }
                continue;
            }
            if (ch == 65534 || ch == 65535) {
                this.callCharDataHandler(offset, this.fCurrentOffset, false);
                return 9;
            }
            ch = this.loadNextChar();
        } while (ch != -1);
        this.callCharDataHandler(offset, this.fCurrentOffset, false);
        return this.changeReaders().scanContent(element);
    }

    private void callCharDataHandler(int offset, int endOffset, boolean isWhitespace) throws Exception {
        int length = endOffset - offset;
        if (!this.fSendCharDataAsCharArray) {
            int stringIndex = this.addString(offset, length);
            if (isWhitespace) {
                this.fCharDataHandler.processWhitespace(stringIndex);
            } else {
                this.fCharDataHandler.processCharacters(stringIndex);
            }
            return;
        }
        if (isWhitespace) {
            this.fCharDataHandler.processWhitespace(this.fData.toCharArray(), offset, length);
        } else {
            this.fCharDataHandler.processCharacters(this.fData.toCharArray(), offset, length);
        }
    }
}

