/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.IOException;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.utils.ChunkyByteArray;
import org.apache.xerces.utils.ChunkyCharArray;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringHasher;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;

final class UCSReader
extends XMLEntityReader
implements StringPool.StringProducer {
    private static final boolean DEBUG_UTF16_BIG = false;
    static final int E_UCS4B = 0;
    static final int E_UCS4L = 1;
    static final int E_UCS2B = 2;
    static final int E_UCS2L = 3;
    static final int E_UCS2B_NOBOM = 4;
    static final int E_UCS2L_NOBOM = 5;
    private ChunkyByteArray fData = null;
    private int fEncoding = -1;
    private StringPool fStringPool = null;
    private int fBytesPerChar = -1;
    private boolean fBigEndian = true;
    private ChunkyCharArray fStringCharArray = null;
    private boolean fCalledCharPropInit = false;
    private static char[] fCharacters = new char[256];
    private int fCharDataLength = 0;
    private static final char[] cdata_string = new char[]{'C', 'D', 'A', 'T', 'A', '['};

    UCSReader(XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, ChunkyByteArray data, int encoding, StringPool stringPool) throws Exception {
        super(entityHandler, errorReporter, sendCharDataAsCharArray);
        this.fCurrentOffset = encoding == 2 || encoding == 3 ? 2 : 0;
        this.fData = data;
        this.fEncoding = encoding;
        this.fStringPool = stringPool;
        this.fBytesPerChar = this.fEncoding == 0 || this.fEncoding == 1 ? 4 : 2;
        this.fBigEndian = this.fEncoding == 0 || this.fEncoding == 2 || this.fEncoding == 4;
    }

    private int getChar(int offset) throws IOException {
        int b0;
        if ((b0 = this.fData.byteAt(offset++) & 0xFF) == 255 && this.fData.atEOF(offset)) {
            return -1;
        }
        int b1 = this.fData.byteAt(offset++) & 0xFF;
        if (this.fBytesPerChar == 4) {
            int b2 = this.fData.byteAt(offset++) & 0xFF;
            int b3 = this.fData.byteAt(offset++) & 0xFF;
            if (this.fBigEndian) {
                return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
            }
            return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
        }
        if (this.fBigEndian) {
            return (b0 << 8) + b1;
        }
        return (b1 << 8) + b0;
    }

    public int addString(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fStringPool.addString(this, offset, length);
    }

    public int addSymbol(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fStringPool.addSymbol(this, offset, length, this.getHashcode(offset, length));
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int offset, int length) {
        int endOffset = offset + length;
        while (offset < endOffset) {
            int ch;
            try {
                ch = this.getChar(offset);
            }
            catch (IOException ex) {
                ch = 0;
            }
            charBuffer.append((char)ch);
            offset += this.fBytesPerChar;
        }
    }

    public void releaseString(int offset, int length) {
    }

    public String toString(int offset, int length) {
        if (this.fStringCharArray == null) {
            this.fStringCharArray = new ChunkyCharArray(this.fStringPool);
        }
        int newOffset = this.fStringCharArray.length();
        this.append(this.fStringCharArray, offset, length);
        int newLength = this.fStringCharArray.length() - newOffset;
        int stringIndex = this.fStringCharArray.addString(newOffset, newLength);
        return this.fStringPool.toString(stringIndex);
    }

    private int getHashcode(int offset, int length) {
        int endOffset = offset + length;
        int hashcode = 0;
        while (offset < endOffset) {
            int ch;
            try {
                ch = this.getChar(offset);
            }
            catch (IOException ex) {
                ch = 0;
            }
            hashcode = StringHasher.hashChar(hashcode, ch);
            offset += this.fBytesPerChar;
        }
        return StringHasher.finishHash(hashcode);
    }

    public boolean equalsString(int offset, int length, char[] strChars, int strOffset, int strLength) {
        int endOffset = offset + length;
        int slen = strLength;
        while (offset < endOffset) {
            int ch;
            if (slen-- == 0) {
                return false;
            }
            try {
                ch = this.getChar(offset);
            }
            catch (IOException ex) {
                ch = 0;
            }
            if (ch != strChars[strOffset++]) {
                return false;
            }
            offset += this.fBytesPerChar;
        }
        return slen == 0;
    }

    private void appendCharData(int ch) {
        if (fCharacters.length == this.fCharDataLength) {
            char[] newchars = new char[fCharacters.length * 2];
            System.arraycopy(fCharacters, 0, newchars, 0, fCharacters.length);
            fCharacters = newchars;
        }
        UCSReader.fCharacters[this.fCharDataLength++] = (char)ch;
    }

    public void callCharDataHandler(int offset, int length, boolean isWhitespace) throws Exception {
        int endOffset = offset + length;
        boolean skiplf = false;
        while (offset < endOffset) {
            int ch = this.getChar(offset);
            if (skiplf) {
                skiplf = false;
                if (ch == 10) {
                    offset += this.fBytesPerChar;
                    continue;
                }
            }
            if (ch == 13) {
                skiplf = true;
                ch = 10;
            }
            this.appendCharData(ch);
            offset += this.fBytesPerChar;
        }
        if (this.fSendCharDataAsCharArray) {
            if (isWhitespace) {
                this.fCharDataHandler.processWhitespace(fCharacters, 0, this.fCharDataLength);
            } else {
                this.fCharDataHandler.processCharacters(fCharacters, 0, this.fCharDataLength);
            }
        } else {
            int stringIndex = this.fStringPool.addString(new String(fCharacters, 0, this.fCharDataLength));
            if (isWhitespace) {
                this.fCharDataHandler.processWhitespace(stringIndex);
            } else {
                this.fCharDataHandler.processCharacters(stringIndex);
            }
        }
        this.fCharDataLength = 0;
    }

    public boolean lookingAtChar(char ch, boolean skipPastChar) throws Exception {
        int ch2 = this.getChar(this.fCurrentOffset);
        if (ch2 == ch) {
            if (skipPastChar) {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
            }
            return true;
        }
        return false;
    }

    public boolean lookingAtValidChar(boolean skipPastChar) throws Exception {
        int ch = this.getChar(this.fCurrentOffset);
        if (ch < 32) {
            if (ch == 9) {
                if (!skipPastChar) {
                    return true;
                }
                ++this.fCharacterCounter;
            } else if (ch == 10) {
                if (!skipPastChar) {
                    return true;
                }
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (ch == 13) {
                if (!skipPastChar) {
                    return true;
                }
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
            } else {
                if (ch == -1) {
                    return this.changeReaders().lookingAtValidChar(skipPastChar);
                }
                return false;
            }
            this.fCurrentOffset += this.fBytesPerChar;
            return true;
        }
        if (ch <= 55295) {
            if (skipPastChar) {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
            }
            return true;
        }
        if (ch <= 57343) {
            if (skipPastChar) {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
            }
            return true;
        }
        if (ch <= 65533) {
            if (skipPastChar) {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
            }
            return true;
        }
        return false;
    }

    public boolean lookingAtSpace(boolean skipPastChar) throws Exception {
        int ch = this.getChar(this.fCurrentOffset);
        if (ch > 32) {
            return false;
        }
        if (ch == 32 || ch == 9) {
            if (!skipPastChar) {
                return true;
            }
            ++this.fCharacterCounter;
        } else if (ch == 10) {
            if (!skipPastChar) {
                return true;
            }
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (ch == 13) {
            if (!skipPastChar) {
                return true;
            }
            ++this.fCarriageReturnCounter;
            this.fCharacterCounter = 1;
        } else {
            if (ch == -1) {
                return this.changeReaders().lookingAtSpace(skipPastChar);
            }
            return false;
        }
        this.fCurrentOffset += this.fBytesPerChar;
        return true;
    }

    public void skipToChar(char chr) throws Exception {
        int ch;
        while ((ch = this.getChar(this.fCurrentOffset)) != chr) {
            if (ch == -1) {
                this.changeReaders().skipToChar(chr);
                return;
            }
            if (ch == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (ch == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
            } else if (ch >= 55296 && ch < 56320) {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
                ch = this.getChar(this.fCurrentOffset);
                if (ch < 56320 || ch >= 57344) {
                    continue;
                }
            } else {
                ++this.fCharacterCounter;
            }
            this.fCurrentOffset += this.fBytesPerChar;
        }
        return;
    }

    public void skipPastSpaces() throws Exception {
        int ch;
        while ((ch = this.getChar(this.fCurrentOffset)) <= 32) {
            if (ch == 32 || ch == 9) {
                ++this.fCharacterCounter;
            } else if (ch == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (ch == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
            } else {
                if (ch == -1) {
                    this.changeReaders().skipPastSpaces();
                }
                return;
            }
            this.fCurrentOffset += this.fBytesPerChar;
        }
        return;
    }

    public void skipPastName(char fastcheck) throws Exception {
        int ch = this.getChar(this.fCurrentOffset);
        if (!this.fCalledCharPropInit) {
            XMLCharacterProperties.initCharFlags();
            this.fCalledCharPropInit = true;
        }
        if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
            return;
        }
        do {
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            ch = this.getChar(this.fCurrentOffset);
            if (fastcheck != ch) continue;
            return;
        } while ((XMLCharacterProperties.fgCharFlags[ch] & 4) != 0);
    }

    public void skipPastNmtoken(char fastcheck) throws Exception {
        int ch = this.getChar(this.fCurrentOffset);
        if (!this.fCalledCharPropInit) {
            XMLCharacterProperties.initCharFlags();
            this.fCalledCharPropInit = true;
        }
        while (fastcheck != ch) {
            if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) {
                return;
            }
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            ch = this.getChar(this.fCurrentOffset);
        }
        return;
    }

    public boolean skippedString(char[] s) throws Exception {
        int offset = this.fCurrentOffset;
        int i = 0;
        while (i < s.length) {
            if (this.getChar(offset) != s[i]) {
                return false;
            }
            offset += this.fBytesPerChar;
            ++i;
        }
        this.fCurrentOffset = offset;
        this.fCharacterCounter += s.length;
        return true;
    }

    public int scanInvalidChar() throws Exception {
        int ch = this.getChar(this.fCurrentOffset);
        if (ch == -1) {
            return this.changeReaders().scanInvalidChar();
        }
        this.fCurrentOffset += this.fBytesPerChar;
        if (ch == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (ch == 13) {
            ++this.fCarriageReturnCounter;
            this.fCharacterCounter = 1;
        } else {
            int ch2;
            ++this.fCharacterCounter;
            if (ch >= 55296 && ch < 56320 && (ch2 = this.getChar(this.fCurrentOffset)) >= 56320 && ch2 < 57344) {
                ch = (ch - 55296 << 10) + (ch2 - 56320) + 65536;
                this.fCurrentOffset += this.fBytesPerChar;
            }
        }
        return ch;
    }

    public int scanCharRef(boolean hex) throws Exception {
        int ch = this.getChar(this.fCurrentOffset);
        if (ch == -1) {
            return this.changeReaders().scanCharRef(hex);
        }
        int num = 0;
        if (hex) {
            if (ch > 102 || XMLCharacterProperties.fgAsciiXDigitChar[ch] == 0) {
                return -2;
            }
            num = ch - (ch < 65 ? 48 : (ch < 97 ? 65 : 97) - 10);
        } else {
            if (ch < 48 || ch > 57) {
                return -2;
            }
            num = ch - 48;
        }
        ++this.fCharacterCounter;
        this.fCurrentOffset += this.fBytesPerChar;
        boolean toobig = false;
        while ((ch = this.getChar(this.fCurrentOffset)) != -1 && !(hex ? ch > 102 || XMLCharacterProperties.fgAsciiXDigitChar[ch] == 0 : ch < 48 || ch > 57)) {
            int dig;
            ++this.fCharacterCounter;
            this.fCurrentOffset += this.fBytesPerChar;
            if (hex) {
                dig = ch - (ch < 65 ? 48 : (ch < 97 ? 65 : 97) - 10);
                num = (num << 4) + dig;
            } else {
                dig = ch - 48;
                num = num * 10 + dig;
            }
            if (num <= 0x10FFFF) continue;
            toobig = true;
            num = 0;
        }
        if (ch != 59) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.fCurrentOffset += this.fBytesPerChar;
        if (toobig) {
            return -3;
        }
        return num;
    }

    public int scanStringLiteral() throws Exception {
        boolean single = this.lookingAtChar('\'', true);
        if (!single && !this.lookingAtChar('\"', true)) {
            return -1;
        }
        int offset = this.fCurrentOffset;
        char qchar = single ? (char)'\'' : '\"';
        while (!this.lookingAtChar(qchar, false)) {
            if (this.lookingAtValidChar(true)) continue;
            return -2;
        }
        int stringIndex = this.addString(offset, this.fCurrentOffset - offset);
        this.lookingAtChar(qchar, true);
        return stringIndex;
    }

    public int scanAttValue(char qchar, boolean asSymbol) throws Exception {
        int offset = this.fCurrentOffset;
        while (!this.lookingAtChar(qchar, false)) {
            if (this.lookingAtChar(' ', true)) continue;
            if (this.lookingAtSpace(false)) {
                return -1;
            }
            if (this.lookingAtChar('&', false)) {
                return -1;
            }
            if (this.lookingAtChar('<', false)) {
                return -2;
            }
            if (this.lookingAtValidChar(true)) continue;
            return -3;
        }
        int result = asSymbol ? this.addSymbol(offset, this.fCurrentOffset - offset) : this.addString(offset, this.fCurrentOffset - offset);
        this.lookingAtChar(qchar, true);
        return result;
    }

    public int scanEntityValue(int qchar, boolean createString) throws Exception {
        int offset;
        block4: {
            offset = this.fCurrentOffset;
            do {
                if (qchar != -1 && this.lookingAtChar((char)qchar, false)) {
                    if (!createString) {
                        return -1;
                    }
                    break block4;
                }
                if (this.lookingAtChar('&', false)) {
                    return -2;
                }
                if (!this.lookingAtChar('%', false)) continue;
                return -3;
            } while (this.lookingAtValidChar(true));
            return -4;
        }
        int result = this.addString(offset, this.fCurrentOffset - offset);
        this.lookingAtChar((char)qchar, true);
        return result;
    }

    public boolean scanExpectedName(char fastcheck, StringPool.CharArrayRange expectedName) throws Exception {
        int nameOffset = this.fCurrentOffset;
        this.skipPastName(fastcheck);
        int nameLength = this.fCurrentOffset - nameOffset;
        if (nameLength == 0) {
            return false;
        }
        int nameIndex = this.addSymbol(nameOffset, nameLength);
        return true;
    }

    public void scanQName(char fastcheck, QName qname) throws Exception {
        int nameOffset = this.fCurrentOffset;
        int prefixend = -1;
        int offset = this.fCurrentOffset;
        int ch = this.getChar(this.fCurrentOffset);
        if (ch < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[ch] == 0) {
                qname.clear();
                return;
            }
            if (ch == 58) {
                qname.clear();
                return;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                return;
            }
        }
        while (true) {
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            ch = this.getChar(this.fCurrentOffset);
            if (fastcheck == ch) break;
            if (ch < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[ch] == 0) break;
                if (ch != 58) continue;
                if (prefixend != -1) break;
                prefixend = this.fCurrentOffset;
                ch = this.getChar(this.fCurrentOffset + this.fBytesPerChar);
                boolean lpok = true;
                if (ch < 128) {
                    if (XMLCharacterProperties.fgAsciiInitialNameChar[ch] == 0 || ch == 58) {
                        lpok = false;
                    }
                } else {
                    if (!this.fCalledCharPropInit) {
                        XMLCharacterProperties.initCharFlags();
                        this.fCalledCharPropInit = true;
                    }
                    if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                        lpok = false;
                    }
                }
                if (lpok) continue;
                prefixend = -1;
                break;
            }
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) break;
        }
        int length = this.fCurrentOffset - offset;
        qname.prefix = prefixend == -1 ? -1 : this.addSymbol(offset, prefixend - offset);
        qname.rawname = this.addSymbol(offset, length);
        qname.localpart = prefixend == -1 ? qname.rawname : this.addSymbol(prefixend + this.fBytesPerChar, this.fCurrentOffset - (prefixend + this.fBytesPerChar));
        qname.uri = 0;
    }

    public int scanName(char fastcheck) throws Exception {
        int nameOffset = this.fCurrentOffset;
        this.skipPastName(fastcheck);
        int nameLength = this.fCurrentOffset - nameOffset;
        if (nameLength == 0) {
            return -1;
        }
        int nameIndex = this.addSymbol(nameOffset, nameLength);
        return nameIndex;
    }

    private int recognizeMarkup() throws Exception {
        int ch = this.getChar(this.fCurrentOffset);
        switch (ch) {
            case -1: {
                return 11;
            }
            case 63: {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
                return 0;
            }
            case 33: {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
                ch = this.getChar(this.fCurrentOffset);
                if (ch == -1) {
                    --this.fCharacterCounter;
                    this.fCurrentOffset -= this.fBytesPerChar;
                    return 11;
                }
                if (ch == 45) {
                    ++this.fCharacterCounter;
                    this.fCurrentOffset += this.fBytesPerChar;
                    ch = this.getChar(this.fCurrentOffset);
                    if (ch == -1) {
                        this.fCharacterCounter -= 2;
                        this.fCurrentOffset -= 2;
                        return 11;
                    }
                    if (ch != 45) break;
                    ++this.fCharacterCounter;
                    this.fCurrentOffset += this.fBytesPerChar;
                    return 1;
                }
                if (ch != 91) break;
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
                int i = 0;
                while (i < 6) {
                    ch = this.getChar(this.fCurrentOffset);
                    if (ch == -1) {
                        this.fCharacterCounter -= 2 + i;
                        this.fCurrentOffset -= (2 + i) * this.fBytesPerChar;
                        return 11;
                    }
                    if (ch != cdata_string[i]) {
                        return 10;
                    }
                    ++this.fCharacterCounter;
                    this.fCurrentOffset += this.fBytesPerChar;
                    ++i;
                }
                return 2;
            }
            case 47: {
                ++this.fCharacterCounter;
                this.fCurrentOffset += this.fBytesPerChar;
                return 4;
            }
            default: {
                return 6;
            }
        }
        return 10;
    }

    private int recognizeReference() throws Exception {
        int ch = this.getChar(this.fCurrentOffset);
        if (ch == -1) {
            return 12;
        }
        if (ch == 35) {
            ++this.fCharacterCounter;
            this.fCurrentOffset += this.fBytesPerChar;
            return 7;
        }
        return 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanContent(QName element) throws Exception {
        byte prop;
        int ch;
        int offset;
        block47: {
            block52: {
                block51: {
                    block49: {
                        block50: {
                            offset = this.fCurrentOffset;
                            ch = this.getChar(this.fCurrentOffset);
                            this.fCurrentOffset += this.fBytesPerChar;
                            if (!this.fCalledCharPropInit) {
                                XMLCharacterProperties.initCharFlags();
                                this.fCalledCharPropInit = true;
                            }
                            if (ch >= 128) break block49;
                            if (ch == -1) {
                                this.fCurrentOffset -= this.fBytesPerChar;
                                return this.changeReaders().scanContent(element);
                            }
                            prop = XMLCharacterProperties.fgCharFlags[ch];
                            if ((prop & 1) != 0 || ch == 10 || ch == 13) break block50;
                            if (ch == 60) {
                                ++this.fCharacterCounter;
                                if (!this.fInCDSect) {
                                    return this.recognizeMarkup();
                                }
                                break block47;
                            } else if (ch == 38) {
                                ++this.fCharacterCounter;
                                if (!this.fInCDSect) {
                                    return this.recognizeReference();
                                }
                                break block47;
                            } else {
                                if (ch != 93) {
                                    this.fCurrentOffset -= this.fBytesPerChar;
                                    return 9;
                                }
                                if (this.getChar(this.fCurrentOffset) == 93 && this.getChar(this.fCurrentOffset + this.fBytesPerChar) == 62) {
                                    this.fCharacterCounter += 3;
                                    this.fCurrentOffset += 2 * this.fBytesPerChar;
                                    return 3;
                                }
                            }
                            break block47;
                        }
                        if (ch != 32 && ch != 9 && ch != 10 && ch != 13) break block47;
                        break block51;
                    }
                    if (ch >= 55296 && ch <= 57343) {
                        this.fCurrentOffset += this.fBytesPerChar;
                        break block47;
                    } else if (ch == 65534 || ch == 65535) {
                        this.fCurrentOffset -= this.fBytesPerChar;
                        return 9;
                    }
                    break block47;
                }
                do {
                    if (ch == 10) {
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                    } else if (ch == 13) {
                        ++this.fCarriageReturnCounter;
                        this.fCharacterCounter = 1;
                    } else {
                        ++this.fCharacterCounter;
                    }
                    ch = this.getChar(this.fCurrentOffset);
                    this.fCurrentOffset += this.fBytesPerChar;
                } while (ch == 32 || ch == 9 || ch == 10 || ch == 13);
                if (ch >= 128) break block52;
                if (ch == -1) {
                    this.fCurrentOffset -= this.fBytesPerChar;
                    this.callCharDataHandler(offset, this.fCurrentOffset - offset, true);
                    return this.changeReaders().scanContent(element);
                }
                prop = XMLCharacterProperties.fgCharFlags[ch];
                if ((prop & 1) == 0) {
                    if (ch == 60) {
                        if (!this.fInCDSect) {
                            this.callCharDataHandler(offset, this.fCurrentOffset - this.fBytesPerChar - offset, true);
                            ++this.fCharacterCounter;
                            return this.recognizeMarkup();
                        }
                        ++this.fCharacterCounter;
                        break block47;
                    } else if (ch == 38) {
                        if (!this.fInCDSect) {
                            this.callCharDataHandler(offset, this.fCurrentOffset - this.fBytesPerChar - offset, true);
                            ++this.fCharacterCounter;
                            return this.recognizeReference();
                        }
                        ++this.fCharacterCounter;
                        break block47;
                    } else {
                        if (ch != 93) {
                            this.fCurrentOffset -= this.fBytesPerChar;
                            this.callCharDataHandler(offset, this.fCurrentOffset - offset, true);
                            return 9;
                        }
                        if (this.getChar(this.fCurrentOffset) == 93 && this.getChar(this.fCurrentOffset + this.fBytesPerChar) == 62) {
                            this.callCharDataHandler(offset, this.fCurrentOffset - this.fBytesPerChar - offset, true);
                            this.fCharacterCounter += 3;
                            this.fCurrentOffset += 2 * this.fBytesPerChar;
                            return 3;
                        }
                    }
                }
                break block47;
            }
            if (ch >= 55296 && ch <= 57343) {
                this.fCurrentOffset += this.fBytesPerChar;
            } else if (ch == 65534 || ch == 65535) {
                this.fCurrentOffset -= this.fBytesPerChar;
                this.callCharDataHandler(offset, this.fCurrentOffset - offset, true);
                return 9;
            }
        }
        ++this.fCharacterCounter;
        while (true) {
            ch = this.getChar(this.fCurrentOffset);
            this.fCurrentOffset += this.fBytesPerChar;
            if (ch >= 128 || ch < 0) break;
            prop = XMLCharacterProperties.fgCharFlags[ch];
            if ((prop & 1) == 0) {
                if (ch == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    continue;
                }
                if (ch != 13) break;
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                continue;
            }
            ++this.fCharacterCounter;
        }
        while (true) {
            block48: {
                block53: {
                    block54: {
                        block56: {
                            block55: {
                                if (ch >= 128) break block53;
                                if (ch == -1) {
                                    this.fCurrentOffset -= this.fBytesPerChar;
                                    this.callCharDataHandler(offset, this.fCurrentOffset - offset, false);
                                    return this.changeReaders().scanContent(element);
                                }
                                prop = XMLCharacterProperties.fgCharFlags[ch];
                                if ((prop & 1) != 0) break block54;
                                if (ch != 60) break block55;
                                if (!this.fInCDSect) {
                                    this.callCharDataHandler(offset, this.fCurrentOffset - this.fBytesPerChar - offset, false);
                                    ++this.fCharacterCounter;
                                    return this.recognizeMarkup();
                                }
                                ++this.fCharacterCounter;
                                break block48;
                            }
                            if (ch != 38) break block56;
                            if (!this.fInCDSect) {
                                this.callCharDataHandler(offset, this.fCurrentOffset - this.fBytesPerChar - offset, false);
                                ++this.fCharacterCounter;
                                return this.recognizeReference();
                            }
                            ++this.fCharacterCounter;
                            break block48;
                        }
                        if (ch == 10) {
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                            break block48;
                        } else if (ch == 13) {
                            ++this.fCarriageReturnCounter;
                            this.fCharacterCounter = 1;
                            break block48;
                        } else {
                            if (ch != 93) {
                                this.fCurrentOffset -= this.fBytesPerChar;
                                this.callCharDataHandler(offset, this.fCurrentOffset - offset, false);
                                return 9;
                            }
                            if (this.getChar(this.fCurrentOffset) == 93 && this.getChar(this.fCurrentOffset + this.fBytesPerChar) == 62) {
                                this.callCharDataHandler(offset, this.fCurrentOffset - this.fBytesPerChar - offset, false);
                                this.fCharacterCounter += 3;
                                this.fCurrentOffset += 2 * this.fBytesPerChar;
                                return 3;
                            }
                            ++this.fCharacterCounter;
                        }
                        break block48;
                    }
                    ++this.fCharacterCounter;
                    break block48;
                }
                if (ch >= 55296 && ch <= 57343) {
                    ++this.fCharacterCounter;
                    this.fCurrentOffset += this.fBytesPerChar;
                } else if (ch == 65534 || ch == 65535) {
                    this.fCurrentOffset -= this.fBytesPerChar;
                    this.callCharDataHandler(offset, this.fCurrentOffset - offset, false);
                    return 9;
                }
                ++this.fCharacterCounter;
            }
            ch = this.getChar(this.fCurrentOffset);
            this.fCurrentOffset += this.fBytesPerChar;
        }
    }
}

