/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.UCSReader;
import org.apache.xerces.readers.XMLDeclRecognizer;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.ChunkyByteArray;
import org.apache.xerces.utils.StringPool;

final class UCSRecognizer
extends XMLDeclRecognizer {
    UCSRecognizer() {
    }

    public XMLEntityHandler.EntityReader recognize(XMLEntityReaderFactory readerFactory, XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, StringPool stringPool, ChunkyByteArray data, boolean xmlDecl, boolean allowJavaEncodingName) throws Exception {
        UCSReader reader = null;
        byte b0 = data.byteAt(0);
        if (b0 == 0) {
            byte b1 = data.byteAt(1);
            if (b1 == 0) {
                if (data.byteAt(2) == 0 && data.byteAt(3) == 60) {
                    reader = new UCSReader(entityHandler, errorReporter, sendCharDataAsCharArray, data, 0, stringPool);
                }
            } else if (b1 == 60 && data.byteAt(2) == 0 && data.byteAt(3) == 63) {
                reader = new UCSReader(entityHandler, errorReporter, sendCharDataAsCharArray, data, 4, stringPool);
            }
        } else if (b0 == 60) {
            byte b1 = data.byteAt(1);
            if (b1 == 0) {
                byte b2 = data.byteAt(2);
                if (data.byteAt(3) == 0) {
                    if (b2 == 0) {
                        reader = new UCSReader(entityHandler, errorReporter, sendCharDataAsCharArray, data, 1, stringPool);
                    } else if (b2 == 63) {
                        reader = new UCSReader(entityHandler, errorReporter, sendCharDataAsCharArray, data, 5, stringPool);
                    }
                }
            }
        } else if (b0 == -2) {
            if (data.byteAt(1) == -1) {
                reader = new UCSReader(entityHandler, errorReporter, sendCharDataAsCharArray, data, 2, stringPool);
            }
        } else if (b0 == -1 && data.byteAt(1) == -2) {
            reader = new UCSReader(entityHandler, errorReporter, sendCharDataAsCharArray, data, 3, stringPool);
        }
        return reader;
    }
}

