/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.AbstractCharReader;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.StringPool;

final class UTF8CharReader
extends AbstractCharReader {
    private InputStream fInputStream = null;
    private boolean fCheckOverflow = false;
    private byte[] fOverflow = null;
    private int fOverflowOffset = 0;
    private int fOverflowEnd = 0;
    private int fOutputOffset = 0;
    private boolean fSkipLinefeed = false;
    private int fPartialMultiByteIn = 0;
    private byte[] fPartialMultiByteChar = new byte[3];
    private int fPartialSurrogatePair = 0;
    private boolean fPartialMultiByteResult = false;

    UTF8CharReader(XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, InputStream dataStream, StringPool stringPool) throws Exception {
        super(entityHandler, errorReporter, sendCharDataAsCharArray, stringPool);
        this.fInputStream = dataStream;
        this.fillCurrentChunk();
    }

    /*
     * Unable to fully structure code
     */
    protected int fillCurrentChunk() throws Exception {
        recycledData = this.fCurrentChunk.toCharArray();
        this.fOutputOffset = 0;
        if (this.fCheckOverflow) {
            this.fMostRecentData = recycledData;
            if (this.fOverflowEnd < 16384) {
                recycledData = null;
                if (this.fOverflowEnd > 0) {
                    if (this.fMostRecentData == null || this.fMostRecentData.length < 1 + this.fOverflowEnd - this.fOverflowOffset) {
                        this.fMostRecentData = new char[1 + this.fOverflowEnd - this.fOverflowOffset];
                    }
                    this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                } else if (this.fMostRecentData == null) {
                    this.fMostRecentData = new char[1];
                }
                this.fMostRecentData[this.fOutputOffset] = '\u0000';
                this.fOverflow = null;
                this.fLength += this.fOutputOffset;
                this.fCurrentIndex = 0;
                this.fCurrentChunk.setCharArray(this.fMostRecentData);
                this.fMostRecentChar = this.fMostRecentData[0];
                return this.fMostRecentChar;
            }
            if (this.fMostRecentData == null || this.fMostRecentData.length < 16384) {
                this.fMostRecentData = new char[16384];
            } else {
                recycledData = null;
            }
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
            this.fCheckOverflow = false;
        } else {
            if (this.fOverflow == null) {
                this.fOverflow = new byte[16384];
            }
            this.fMostRecentData = null;
        }
        do lbl-1000:
        // 3 sources

        {
            block22: {
                this.fOverflowOffset = 0;
                this.fOverflowEnd = 0;
                capacity = 16384;
                result = 0;
                do {
                    try {
                        result = this.fInputStream.read(this.fOverflow, this.fOverflowEnd, capacity);
                    }
                    catch (IOException ex) {
                        result = -1;
                    }
                    if (result == -1) {
                        this.fInputStream.close();
                        this.fInputStream = null;
                        if (this.fMostRecentData == null) {
                            this.fMostRecentData = recycledData;
                            if (this.fMostRecentData == null || this.fMostRecentData.length < 1 + this.fOverflowEnd) {
                                this.fMostRecentData = new char[1 + this.fOverflowEnd];
                            } else {
                                recycledData = null;
                            }
                            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = '\u0000';
                            break;
                        }
                        alldone = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                        if (alldone) {
                            if (this.fOverflowEnd == 16384) {
                                this.fCheckOverflow = true;
                                this.fOverflowOffset = 0;
                                this.fOverflowEnd = 0;
                                break;
                            }
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = '\u0000';
                            break;
                        }
                        this.fCheckOverflow = true;
                        break;
                    }
                    if (result <= 0) continue;
                    this.fOverflowEnd += result;
                    capacity -= result;
                } while (capacity > 0);
                if (result == -1) break;
                if (this.fMostRecentData == null) break block22;
                alldone = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                if (this.fOutputOffset != 16384) ** GOTO lbl-1000
                if (alldone) break;
                this.fCheckOverflow = true;
                break;
            }
            this.fMostRecentData = recycledData;
            if (this.fMostRecentData == null || this.fMostRecentData.length < 16384) {
                this.fMostRecentData = new char[16384];
            } else {
                recycledData = null;
            }
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
        } while (this.fOutputOffset != 16384);
        this.fLength += this.fOutputOffset;
        this.fCurrentIndex = 0;
        this.fCurrentChunk.setCharArray(this.fMostRecentData);
        this.fMostRecentChar = this.fMostRecentData[0];
        return this.fMostRecentChar;
    }

    private boolean copyNormalize(byte[] in, int inOffset, char[] out, int outOffset) throws Exception {
        int inEnd = this.fOverflowEnd;
        int outEnd = out.length;
        if (inOffset == inEnd) {
            return true;
        }
        byte b = in[inOffset];
        if (this.fSkipLinefeed) {
            this.fSkipLinefeed = false;
            if (b == 10) {
                if (++inOffset == inEnd) {
                    return this.exitNormalize(inOffset, outOffset, true);
                }
                b = in[inOffset];
            }
        } else if (this.fPartialMultiByteIn > 0) {
            if (!this.handlePartialMultiByteChar(b, in, inOffset, inEnd, out, outOffset, outEnd)) {
                return this.fPartialMultiByteResult;
            }
            inOffset = this.fOverflowOffset;
            outOffset = this.fOutputOffset;
            b = in[inOffset];
        }
        while (outOffset < outEnd) {
            int inCount = inEnd - inOffset;
            int outCount = outEnd - outOffset;
            if (inCount > outCount) {
                inCount = outCount;
            }
            ++inOffset;
            while (true) {
                if (b == 13 || b < 0) {
                    if (b == 13) {
                        out[outOffset++] = 10;
                        if (inOffset == inEnd) {
                            this.fSkipLinefeed = true;
                            return this.exitNormalize(inOffset, outOffset, true);
                        }
                        b = in[inOffset];
                        if (b == 10) {
                            if (++inOffset == inEnd) {
                                return this.exitNormalize(inOffset, outOffset, true);
                            }
                            b = in[inOffset];
                        }
                        if (outOffset == outEnd) {
                            return this.exitNormalize(inOffset, outOffset, false);
                        }
                    } else {
                        if (!this.handleMultiByteChar(b, in, inOffset, inEnd, out, outOffset, outEnd)) {
                            return this.fPartialMultiByteResult;
                        }
                        inOffset = this.fOverflowOffset;
                        outOffset = this.fOutputOffset;
                        b = in[inOffset];
                    }
                    if ((inCount = inEnd - inOffset) > (outCount = outEnd - outOffset)) {
                        inCount = outCount;
                    }
                    ++inOffset;
                    continue;
                }
                do {
                    out[outOffset++] = (char)b;
                } while (--inCount != 0 && (b = in[inOffset++]) != 13 && b >= 0);
                if (inCount == 0) break;
            }
            if (inOffset == inEnd) break;
        }
        return this.exitNormalize(inOffset, outOffset, inOffset == inEnd);
    }

    private boolean exitNormalize(int inOffset, int outOffset, boolean result) {
        this.fOverflowOffset = inOffset;
        this.fOutputOffset = outOffset;
        return result;
    }

    private void savePartialMultiByte(int inCount, byte bz, byte by, byte bx) {
        this.fPartialMultiByteIn = inCount--;
        this.fPartialMultiByteChar[inCount] = bz;
        this.fPartialMultiByteChar[--inCount] = by;
        this.fPartialMultiByteChar[--inCount] = bx;
    }

    private void savePartialMultiByte(int inCount, byte bz, byte by) {
        this.fPartialMultiByteIn = inCount--;
        this.fPartialMultiByteChar[inCount] = bz;
        this.fPartialMultiByteChar[--inCount] = by;
    }

    private void savePartialMultiByte(int inCount, byte bz) {
        this.fPartialMultiByteIn = inCount--;
        this.fPartialMultiByteChar[inCount] = bz;
    }

    private boolean handleMultiByteChar(byte b, byte[] in, int inOffset, int inEnd, char[] out, int outOffset, int outEnd) throws Exception {
        byte b1;
        if (inOffset == inEnd) {
            this.savePartialMultiByte(1, b);
            this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, true);
            return false;
        }
        if (((b1 = in[inOffset++]) & 0xC0) != 128) {
            Object[] args = new Object[]{Integer.toHexString(b & 0xFF), Integer.toHexString(b1 & 0xFF)};
            this.deferException(2, args, outOffset);
            out[outOffset++] = '\u0000';
            return this.exitNormalize(inOffset, outOffset, true);
        }
        if ((b & 0xE0) == 192) {
            int ch = ((0x1F & b) << 6) + (0x3F & b1);
            out[outOffset++] = (char)ch;
            if (inOffset == inEnd || outOffset == outEnd) {
                this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, inOffset == inEnd);
                return false;
            }
        } else {
            byte b2;
            if (inOffset == inEnd) {
                this.savePartialMultiByte(2, b1, b);
                this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, true);
                return false;
            }
            if (((b2 = in[inOffset++]) & 0xC0) != 128) {
                Object[] args = new Object[]{Integer.toHexString(b & 0xFF), Integer.toHexString(b1 & 0xFF), Integer.toHexString(b2 & 0xFF)};
                this.deferException(3, args, outOffset);
                out[outOffset++] = '\u0000';
                return this.exitNormalize(inOffset, outOffset, true);
            }
            if ((b & 0xF0) == 224) {
                int ch = ((0xF & b) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                out[outOffset++] = (char)ch;
                if (inOffset == inEnd || outOffset == outEnd) {
                    this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, inOffset == inEnd);
                    return false;
                }
            } else {
                byte b3;
                if ((b & 0xF8) != 240) {
                    Object[] args = new Object[]{Integer.toHexString(b & 0xFF)};
                    this.deferException(1, args, outOffset);
                    out[outOffset++] = '\u0000';
                    return this.exitNormalize(inOffset, outOffset, true);
                }
                if (inOffset == inEnd) {
                    this.savePartialMultiByte(3, b2, b1, b);
                    this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, true);
                    return false;
                }
                if (((b3 = in[inOffset++]) & 0xC0) != 128) {
                    Object[] args = new Object[]{Integer.toHexString(b & 0xFF), Integer.toHexString(b1 & 0xFF), Integer.toHexString(b2 & 0xFF), Integer.toHexString(b3 & 0xFF)};
                    this.deferException(4, args, outOffset);
                    out[outOffset++] = '\u0000';
                    return this.exitNormalize(inOffset, outOffset, true);
                }
                int ch = ((0xF & b) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3);
                if (ch >= 65536) {
                    out[outOffset++] = (char)((ch - 65536 >> 10) + 55296);
                    ch = (ch - 65536 & 0x3FF) + 56320;
                    if (outOffset == outEnd) {
                        this.fPartialSurrogatePair = ch;
                        this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, inOffset == inEnd);
                        return false;
                    }
                }
                out[outOffset++] = (char)ch;
                if (inOffset == inEnd || outOffset == outEnd) {
                    this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, inOffset == inEnd);
                    return false;
                }
            }
        }
        return this.exitNormalize(inOffset, outOffset, true);
    }

    private boolean handlePartialMultiByteChar(byte b, byte[] in, int inOffset, int inEnd, char[] out, int outOffset, int outEnd) throws Exception {
        if (outOffset == outEnd) {
            this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, inOffset == inEnd);
            return false;
        }
        if (this.fPartialMultiByteIn == 4) {
            out[outOffset++] = (char)this.fPartialSurrogatePair;
            if (outOffset == outEnd) {
                this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, false);
                return false;
            }
            this.fOutputOffset = outOffset;
            return true;
        }
        int byteIn = this.fPartialMultiByteIn;
        this.fPartialMultiByteIn = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        switch (byteIn) {
            case 1: {
                b1 = b;
                break;
            }
            case 2: {
                b2 = b;
                break;
            }
            case 3: {
                b3 = b;
            }
        }
        int i = byteIn;
        switch (byteIn) {
            case 3: {
                b2 = this.fPartialMultiByteChar[--i];
            }
            case 2: {
                b1 = this.fPartialMultiByteChar[--i];
            }
            case 1: {
                b = this.fPartialMultiByteChar[--i];
            }
        }
        switch (byteIn) {
            case 1: {
                if ((b1 & 0xC0) != 128) {
                    Object[] args = new Object[]{Integer.toHexString(b), Integer.toHexString(b1)};
                    this.deferException(2, args, outOffset);
                    out[outOffset++] = '\u0000';
                    break;
                }
            }
            case 2: {
                if ((b & 0xE0) == 192) {
                    int ch = ((0x1F & b) << 6) + (0x3F & b1);
                    out[outOffset++] = (char)ch;
                    if (outOffset == outEnd) {
                        this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, false);
                        return false;
                    }
                    if (byteIn >= 2 || ++inOffset != inEnd) break;
                    this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, true);
                    return false;
                }
                if (byteIn < 2) {
                    if (++inOffset == inEnd) {
                        this.savePartialMultiByte(2, b1);
                        this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, true);
                        return false;
                    }
                    b2 = in[inOffset];
                }
                if ((b2 & 0xC0) != 128) {
                    Object[] args = new Object[]{Integer.toHexString(b), Integer.toHexString(b1), Integer.toHexString(b2)};
                    this.deferException(3, args, outOffset);
                    out[outOffset++] = '\u0000';
                    break;
                }
            }
            case 3: {
                if ((b & 0xF0) == 224) {
                    int ch = ((0xF & b) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                    out[outOffset++] = (char)ch;
                    if (outOffset == outEnd) {
                        this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, false);
                        return false;
                    }
                    if (byteIn >= 3 || ++inOffset != inEnd) break;
                    this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, true);
                    return false;
                }
                if (byteIn < 3) {
                    if ((b & 0xF8) != 240) {
                        Object[] args = new Object[]{Integer.toHexString(b)};
                        this.deferException(1, args, outOffset);
                        out[outOffset++] = '\u0000';
                        break;
                    }
                    if (++inOffset == inEnd) {
                        this.savePartialMultiByte(3, b2, b1);
                        this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, true);
                        return false;
                    }
                    b3 = in[inOffset];
                }
                if ((b3 & 0xC0) != 128) {
                    Object[] args = new Object[]{Integer.toHexString(b), Integer.toHexString(b1), Integer.toHexString(b2), Integer.toHexString(b3)};
                    this.deferException(4, args, outOffset);
                    out[outOffset++] = '\u0000';
                    break;
                }
                int ch = ((0xF & b) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3);
                if (ch >= 65536) {
                    out[outOffset++] = (char)((ch - 65536 >> 10) + 55296);
                    ch = (ch - 65536 & 0x3FF) + 56320;
                    if (outOffset == outEnd) {
                        this.fPartialSurrogatePair = ch;
                        this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, false);
                        return false;
                    }
                }
                out[outOffset++] = (char)ch;
                if (outOffset == outEnd) {
                    this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, false);
                    return false;
                }
                if (++inOffset != inEnd) break;
                this.fPartialMultiByteResult = this.exitNormalize(inOffset, outOffset, true);
                return false;
            }
        }
        return this.exitNormalize(inOffset, outOffset, true);
    }
}

