/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.SymbolCache;
import org.apache.xerces.utils.UTF8DataChunk;
import org.apache.xerces.utils.XMLCharacterProperties;

final class UTF8Reader
extends XMLEntityReader {
    private static final boolean USE_OUT_OF_LINE_LOAD_NEXT_BYTE = false;
    private static final boolean USE_TRY_CATCH_FOR_LOAD_NEXT_BYTE = true;
    public static final byte[] fgAsciiAttValueChar;
    public static final byte[] fgAsciiEntityValueChar;
    private char[] fCharacters = new char[16384];
    private int fCharDataLength = 0;
    private static final char[] cdata_string;
    private StringPool.CharArrayRange fCharArrayRange = null;
    private InputStream fInputStream = null;
    private StringPool fStringPool = null;
    private UTF8DataChunk fCurrentChunk = null;
    private int fCurrentIndex = 0;
    private byte[] fMostRecentData = null;
    private int fMostRecentByte = 0;
    private int fLength = 0;
    private boolean fCalledCharPropInit = false;
    private boolean fCallClearPreviousChunk = true;

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 4;
        byArray[1] = 4;
        byArray[2] = 4;
        byArray[3] = 4;
        byArray[4] = 4;
        byArray[5] = 4;
        byArray[6] = 4;
        byArray[7] = 4;
        byArray[8] = 4;
        byArray[9] = 2;
        byArray[10] = 2;
        byArray[11] = 4;
        byArray[12] = 4;
        byArray[13] = 2;
        byArray[14] = 4;
        byArray[15] = 4;
        byArray[16] = 4;
        byArray[17] = 4;
        byArray[18] = 4;
        byArray[19] = 4;
        byArray[20] = 4;
        byArray[21] = 4;
        byArray[22] = 4;
        byArray[23] = 4;
        byArray[24] = 4;
        byArray[25] = 4;
        byArray[26] = 4;
        byArray[27] = 4;
        byArray[28] = 4;
        byArray[29] = 4;
        byArray[30] = 4;
        byArray[31] = 4;
        byArray[34] = 1;
        byArray[38] = 2;
        byArray[39] = 1;
        byArray[60] = 3;
        fgAsciiAttValueChar = byArray;
        byte[] byArray2 = new byte[128];
        byArray2[0] = 7;
        byArray2[1] = 4;
        byArray2[2] = 4;
        byArray2[3] = 4;
        byArray2[4] = 4;
        byArray2[5] = 4;
        byArray2[6] = 4;
        byArray2[7] = 4;
        byArray2[8] = 4;
        byArray2[10] = 5;
        byArray2[11] = 4;
        byArray2[12] = 4;
        byArray2[13] = 6;
        byArray2[14] = 4;
        byArray2[15] = 4;
        byArray2[16] = 4;
        byArray2[17] = 4;
        byArray2[18] = 4;
        byArray2[19] = 4;
        byArray2[20] = 4;
        byArray2[21] = 4;
        byArray2[22] = 4;
        byArray2[23] = 4;
        byArray2[24] = 4;
        byArray2[25] = 4;
        byArray2[26] = 4;
        byArray2[27] = 4;
        byArray2[28] = 4;
        byArray2[29] = 4;
        byArray2[30] = 4;
        byArray2[31] = 4;
        byArray2[34] = 1;
        byArray2[37] = 3;
        byArray2[38] = 2;
        byArray2[39] = 1;
        fgAsciiEntityValueChar = byArray2;
        cdata_string = new char[]{'C', 'D', 'A', 'T', 'A', '['};
    }

    public UTF8Reader(XMLEntityHandler entityHandler, XMLErrorReporter errorReporter, boolean sendCharDataAsCharArray, InputStream dataStream, StringPool stringPool) throws Exception {
        super(entityHandler, errorReporter, sendCharDataAsCharArray);
        this.fInputStream = dataStream;
        this.fStringPool = stringPool;
        this.fCharArrayRange = this.fStringPool.createCharArrayRange();
        this.fCurrentChunk = UTF8DataChunk.createChunk(this.fStringPool, null);
        this.fillCurrentChunk();
    }

    public int addString(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(offset, length);
    }

    public int addSymbol(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(offset, length, 0);
    }

    private int addSymbol(int offset, int length, int hashcode) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(offset, length, hashcode);
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int offset, int length) {
        this.fCurrentChunk.append(charBuffer, offset, length);
    }

    private int slowLoadNextByte() throws Exception {
        this.fCallClearPreviousChunk = true;
        if (this.fCurrentChunk.nextChunk() != null) {
            this.fCurrentChunk = this.fCurrentChunk.nextChunk();
            this.fCurrentIndex = 0;
            this.fMostRecentData = this.fCurrentChunk.toByteArray();
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            return this.fMostRecentByte;
        }
        this.fCurrentChunk = UTF8DataChunk.createChunk(this.fStringPool, this.fCurrentChunk);
        return this.fillCurrentChunk();
    }

    private int loadNextByte() throws Exception {
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            return this.fMostRecentByte;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.slowLoadNextByte();
        }
    }

    private boolean atEOF(int offset) {
        return offset > this.fLength;
    }

    public XMLEntityHandler.EntityReader changeReaders() throws Exception {
        XMLEntityHandler.EntityReader nextReader = super.changeReaders();
        this.fCurrentChunk.releaseChunk();
        this.fCurrentChunk = null;
        this.fMostRecentData = null;
        this.fMostRecentByte = 0;
        return nextReader;
    }

    public boolean lookingAtChar(char ch, boolean skipPastChar) throws Exception {
        int b0 = this.fMostRecentByte;
        if (b0 != ch) {
            if (b0 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtChar(ch, skipPastChar);
            }
            if (ch == '\n' && b0 == 13) {
                if (skipPastChar) {
                    ++this.fCarriageReturnCounter;
                    this.fCharacterCounter = 1;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        b0 = this.slowLoadNextByte();
                    }
                    if (b0 == 10) {
                        ++this.fLinefeedCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            this.slowLoadNextByte();
                        }
                    }
                }
                return true;
            }
            return false;
        }
        if (ch == '\r') {
            return false;
        }
        if (skipPastChar) {
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                this.slowLoadNextByte();
            }
        }
        return true;
    }

    public boolean lookingAtValidChar(boolean skipPastChar) throws Exception {
        int b0 = this.fMostRecentByte;
        if (b0 < 128) {
            if (b0 >= 32 || b0 == 9) {
                if (skipPastChar) {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        this.slowLoadNextByte();
                    }
                }
                return true;
            }
            if (b0 == 10) {
                if (skipPastChar) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        this.slowLoadNextByte();
                    }
                }
                return true;
            }
            if (b0 == 13) {
                if (skipPastChar) {
                    ++this.fCarriageReturnCounter;
                    this.fCharacterCounter = 1;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        b0 = this.slowLoadNextByte();
                    }
                    if (b0 == 10) {
                        ++this.fLinefeedCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            this.slowLoadNextByte();
                        }
                    }
                }
                return true;
            }
            if (b0 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtValidChar(skipPastChar);
            }
            return false;
        }
        UTF8DataChunk saveChunk = this.fCurrentChunk;
        int saveIndex = this.fCurrentIndex;
        int saveOffset = this.fCurrentOffset;
        int b1 = this.loadNextByte();
        if ((0xE0 & b0) == 192) {
            if (skipPastChar) {
                ++this.fCharacterCounter;
                this.loadNextByte();
            } else {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
            }
            return true;
        }
        int b2 = this.loadNextByte();
        if ((0xF0 & b0) == 224) {
            boolean result = false;
            if (!(b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190)) {
                if (skipPastChar) {
                    ++this.fCharacterCounter;
                    this.loadNextByte();
                    return true;
                }
                result = true;
            }
            this.fCurrentChunk = saveChunk;
            this.fCurrentIndex = saveIndex;
            this.fCurrentOffset = saveOffset;
            this.fMostRecentData = saveChunk.toByteArray();
            this.fMostRecentByte = b0;
            return result;
        }
        int b3 = this.loadNextByte();
        boolean result = false;
        if ((b0 & 0xF8) == 240 && (b1 & 0xC0) == 128 && (b2 & 0xC0) == 128 && (b3 & 0xC0) == 128) {
            if (b0 <= 244 && (b0 != 244 || b1 < 144)) {
                if (skipPastChar) {
                    ++this.fCharacterCounter;
                    this.loadNextByte();
                    return true;
                }
                result = true;
            }
            this.fCurrentChunk = saveChunk;
            this.fCurrentIndex = saveIndex;
            this.fCurrentOffset = saveOffset;
            this.fMostRecentData = saveChunk.toByteArray();
            this.fMostRecentByte = b0;
            return result;
        }
        this.fCurrentChunk = saveChunk;
        this.fCurrentIndex = saveIndex;
        this.fCurrentOffset = saveOffset;
        this.fMostRecentData = saveChunk.toByteArray();
        this.fMostRecentByte = b0;
        return result;
    }

    public boolean lookingAtSpace(boolean skipPastChar) throws Exception {
        int ch = this.fMostRecentByte;
        if (ch > 32) {
            return false;
        }
        if (ch == 32 || ch == 9) {
            if (!skipPastChar) {
                return true;
            }
            ++this.fCharacterCounter;
        } else if (ch == 10) {
            if (!skipPastChar) {
                return true;
            }
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (ch == 13) {
            if (!skipPastChar) {
                return true;
            }
            ++this.fCarriageReturnCounter;
            this.fCharacterCounter = 1;
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                ch = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ch = this.slowLoadNextByte();
            }
            if (ch != 10) {
                return true;
            }
            ++this.fLinefeedCounter;
        } else {
            if (ch == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtSpace(skipPastChar);
            }
            return false;
        }
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.slowLoadNextByte();
        }
        return true;
    }

    public void skipToChar(char ch) throws Exception {
        int b0 = this.fMostRecentByte;
        while (b0 != ch) {
            if (b0 == 0) {
                if (this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders().skipToChar(ch);
                    return;
                }
                ++this.fCharacterCounter;
            } else if (b0 == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (b0 == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                b0 = this.loadNextByte();
                if (b0 != 10) continue;
                ++this.fLinefeedCounter;
            } else if (b0 < 128) {
                ++this.fCharacterCounter;
            } else {
                ++this.fCharacterCounter;
                if ((0xE0 & b0) == 192) {
                    this.loadNextByte();
                } else if ((0xF0 & b0) == 224) {
                    this.loadNextByte();
                    this.loadNextByte();
                } else {
                    this.loadNextByte();
                    this.loadNextByte();
                    this.loadNextByte();
                }
            }
            b0 = this.loadNextByte();
        }
        return;
    }

    public void skipPastSpaces() throws Exception {
        int ch = this.fMostRecentByte;
        while (true) {
            if (ch == 32 || ch == 9) {
                ++this.fCharacterCounter;
            } else if (ch == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (ch == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    ch = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ch = this.slowLoadNextByte();
                }
                if (ch != 10) continue;
                ++this.fLinefeedCounter;
            } else {
                if (ch == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders().skipPastSpaces();
                }
                return;
            }
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                ch = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ch = this.slowLoadNextByte();
                continue;
            }
            break;
        }
    }

    protected boolean skippedMultiByteCharWithFlag(int b0, int flag) throws Exception {
        UTF8DataChunk saveChunk = this.fCurrentChunk;
        int saveOffset = this.fCurrentOffset;
        int saveIndex = this.fCurrentIndex;
        if (!this.fCalledCharPropInit) {
            XMLCharacterProperties.initCharFlags();
            this.fCalledCharPropInit = true;
        }
        int b1 = this.loadNextByte();
        if ((0xE0 & b0) == 192) {
            if ((XMLCharacterProperties.fgCharFlags[((0x1F & b0) << 6) + (0x3F & b1)] & flag) == 0) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return false;
            }
            return true;
        }
        int b2 = this.loadNextByte();
        if ((0xF0 & b0) == 224) {
            if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return false;
            }
            if ((XMLCharacterProperties.fgCharFlags[((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2)] & flag) == 0) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return false;
            }
            return true;
        }
        this.fCurrentChunk = saveChunk;
        this.fCurrentIndex = saveIndex;
        this.fCurrentOffset = saveOffset;
        this.fMostRecentData = saveChunk.toByteArray();
        this.fMostRecentByte = b0;
        return false;
    }

    public void skipPastName(char fastcheck) throws Exception {
        int b0 = this.fMostRecentByte;
        if (b0 < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[b0] == 0) {
                return;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if (!this.skippedMultiByteCharWithFlag(b0, 2)) {
                return;
            }
        }
        while (true) {
            ++this.fCharacterCounter;
            b0 = this.loadNextByte();
            if (fastcheck == b0) {
                return;
            }
            if (b0 < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[b0] != 0) continue;
                return;
            }
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if (!this.skippedMultiByteCharWithFlag(b0, 4)) break;
        }
    }

    public void skipPastNmtoken(char fastcheck) throws Exception {
        int b0 = this.fMostRecentByte;
        while (fastcheck != b0) {
            if (b0 < 128 ? XMLCharacterProperties.fgAsciiNameChar[b0] == 0 : !this.skippedMultiByteCharWithFlag(b0, 4)) {
                return;
            }
            ++this.fCharacterCounter;
            b0 = this.loadNextByte();
        }
        return;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean skippedString(char[] s) throws Exception {
        block7: {
            length = s.length;
            data = this.fMostRecentData;
            index = this.fCurrentIndex + length;
            sindex = length;
            try {
                do {
                    if (sindex-- > 0) continue;
                    this.fCurrentIndex += length;
                    break block7;
                } while (data[--index] == s[sindex]);
                return false;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                i = 0;
                index = this.fCurrentIndex;
                ** while (index < 16384)
            }
lbl-1000:
            // 1 sources

            {
                if (data[index++] == s[i++]) continue;
                return false;
            }
lbl18:
            // 1 sources

            dataChunk = this.fCurrentChunk;
            savedOffset = this.fCurrentOffset;
            savedIndex = this.fCurrentIndex;
            this.slowLoadNextByte();
            data = this.fMostRecentData;
            index = 0;
            while (i < length) {
                if (data[index++] == s[i++]) continue;
                this.fCurrentChunk = dataChunk;
                this.fCurrentIndex = savedIndex;
                this.fCurrentOffset = savedOffset;
                this.fMostRecentData = this.fCurrentChunk.toByteArray();
                this.fMostRecentByte = this.fMostRecentData[savedIndex] & 255;
                return false;
            }
            this.fCurrentIndex = index;
        }
        this.fCharacterCounter += length;
        this.fCurrentOffset += length;
        try {
            this.fMostRecentByte = data[this.fCurrentIndex] & 255;
            return true;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.slowLoadNextByte();
        }
        return true;
    }

    public int scanInvalidChar() throws Exception {
        int b0 = this.fMostRecentByte;
        int ch = b0;
        if (ch == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (ch == 13) {
            ++this.fCarriageReturnCounter;
            this.fCharacterCounter = 1;
            ch = this.loadNextByte();
            if (ch != 10) {
                return 10;
            }
            ++this.fLinefeedCounter;
        } else if (ch == 0) {
            if (this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().scanInvalidChar();
            }
            ++this.fCharacterCounter;
        } else if (b0 >= 128) {
            ++this.fCharacterCounter;
            int b1 = this.loadNextByte();
            int b2 = 0;
            if ((0xE0 & b0) == 192) {
                ch = ((0x1F & b0) << 6) + (0x3F & b1);
            } else if ((0xF0 & b0) == 224) {
                b2 = this.loadNextByte();
                ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
            } else if ((0xF8 & b0) == 240) {
                b2 = this.loadNextByte();
                int b3 = this.loadNextByte();
                ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3);
            }
        }
        this.loadNextByte();
        return ch;
    }

    public int scanCharRef(boolean hex) throws Exception {
        int ch = this.fMostRecentByte;
        if (ch == 0) {
            if (this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().scanCharRef(hex);
            }
            return -2;
        }
        int num = 0;
        if (hex) {
            if (ch > 102 || XMLCharacterProperties.fgAsciiXDigitChar[ch] == 0) {
                return -2;
            }
            num = ch - (ch < 65 ? 48 : (ch < 97 ? 65 : 97) - 10);
        } else {
            if (ch < 48 || ch > 57) {
                return -2;
            }
            num = ch - 48;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        boolean toobig = false;
        while ((ch = this.fMostRecentByte) != 0 && !(hex ? ch > 102 || XMLCharacterProperties.fgAsciiXDigitChar[ch] == 0 : ch < 48 || ch > 57)) {
            int dig;
            ++this.fCharacterCounter;
            this.loadNextByte();
            if (hex) {
                dig = ch - (ch < 65 ? 48 : (ch < 97 ? 65 : 97) - 10);
                num = (num << 4) + dig;
            } else {
                dig = ch - 48;
                num = num * 10 + dig;
            }
            if (num <= 0x10FFFF) continue;
            toobig = true;
            num = 0;
        }
        if (ch != 59) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        if (toobig) {
            return -3;
        }
        return num;
    }

    public int scanStringLiteral() throws Exception {
        boolean single = this.lookingAtChar('\'', true);
        if (!single && !this.lookingAtChar('\"', true)) {
            return -1;
        }
        int offset = this.fCurrentOffset;
        char qchar = single ? (char)'\'' : '\"';
        while (!this.lookingAtChar(qchar, false)) {
            if (this.lookingAtValidChar(true)) continue;
            return -2;
        }
        int stringIndex = this.fCurrentChunk.addString(offset, this.fCurrentOffset - offset);
        this.lookingAtChar(qchar, true);
        return stringIndex;
    }

    public int scanAttValue(char qchar, boolean asSymbol) throws Exception {
        int offset = this.fCurrentOffset;
        int b0 = this.fMostRecentByte;
        block11: while (true) {
            if (b0 < 128) {
                switch (fgAsciiAttValueChar[b0]) {
                    case 1: {
                        if (b0 == qchar) {
                            int length = this.fCurrentOffset - offset;
                            int result = length == 0 ? 0 : (asSymbol ? this.fCurrentChunk.addSymbol(offset, length, 0) : this.fCurrentChunk.addString(offset, length));
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {
                                this.slowLoadNextByte();
                            }
                            return result;
                        }
                    }
                    case 0: {
                        ++this.fCharacterCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            b0 = this.slowLoadNextByte();
                        }
                        continue block11;
                    }
                    case 2: {
                        return -1;
                    }
                    case 3: {
                        return -2;
                    }
                    case 4: {
                        return -3;
                    }
                }
                continue;
            }
            if (!this.skipMultiByteCharData(b0)) {
                return -3;
            }
            b0 = this.fMostRecentByte;
        }
    }

    public int scanEntityValue(int qchar, boolean createString) throws Exception {
        int offset = this.fCurrentOffset;
        int b0 = this.fMostRecentByte;
        block20: while (true) {
            if (b0 < 128) {
                switch (fgAsciiEntityValueChar[b0]) {
                    case 1: {
                        if (b0 == qchar) {
                            if (!createString) {
                                return -1;
                            }
                            int length = this.fCurrentOffset - offset;
                            int result = length == 0 ? 0 : this.fCurrentChunk.addString(offset, length);
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {
                                this.slowLoadNextByte();
                            }
                            return result;
                        }
                    }
                    case 0: {
                        ++this.fCharacterCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            b0 = this.slowLoadNextByte();
                        }
                        continue block20;
                    }
                    case 5: {
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            b0 = this.slowLoadNextByte();
                        }
                        continue block20;
                    }
                    case 6: {
                        ++this.fCarriageReturnCounter;
                        this.fCharacterCounter = 1;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            b0 = this.slowLoadNextByte();
                        }
                        if (b0 != 10) continue block20;
                        ++this.fLinefeedCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            b0 = this.slowLoadNextByte();
                        }
                        continue block20;
                    }
                    case 2: {
                        return -2;
                    }
                    case 3: {
                        return -3;
                    }
                    case 7: {
                        if (this.atEOF(this.fCurrentOffset + 1)) {
                            this.changeReaders();
                            return -5;
                        }
                    }
                    case 4: {
                        return -4;
                    }
                }
                continue;
            }
            if (!this.skipMultiByteCharData(b0)) {
                return -4;
            }
            b0 = this.fMostRecentByte;
        }
    }

    public boolean scanExpectedName(char fastcheck, StringPool.CharArrayRange expectedName) throws Exception {
        char[] expected = expectedName.chars;
        int offset = expectedName.offset;
        int len = expectedName.length;
        int b0 = this.fMostRecentByte;
        int ch = 0;
        int i = 0;
        while (true) {
            if (b0 < 128) {
                ch = b0;
                if (i == len) break;
                if (ch != expected[offset]) {
                    this.skipPastNmtoken(fastcheck);
                    return false;
                }
            } else {
                int b1;
                UTF8DataChunk saveChunk = this.fCurrentChunk;
                int saveIndex = this.fCurrentIndex++;
                int saveOffset = this.fCurrentOffset++;
                try {
                    b1 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    b1 = this.slowLoadNextByte();
                }
                if ((0xE0 & b0) == 192) {
                    ch = ((0x1F & b0) << 6) + (0x3F & b1);
                    if (i == len) break;
                    if (ch != expected[offset]) {
                        this.fCurrentChunk = saveChunk;
                        this.fCurrentIndex = saveIndex;
                        this.fCurrentOffset = saveOffset;
                        this.fMostRecentData = saveChunk.toByteArray();
                        this.fMostRecentByte = b0;
                        this.skipPastNmtoken(fastcheck);
                        return false;
                    }
                } else {
                    int b2;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        b2 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        b2 = this.slowLoadNextByte();
                    }
                    if ((0xF0 & b0) == 224) {
                        if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                            this.fCurrentChunk = saveChunk;
                            this.fCurrentIndex = saveIndex;
                            this.fCurrentOffset = saveOffset;
                            this.fMostRecentData = saveChunk.toByteArray();
                            this.fMostRecentByte = b0;
                            return false;
                        }
                        ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                        if (i == len) break;
                        if (ch != expected[offset]) {
                            this.fCurrentChunk = saveChunk;
                            this.fCurrentIndex = saveIndex;
                            this.fCurrentOffset = saveOffset;
                            this.fMostRecentData = saveChunk.toByteArray();
                            this.fMostRecentByte = b0;
                            this.skipPastNmtoken(fastcheck);
                            return false;
                        }
                    } else {
                        this.fCurrentChunk = saveChunk;
                        this.fCurrentIndex = saveIndex;
                        this.fCurrentOffset = saveOffset;
                        this.fMostRecentData = saveChunk.toByteArray();
                        this.fMostRecentByte = b0;
                        return false;
                    }
                }
            }
            ++i;
            ++offset;
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                b0 = this.slowLoadNextByte();
            }
        }
        if (ch == fastcheck) {
            return true;
        }
        if (ch < 128) {
            if (XMLCharacterProperties.fgAsciiNameChar[ch] == 0) {
                return true;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) {
                return true;
            }
        }
        this.skipPastNmtoken(fastcheck);
        return false;
    }

    public void scanQName(char fastcheck, QName qname) throws Exception {
        int offset = this.fCurrentOffset;
        int ch = this.fMostRecentByte;
        if (ch < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[ch] == 0) {
                qname.clear();
                return;
            }
            if (ch == 58) {
                qname.clear();
                return;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            ch = this.getMultiByteSymbolChar(ch);
            --this.fCurrentIndex;
            --this.fCurrentOffset;
            if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                qname.clear();
                return;
            }
        }
        int index = this.fCurrentIndex;
        byte[] data = this.fMostRecentData;
        int prefixend = -1;
        while (true) {
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            ++index;
            try {
                ch = data[index] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ch = this.slowLoadNextByte();
                index = 0;
                data = this.fMostRecentData;
            }
            if (fastcheck == ch) break;
            if (ch < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[ch] == 0) break;
                if (ch != 58) continue;
                if (prefixend != -1) break;
                prefixend = this.fCurrentOffset;
                try {
                    ch = data[index + 1] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    UTF8DataChunk savedChunk = this.fCurrentChunk;
                    int savedOffset = this.fCurrentOffset;
                    ch = this.slowLoadNextByte();
                    this.fCurrentChunk = savedChunk;
                    this.fCurrentOffset = savedOffset;
                    this.fMostRecentData = this.fCurrentChunk.toByteArray();
                }
                boolean lpok = true;
                if (ch < 128) {
                    if (XMLCharacterProperties.fgAsciiInitialNameChar[ch] == 0 || ch == 58) {
                        lpok = false;
                    }
                } else {
                    if (!this.fCalledCharPropInit) {
                        XMLCharacterProperties.initCharFlags();
                        this.fCalledCharPropInit = true;
                    }
                    if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                        lpok = false;
                    }
                }
                ch = 58;
                if (lpok) continue;
                prefixend = -1;
                break;
            }
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            this.fCurrentIndex = index;
            this.fMostRecentByte = ch;
            ch = this.getMultiByteSymbolChar(ch);
            --this.fCurrentIndex;
            --this.fCurrentOffset;
            index = this.fCurrentIndex;
            if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) break;
        }
        this.fCurrentIndex = index;
        this.fMostRecentByte = ch;
        int length = this.fCurrentOffset - offset;
        qname.rawname = this.addSymbol(offset, length);
        qname.prefix = prefixend == -1 ? -1 : this.addSymbol(offset, prefixend - offset);
        qname.localpart = prefixend == -1 ? qname.rawname : this.addSymbol(prefixend + 1, this.fCurrentOffset - (prefixend + 1));
        qname.uri = 0;
    }

    private int getMultiByteSymbolChar(int b0) throws Exception {
        int b2;
        int b1;
        UTF8DataChunk saveChunk = this.fCurrentChunk;
        int saveIndex = this.fCurrentIndex;
        int saveOffset = this.fCurrentOffset;
        if (!this.fCalledCharPropInit) {
            XMLCharacterProperties.initCharFlags();
            this.fCalledCharPropInit = true;
        }
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            b1 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            b1 = this.slowLoadNextByte();
        }
        if ((0xE0 & b0) == 192) {
            int ch = ((0x1F & b0) << 6) + (0x3F & b1);
            if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return -1;
            }
            this.loadNextByte();
            return ch;
        }
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            b2 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            b2 = this.slowLoadNextByte();
        }
        if ((0xF0 & b0) == 224) {
            if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return -1;
            }
            int ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
            if ((XMLCharacterProperties.fgCharFlags[ch] & 4) == 0) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return -1;
            }
            this.loadNextByte();
            return ch;
        }
        this.fCurrentChunk = saveChunk;
        this.fCurrentIndex = saveIndex;
        this.fCurrentOffset = saveOffset;
        this.fMostRecentData = saveChunk.toByteArray();
        this.fMostRecentByte = b0;
        return -1;
    }

    public int scanName(char fastcheck) throws Exception {
        int ch;
        int b0 = this.fMostRecentByte;
        if (b0 < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[b0] == 0) {
                if (b0 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                    return this.changeReaders().scanName(fastcheck);
                }
                return -1;
            }
            ch = b0;
        } else {
            int b1;
            UTF8DataChunk saveChunk = this.fCurrentChunk;
            int saveIndex = this.fCurrentIndex;
            int saveOffset = this.fCurrentOffset;
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                b1 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                b1 = this.slowLoadNextByte();
            }
            if ((0xE0 & b0) == 192) {
                ch = ((0x1F & b0) << 6) + (0x3F & b1);
                if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                    this.fCurrentChunk = saveChunk;
                    this.fCurrentIndex = saveIndex;
                    this.fCurrentOffset = saveOffset;
                    this.fMostRecentData = saveChunk.toByteArray();
                    this.fMostRecentByte = b0;
                    return -1;
                }
            } else {
                int b2;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    b2 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    b2 = this.slowLoadNextByte();
                }
                if ((0xF0 & b0) == 224) {
                    if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                        this.fCurrentChunk = saveChunk;
                        this.fCurrentIndex = saveIndex;
                        this.fCurrentOffset = saveOffset;
                        this.fMostRecentData = saveChunk.toByteArray();
                        this.fMostRecentByte = b0;
                        return -1;
                    }
                    ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                    if ((XMLCharacterProperties.fgCharFlags[ch] & 2) == 0) {
                        this.fCurrentChunk = saveChunk;
                        this.fCurrentIndex = saveIndex;
                        this.fCurrentOffset = saveOffset;
                        this.fMostRecentData = saveChunk.toByteArray();
                        this.fMostRecentByte = b0;
                        return -1;
                    }
                } else {
                    this.fCurrentChunk = saveChunk;
                    this.fCurrentIndex = saveIndex;
                    this.fCurrentOffset = saveOffset;
                    this.fMostRecentData = saveChunk.toByteArray();
                    this.fMostRecentByte = b0;
                    return -1;
                }
            }
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            b0 = this.slowLoadNextByte();
        }
        return this.scanMatchingName(ch, b0, fastcheck);
    }

    private int scanMatchingName(int ch, int b0, int fastcheck) throws Exception {
        SymbolCache cache = this.fStringPool.getSymbolCache();
        Object cacheLines = cache.fCacheLines;
        char[] symbolChars = cache.fSymbolChars;
        boolean lengthOfOne = fastcheck == this.fMostRecentByte;
        int startOffset = cache.fSymbolCharsOffset;
        int entry = 0;
        int[] entries = cacheLines[entry];
        int offset = 1 + (entries[0] - 1) * 3;
        int totalMisses = 0;
        if (lengthOfOne) {
            while (offset > 0) {
                if (entries[offset + 0] == ch) {
                    if (entries[offset + 1] == -1) break;
                    int symbolIndex = entries[offset + 1];
                    if (totalMisses > 3) {
                        this.fStringPool.updateCacheLine(symbolIndex, totalMisses, 1);
                    }
                    return symbolIndex;
                }
                offset -= 3;
                ++totalMisses;
            }
            try {
                symbolChars[cache.fSymbolCharsOffset] = (char)ch;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                symbolChars = new char[cache.fSymbolCharsOffset * 2];
                System.arraycopy(cache.fSymbolChars, 0, symbolChars, 0, cache.fSymbolCharsOffset);
                cache.fSymbolChars = symbolChars;
                symbolChars[cache.fSymbolCharsOffset] = (char)ch;
            }
            ++cache.fSymbolCharsOffset;
            if (offset < 0) {
                offset = 1 + entries[0] * 3;
                entries[0] = entries[0] + 1;
                try {
                    entries[offset + 0] = ch;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    int newSize = 1 + (offset - 1) * 2;
                    entries = new int[newSize];
                    System.arraycopy(cacheLines[entry], 0, entries, 0, offset);
                    cacheLines[entry] = entries;
                    entries[offset + 0] = ch;
                }
                entries[offset + 2] = -1;
            }
            int result = this.fStringPool.createNonMatchingSymbol(startOffset, entry, entries, offset);
            return result;
        }
        try {
            symbolChars[cache.fSymbolCharsOffset] = (char)ch;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            symbolChars = new char[cache.fSymbolCharsOffset * 2];
            System.arraycopy(cache.fSymbolChars, 0, symbolChars, 0, cache.fSymbolCharsOffset);
            cache.fSymbolChars = symbolChars;
            symbolChars[cache.fSymbolCharsOffset] = (char)ch;
        }
        ++cache.fSymbolCharsOffset;
        int depth = 1;
        while (offset >= 0) {
            if (entries[offset + 0] != ch) {
                offset -= 3;
                ++totalMisses;
                continue;
            }
            if (b0 >= 128) {
                ch = this.getMultiByteSymbolChar(b0);
                b0 = this.fMostRecentByte;
            } else if (b0 == fastcheck || XMLCharacterProperties.fgAsciiNameChar[b0] == 0) {
                ch = -1;
            } else {
                ch = b0;
                ++this.fCharacterCounter;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    b0 = this.slowLoadNextByte();
                }
            }
            if (ch == -1) {
                if (entries[offset + 1] == -1) {
                    return this.fStringPool.createNonMatchingSymbol(startOffset, entry, entries, offset);
                }
                cache.fSymbolCharsOffset = startOffset;
                int symbolIndex = entries[offset + 1];
                if (totalMisses > depth * 3) {
                    this.fStringPool.updateCacheLine(symbolIndex, totalMisses, depth);
                }
                return symbolIndex;
            }
            try {
                symbolChars[cache.fSymbolCharsOffset] = (char)ch;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                symbolChars = new char[cache.fSymbolCharsOffset * 2];
                System.arraycopy(cache.fSymbolChars, 0, symbolChars, 0, cache.fSymbolCharsOffset);
                cache.fSymbolChars = symbolChars;
                symbolChars[cache.fSymbolCharsOffset] = (char)ch;
            }
            ++cache.fSymbolCharsOffset;
            entry = entries[offset + 2];
            try {
                entries = cacheLines[entry];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                if (entry == -1) {
                    entries[offset + 2] = entry = cache.fCacheLineCount++;
                    entries = new int[13];
                    try {
                        cacheLines[entry] = entries;
                    }
                    catch (ArrayIndexOutOfBoundsException ex2) {
                        cacheLines = new int[entry * 2][];
                        System.arraycopy(cache.fCacheLines, 0, cacheLines, 0, entry);
                        cache.fCacheLines = cacheLines;
                        cacheLines[entry] = entries;
                    }
                }
                entries = cacheLines[entry];
                throw new RuntimeException("RDR001 untested");
            }
            offset = 1 + (entries[0] - 1) * 3;
            ++depth;
        }
        if (offset < 0) {
            offset = 1 + entries[0] * 3;
        }
        while (true) {
            entries[0] = entries[0] + 1;
            try {
                entries[offset + 0] = ch;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                int newSize = 1 + (offset - 1) * 2;
                entries = new int[newSize];
                System.arraycopy(cacheLines[entry], 0, entries, 0, offset);
                cacheLines[entry] = entries;
                entries[offset + 0] = ch;
            }
            if (b0 >= 128) {
                ch = this.getMultiByteSymbolChar(b0);
                b0 = this.fMostRecentByte;
            } else if (b0 == fastcheck || XMLCharacterProperties.fgAsciiNameChar[b0] == 0) {
                ch = -1;
            } else {
                ch = b0;
                ++this.fCharacterCounter;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    b0 = this.slowLoadNextByte();
                }
            }
            if (ch == -1) break;
            ++cache.fCacheLineCount;
            entries[offset + 1] = -1;
            entries[offset + 2] = entry;
            entries = new int[13];
            try {
                cacheLines[entry] = entries;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                cacheLines = new int[entry * 2][];
                System.arraycopy(cache.fCacheLines, 0, cacheLines, 0, entry);
                cache.fCacheLines = cacheLines;
                cacheLines[entry] = entries;
            }
            offset = 1;
            try {
                symbolChars[cache.fSymbolCharsOffset] = (char)ch;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                symbolChars = new char[cache.fSymbolCharsOffset * 2];
                System.arraycopy(cache.fSymbolChars, 0, symbolChars, 0, cache.fSymbolCharsOffset);
                cache.fSymbolChars = symbolChars;
                symbolChars[cache.fSymbolCharsOffset] = (char)ch;
            }
            ++cache.fSymbolCharsOffset;
        }
        entries[offset + 2] = -1;
        int result = this.fStringPool.createNonMatchingSymbol(startOffset, entry, entries, offset);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int recognizeMarkup(int b0, QName element) throws Exception {
        switch (b0) {
            case 0: {
                return 11;
            }
            case 63: {
                ++this.fCharacterCounter;
                this.loadNextByte();
                return 0;
            }
            case 33: {
                ++this.fCharacterCounter;
                b0 = this.loadNextByte();
                if (b0 == 0) {
                    --this.fCharacterCounter;
                    --this.fCurrentOffset;
                    return 11;
                }
                if (b0 == 45) {
                    ++this.fCharacterCounter;
                    b0 = this.loadNextByte();
                    if (b0 == 0) {
                        this.fCharacterCounter -= 2;
                        this.fCurrentOffset -= 2;
                        return 11;
                    }
                    if (b0 != 45) return 10;
                    ++this.fCharacterCounter;
                    b0 = this.loadNextByte();
                    return 1;
                }
                if (b0 != 91) return 10;
                int i = 0;
                while (true) {
                    if (i >= 6) {
                        ++this.fCharacterCounter;
                        this.loadNextByte();
                        return 2;
                    }
                    ++this.fCharacterCounter;
                    b0 = this.loadNextByte();
                    if (b0 == 0) {
                        this.fCharacterCounter -= 2 + i;
                        this.fCurrentOffset -= 2 + i;
                        return 11;
                    }
                    if (b0 != cdata_string[i]) {
                        return 10;
                    }
                    ++i;
                }
            }
            case 47: {
                ++this.fCharacterCounter;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    b0 = this.slowLoadNextByte();
                }
                int expectedName = element.rawname;
                this.fStringPool.getCharArrayRange(expectedName, this.fCharArrayRange);
                char[] expected = this.fCharArrayRange.chars;
                int offset = this.fCharArrayRange.offset;
                int len = this.fCharArrayRange.length;
                if (b0 != expected[offset++]) return 4;
                UTF8DataChunk savedChunk = this.fCurrentChunk;
                int savedIndex = this.fCurrentIndex;
                int savedOffset = this.fCurrentOffset;
                int i = 1;
                while (true) {
                    if (i >= len) {
                        this.fCharacterCounter += len;
                        ++this.fCharacterCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            b0 = this.slowLoadNextByte();
                        }
                        break;
                    }
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        b0 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        b0 = this.slowLoadNextByte();
                    }
                    if (b0 != expected[offset++]) {
                        this.fCurrentChunk = savedChunk;
                        this.fCurrentIndex = savedIndex;
                        this.fCurrentOffset = savedOffset;
                        this.fMostRecentData = this.fCurrentChunk.toByteArray();
                        this.fMostRecentByte = this.fMostRecentData[savedIndex] & 0xFF;
                        return 4;
                    }
                    ++i;
                }
                if (b0 == 62) {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        return 5;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        this.slowLoadNextByte();
                    }
                    return 5;
                }
                do {
                    if (b0 != 32 && b0 != 9 && b0 != 10 && b0 != 13) {
                        this.fCurrentChunk = savedChunk;
                        this.fCurrentIndex = savedIndex;
                        this.fCurrentOffset = savedOffset;
                        this.fMostRecentData = this.fCurrentChunk.toByteArray();
                        this.fMostRecentByte = this.fMostRecentData[savedIndex] & 0xFF;
                        return 4;
                    }
                    if (b0 == 10) {
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                        b0 = this.loadNextByte();
                        continue;
                    }
                    if (b0 == 13) {
                        ++this.fCarriageReturnCounter;
                        this.fCharacterCounter = 1;
                        b0 = this.loadNextByte();
                        if (b0 != 10) continue;
                        ++this.fLinefeedCounter;
                        b0 = this.loadNextByte();
                        continue;
                    }
                    ++this.fCharacterCounter;
                    b0 = this.loadNextByte();
                } while (b0 != 62);
                ++this.fCharacterCounter;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    return 5;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    this.slowLoadNextByte();
                }
                return 5;
            }
        }
        return 6;
    }

    private int recognizeReference(int ch) throws Exception {
        if (ch == 0) {
            return 12;
        }
        if (ch == 35) {
            ++this.fCharacterCounter;
            this.loadNextByte();
            return 7;
        }
        return 8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int scanContent(QName element) throws Exception {
        int saveOffset;
        int saveIndex;
        int ch;
        int charDataOffset;
        block98: {
            block97: {
                block96: {
                    if (this.fCallClearPreviousChunk && this.fCurrentChunk.clearPreviousChunk()) {
                        this.fCallClearPreviousChunk = false;
                    }
                    this.fCharDataLength = 0;
                    charDataOffset = this.fCurrentOffset++;
                    ch = this.fMostRecentByte;
                    if (ch >= 128) break block96;
                    switch (XMLCharacterProperties.fgAsciiWSCharData[ch]) {
                        case 0: {
                            if (this.fSendCharDataAsCharArray) {
                                try {
                                    this.fCharacters[this.fCharDataLength] = (char)ch;
                                    ++this.fCharDataLength;
                                }
                                catch (ArrayIndexOutOfBoundsException ex) {
                                    this.slowAppendCharData(ch);
                                }
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                ch = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {
                                ch = this.slowLoadNextByte();
                            }
                            break;
                        }
                        case 1: {
                            ++this.fCharacterCounter;
                            ++this.fCurrentIndex;
                            try {
                                ch = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {
                                ch = this.slowLoadNextByte();
                            }
                            if (!this.fInCDSect) {
                                return this.recognizeMarkup(ch, element);
                            }
                            if (!this.fSendCharDataAsCharArray) break;
                            this.appendCharData(60);
                            break;
                        }
                        case 2: {
                            ++this.fCharacterCounter;
                            ch = this.loadNextByte();
                            if (!this.fInCDSect) {
                                return this.recognizeReference(ch);
                            }
                            if (!this.fSendCharDataAsCharArray) break;
                            this.appendCharData(38);
                            break;
                        }
                        case 3: {
                            ++this.fCharacterCounter;
                            ch = this.loadNextByte();
                            if (ch != 93) {
                                if (!this.fSendCharDataAsCharArray) break;
                                this.appendCharData(93);
                                break;
                            }
                            if (this.fCurrentIndex + 1 == 16384) {
                                UTF8DataChunk saveChunk = this.fCurrentChunk;
                                int saveIndex2 = this.fCurrentIndex;
                                int saveOffset2 = this.fCurrentOffset;
                                if (this.loadNextByte() != 62) {
                                    this.fCurrentChunk = saveChunk;
                                    this.fCurrentIndex = saveIndex2;
                                    this.fCurrentOffset = saveOffset2;
                                    this.fMostRecentData = this.fCurrentChunk.toByteArray();
                                    this.fMostRecentByte = 93;
                                    if (!this.fSendCharDataAsCharArray) break;
                                    this.appendCharData(93);
                                    break;
                                }
                            } else {
                                if (this.fMostRecentData[this.fCurrentIndex + 1] != 62) {
                                    if (!this.fSendCharDataAsCharArray) break;
                                    this.appendCharData(93);
                                    break;
                                }
                                ++this.fCurrentIndex;
                                ++this.fCurrentOffset;
                            }
                            this.loadNextByte();
                            this.fCharacterCounter += 2;
                            return 3;
                        }
                        case 4: {
                            if (ch != 0) return 9;
                            if (!this.atEOF(this.fCurrentOffset + 1)) return 9;
                            this.changeReaders();
                            return 9;
                        }
                        case 5: {
                            break block97;
                        }
                    }
                    break block98;
                }
                if (this.fSendCharDataAsCharArray ? !this.copyMultiByteCharData(ch) : !this.skipMultiByteCharData(ch)) {
                    return 9;
                }
                break block98;
            }
            do {
                if (ch == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else if (ch == 13) {
                    ++this.fCarriageReturnCounter;
                    this.fCharacterCounter = 1;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        ch = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        ch = this.slowLoadNextByte();
                    }
                    if (ch != 10) {
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(10);
                        }
                        if (ch != 32 && ch != 9 && ch != 13) break;
                        continue;
                    }
                    ++this.fLinefeedCounter;
                } else {
                    ++this.fCharacterCounter;
                }
                if (this.fSendCharDataAsCharArray) {
                    try {
                        this.fCharacters[this.fCharDataLength] = (char)ch;
                        ++this.fCharDataLength;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        this.slowAppendCharData(ch);
                    }
                }
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    ch = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ch = this.slowLoadNextByte();
                }
            } while (ch == 32 || ch == 9 || ch == 10 || ch == 13);
            if (ch < 128) {
                switch (XMLCharacterProperties.fgAsciiCharData[ch]) {
                    case 0: {
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(ch);
                        }
                        ++this.fCharacterCounter;
                        ch = this.loadNextByte();
                        break;
                    }
                    case 1: {
                        if (!this.fInCDSect) {
                            if (this.fSendCharDataAsCharArray) {
                                this.fCharDataHandler.processWhitespace(this.fCharacters, 0, this.fCharDataLength);
                            } else {
                                int stringIndex = this.addString(charDataOffset, this.fCurrentOffset - charDataOffset);
                                this.fCharDataHandler.processWhitespace(stringIndex);
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                ch = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                                return this.recognizeMarkup(ch, element);
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {
                                ch = this.slowLoadNextByte();
                            }
                            return this.recognizeMarkup(ch, element);
                        }
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(60);
                        }
                        ++this.fCharacterCounter;
                        ch = this.loadNextByte();
                        break;
                    }
                    case 2: {
                        if (!this.fInCDSect) {
                            this.whitespace(charDataOffset, this.fCurrentOffset);
                            ++this.fCharacterCounter;
                            ch = this.loadNextByte();
                            return this.recognizeReference(ch);
                        }
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(38);
                        }
                        ++this.fCharacterCounter;
                        ch = this.loadNextByte();
                        break;
                    }
                    case 3: {
                        int endOffset = this.fCurrentOffset++;
                        ch = this.loadNextByte();
                        if (ch != 93) {
                            ++this.fCharacterCounter;
                            if (!this.fSendCharDataAsCharArray) break;
                            this.appendCharData(93);
                            break;
                        }
                        if (this.fCurrentIndex + 1 == 16384) {
                            UTF8DataChunk saveChunk = this.fCurrentChunk;
                            saveIndex = this.fCurrentIndex;
                            saveOffset = this.fCurrentOffset;
                            if (this.loadNextByte() != 62) {
                                this.fCurrentChunk = saveChunk;
                                this.fCurrentIndex = saveIndex;
                                this.fCurrentOffset = saveOffset;
                                this.fMostRecentData = this.fCurrentChunk.toByteArray();
                                this.fMostRecentByte = 93;
                                ++this.fCharacterCounter;
                                if (!this.fSendCharDataAsCharArray) break;
                                this.appendCharData(93);
                                break;
                            }
                        } else {
                            if (this.fMostRecentData[this.fCurrentIndex + 1] != 62) {
                                ++this.fCharacterCounter;
                                if (!this.fSendCharDataAsCharArray) break;
                                this.appendCharData(93);
                                break;
                            }
                            ++this.fCurrentIndex;
                        }
                        this.loadNextByte();
                        this.whitespace(charDataOffset, endOffset);
                        this.fCharacterCounter += 3;
                        return 3;
                    }
                    case 4: {
                        this.whitespace(charDataOffset, this.fCurrentOffset);
                        if (ch != 0) return 9;
                        if (!this.atEOF(this.fCurrentOffset + 1)) return 9;
                        this.changeReaders();
                        return 9;
                    }
                }
            } else if (this.fSendCharDataAsCharArray) {
                if (!this.copyMultiByteCharData(ch)) {
                    this.whitespace(charDataOffset, this.fCurrentOffset);
                    return 9;
                }
            } else if (!this.skipMultiByteCharData(ch)) {
                this.whitespace(charDataOffset, this.fCurrentOffset);
                return 9;
            }
        }
        ch = this.fSendCharDataAsCharArray ? this.copyAsciiCharData() : this.skipAsciiCharData();
        block39: while (true) {
            if (ch < 128) {
                switch (XMLCharacterProperties.fgAsciiCharData[ch]) {
                    case 0: {
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(ch);
                        }
                        ++this.fCharacterCounter;
                        ch = this.loadNextByte();
                        continue block39;
                    }
                    case 1: {
                        if (!this.fInCDSect) {
                            if (this.fSendCharDataAsCharArray) {
                                this.fCharDataHandler.processCharacters(this.fCharacters, 0, this.fCharDataLength);
                            } else {
                                int stringIndex = this.addString(charDataOffset, this.fCurrentOffset - charDataOffset);
                                this.fCharDataHandler.processCharacters(stringIndex);
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                ch = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                                return this.recognizeMarkup(ch, element);
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {
                                ch = this.slowLoadNextByte();
                            }
                            return this.recognizeMarkup(ch, element);
                        }
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(60);
                        }
                        ++this.fCharacterCounter;
                        ch = this.loadNextByte();
                        continue block39;
                    }
                    case 2: {
                        if (!this.fInCDSect) {
                            this.characters(charDataOffset, this.fCurrentOffset);
                            ++this.fCharacterCounter;
                            ch = this.loadNextByte();
                            return this.recognizeReference(ch);
                        }
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(38);
                        }
                        ++this.fCharacterCounter;
                        ch = this.loadNextByte();
                        continue block39;
                    }
                    case 3: {
                        int endOffset = this.fCurrentOffset++;
                        ch = this.loadNextByte();
                        if (ch != 93) {
                            ++this.fCharacterCounter;
                            if (!this.fSendCharDataAsCharArray) continue block39;
                            this.appendCharData(93);
                            continue block39;
                        }
                        if (this.fCurrentIndex + 1 == 16384) {
                            UTF8DataChunk saveChunk = this.fCurrentChunk;
                            saveIndex = this.fCurrentIndex;
                            saveOffset = this.fCurrentOffset;
                            if (this.loadNextByte() != 62) {
                                this.fCurrentChunk = saveChunk;
                                this.fCurrentIndex = saveIndex;
                                this.fCurrentOffset = saveOffset;
                                this.fMostRecentData = this.fCurrentChunk.toByteArray();
                                this.fMostRecentByte = 93;
                                ++this.fCharacterCounter;
                                if (!this.fSendCharDataAsCharArray) continue block39;
                                this.appendCharData(93);
                                continue block39;
                            }
                        } else {
                            if (this.fMostRecentData[this.fCurrentIndex + 1] != 62) {
                                ++this.fCharacterCounter;
                                if (!this.fSendCharDataAsCharArray) continue block39;
                                this.appendCharData(93);
                                continue block39;
                            }
                            ++this.fCurrentIndex;
                        }
                        this.loadNextByte();
                        this.characters(charDataOffset, endOffset);
                        this.fCharacterCounter += 3;
                        return 3;
                    }
                    case 4: {
                        if (ch == 10) {
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(ch);
                            }
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                            ch = this.loadNextByte();
                            continue block39;
                        }
                        if (ch != 13) {
                            this.characters(charDataOffset, this.fCurrentOffset);
                            if (ch != 0) return 9;
                            if (!this.atEOF(this.fCurrentOffset + 1)) return 9;
                            this.changeReaders();
                            return 9;
                        }
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(10);
                        }
                        ++this.fCarriageReturnCounter;
                        this.fCharacterCounter = 1;
                        ch = this.loadNextByte();
                        if (ch != 10) continue block39;
                        ++this.fLinefeedCounter;
                        ch = this.loadNextByte();
                        continue block39;
                    }
                }
                continue;
            }
            if (this.fSendCharDataAsCharArray) {
                if (!this.copyMultiByteCharData(ch)) {
                    this.characters(charDataOffset, this.fCurrentOffset);
                    return 9;
                }
            } else if (!this.skipMultiByteCharData(ch)) {
                this.characters(charDataOffset, this.fCurrentOffset);
                return 9;
            }
            ch = this.fMostRecentByte;
        }
    }

    private boolean copyMultiByteCharData(int b0) throws Exception {
        UTF8DataChunk saveChunk = this.fCurrentChunk;
        int saveOffset = this.fCurrentOffset;
        int saveIndex = this.fCurrentIndex;
        int b1 = this.loadNextByte();
        if ((0xE0 & b0) == 192) {
            int ch = ((0x1F & b0) << 6) + (0x3F & b1);
            this.appendCharData(ch);
            this.loadNextByte();
            return true;
        }
        int b2 = this.loadNextByte();
        if ((0xF0 & b0) == 224) {
            if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return false;
            }
            int ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
            this.appendCharData(ch);
            this.loadNextByte();
            return true;
        }
        int b3 = this.loadNextByte();
        if ((0xF8 & b0) == 240) {
            if (b0 > 244 || b0 == 244 && b1 >= 144) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return false;
            }
            int ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3);
            if (ch < 65536) {
                this.appendCharData(ch);
            } else {
                this.appendCharData((ch - 65536 >> 10) + 55296);
                this.appendCharData((ch - 65536 & 0x3FF) + 56320);
            }
            this.loadNextByte();
            return true;
        }
        this.fCurrentChunk = saveChunk;
        this.fCurrentIndex = saveIndex;
        this.fCurrentOffset = saveOffset;
        this.fMostRecentData = saveChunk.toByteArray();
        this.fMostRecentByte = b0;
        return false;
    }

    private boolean skipMultiByteCharData(int b0) throws Exception {
        UTF8DataChunk saveChunk = this.fCurrentChunk;
        int saveOffset = this.fCurrentOffset;
        int saveIndex = this.fCurrentIndex;
        int b1 = this.loadNextByte();
        if ((0xE0 & b0) == 192) {
            this.loadNextByte();
            return true;
        }
        int b2 = this.loadNextByte();
        if ((0xF0 & b0) == 224) {
            if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return false;
            }
            this.loadNextByte();
            return true;
        }
        int b3 = this.loadNextByte();
        if (b0 > 244 || b0 == 244 && b1 >= 144) {
            this.fCurrentChunk = saveChunk;
            this.fCurrentIndex = saveIndex;
            this.fCurrentOffset = saveOffset;
            this.fMostRecentData = saveChunk.toByteArray();
            this.fMostRecentByte = b0;
            return false;
        }
        this.loadNextByte();
        return true;
    }

    private int copyAsciiCharData() throws Exception {
        int srcIndex = this.fCurrentIndex;
        int offset = this.fCurrentOffset - srcIndex;
        byte[] data = this.fMostRecentData;
        int dstIndex = this.fCharDataLength;
        boolean skiplf = false;
        while (true) {
            int ch;
            try {
                ch = data[srcIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                offset += srcIndex;
                this.slowLoadNextByte();
                srcIndex = 0;
                data = this.fMostRecentData;
                ch = data[srcIndex] & 0xFF;
            }
            if (ch >= 128) {
                this.fCurrentOffset = offset + srcIndex;
                this.fCurrentIndex = srcIndex;
                this.fMostRecentByte = ch;
                return ch;
            }
            if (XMLCharacterProperties.fgAsciiCharData[ch] == 0) {
                ++this.fCharacterCounter;
                skiplf = false;
            } else if (ch == 10) {
                ++this.fLinefeedCounter;
                if (skiplf) {
                    skiplf = false;
                    ++srcIndex;
                    continue;
                }
                this.fCharacterCounter = 1;
            } else if (ch == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                skiplf = true;
                ch = 10;
            } else {
                this.fCurrentOffset = offset + srcIndex;
                this.fCurrentIndex = srcIndex;
                this.fMostRecentByte = ch;
                return ch;
            }
            ++srcIndex;
            try {
                this.fCharacters[this.fCharDataLength] = (char)ch;
                ++this.fCharDataLength;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                this.slowAppendCharData(ch);
                continue;
            }
            break;
        }
    }

    private int skipAsciiCharData() throws Exception {
        int srcIndex = this.fCurrentIndex;
        int offset = this.fCurrentOffset - srcIndex;
        byte[] data = this.fMostRecentData;
        while (true) {
            int ch;
            try {
                ch = data[srcIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                offset += srcIndex;
                this.slowLoadNextByte();
                srcIndex = 0;
                data = this.fMostRecentData;
                ch = data[srcIndex] & 0xFF;
            }
            if (ch >= 128) {
                this.fCurrentOffset = offset + srcIndex;
                this.fCurrentIndex = srcIndex;
                this.fMostRecentByte = ch;
                return ch;
            }
            if (XMLCharacterProperties.fgAsciiCharData[ch] == 0) {
                ++this.fCharacterCounter;
            } else if (ch == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (ch == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
            } else {
                this.fCurrentOffset = offset + srcIndex;
                this.fCurrentIndex = srcIndex;
                this.fMostRecentByte = ch;
                return ch;
            }
            ++srcIndex;
        }
    }

    private void appendCharData(int ch) throws Exception {
        try {
            this.fCharacters[this.fCharDataLength] = (char)ch;
            ++this.fCharDataLength;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.slowAppendCharData(ch);
        }
    }

    private void slowAppendCharData(int ch) throws Exception {
        this.characters(0, this.fCharDataLength);
        this.fCharDataLength = 0;
        this.fCharacters[this.fCharDataLength++] = (char)ch;
    }

    private void characters(int offset, int endOffset) throws Exception {
        if (!this.fSendCharDataAsCharArray) {
            int stringIndex = this.addString(offset, endOffset - offset);
            this.fCharDataHandler.processCharacters(stringIndex);
            return;
        }
        this.fCharDataHandler.processCharacters(this.fCharacters, 0, this.fCharDataLength);
    }

    private void whitespace(int offset, int endOffset) throws Exception {
        if (!this.fSendCharDataAsCharArray) {
            int stringIndex = this.addString(offset, endOffset - offset);
            this.fCharDataHandler.processWhitespace(stringIndex);
            return;
        }
        this.fCharDataHandler.processWhitespace(this.fCharacters, 0, this.fCharDataLength);
    }

    private int fillCurrentChunk() throws Exception {
        byte[] buf = this.fCurrentChunk.toByteArray();
        if (this.fInputStream == null) {
            if (buf == null) {
                buf = new byte[]{0};
            }
            this.fMostRecentData = buf;
            this.fCurrentIndex = 0;
            this.fCurrentChunk.setByteArray(this.fMostRecentData);
            this.fMostRecentByte = this.fMostRecentData[0] & 0xFF;
            return this.fMostRecentByte;
        }
        if (buf == null) {
            buf = new byte[16384];
        }
        int offset = 0;
        int capacity = 16384;
        int result = 0;
        do {
            try {
                result = this.fInputStream.read(buf, offset, capacity);
            }
            catch (IOException ex) {
                result = -1;
            }
            if (result == -1) {
                this.fInputStream.close();
                this.fInputStream = null;
                try {
                    buf[offset] = 0;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                break;
            }
            if (result <= 0) continue;
            offset += result;
            capacity -= result;
        } while (capacity > 0);
        this.fMostRecentData = buf;
        this.fLength += offset;
        this.fCurrentIndex = 0;
        this.fCurrentChunk.setByteArray(this.fMostRecentData);
        this.fMostRecentByte = this.fMostRecentData[0] & 0xFF;
        return this.fMostRecentByte;
    }
}

