/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.util.Stack;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.EBCDICRecognizer;
import org.apache.xerces.readers.UCSRecognizer;
import org.apache.xerces.readers.UTF8Recognizer;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.ChunkyByteArray;
import org.apache.xerces.utils.StringPool;

public abstract class XMLDeclRecognizer {
    private static final char[] xml_string = new char[]{'x', 'm', 'l'};
    private static final char[] version_string = new char[]{'v', 'e', 'r', 's', 'i', 'o', 'n'};
    private static final char[] encoding_string = new char[]{'e', 'n', 'c', 'o', 'd', 'i', 'n', 'g'};

    public static void registerDefaultRecognizers(Stack recognizerStack) {
        recognizerStack.push(new EBCDICRecognizer());
        recognizerStack.push(new UCSRecognizer());
        recognizerStack.push(new UTF8Recognizer());
    }

    public abstract XMLEntityHandler.EntityReader recognize(XMLEntityReaderFactory var1, XMLEntityHandler var2, XMLErrorReporter var3, boolean var4, StringPool var5, ChunkyByteArray var6, boolean var7, boolean var8) throws Exception;

    protected int prescanXMLDeclOrTextDecl(XMLEntityHandler.EntityReader entityReader, boolean xmlDecl) throws Exception {
        if (!entityReader.lookingAtChar('<', true)) {
            return -1;
        }
        if (!entityReader.lookingAtChar('?', true)) {
            return -1;
        }
        if (!entityReader.skippedString(xml_string)) {
            return -1;
        }
        entityReader.skipPastSpaces();
        if (entityReader.skippedString(version_string)) {
            entityReader.skipPastSpaces();
            if (!entityReader.lookingAtChar('=', true)) {
                return -1;
            }
            entityReader.skipPastSpaces();
            int versionIndex = entityReader.scanStringLiteral();
            if (versionIndex < 0) {
                return -1;
            }
            if (!entityReader.lookingAtSpace(true)) {
                return -1;
            }
            entityReader.skipPastSpaces();
        } else if (xmlDecl) {
            return -1;
        }
        if (!entityReader.skippedString(encoding_string)) {
            return -1;
        }
        entityReader.skipPastSpaces();
        if (!entityReader.lookingAtChar('=', true)) {
            return -1;
        }
        entityReader.skipPastSpaces();
        int encodingIndex = entityReader.scanStringLiteral();
        return encodingIndex;
    }
}

