/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.ImplementationMessages;
import org.apache.xerces.utils.StringHasher;
import org.apache.xerces.utils.StringPool;

public final class CharDataChunk
implements StringPool.StringProducer {
    public static final int CHUNK_SHIFT = 14;
    public static final int CHUNK_SIZE = 16384;
    public static final int CHUNK_MASK = 16383;
    private StringPool fStringPool;
    private int fRefCount;
    private int fChunk;
    private char[] fData = null;
    private CharDataChunk fNextChunk;
    private CharDataChunk fPreviousChunk;
    private static CharDataChunk fgFreeChunks = null;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharDataChunk createChunk(StringPool stringPool, CharDataChunk prev) {
        CharDataChunk newChunk = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.xerces.utils.CharDataChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            newChunk = fgFreeChunks;
            if (newChunk != null) {
                fgFreeChunks = newChunk.fNextChunk;
            } else {
                newChunk = new CharDataChunk();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            newChunk.fStringPool = stringPool;
            newChunk.fRefCount = 1;
            newChunk.fChunk = prev == null ? 0 : prev.fChunk + 1;
            newChunk.fNextChunk = null;
            newChunk.fPreviousChunk = prev;
            if (prev != null) {
                prev.setNextChunk(newChunk);
            }
            return newChunk;
        }
    }

    public CharDataChunk chunkFor(int offset) {
        int firstChunk = offset >> 14;
        if (firstChunk == this.fChunk) {
            return this;
        }
        CharDataChunk dataChunk = this.fPreviousChunk;
        while (firstChunk != dataChunk.fChunk) {
            dataChunk = dataChunk.fPreviousChunk;
        }
        return dataChunk;
    }

    public char[] toCharArray() {
        return this.fData;
    }

    public void setCharArray(char[] data) {
        this.fData = data;
    }

    public CharDataChunk nextChunk() {
        return this.fNextChunk;
    }

    public boolean clearPreviousChunk() {
        if (this.fPreviousChunk != null) {
            this.fPreviousChunk.clearNextChunk();
            this.fPreviousChunk.removeRef();
            this.fPreviousChunk = null;
            return true;
        }
        return false;
    }

    public void releaseChunk() {
        this.removeRef();
    }

    public int addString(int offset, int length) {
        int chunk = offset >> 14;
        if (chunk != this.fChunk) {
            if (this.fPreviousChunk == null) {
                throw new RuntimeException(new ImplementationMessages().createMessage(null, 15, 0, null));
            }
            return this.fPreviousChunk.addString(offset, length);
        }
        int lastChunk = offset + length - 1 >> 14;
        if (chunk == lastChunk) {
            this.addRef();
            return this.fStringPool.addString(this, offset & 0x3FFF, length);
        }
        String str = this.toString(offset & 0x3FFF, length);
        return this.fStringPool.addString(str);
    }

    public int addSymbol(int offset, int length, int hashcode) {
        int chunk = offset >> 14;
        if (chunk != this.fChunk) {
            if (this.fPreviousChunk == null) {
                throw new RuntimeException(new ImplementationMessages().createMessage(null, 15, 0, null));
            }
            return this.fPreviousChunk.addSymbol(offset, length, hashcode);
        }
        int lastChunk = offset + length - 1 >> 14;
        int index = offset & 0x3FFF;
        if (chunk == lastChunk) {
            int symbol;
            if (hashcode == 0) {
                hashcode = StringHasher.hashChars(this.fData, index, length);
            }
            if ((symbol = this.fStringPool.lookupSymbol(this, offset & 0x3FFF, length, hashcode)) == -1) {
                String str = this.toString(offset & 0x3FFF, length);
                symbol = this.fStringPool.addNewSymbol(str, hashcode);
            }
            return symbol;
        }
        String str = this.toString(offset & 0x3FFF, length);
        return this.fStringPool.addSymbol(str);
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int offset, int length) {
        CharDataChunk dataChunk = this.chunkFor(offset);
        int index = offset & 0x3FFF;
        int nbytes = index + length <= 16384 ? length : 16384 - index;
        while (true) {
            charBuffer.append(dataChunk.fData, index, nbytes);
            if ((length -= nbytes) == 0) break;
            dataChunk = dataChunk.fNextChunk;
            index = 0;
            nbytes = length <= 16384 ? length : 16384;
        }
    }

    public String toString(int offset, int length) {
        if (offset + length <= 16384) {
            return new String(this.fData, offset, length);
        }
        StringBuffer sb = new StringBuffer(length);
        int nbytes = 16384 - offset;
        sb.append(this.fData, offset, nbytes);
        length -= nbytes;
        CharDataChunk aChunk = this.fNextChunk;
        do {
            nbytes = length <= 16384 ? length : 16384;
            sb.append(aChunk.fData, 0, nbytes);
            aChunk = aChunk.fNextChunk;
        } while ((length -= nbytes) > 0);
        String retval = sb.toString();
        sb = null;
        return retval;
    }

    public void releaseString(int offset, int length) {
        this.removeRef();
    }

    public boolean equalsString(int offset, int length, char[] strChars, int strOffset, int strLength) {
        if (length != strLength) {
            return false;
        }
        if (offset + length <= 16384) {
            int i = 0;
            while (i < length) {
                if (this.fData[offset++] != strChars[strOffset++]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int nbytes = 16384 - offset;
        length -= nbytes;
        while (nbytes-- > 0) {
            if (this.fData[offset++] == strChars[strOffset++]) continue;
            return false;
        }
        CharDataChunk aChunk = this.fNextChunk;
        do {
            offset = 0;
            nbytes = length <= 16384 ? length : 16384;
            length -= nbytes;
            while (nbytes-- > 0) {
                if (aChunk.fData[offset++] == strChars[strOffset++]) continue;
                return false;
            }
            aChunk = aChunk.fNextChunk;
        } while (length > 0);
        return true;
    }

    private CharDataChunk() {
    }

    private void addRef() {
        ++this.fRefCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeRef() {
        --this.fRefCount;
        if (this.fRefCount != 0) return;
        this.fStringPool = null;
        this.fChunk = -1;
        this.fPreviousChunk = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.xerces.utils.CharDataChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            this.fNextChunk = null;
            fgFreeChunks = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void clearNextChunk() {
        if (this.fNextChunk != null) {
            this.fNextChunk.removeRef();
        }
        this.fNextChunk = null;
    }

    private void setNextChunk(CharDataChunk nextChunk) {
        if (this.fNextChunk != null) {
            throw new RuntimeException("CharDataChunk::setNextChunk");
        }
        nextChunk.addRef();
        this.fNextChunk = nextChunk;
    }
}

