/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.CharDataChunk;
import org.apache.xerces.utils.StringPool;

public final class ChunkyCharArray
implements XMLEntityHandler.CharBuffer {
    private static final int INITIAL_CHUNK_SHIFT = 7;
    private static final int INITIAL_CHUNK_SIZE = 128;
    private StringPool fStringPool = null;
    private CharDataChunk fCurrentChunk = null;
    private char[] fCurrentData = null;
    private int fCurrentIndex = 0;
    private int fLength = 0;

    public ChunkyCharArray(StringPool stringPool) {
        this.fStringPool = stringPool;
        this.fCurrentChunk = CharDataChunk.createChunk(stringPool, null);
    }

    public int length() {
        return this.fLength;
    }

    public void append(char ch) {
        try {
            this.fCurrentData[this.fCurrentIndex] = ch;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            if (this.fCurrentIndex == 16384) {
                this.fCurrentChunk = CharDataChunk.createChunk(this.fStringPool, this.fCurrentChunk);
                this.fCurrentData = new char[128];
                this.fCurrentIndex = 0;
            } else {
                char[] newData = new char[this.fCurrentIndex * 2];
                System.arraycopy(this.fCurrentData, 0, newData, 0, this.fCurrentIndex);
                this.fCurrentData = newData;
            }
            this.fCurrentChunk.setCharArray(this.fCurrentData);
            this.fCurrentData[this.fCurrentIndex] = ch;
        }
        catch (NullPointerException ex) {
            this.fCurrentData = new char[128];
            this.fCurrentChunk.setCharArray(this.fCurrentData);
            this.fCurrentData[this.fCurrentIndex] = ch;
        }
        ++this.fCurrentIndex;
        ++this.fLength;
    }

    public void append(String s) {
        int slen = s.length();
        int i = 0;
        while (i < slen) {
            this.append(s.charAt(i));
            ++i;
        }
    }

    public void append(char[] ch, int offset, int length) {
        while (length-- > 0) {
            this.append(ch[offset++]);
        }
    }

    public void append(ChunkyCharArray charArray, int offset, int length) {
        this.fCurrentChunk.append(charArray, offset, length);
    }

    public int addString(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(offset, length);
    }

    public int addSymbol(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(offset, length, 0);
    }
}

