/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

public final class Hash2intTable {
    private static final int INITIAL_BUCKET_SIZE = 4;
    private static final int HASHTABLE_SIZE = 256;
    private int[][] fHashTable = new int[256][];

    public void put(int key1, int key2, int key3, int value) {
        int hash = (key1 + key2 + key3 + 2) % 256;
        int[] bucket = this.fHashTable[hash];
        if (bucket == null) {
            bucket = new int[17];
            bucket[0] = 1;
            bucket[1] = key1;
            bucket[2] = key2;
            bucket[3] = key3;
            bucket[4] = value;
            this.fHashTable[hash] = bucket;
        } else {
            int count = bucket[0];
            int offset = 1 + 4 * count;
            if (offset == bucket.length) {
                int newSize = count + 4;
                int[] newBucket = new int[1 + 4 * newSize];
                System.arraycopy(bucket, 0, newBucket, 0, offset);
                bucket = newBucket;
                this.fHashTable[hash] = bucket;
            }
            boolean found = false;
            int j = 1;
            int i = 0;
            while (i < count) {
                if (bucket[j] == key1 && bucket[j + 1] == key2 && bucket[j + 2] == key3) {
                    bucket[j + 3] = value;
                    found = true;
                    break;
                }
                j += 4;
                ++i;
            }
            if (!found) {
                bucket[offset++] = key1;
                bucket[offset++] = key2;
                bucket[offset++] = key3;
                bucket[offset] = value;
                bucket[0] = ++count;
            }
        }
    }

    public int get(int key1, int key2, int key3) {
        int hash = (key1 + key2 + key3 + 2) % 256;
        int[] bucket = this.fHashTable[hash];
        if (bucket == null) {
            return -1;
        }
        int count = bucket[0];
        int j = 1;
        int i = 0;
        while (i < count) {
            if (bucket[j] == key1 && bucket[j + 1] == key2 && bucket[j + 2] == key3) {
                return bucket[j + 3];
            }
            j += 4;
            ++i;
        }
        return -1;
    }
}

