/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static byte[] hexNumberTable = new byte[255];
    private static byte[] lookUpHexAlphabet = new byte[16];

    static {
        int i = 0;
        while (i < 255) {
            HexBin.hexNumberTable[i] = -1;
            ++i;
        }
        i = 57;
        while (i >= 48) {
            HexBin.hexNumberTable[i] = (byte)(i - 48);
            --i;
        }
        i = 70;
        while (i >= 65) {
            HexBin.hexNumberTable[i] = (byte)(i - 65 + 10);
            --i;
        }
        i = 102;
        while (i >= 97) {
            HexBin.hexNumberTable[i] = (byte)(i - 97 + 10);
            --i;
        }
        i = 0;
        while (i < 10) {
            HexBin.lookUpHexAlphabet[i] = (byte)(48 + i);
            ++i;
        }
        i = 10;
        while (i <= 15) {
            HexBin.lookUpHexAlphabet[i] = (byte)(65 + i - 10);
            ++i;
        }
    }

    static boolean isHex(byte octect) {
        return hexNumberTable[octect] != -1;
    }

    static boolean isArrayByteHex(byte[] arrayOctect) {
        if (arrayOctect == null) {
            return false;
        }
        int length = arrayOctect.length;
        if (length % 2 != 0) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!HexBin.isHex(arrayOctect[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isHex(String isValidString) {
        if (isValidString == null) {
            return false;
        }
        return HexBin.isArrayByteHex(isValidString.getBytes());
    }

    public static byte[] encode(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        int lengthData = binaryData.length;
        int lengthEncode = lengthData * 2;
        byte[] encodedData = new byte[lengthEncode];
        int i = 0;
        while (i < lengthData) {
            encodedData[i * 2] = lookUpHexAlphabet[binaryData[i] >> 4];
            encodedData[i * 2 + 1] = lookUpHexAlphabet[binaryData[i] & 0xF];
            ++i;
        }
        return encodedData;
    }

    public static byte[] decode(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        int lengthData = binaryData.length;
        if (lengthData % 2 != 0) {
            return null;
        }
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        int i = 0;
        while (i < lengthDecode) {
            decodedData[i] = (byte)(hexNumberTable[binaryData[i * 2]] << 4 | hexNumberTable[binaryData[i * 2 + 1]]);
            ++i;
        }
        return decodedData;
    }

    public static int getDecodedDataLength(byte[] hexData) {
        if (!HexBin.isArrayByteHex(hexData)) {
            return -1;
        }
        return hexData.length / 2;
    }
}

