/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.xerces.utils.XMLMessageProvider;

public class ImplementationMessages
implements XMLMessageProvider {
    public static final String XERCES_IMPLEMENTATION_DOMAIN = "http://www.apache.org/xml/xerces.html";
    private Locale fLocale = null;
    private ResourceBundle fResourceBundle = null;
    public static final int BAD_MAJORCODE = 0;
    public static final int ENC4 = 1;
    public static final int ENC5 = 2;
    public static final int ENC6 = 3;
    public static final int ENC7 = 4;
    public static final int IO0 = 5;
    public static final int VAL_BST = 6;
    public static final int VAL_CMSI = 7;
    public static final int VAL_CST = 8;
    public static final int VAL_LST = 9;
    public static final int VAL_NIICM = 10;
    public static final int VAL_NPCD = 11;
    public static final int VAL_UST = 12;
    public static final int VAL_WCGHI = 13;
    public static final int INT_DCN = 14;
    public static final int INT_PCN = 15;
    public static final int FATAL_ERROR = 16;
    public static final int FORMAT_FAILED = 17;
    private static final String[] fgMessageKeys;

    static {
        String[] stringArray = new String[19];
        stringArray[0] = "BadMajorCode";
        stringArray[1] = "ENC4";
        stringArray[2] = "ENC5";
        stringArray[3] = "ENC6";
        stringArray[4] = "ENC7";
        stringArray[5] = "FileNotFound";
        stringArray[6] = "VAL_BST";
        stringArray[7] = "VAL_CMSI";
        stringArray[8] = "VAL_CST";
        stringArray[9] = "VAL_LST";
        stringArray[10] = "VAL_NIICM";
        stringArray[11] = "VAL_NPCD";
        stringArray[12] = "VAL_UST";
        stringArray[13] = "VAL_WCGHI";
        stringArray[14] = "INT_DCN";
        stringArray[15] = "INT_PCN";
        stringArray[16] = "FatalError";
        stringArray[17] = "FormatFailed";
        fgMessageKeys = stringArray;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public String createMessage(Locale locale, int majorCode, int minorCode, Object[] args) {
        boolean throwex = false;
        if (this.fResourceBundle == null || locale != this.fLocale) {
            if (locale != null) {
                this.fResourceBundle = ResourceBundle.getBundle("org.apache.xerces.msg.ImplementationMessages", locale);
            }
            if (this.fResourceBundle == null) {
                this.fResourceBundle = ResourceBundle.getBundle("org.apache.xerces.msg.ImplementationMessages");
            }
        }
        if (majorCode < 0 || majorCode >= fgMessageKeys.length - 1) {
            majorCode = 0;
            throwex = true;
        }
        String msgKey = fgMessageKeys[majorCode];
        String msg = this.fResourceBundle.getString(msgKey);
        if (args != null) {
            try {
                msg = MessageFormat.format(msg, args);
            }
            catch (Exception e) {
                msg = this.fResourceBundle.getString(fgMessageKeys[17]);
                msg = String.valueOf(msg) + " " + this.fResourceBundle.getString(msgKey);
            }
        }
        if (throwex) {
            throw new RuntimeException(msg);
        }
        return msg;
    }
}

