/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

public final class IntStack {
    private int fDepth;
    private int[] fData;

    public int size() {
        return this.fDepth;
    }

    public void push(int value) {
        this.ensureCapacity(this.fDepth + 1);
        this.fData[this.fDepth++] = value;
    }

    public int peek() {
        return this.fData[this.fDepth - 1];
    }

    public int pop() {
        return this.fData[--this.fDepth];
    }

    public void clear() {
        this.fDepth = 0;
    }

    public void print() {
        System.out.print('(');
        System.out.print(this.fDepth);
        System.out.print(") {");
        int i = 0;
        while (i < this.fDepth) {
            if (i == 3) {
                System.out.print(" ...");
                break;
            }
            System.out.print(' ');
            System.out.print(this.fData[i]);
            if (i < this.fDepth - 1) {
                System.out.print(',');
            }
            ++i;
        }
        System.out.print(" }");
        System.out.println();
    }

    private boolean ensureCapacity(int size) {
        try {
            return this.fData[size] != 0;
        }
        catch (NullPointerException e) {
            this.fData = new int[32];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int[] newdata = new int[this.fData.length * 2];
            System.arraycopy(this.fData, 0, newdata, 0, this.fData.length);
            this.fData = newdata;
        }
        return true;
    }
}

