/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

public class NamespacesScope {
    private NamespacesHandler fHandler = null;
    private int fElementDepth = 0;
    private int[][] fNamespaceMappings = new int[8][];

    public NamespacesScope() {
        this(new NamespacesHandler(){

            public void startNamespaceDeclScope(int prefix, int uri) throws Exception {
            }

            public void endNamespaceDeclScope(int prefix) throws Exception {
            }
        });
    }

    public NamespacesScope(NamespacesHandler handler) {
        this.fHandler = handler;
        this.fNamespaceMappings[0] = new int[9];
        this.fNamespaceMappings[0][0] = 1;
    }

    public NamespacesScope(NamespacesHandler handler, int elemDepth, int[][] map) {
        this.fHandler = handler;
        this.fElementDepth = elemDepth;
        if (map == null) {
            this.fNamespaceMappings = new int[8][];
            return;
        }
        this.fNamespaceMappings = new int[map.length][];
        int i = 0;
        while (i <= this.fElementDepth) {
            if (map[i] != null) {
                this.fNamespaceMappings[i] = new int[map[i].length];
                System.arraycopy(map[i], 0, this.fNamespaceMappings[i], 0, map[i].length);
            }
            ++i;
        }
    }

    public void setNamespaceForPrefix(int prefix, int namespace) throws Exception {
        int offset = this.fNamespaceMappings[this.fElementDepth][0];
        if (offset == this.fNamespaceMappings[this.fElementDepth].length) {
            int[] newMappings = new int[offset + 8];
            System.arraycopy(this.fNamespaceMappings[this.fElementDepth], 0, newMappings, 0, offset);
            this.fNamespaceMappings[this.fElementDepth] = newMappings;
        }
        this.fNamespaceMappings[this.fElementDepth][offset++] = prefix;
        this.fNamespaceMappings[this.fElementDepth][offset++] = namespace;
        this.fNamespaceMappings[this.fElementDepth][0] = offset;
        if (this.fElementDepth > 0) {
            this.fHandler.startNamespaceDeclScope(prefix, namespace);
        }
    }

    public int getNamespaceForPrefix(int prefix) {
        int depth = this.fElementDepth;
        while (depth >= 0) {
            int offset = this.fNamespaceMappings[depth][0];
            int i = 1;
            while (i < offset) {
                if (prefix == this.fNamespaceMappings[depth][i]) {
                    return this.fNamespaceMappings[depth][i + 1];
                }
                i += 2;
            }
            --depth;
        }
        return 0;
    }

    public void increaseDepth() throws Exception {
        ++this.fElementDepth;
        if (this.fElementDepth == this.fNamespaceMappings.length) {
            int[][] newMappings = new int[this.fElementDepth + 8][];
            System.arraycopy(this.fNamespaceMappings, 0, newMappings, 0, this.fElementDepth);
            this.fNamespaceMappings = newMappings;
        }
        if (this.fNamespaceMappings[this.fElementDepth] == null) {
            this.fNamespaceMappings[this.fElementDepth] = new int[9];
        }
        this.fNamespaceMappings[this.fElementDepth][0] = 1;
    }

    public void decreaseDepth() throws Exception {
        if (this.fElementDepth > 0) {
            int offset = this.fNamespaceMappings[this.fElementDepth][0];
            while (offset > 1) {
                this.fHandler.endNamespaceDeclScope(this.fNamespaceMappings[this.fElementDepth][offset -= 2]);
            }
        }
        --this.fElementDepth;
    }

    public Object clone() {
        return new NamespacesScope(this.fHandler, this.fElementDepth, this.fNamespaceMappings);
    }

    public static interface NamespacesHandler {
        public void startNamespaceDeclScope(int var1, int var2) throws Exception;

        public void endNamespaceDeclScope(int var1) throws Exception;
    }
}

