/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

import org.apache.xerces.utils.StringPool;

public class QName {
    private static final boolean FIND_URI_IS_MINUS_ONE = false;
    public int prefix;
    public int localpart;
    public int rawname;
    public int uri;

    public QName() {
        this.clear();
    }

    public QName(int prefix, int localpart, int rawname) {
        this.setValues(prefix, localpart, rawname, 0);
    }

    public QName(int prefix, int localpart, int rawname, int uri) {
        this.setValues(prefix, localpart, rawname, uri);
    }

    public QName(QName qname) {
        this.setValues(qname);
    }

    public void setValues(QName qname) {
        this.prefix = qname.prefix;
        this.localpart = qname.localpart;
        this.rawname = qname.rawname;
        this.uri = qname.uri;
    }

    public void setValues(int prefix, int localpart, int rawname) {
        this.setValues(prefix, localpart, rawname, 0);
    }

    public void setValues(int prefix, int localpart, int rawname, int uri) {
        this.prefix = prefix;
        this.localpart = localpart;
        this.rawname = rawname;
        this.uri = uri;
    }

    public void clear() {
        this.prefix = -1;
        this.localpart = -1;
        this.rawname = -1;
        this.uri = 0;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof QName) {
            QName qname = (QName)object;
            if (this.uri == 0) {
                return this.rawname == qname.rawname;
            }
            return this.localpart == qname.localpart && this.uri == qname.uri;
        }
        return false;
    }

    public int hashCode() {
        return this.localpart << 16 | this.uri;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("prefix: ");
        str.append(this.prefix);
        str.append(", ");
        str.append("localpart: ");
        str.append(this.localpart);
        str.append(", ");
        str.append("rawname: ");
        str.append(this.rawname);
        str.append(", ");
        str.append("uri: ");
        str.append(this.uri);
        return str.toString();
    }

    public String toString(StringPool stringPool) {
        StringBuffer str = new StringBuffer();
        str.append("prefix: ");
        str.append(String.valueOf(stringPool.toString(this.prefix)));
        str.append(", ");
        str.append("localpart: ");
        str.append(String.valueOf(stringPool.toString(this.localpart)));
        str.append(", ");
        str.append("rawname: ");
        str.append(String.valueOf(stringPool.toString(this.rawname)));
        str.append(", ");
        str.append("uri: ");
        str.append(String.valueOf(stringPool.toString(this.uri)));
        return str.toString();
    }
}

