/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

import org.apache.xerces.utils.StringHasher;
import org.apache.xerces.utils.SymbolCache;

public final class StringPool {
    private static final boolean DEBUG_ADDITIONS = false;
    public static final int NULL_STRING = -1;
    public static final int EMPTY_STRING = 0;
    private static final int INITIAL_CHUNK_SHIFT = 8;
    private static final int INITIAL_CHUNK_SIZE = 256;
    private static final int CHUNK_SHIFT = 13;
    private static final int CHUNK_SIZE = 8192;
    private static final int CHUNK_MASK = 8191;
    private static final int INITIAL_CHUNK_COUNT = 8;
    private int fStringCount = 0;
    private int fStringFreeList = -1;
    private String[][] fString = new String[8][];
    private StringProducer[][] fStringProducer = new StringProducer[8][];
    private int[][] fOffset = new int[8][];
    private int[][] fLength = new int[8][];
    private int[][] fCharsOffset = new int[8][];
    private int fStringListCount = 0;
    private int fActiveStringList = -1;
    private int[][] fStringList = new int[8][];
    private static final int INITIAL_BUCKET_SIZE = 4;
    private static final int HASHTABLE_SIZE = 128;
    private int[][] fSymbolTable = new int[128][];
    private SymbolCache fSymbolCache = new SymbolCache();
    private int fShuffleCount = 0;

    public StringPool() {
        if (this.addSymbol("") != 0) {
            throw new RuntimeException("UTL002 cannot happen");
        }
    }

    public void reset() {
        int chunk = 0;
        int index = 0;
        int i = 0;
        while (i < this.fStringCount) {
            this.fString[chunk][index] = null;
            if (this.fStringProducer[chunk][index] != null) {
                this.fStringProducer[chunk][index].releaseString(this.fOffset[chunk][index], this.fLength[chunk][index]);
            }
            this.fStringProducer[chunk][index] = null;
            if (++index == 8192) {
                ++chunk;
                index = 0;
            }
            ++i;
        }
        i = 0;
        while (i < 128) {
            this.fSymbolTable[i] = null;
            ++i;
        }
        this.fStringCount = 0;
        this.fStringFreeList = -1;
        this.fStringListCount = 0;
        this.fActiveStringList = -1;
        this.fSymbolCache.reset();
        this.fShuffleCount = 0;
        if (this.addSymbol("") != 0) {
            throw new RuntimeException("UTL002 cannot happen");
        }
    }

    private void ensureCapacity(int chunk, int index) {
        if (chunk >= this.fOffset.length) {
            String[][] newString = new String[chunk * 2][];
            System.arraycopy(this.fString, 0, newString, 0, chunk);
            this.fString = newString;
            StringProducer[][] newProducer = new StringProducer[chunk * 2][];
            System.arraycopy(this.fStringProducer, 0, newProducer, 0, chunk);
            this.fStringProducer = newProducer;
            int[][] newInt = new int[chunk * 2][];
            System.arraycopy(this.fOffset, 0, newInt, 0, chunk);
            this.fOffset = newInt;
            newInt = new int[chunk * 2][];
            System.arraycopy(this.fLength, 0, newInt, 0, chunk);
            this.fLength = newInt;
            newInt = new int[chunk * 2][];
            System.arraycopy(this.fCharsOffset, 0, newInt, 0, chunk);
            this.fCharsOffset = newInt;
        } else if (this.fOffset[chunk] != null) {
            if (index >= this.fOffset[chunk].length) {
                String[] newString = new String[index * 2];
                System.arraycopy(this.fString[chunk], 0, newString, 0, index);
                this.fString[chunk] = newString;
                StringProducer[] newProducer = new StringProducer[index * 2];
                System.arraycopy(this.fStringProducer[chunk], 0, newProducer, 0, index);
                this.fStringProducer[chunk] = newProducer;
                int[] newInt = new int[index * 2];
                System.arraycopy(this.fOffset[chunk], 0, newInt, 0, index);
                this.fOffset[chunk] = newInt;
                newInt = new int[index * 2];
                System.arraycopy(this.fLength[chunk], 0, newInt, 0, index);
                this.fLength[chunk] = newInt;
                newInt = new int[index * 2];
                System.arraycopy(this.fCharsOffset[chunk], 0, newInt, 0, index);
                this.fCharsOffset[chunk] = newInt;
                return;
            }
            return;
        }
        this.fString[chunk] = new String[256];
        this.fStringProducer[chunk] = new StringProducer[256];
        this.fOffset[chunk] = new int[256];
        this.fLength[chunk] = new int[256];
        this.fCharsOffset[chunk] = new int[256];
    }

    public int addString(String str) {
        int index;
        int chunk;
        int stringIndex;
        if (this.fStringFreeList != -1) {
            stringIndex = this.fStringFreeList;
            chunk = stringIndex >> 13;
            index = stringIndex & 0x1FFF;
            this.fStringFreeList = this.fOffset[chunk][index];
        } else {
            stringIndex = this.fStringCount++;
            chunk = stringIndex >> 13;
            index = stringIndex & 0x1FFF;
            this.ensureCapacity(chunk, index);
        }
        this.fString[chunk][index] = str;
        this.fStringProducer[chunk][index] = null;
        this.fOffset[chunk][index] = 0;
        this.fLength[chunk][index] = str.length();
        this.fCharsOffset[chunk][index] = -1;
        return stringIndex;
    }

    public int addString(StringProducer stringProducer, int offset, int length) {
        int index;
        int chunk;
        int stringIndex;
        if (this.fStringFreeList != -1) {
            stringIndex = this.fStringFreeList;
            chunk = stringIndex >> 13;
            index = stringIndex & 0x1FFF;
            this.fStringFreeList = this.fOffset[chunk][index];
        } else {
            stringIndex = this.fStringCount++;
            chunk = stringIndex >> 13;
            index = stringIndex & 0x1FFF;
            this.ensureCapacity(chunk, index);
        }
        this.fString[chunk][index] = null;
        this.fStringProducer[chunk][index] = stringProducer;
        this.fOffset[chunk][index] = offset;
        this.fLength[chunk][index] = length;
        this.fCharsOffset[chunk][index] = -1;
        return stringIndex;
    }

    public SymbolCache getSymbolCache() {
        return this.fSymbolCache;
    }

    public void resetShuffleCount() {
        this.fShuffleCount = 0;
    }

    public void updateCacheLine(int symbolIndex, int totalMisses, int length) {
        if (++this.fShuffleCount > 200) {
            return;
        }
        int chunk = symbolIndex >> 13;
        int index = symbolIndex & 0x1FFF;
        int charsOffset = this.fCharsOffset[chunk][index];
        this.fSymbolCache.updateCacheLine(charsOffset, totalMisses, length);
    }

    public int createNonMatchingSymbol(int startOffset, int entry, int[] entries, int offset) throws Exception {
        int index;
        int chunk;
        int stringIndex;
        if (this.fStringFreeList != -1) {
            stringIndex = this.fStringFreeList;
            chunk = stringIndex >> 13;
            index = stringIndex & 0x1FFF;
            this.fStringFreeList = this.fOffset[chunk][index];
        } else {
            stringIndex = this.fStringCount++;
            chunk = stringIndex >> 13;
            index = stringIndex & 0x1FFF;
            this.ensureCapacity(chunk, index);
        }
        String str = this.fSymbolCache.createSymbol(stringIndex, startOffset, entry, entries, offset);
        int slen = str.length();
        this.fString[chunk][index] = str;
        this.fStringProducer[chunk][index] = null;
        this.fOffset[chunk][index] = -1;
        this.fLength[chunk][index] = slen;
        this.fCharsOffset[chunk][index] = startOffset;
        int hashcode = StringHasher.hashString(str, slen);
        int hc = hashcode % 128;
        int[] bucket = this.fSymbolTable[hc];
        this.hashSymbol(bucket, hashcode, chunk, index);
        return stringIndex;
    }

    private void hashSymbol(int[] bucket, int hashcode, int chunk, int index) {
        if (bucket == null) {
            bucket = new int[13];
            bucket[0] = 1;
            bucket[1] = hashcode;
            bucket[2] = chunk;
            bucket[3] = index;
            int hc = hashcode % 128;
            this.fSymbolTable[hc] = bucket;
        } else {
            int count = bucket[0];
            int offset = 1 + count * 3;
            if (offset == bucket.length) {
                int newSize = count + 4;
                int[] newBucket = new int[1 + newSize * 3];
                System.arraycopy(bucket, 0, newBucket, 0, offset);
                bucket = newBucket;
                int hc = hashcode % 128;
                this.fSymbolTable[hc] = bucket;
            }
            bucket[offset++] = hashcode;
            bucket[offset++] = chunk;
            bucket[offset++] = index;
            bucket[0] = ++count;
        }
    }

    public int addSymbol(String str) {
        int index;
        int chunk;
        int stringIndex;
        int slen = str.length();
        int hashcode = StringHasher.hashString(str, slen);
        int hc = hashcode % 128;
        int[] bucket = this.fSymbolTable[hc];
        if (bucket != null) {
            int j = 1;
            int i = 0;
            while (i < bucket[0]) {
                int index2;
                int chunk2;
                if (bucket[j] == hashcode && slen == this.fLength[chunk2 = bucket[j + 1]][index2 = bucket[j + 2]]) {
                    int symoff = this.fCharsOffset[chunk2][index2];
                    boolean match = true;
                    char[] symbolChars = this.fSymbolCache.getSymbolChars();
                    int k = 0;
                    while (k < slen) {
                        if (symbolChars[symoff++] != str.charAt(k)) {
                            match = false;
                            break;
                        }
                        ++k;
                    }
                    if (match) {
                        return (chunk2 << 13) + index2;
                    }
                }
                j += 3;
                ++i;
            }
        }
        if (this.fStringFreeList != -1) {
            stringIndex = this.fStringFreeList;
            chunk = stringIndex >> 13;
            index = stringIndex & 0x1FFF;
            this.fStringFreeList = this.fOffset[chunk][index];
        } else {
            stringIndex = this.fStringCount++;
            chunk = stringIndex >> 13;
            index = stringIndex & 0x1FFF;
            this.ensureCapacity(chunk, index);
        }
        this.fString[chunk][index] = str;
        this.fStringProducer[chunk][index] = null;
        this.fOffset[chunk][index] = -1;
        this.fLength[chunk][index] = slen;
        this.fCharsOffset[chunk][index] = this.fSymbolCache.addSymbolToCache(str, slen, stringIndex);
        this.hashSymbol(bucket, hashcode, chunk, index);
        return stringIndex;
    }

    public int addSymbol(StringProducer stringProducer, int offset, int length, int hashcode) {
        int index;
        int chunk;
        int stringIndex;
        int hc = hashcode % 128;
        int[] bucket = this.fSymbolTable[hc];
        if (bucket != null) {
            int j = 1;
            int i = 0;
            while (i < bucket[0]) {
                if (bucket[j] == hashcode) {
                    int chunk2 = bucket[j + 1];
                    int index2 = bucket[j + 2];
                    char[] symbolChars = this.fSymbolCache.getSymbolChars();
                    if (stringProducer.equalsString(offset, length, symbolChars, this.fCharsOffset[chunk2][index2], this.fLength[chunk2][index2])) {
                        stringProducer.releaseString(offset, length);
                        return (chunk2 << 13) + index2;
                    }
                }
                j += 3;
                ++i;
            }
        }
        if (this.fStringFreeList != -1) {
            stringIndex = this.fStringFreeList;
            chunk = stringIndex >> 13;
            index = stringIndex & 0x1FFF;
            this.fStringFreeList = this.fOffset[chunk][index];
        } else {
            stringIndex = this.fStringCount++;
            chunk = stringIndex >> 13;
            index = stringIndex & 0x1FFF;
            this.ensureCapacity(chunk, index);
        }
        String str = stringProducer.toString(offset, length);
        stringProducer.releaseString(offset, length);
        int slen = str.length();
        this.fString[chunk][index] = str;
        this.fStringProducer[chunk][index] = null;
        this.fOffset[chunk][index] = -1;
        this.fLength[chunk][index] = slen;
        this.fCharsOffset[chunk][index] = this.fSymbolCache.addSymbolToCache(str, slen, stringIndex);
        this.hashSymbol(bucket, hashcode, chunk, index);
        return stringIndex;
    }

    public int lookupSymbol(StringProducer stringProducer, int offset, int length, int hashcode) {
        int hc = hashcode % 128;
        int[] bucket = this.fSymbolTable[hc];
        if (bucket != null) {
            int j = 1;
            int i = 0;
            while (i < bucket[0]) {
                if (bucket[j] == hashcode) {
                    int chunk = bucket[j + 1];
                    int index = bucket[j + 2];
                    char[] symbolChars = this.fSymbolCache.getSymbolChars();
                    if (stringProducer.equalsString(offset, length, symbolChars, this.fCharsOffset[chunk][index], this.fLength[chunk][index])) {
                        return (chunk << 13) + index;
                    }
                }
                j += 3;
                ++i;
            }
        }
        return -1;
    }

    public int addNewSymbol(String str, int hashcode) {
        int index;
        int chunk;
        int stringIndex;
        int hc = hashcode % 128;
        int[] bucket = this.fSymbolTable[hc];
        if (this.fStringFreeList != -1) {
            stringIndex = this.fStringFreeList;
            chunk = stringIndex >> 13;
            index = stringIndex & 0x1FFF;
            this.fStringFreeList = this.fOffset[chunk][index];
        } else {
            stringIndex = this.fStringCount++;
            chunk = stringIndex >> 13;
            index = stringIndex & 0x1FFF;
            this.ensureCapacity(chunk, index);
        }
        int slen = str.length();
        this.fString[chunk][index] = str;
        this.fStringProducer[chunk][index] = null;
        this.fOffset[chunk][index] = -1;
        this.fLength[chunk][index] = slen;
        this.fCharsOffset[chunk][index] = this.fSymbolCache.addSymbolToCache(str, slen, stringIndex);
        this.hashSymbol(bucket, hashcode, chunk, index);
        return stringIndex;
    }

    public int addSymbol(int stringIndex) {
        if (stringIndex < 0 || stringIndex >= this.fStringCount) {
            return -1;
        }
        int chunk = stringIndex >> 13;
        int index = stringIndex & 0x1FFF;
        if (this.fOffset[chunk][index] == -1) {
            return stringIndex;
        }
        String s = this.fString[chunk][index];
        if (s == null) {
            s = this.fStringProducer[chunk][index].toString(this.fOffset[chunk][index], this.fLength[chunk][index]);
            this.fStringProducer[chunk][index].releaseString(this.fOffset[chunk][index], this.fLength[chunk][index]);
            this.fString[chunk][index] = s;
            this.fStringProducer[chunk][index] = null;
        }
        return this.addSymbol(s);
    }

    public CharArrayRange createCharArrayRange() {
        return new CharArrayRange();
    }

    public void getCharArrayRange(int symbolIndex, CharArrayRange r) {
        if (symbolIndex < 0 || symbolIndex >= this.fStringCount) {
            r.chars = null;
            r.offset = -1;
            r.length = -1;
            return;
        }
        int chunk = symbolIndex >> 13;
        int index = symbolIndex & 0x1FFF;
        r.chars = this.fSymbolCache.getSymbolChars();
        r.offset = this.fCharsOffset[chunk][index];
        r.length = this.fLength[chunk][index];
    }

    public boolean equalNames(int stringIndex1, int stringIndex2) {
        return stringIndex1 == stringIndex2;
    }

    private void ensureListCapacity(int chunk, int index) {
        if (chunk >= this.fStringList.length) {
            int[][] newInt = new int[chunk * 2][];
            System.arraycopy(this.fStringList, 0, newInt, 0, chunk);
            this.fStringList = newInt;
            this.fStringList[chunk] = new int[256];
        } else if (this.fStringList[chunk] == null) {
            this.fStringList[chunk] = new int[256];
        } else if (index >= this.fStringList[chunk].length) {
            int[] newInt = new int[index * 2];
            System.arraycopy(this.fStringList[chunk], 0, newInt, 0, index);
            this.fStringList[chunk] = newInt;
        }
    }

    public int startStringList() {
        this.fActiveStringList = this.fStringListCount;
        return this.fStringListCount;
    }

    public boolean addStringToList(int stringListIndex, int stringIndex) {
        if (stringIndex == -1 || stringListIndex != this.fActiveStringList) {
            return false;
        }
        int chunk = this.fStringListCount >> 13;
        int index = this.fStringListCount & 0x1FFF;
        this.ensureListCapacity(chunk, index);
        this.fStringList[chunk][index] = stringIndex;
        ++this.fStringListCount;
        return true;
    }

    public void finishStringList(int stringListIndex) {
        if (stringListIndex != this.fActiveStringList) {
            return;
        }
        int chunk = this.fStringListCount >> 13;
        int index = this.fStringListCount & 0x1FFF;
        this.ensureListCapacity(chunk, index);
        this.fStringList[chunk][index] = -1;
        this.fActiveStringList = -1;
        ++this.fStringListCount;
    }

    public int stringListLength(int stringListIndex) {
        int chunk = stringListIndex >> 13;
        int index = stringListIndex & 0x1FFF;
        int count = 0;
        while (this.fStringList[chunk][index] != -1) {
            ++count;
            if (++index != 8192) continue;
            ++chunk;
            index = 0;
        }
        return count;
    }

    public boolean stringInList(int stringListIndex, int stringIndex) {
        int chunk = stringListIndex >> 13;
        int index = stringListIndex & 0x1FFF;
        while (this.fStringList[chunk][index] != stringIndex) {
            if (this.fStringList[chunk][index] == -1) {
                return false;
            }
            if (++index != 8192) continue;
            ++chunk;
            index = 0;
        }
        return true;
    }

    public String stringListAsString(int stringListIndex) {
        int chunk = stringListIndex >> 13;
        int index = stringListIndex & 0x1FFF;
        StringBuffer sb = new StringBuffer();
        int sep = 40;
        while (this.fStringList[chunk][index] != -1) {
            sb.append((char)sep);
            sep = 124;
            sb.append(this.toString(this.fStringList[chunk][index]));
            if (++index != 8192) continue;
            ++chunk;
            index = 0;
        }
        if (sep == 124) {
            sb.append(')');
        }
        return sb.toString();
    }

    public int[] stringListAsIntArray(int stringListIndex) {
        int chunk = stringListIndex >> 13;
        int index = stringListIndex & 0x1FFF;
        int len = this.stringListLength(stringListIndex);
        int[] ia = new int[len];
        int i = 0;
        while (i < len) {
            ia[i] = this.fStringList[chunk][index];
            if (++index == 8192) {
                ++chunk;
                index = 0;
            }
            ++i;
        }
        return ia;
    }

    private void releaseStringInternal(int chunk, int index) {
        int offset;
        this.fString[chunk][index] = null;
        this.fStringProducer[chunk][index] = null;
        this.fLength[chunk][index] = 0;
        this.fOffset[chunk][index] = this.fStringFreeList;
        this.fStringFreeList = offset = (chunk << 13) + index;
    }

    public void releaseString(int stringIndex) {
        if (stringIndex < 0 || stringIndex >= this.fStringCount) {
            return;
        }
        int chunk = stringIndex >> 13;
        int index = stringIndex & 0x1FFF;
        if (this.fOffset[chunk][index] != -1) {
            if (this.fStringProducer[chunk][index] != null) {
                this.fStringProducer[chunk][index].releaseString(this.fOffset[chunk][index], this.fLength[chunk][index]);
            }
            this.releaseStringInternal(chunk, index);
        }
    }

    public String toString(int stringIndex) {
        String result;
        if (stringIndex >= 0 && stringIndex < this.fString[0].length && (result = this.fString[0][stringIndex]) != null) {
            return result;
        }
        if (stringIndex < 0 || stringIndex >= this.fStringCount) {
            return null;
        }
        int chunk = stringIndex >> 13;
        int index = stringIndex & 0x1FFF;
        String s = this.fString[chunk][index];
        if (s != null) {
            return s;
        }
        s = this.fStringProducer[chunk][index].toString(this.fOffset[chunk][index], this.fLength[chunk][index]);
        this.fStringProducer[chunk][index].releaseString(this.fOffset[chunk][index], this.fLength[chunk][index]);
        this.fString[chunk][index] = s;
        this.fStringProducer[chunk][index] = null;
        return s;
    }

    public String orphanString(int stringIndex) {
        if (stringIndex < 0 || stringIndex >= this.fStringCount) {
            return null;
        }
        int chunk = stringIndex >> 13;
        int index = stringIndex & 0x1FFF;
        String s = this.fString[chunk][index];
        if (s == null) {
            s = this.fStringProducer[chunk][index].toString(this.fOffset[chunk][index], this.fLength[chunk][index]);
            this.fStringProducer[chunk][index].releaseString(this.fOffset[chunk][index], this.fLength[chunk][index]);
            this.releaseStringInternal(chunk, index);
        } else if (this.fOffset[chunk][index] != -1) {
            this.releaseStringInternal(chunk, index);
        }
        return s;
    }

    public class CharArrayRange {
        public char[] chars;
        public int offset;
        public int length;
    }

    public static interface StringProducer {
        public String toString(int var1, int var2);

        public void releaseString(int var1, int var2);

        public boolean equalsString(int var1, int var2, char[] var3, int var4, int var5);
    }
}

