/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

public final class SymbolCache {
    public static final int CHAR_OFFSET = 0;
    public static final int INDEX_OFFSET = 1;
    public static final int NEXT_OFFSET = 2;
    public static final int CACHE_RECORD_SIZE = 3;
    public static final int INITIAL_CACHE_RECORD_COUNT = 4;
    public static final int HEAD_INITIAL_CACHE_RECORD_COUNT = 85;
    public char[] fSymbolChars = new char[8192];
    public int fSymbolCharsOffset = 0;
    public int[][] fCacheLines = new int[256][];
    public int fCacheLineCount = 0;

    public SymbolCache() {
        this.fCacheLines[this.fCacheLineCount++] = new int[256];
    }

    public void reset() {
        this.fSymbolCharsOffset = 0;
        this.fCacheLineCount = 0;
        this.fCacheLines[this.fCacheLineCount++] = new int[256];
    }

    public char[] getSymbolChars() {
        return this.fSymbolChars;
    }

    public String createSymbol(int symbolHandle, int startOffset, int entry, int[] entries, int offset) {
        int slen = this.fSymbolCharsOffset - startOffset;
        String str = new String(this.fSymbolChars, startOffset, slen);
        try {
            entries[offset + 1] = symbolHandle;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RuntimeException("UTL001 untested");
        }
        return str;
    }

    public int addSymbolToCache(String str, int slen, int symbolHandle) {
        int charsOffset = this.fSymbolCharsOffset;
        if (slen == 0) {
            return charsOffset;
        }
        int strIndex = 0;
        char ch = str.charAt(strIndex++);
        try {
            this.fSymbolChars[this.fSymbolCharsOffset] = ch;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            char[] newChars = new char[this.fSymbolChars.length * 2];
            System.arraycopy(this.fSymbolChars, 0, newChars, 0, this.fSymbolChars.length);
            this.fSymbolChars = newChars;
            this.fSymbolChars[this.fSymbolCharsOffset] = ch;
        }
        ++this.fSymbolCharsOffset;
        int entry = 0;
        int[] entries = this.fCacheLines[entry];
        int count = entries[0];
        int i = 0;
        int offset = 1;
        while (i != count) {
            if (entries[offset + 0] != ch) {
                ++i;
                offset += 3;
                continue;
            }
            if (strIndex == slen) {
                if (entries[offset + 1] != -1) {
                    throw new RuntimeException("addSymbolToCache");
                }
                entries[offset + 1] = symbolHandle;
                return charsOffset;
            }
            ch = str.charAt(strIndex++);
            try {
                this.fSymbolChars[this.fSymbolCharsOffset] = ch;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                char[] newChars = new char[this.fSymbolChars.length * 2];
                System.arraycopy(this.fSymbolChars, 0, newChars, 0, this.fSymbolChars.length);
                this.fSymbolChars = newChars;
                this.fSymbolChars[this.fSymbolCharsOffset] = ch;
            }
            ++this.fSymbolCharsOffset;
            entry = entries[offset + 2];
            try {
                entries = this.fCacheLines[entry];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                if (entry == -1) {
                    entries[offset + 2] = entry = this.fCacheLineCount++;
                    entries = new int[13];
                    try {
                        this.fCacheLines[entry] = entries;
                    }
                    catch (ArrayIndexOutOfBoundsException ex2) {
                        int[][] newCache = new int[entry * 2][];
                        System.arraycopy(this.fCacheLines, 0, newCache, 0, entry);
                        this.fCacheLines = newCache;
                        this.fCacheLines[entry] = entries;
                    }
                }
                entries = this.fCacheLines[entry];
                throw new RuntimeException("UTL001 untested");
            }
            count = entries[0];
            i = 0;
            offset = 1;
        }
        while (true) {
            entries[0] = entries[0] + 1;
            try {
                entries[offset + 0] = ch;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                int newSize = 1 + (offset - 1) * 2;
                int[] newEntries = new int[newSize];
                System.arraycopy(entries, 0, newEntries, 0, offset);
                entries = newEntries;
                this.fCacheLines[entry] = newEntries;
                entries[offset + 0] = ch;
            }
            if (strIndex == slen) break;
            ++this.fCacheLineCount;
            entries[offset + 1] = -1;
            entries[offset + 2] = entry;
            entries = new int[13];
            try {
                this.fCacheLines[entry] = entries;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                int[][] newCache = new int[entry * 2][];
                System.arraycopy(this.fCacheLines, 0, newCache, 0, entry);
                this.fCacheLines = newCache;
                this.fCacheLines[entry] = entries;
            }
            offset = 1;
            ch = str.charAt(strIndex++);
            try {
                this.fSymbolChars[this.fSymbolCharsOffset] = ch;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                char[] newChars = new char[this.fSymbolChars.length * 2];
                System.arraycopy(this.fSymbolChars, 0, newChars, 0, this.fSymbolChars.length);
                this.fSymbolChars = newChars;
                this.fSymbolChars[this.fSymbolCharsOffset] = ch;
            }
            ++this.fSymbolCharsOffset;
        }
        entries[offset + 1] = symbolHandle;
        entries[offset + 2] = -1;
        return charsOffset;
    }

    public void updateCacheLine(int charsOffset, int totalMisses, int length) {
        int entry = 0;
        int[] entries = this.fCacheLines[0];
        int ch = this.fSymbolChars[charsOffset++];
        int count = entries[0];
        int offset = 1 + (count - 1) * 3;
        int misses = 0;
        while (true) {
            if (ch != entries[offset + 0]) {
                offset -= 3;
                ++misses;
                continue;
            }
            if (misses > 4) {
                int symIndex = entries[offset + 1];
                int nextIndex = entries[offset + 2];
                System.arraycopy(entries, offset + 3, entries, offset, misses * 3);
                offset = 1 + (count - 1) * 3;
                entries[offset + 0] = ch;
                entries[offset + 1] = symIndex;
                entries[offset + 2] = nextIndex;
            }
            if (--length == 0) break;
            entry = entries[offset + 2];
            entries = this.fCacheLines[entry];
            ch = this.fSymbolChars[charsOffset++];
            count = entries[0];
            offset = 1 + (count - 1) * 3;
            misses = 0;
        }
    }
}

