/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.ImplementationMessages;
import org.apache.xerces.utils.StringHasher;
import org.apache.xerces.utils.StringPool;

public class UTF8DataChunk
implements StringPool.StringProducer {
    public static final int CHUNK_SHIFT = 14;
    public static final int CHUNK_SIZE = 16384;
    public static final int CHUNK_MASK = 16383;
    private StringPool fStringPool;
    private int fRefCount;
    private int fChunk;
    private byte[] fData = null;
    private UTF8DataChunk fNextChunk;
    private UTF8DataChunk fPreviousChunk;
    private static UTF8DataChunk fgFreeChunks = null;
    private static char[] fgTempBuffer = null;
    private static Object fgTempBufferLock = new Object();
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UTF8DataChunk createChunk(StringPool stringPool, UTF8DataChunk prev) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.xerces.utils.UTF8DataChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (fgFreeChunks != null) {
                UTF8DataChunk newChunk = fgFreeChunks;
                fgFreeChunks = newChunk.fNextChunk;
                newChunk.fNextChunk = null;
                newChunk.init(stringPool, prev);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return newChunk;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            UTF8DataChunk chunk = new UTF8DataChunk(stringPool, prev);
            return chunk;
        }
    }

    public final byte[] toByteArray() {
        return this.fData;
    }

    public void setByteArray(byte[] data) {
        this.fData = data;
    }

    public UTF8DataChunk nextChunk() {
        return this.fNextChunk;
    }

    public boolean clearPreviousChunk() {
        if (this.fPreviousChunk != null) {
            this.fPreviousChunk.setNextChunk(null);
            this.fPreviousChunk.removeRef();
            this.fPreviousChunk = null;
            return true;
        }
        return this.fChunk == 0;
    }

    public void releaseChunk() {
        this.removeRef();
    }

    public void releaseString(int offset, int length) {
        this.removeRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(int offset, int length) {
        Object object = fgTempBufferLock;
        synchronized (object) {
            int outOffset = 0;
            UTF8DataChunk dataChunk = this;
            int endOffset = offset + length;
            int index = offset & 0x3FFF;
            byte[] data = this.fData;
            boolean skiplf = false;
            while (offset < endOffset) {
                char[] newBuffer;
                int ch;
                int b0 = data[index++] & 0xFF;
                if (index == 16384 && ++offset < endOffset) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if (b0 < 128) {
                    if (skiplf) {
                        skiplf = false;
                        if (b0 == 10) continue;
                    }
                    if (b0 == 13) {
                        b0 = 10;
                        skiplf = true;
                    }
                    try {
                        UTF8DataChunk.fgTempBuffer[outOffset] = (char)b0;
                        ++outOffset;
                    }
                    catch (NullPointerException ex) {
                        fgTempBuffer = new char[16384];
                        UTF8DataChunk.fgTempBuffer[outOffset++] = (char)b0;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        char[] newBuffer2 = new char[outOffset * 2];
                        System.arraycopy(fgTempBuffer, 0, newBuffer2, 0, outOffset);
                        fgTempBuffer = newBuffer2;
                        UTF8DataChunk.fgTempBuffer[outOffset++] = (char)b0;
                    }
                    continue;
                }
                int b1 = data[index++] & 0xFF;
                if (index == 16384 && ++offset < endOffset) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((0xE0 & b0) == 192) {
                    int ch2 = ((0x1F & b0) << 6) + (0x3F & b1);
                    try {
                        UTF8DataChunk.fgTempBuffer[outOffset] = (char)ch2;
                        ++outOffset;
                    }
                    catch (NullPointerException ex) {
                        fgTempBuffer = new char[16384];
                        UTF8DataChunk.fgTempBuffer[outOffset++] = (char)ch2;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        char[] newBuffer3 = new char[outOffset * 2];
                        System.arraycopy(fgTempBuffer, 0, newBuffer3, 0, outOffset);
                        fgTempBuffer = newBuffer3;
                        UTF8DataChunk.fgTempBuffer[outOffset++] = (char)ch2;
                    }
                    continue;
                }
                int b2 = data[index++] & 0xFF;
                if (index == 16384 && ++offset < endOffset) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((0xF0 & b0) == 224) {
                    int ch3 = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                    try {
                        UTF8DataChunk.fgTempBuffer[outOffset] = (char)ch3;
                        ++outOffset;
                    }
                    catch (NullPointerException ex) {
                        fgTempBuffer = new char[16384];
                        UTF8DataChunk.fgTempBuffer[outOffset++] = (char)ch3;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        char[] newBuffer4 = new char[outOffset * 2];
                        System.arraycopy(fgTempBuffer, 0, newBuffer4, 0, outOffset);
                        fgTempBuffer = newBuffer4;
                        UTF8DataChunk.fgTempBuffer[outOffset++] = (char)ch3;
                    }
                    continue;
                }
                int b3 = data[index++] & 0xFF;
                if (index == 16384 && ++offset < endOffset) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3)) < 65536) {
                    try {
                        UTF8DataChunk.fgTempBuffer[outOffset] = (char)ch;
                        ++outOffset;
                    }
                    catch (NullPointerException ex) {
                        fgTempBuffer = new char[16384];
                        UTF8DataChunk.fgTempBuffer[outOffset++] = (char)ch;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        char[] newBuffer5 = new char[outOffset * 2];
                        System.arraycopy(fgTempBuffer, 0, newBuffer5, 0, outOffset);
                        fgTempBuffer = newBuffer5;
                        UTF8DataChunk.fgTempBuffer[outOffset++] = (char)ch;
                    }
                    continue;
                }
                char ch1 = (char)((ch - 65536 >> 10) + 55296);
                char ch2 = (char)((ch - 65536 & 0x3FF) + 56320);
                try {
                    UTF8DataChunk.fgTempBuffer[outOffset] = ch1;
                    ++outOffset;
                }
                catch (NullPointerException ex) {
                    fgTempBuffer = new char[16384];
                    UTF8DataChunk.fgTempBuffer[outOffset++] = ch1;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    newBuffer = new char[outOffset * 2];
                    System.arraycopy(fgTempBuffer, 0, newBuffer, 0, outOffset);
                    fgTempBuffer = newBuffer;
                    UTF8DataChunk.fgTempBuffer[outOffset++] = ch1;
                }
                try {
                    UTF8DataChunk.fgTempBuffer[outOffset] = ch2;
                    ++outOffset;
                }
                catch (NullPointerException ex) {
                    fgTempBuffer = new char[16384];
                    UTF8DataChunk.fgTempBuffer[outOffset++] = ch2;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    newBuffer = new char[outOffset * 2];
                    System.arraycopy(fgTempBuffer, 0, newBuffer, 0, outOffset);
                    fgTempBuffer = newBuffer;
                    UTF8DataChunk.fgTempBuffer[outOffset++] = ch2;
                }
            }
            return new String(fgTempBuffer, 0, outOffset);
        }
    }

    public boolean equalsString(int offset, int length, char[] strChars, int strOffset, int strLength) {
        UTF8DataChunk dataChunk = this;
        int endOffset = offset + length;
        int index = offset & 0x3FFF;
        byte[] data = this.fData;
        boolean skiplf = false;
        while (offset < endOffset) {
            int ch;
            if (strLength-- == 0) {
                return false;
            }
            int b0 = data[index++] & 0xFF;
            if (index == 16384 && ++offset < endOffset) {
                dataChunk = dataChunk.fNextChunk;
                data = dataChunk.fData;
                index = 0;
            }
            if (b0 < 128) {
                if (skiplf) {
                    skiplf = false;
                    if (b0 == 10) continue;
                }
                if (b0 == 13) {
                    b0 = 10;
                    skiplf = true;
                }
                if (b0 == strChars[strOffset++]) continue;
                return false;
            }
            int b1 = data[index++] & 0xFF;
            if (index == 16384 && ++offset < endOffset) {
                dataChunk = dataChunk.fNextChunk;
                data = dataChunk.fData;
                index = 0;
            }
            if ((0xE0 & b0) == 192) {
                int ch2 = ((0x1F & b0) << 6) + (0x3F & b1);
                if (ch2 == strChars[strOffset++]) continue;
                return false;
            }
            int b2 = data[index++] & 0xFF;
            if (index == 16384 && ++offset < endOffset) {
                dataChunk = dataChunk.fNextChunk;
                data = dataChunk.fData;
                index = 0;
            }
            if ((0xF0 & b0) == 224) {
                int ch3 = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                if (ch3 == strChars[strOffset++]) continue;
                return false;
            }
            int b3 = data[index++] & 0xFF;
            if (index == 16384 && ++offset < endOffset) {
                dataChunk = dataChunk.fNextChunk;
                data = dataChunk.fData;
                index = 0;
            }
            if ((ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3)) < 65536) {
                if (ch == strChars[strOffset++]) continue;
                return false;
            }
            if ((ch - 65536 >> 10) + 55296 != strChars[strOffset++]) {
                return false;
            }
            if (strLength-- == 0) {
                return false;
            }
            if ((ch - 65536 & 0x3FF) + 56320 == strChars[strOffset++]) continue;
            return false;
        }
        return strLength == 0;
    }

    public int addString(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        int chunk = offset >> 14;
        if (chunk != this.fChunk) {
            if (this.fPreviousChunk == null) {
                throw new RuntimeException(new ImplementationMessages().createMessage(null, 15, 0, null));
            }
            return this.fPreviousChunk.addString(offset, length);
        }
        int lastChunk = offset + length - 1 >> 14;
        if (chunk == lastChunk) {
            this.addRef();
            return this.fStringPool.addString(this, offset & 0x3FFF, length);
        }
        String str = this.toString(offset & 0x3FFF, length);
        return this.fStringPool.addString(str);
    }

    public int addSymbol(int offset, int length, int hashcode) {
        if (length == 0) {
            return 0;
        }
        int chunk = offset >> 14;
        if (chunk != this.fChunk) {
            if (this.fPreviousChunk == null) {
                throw new RuntimeException(new ImplementationMessages().createMessage(null, 15, 0, null));
            }
            return this.fPreviousChunk.addSymbol(offset, length, hashcode);
        }
        int lastChunk = offset + length - 1 >> 14;
        int index = offset & 0x3FFF;
        if (chunk == lastChunk) {
            int symbol;
            if (hashcode == 0) {
                hashcode = this.getHashcode(index, length);
            }
            if ((symbol = this.fStringPool.lookupSymbol(this, index, length, hashcode)) == -1) {
                String str = this.toString(index, length);
                symbol = this.fStringPool.addNewSymbol(str, hashcode);
            }
            return symbol;
        }
        String str = this.toString(index, length);
        return this.fStringPool.addSymbol(str);
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int offset, int length) {
        UTF8DataChunk dataChunk = this.chunkFor(offset);
        int endOffset = offset + length;
        int index = offset & 0x3FFF;
        byte[] data = dataChunk.fData;
        boolean skiplf = false;
        while (offset < endOffset) {
            int ch;
            int b0 = data[index++] & 0xFF;
            if (index == 16384 && ++offset < endOffset) {
                dataChunk = dataChunk.fNextChunk;
                data = dataChunk.fData;
                index = 0;
            }
            if (b0 < 128) {
                if (skiplf) {
                    skiplf = false;
                    if (b0 == 10) continue;
                }
                if (b0 == 13) {
                    b0 = 10;
                    skiplf = true;
                }
                charBuffer.append((char)b0);
                continue;
            }
            int b1 = data[index++] & 0xFF;
            if (index == 16384 && ++offset < endOffset) {
                dataChunk = dataChunk.fNextChunk;
                data = dataChunk.fData;
                index = 0;
            }
            if ((0xE0 & b0) == 192) {
                int ch2 = ((0x1F & b0) << 6) + (0x3F & b1);
                charBuffer.append((char)ch2);
                continue;
            }
            int b2 = data[index++] & 0xFF;
            if (index == 16384 && ++offset < endOffset) {
                dataChunk = dataChunk.fNextChunk;
                data = dataChunk.fData;
                index = 0;
            }
            if ((0xF0 & b0) == 224) {
                int ch3 = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                charBuffer.append((char)ch3);
                continue;
            }
            int b3 = data[index++] & 0xFF;
            if (index == 16384 && ++offset < endOffset) {
                dataChunk = dataChunk.fNextChunk;
                data = dataChunk.fData;
                index = 0;
            }
            if ((ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3)) < 65536) {
                charBuffer.append((char)ch);
                continue;
            }
            charBuffer.append((char)((ch - 65536 >> 10) + 55296));
            charBuffer.append((char)((ch - 65536 & 0x3FF) + 56320));
        }
    }

    private int getHashcode(int index, int length) {
        int endIndex = index + length;
        int hashcode = 0;
        byte[] data = this.fData;
        while (index < endIndex) {
            int b3;
            int ch;
            int b0;
            if (((b0 = data[index++] & 0xFF) & 0x80) == 0) {
                hashcode = StringHasher.hashChar(hashcode, b0);
                continue;
            }
            int b1 = data[index++] & 0xFF;
            if ((0xE0 & b0) == 192) {
                int ch2 = ((0x1F & b0) << 6) + (0x3F & b1);
                hashcode = StringHasher.hashChar(hashcode, ch2);
                continue;
            }
            int b2 = data[index++] & 0xFF;
            if ((0xF0 & b0) == 224) {
                int ch3 = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                hashcode = StringHasher.hashChar(hashcode, ch3);
                continue;
            }
            if ((ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & (b3 = data[index++] & 0xFF))) < 65536) {
                hashcode = StringHasher.hashChar(hashcode, ch);
                continue;
            }
            hashcode = StringHasher.hashChar(hashcode, (ch - 65536 >> 10) + 55296);
            hashcode = StringHasher.hashChar(hashcode, (ch - 65536 & 0x3FF) + 56320);
        }
        return StringHasher.finishHash(hashcode);
    }

    private void init(StringPool stringPool, UTF8DataChunk prev) {
        this.fStringPool = stringPool;
        this.fRefCount = 1;
        this.fChunk = prev == null ? 0 : prev.fChunk + 1;
        this.fNextChunk = null;
        this.fPreviousChunk = prev;
        if (prev != null) {
            prev.addRef();
            prev.setNextChunk(this);
            prev.removeRef();
        }
    }

    private UTF8DataChunk(StringPool stringPool, UTF8DataChunk prev) {
        this.init(stringPool, prev);
    }

    private final UTF8DataChunk chunkFor(int offset) {
        if (offset >> 14 == this.fChunk) {
            return this;
        }
        return this.slowChunkFor(offset);
    }

    private UTF8DataChunk slowChunkFor(int offset) {
        int firstChunk = offset >> 14;
        UTF8DataChunk dataChunk = this;
        while (firstChunk != dataChunk.fChunk) {
            dataChunk = dataChunk.fPreviousChunk;
        }
        return dataChunk;
    }

    private final void addRef() {
        ++this.fRefCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void removeRef() {
        --this.fRefCount;
        if (this.fRefCount != 0) return;
        this.fStringPool = null;
        this.fChunk = -1;
        this.fPreviousChunk = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.xerces.utils.UTF8DataChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            this.fNextChunk = null;
            fgFreeChunks = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void setNextChunk(UTF8DataChunk nextChunk) {
        if (nextChunk == null) {
            if (this.fNextChunk != null) {
                this.fNextChunk.removeRef();
            }
        } else if (this.fNextChunk == null) {
            nextChunk.addRef();
        } else {
            throw new RuntimeException("UTF8DataChunk::setNextChunk");
        }
        this.fNextChunk = nextChunk;
    }
}

