/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import java.util.Hashtable;
import org.apache.xerces.utils.QName;
import org.apache.xerces.validators.common.ContentLeafNameTypeVector;
import org.apache.xerces.validators.common.ElementWildcard;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;

public class AllContentModel
implements XMLContentModel {
    private QName[] fAllElements = new QName[10];
    private boolean[] fIsOptionalElement = new boolean[10];
    private boolean fHasOptionalContent = false;
    private boolean fIsMixed = false;
    private int fNumElements = 0;
    private int fNumRequired = 0;
    private Hashtable fElementsHash;
    private SubstitutionGroupComparator fComparator = null;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;

    public AllContentModel(boolean hasOptionalContent) {
        this.fHasOptionalContent = hasOptionalContent;
    }

    public AllContentModel(boolean hasOptionalContent, boolean isMixed) {
        this(hasOptionalContent);
        this.fIsMixed = isMixed;
    }

    void addElement(QName newElement, boolean isOptional) {
        if (this.fNumElements >= this.fAllElements.length) {
            QName[] newAllElements = new QName[2 * this.fAllElements.length];
            boolean[] newIsOptionalElements = new boolean[2 * this.fIsOptionalElement.length];
            System.arraycopy(this.fAllElements, 0, newAllElements, 0, this.fAllElements.length);
            System.arraycopy(this.fIsOptionalElement, 0, newIsOptionalElements, 0, this.fIsOptionalElement.length);
            this.fAllElements = newAllElements;
            this.fIsOptionalElement = newIsOptionalElements;
        }
        this.fAllElements[this.fNumElements] = newElement;
        this.fIsOptionalElement[this.fNumElements] = isOptional;
        ++this.fNumElements;
        if (!isOptional) {
            ++this.fNumRequired;
        }
    }

    public void checkUniqueParticleAttribution(SchemaGrammar gram) throws Exception {
        int i = 0;
        while (i < this.fNumElements) {
            this.fAllElements[i].uri = gram.getContentSpecOrgUri(this.fAllElements[i].uri);
            ++i;
        }
        int j = 0;
        while (j < this.fNumElements) {
            int k = j + 1;
            while (k < this.fNumElements) {
                ElementWildcard.conflict(0, this.fAllElements[j].localpart, this.fAllElements[j].uri, 0, this.fAllElements[k].localpart, this.fAllElements[k].uri, this.fComparator);
                ++k;
            }
            ++j;
        }
    }

    public int validateContent(QName[] children, int offset, int length) throws Exception {
        if (this.fHasOptionalContent && length == 0) {
            return -1;
        }
        int numElements = this.fNumElements;
        if (this.fElementsHash == null) {
            this.createElementsHash();
        }
        boolean[] elementSeen = new boolean[numElements];
        int numRequiredSeen = 0;
        int childIndex = 0;
        while (childIndex < length) {
            QName currChild = children[offset + childIndex];
            if (!this.fIsMixed || currChild.localpart != -1) {
                Integer foundIdx = (Integer)this.fElementsHash.get(currChild);
                if (foundIdx == null) {
                    return childIndex;
                }
                int foundIdxVal = foundIdx;
                if (elementSeen[foundIdxVal]) {
                    return childIndex;
                }
                elementSeen[foundIdxVal] = true;
                if (!this.fIsOptionalElement[foundIdxVal]) {
                    ++numRequiredSeen;
                }
            }
            ++childIndex;
        }
        if (numRequiredSeen != this.fNumRequired) {
            return length;
        }
        return -1;
    }

    public int validateContentSpecial(QName[] children, int offset, int length) throws Exception {
        if (this.fComparator == null) {
            return this.validateContent(children, offset, length);
        }
        if (this.fHasOptionalContent && length == 0) {
            return -1;
        }
        int numElements = this.fNumElements;
        boolean[] elementSeen = new boolean[numElements];
        int numRequiredSeen = 0;
        int childIndex = 0;
        while (childIndex < length) {
            block9: {
                QName currChild = children[offset + childIndex];
                if (!this.fIsMixed || currChild.localpart != -1) {
                    int compareIdx = 0;
                    while (compareIdx < numElements) {
                        if (this.fComparator.isEquivalentTo(currChild, this.fAllElements[compareIdx])) {
                            if (elementSeen[compareIdx]) {
                                return childIndex;
                            }
                            elementSeen[compareIdx] = true;
                            if (!this.fIsOptionalElement[compareIdx]) {
                                ++numRequiredSeen;
                            }
                            break block9;
                        }
                        ++compareIdx;
                    }
                    return childIndex;
                }
            }
            ++childIndex;
        }
        if (numRequiredSeen != this.fNumRequired) {
            return length;
        }
        return -1;
    }

    public void setSubstitutionGroupComparator(SubstitutionGroupComparator comparator) {
        this.fComparator = comparator;
    }

    public int whatCanGoHere(boolean fullyValid, InsertableElementsInfo info) throws Exception {
        int resultsCount;
        if (this.fElementsHash == null) {
            this.createElementsHash();
        }
        int numElements = this.fNumElements;
        boolean[] elementSeen = new boolean[numElements];
        int numChildren = info.curChildren.length;
        int insertAt = info.insertAt;
        QName[] curChildren = info.curChildren;
        int childIndex = 0;
        while (childIndex < insertAt) {
            QName currChild = curChildren[childIndex];
            Integer foundIdx = (Integer)this.fElementsHash.get(currChild);
            if (foundIdx == null) {
                return childIndex;
            }
            int foundIdxVal = foundIdx;
            if (elementSeen[foundIdxVal]) {
                return childIndex;
            }
            elementSeen[foundIdxVal] = true;
            ++childIndex;
        }
        info.canHoldPCData = this.fIsMixed;
        info.resultsCount = resultsCount = numElements - insertAt;
        if (info.results == null || info.results.length < resultsCount) {
            info.results = new boolean[resultsCount];
        }
        if (info.possibleChildren == null || info.possibleChildren.length < resultsCount) {
            QName[] possibleChildren = info.possibleChildren = new QName[resultsCount];
            int possibleChildrenLen = info.possibleChildren.length;
            int i = 0;
            while (i < possibleChildrenLen) {
                possibleChildren[i] = new QName();
                ++i;
            }
        }
        int possibleChildIdx = 0;
        int elemIdx = 0;
        while (elemIdx < numElements) {
            if (!elementSeen[elemIdx]) {
                info.possibleChildren[possibleChildIdx].setValues(this.fAllElements[elemIdx]);
                info.results[possibleChildIdx] = true;
                ++possibleChildIdx;
            }
            ++elemIdx;
        }
        boolean bl = info.isValidEOC = resultsCount == 0;
        if (resultsCount == 0) {
            return -1;
        }
        return info.childCount;
    }

    public ContentLeafNameTypeVector getContentLeafNameTypeVector() {
        return null;
    }

    private void createElementsHash() {
        int numElements = this.fNumElements;
        this.fElementsHash = new Hashtable(numElements);
        int elementIdx = 0;
        while (elementIdx < numElements) {
            this.fElementsHash.put(this.fAllElements[elementIdx], new Integer(elementIdx));
            ++elementIdx;
        }
    }

    private void showAllElements() {
        int elementIdx = 0;
        while (elementIdx < this.fNumElements) {
            System.out.print("fAllElements[" + elementIdx + "] == " + this.fAllElements[elementIdx].toString());
            if (this.fIsOptionalElement[elementIdx]) {
                System.out.print(" (optional)");
            }
            System.out.println();
            ++elementIdx;
        }
    }
}

