/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.CMNode;
import org.apache.xerces.validators.common.CMStateSet;

public class CMAny
extends CMNode {
    private int fType;
    private int fURI;
    private int fPosition = -1;

    public CMAny(int type, int uri, int position) throws CMException {
        super(type);
        this.fType = type;
        this.fURI = uri;
        this.fPosition = position;
    }

    final int getType() {
        return this.fType;
    }

    final int getURI() {
        return this.fURI;
    }

    final int getPosition() {
        return this.fPosition;
    }

    final void setPosition(int newPosition) {
        this.fPosition = newPosition;
    }

    boolean isNullable() throws CMException {
        return this.fPosition == -1;
    }

    String toString(StringPool stringPool) {
        StringBuffer strRet = new StringBuffer();
        strRet.append("(");
        switch (this.fType & 0xF) {
            case 6: {
                strRet.append("##any");
                break;
            }
            case 8: {
                strRet.append("##any:uri=" + stringPool.toString(this.fURI));
                break;
            }
            case 7: {
                strRet.append("##other:uri=" + stringPool.toString(this.fURI));
            }
        }
        strRet.append(stringPool.toString(this.fURI));
        strRet.append(')');
        if (this.fPosition >= 0) {
            strRet.append(" (Pos:" + new Integer(this.fPosition).toString() + ")");
        }
        return strRet.toString();
    }

    protected void calcFirstPos(CMStateSet toSet) throws CMException {
        if (this.fPosition == -1) {
            toSet.zeroBits();
        } else {
            toSet.setBit(this.fPosition);
        }
    }

    protected void calcLastPos(CMStateSet toSet) throws CMException {
        if (this.fPosition == -1) {
            toSet.zeroBits();
        } else {
            toSet.setBit(this.fPosition);
        }
    }
}

