/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.CMNode;
import org.apache.xerces.validators.common.CMStateSet;

public class CMBinOp
extends CMNode {
    private CMNode fLeftChild;
    private CMNode fRightChild;

    public CMBinOp(int type, CMNode leftNode, CMNode rightNode) throws CMException {
        super(type);
        if (this.type() != 4 && this.type() != 5) {
            throw new CMException(6);
        }
        this.fLeftChild = leftNode;
        this.fRightChild = rightNode;
    }

    final CMNode getLeft() {
        return this.fLeftChild;
    }

    final CMNode getRight() {
        return this.fRightChild;
    }

    boolean isNullable() throws CMException {
        if (this.type() == 4) {
            return this.fLeftChild.isNullable() || this.fRightChild.isNullable();
        }
        if (this.type() == 5) {
            return this.fLeftChild.isNullable() && this.fRightChild.isNullable();
        }
        throw new CMException(6);
    }

    protected void calcFirstPos(CMStateSet toSet) throws CMException {
        if (this.type() == 4) {
            toSet.setTo(this.fLeftChild.firstPos());
            toSet.union(this.fRightChild.firstPos());
        } else if (this.type() == 5) {
            toSet.setTo(this.fLeftChild.firstPos());
            if (this.fLeftChild.isNullable()) {
                toSet.union(this.fRightChild.firstPos());
            }
        } else {
            throw new CMException(6);
        }
    }

    protected void calcLastPos(CMStateSet toSet) throws CMException {
        if (this.type() == 4) {
            toSet.setTo(this.fLeftChild.lastPos());
            toSet.union(this.fRightChild.lastPos());
        } else if (this.type() == 5) {
            toSet.setTo(this.fRightChild.lastPos());
            if (this.fRightChild.isNullable()) {
                toSet.union(this.fLeftChild.lastPos());
            }
        } else {
            throw new CMException(6);
        }
    }
}

