/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.CMNode;
import org.apache.xerces.validators.common.CMStateSet;

public class CMLeaf
extends CMNode {
    private QName fElement = new QName();
    private int fPosition = -1;

    public CMLeaf(QName element, int position) throws CMException {
        super(0);
        this.fElement.setValues(element);
        this.fPosition = position;
    }

    public CMLeaf(QName element) throws CMException {
        super(0);
        this.fElement.setValues(element);
    }

    final QName getElement() {
        return this.fElement;
    }

    final int getPosition() {
        return this.fPosition;
    }

    final void setPosition(int newPosition) {
        this.fPosition = newPosition;
    }

    boolean isNullable() throws CMException {
        return this.fPosition == -1;
    }

    String toString(StringPool stringPool) {
        StringBuffer strRet = new StringBuffer(this.fElement.toString());
        strRet.append(" (");
        strRet.append(stringPool.toString(this.fElement.uri));
        strRet.append(',');
        strRet.append(stringPool.toString(this.fElement.localpart));
        strRet.append(')');
        if (this.fPosition >= 0) {
            strRet.append(" (Pos:" + new Integer(this.fPosition).toString() + ")");
        }
        return strRet.toString();
    }

    protected void calcFirstPos(CMStateSet toSet) throws CMException {
        if (this.fPosition == -1) {
            toSet.zeroBits();
        } else {
            toSet.setBit(this.fPosition);
        }
    }

    protected void calcLastPos(CMStateSet toSet) throws CMException {
        if (this.fPosition == -1) {
            toSet.zeroBits();
        } else {
            toSet.setBit(this.fPosition);
        }
    }
}

